/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.internal.colorUtil;

import androidx.compose.material3.internal.colorUtil.CamUtils;
import androidx.compose.material3.internal.colorUtil.Frame;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b&\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002J#\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\rH\u0002J \u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J \u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\rH\u0002J\u0010\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\rH\u0002J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\rH\u0002J \u0010'\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0004H\u0002J\u0018\u0010)\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u0011H\u0002J\u0010\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\rH\u0002J\u0010\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\rH\u0002J(\u0010/\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u00100\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0011H\u0002J\u001e\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u00104\u001a\u00020\rJ\u0010\u00105\u001a\u00020\r2\u0006\u00106\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Landroidx/compose/material3/internal/colorUtil/HctSolver;", "", "()V", "CRITICAL_PLANES", "", "LINRGB_FROM_SCALED_DISCOUNT", "", "[[D", "SCALED_DISCOUNT_FROM_LINRGB", "Y_FROM_LINRGB", "areInCyclicOrder", "", "a", "", "b", "c", "bisectToLimit", "", "y", "targetHue", "bisectToSegment", "(DD)[[D", "chromaticAdaptation", "component", "criticalPlaneAbove", "x", "criticalPlaneBelow", "findResultByJ", "hueRadians", "chroma", "hueOf", "linrgb", "intercept", "source", "mid", "target", "inverseChromaticAdaptation", "adapted", "isBounded", "lerpPoint", "t", "nthVertex", "n", "sanitizeDegreesDouble", "degrees", "sanitizeRadians", "angle", "setCoordinate", "coordinate", "axis", "solveToInt", "hueDegrees", "lstar", "trueDelinearized", "rgbComponent", "material3_release"})
@StabilityInferred(parameters=0)
public final class HctSolver {
    @NotNull
    public static final HctSolver INSTANCE = new HctSolver();
    @NotNull
    private static final double[][] SCALED_DISCOUNT_FROM_LINRGB;
    @NotNull
    private static final double[][] LINRGB_FROM_SCALED_DISCOUNT;
    @NotNull
    private static final double[] Y_FROM_LINRGB;
    @NotNull
    private static final double[] CRITICAL_PLANES;
    public static final int $stable;

    private HctSolver() {
    }

    private final double sanitizeRadians(double angle) {
        return (angle + Math.PI * 8) % (Math.PI * 2);
    }

    private final double trueDelinearized(double rgbComponent) {
        double normalized = rgbComponent / 100.0;
        double delinearized = normalized <= 0.0031308 ? normalized * 12.92 : 1.055 * Math.pow(normalized, 0.4166666666666667) - 0.055;
        return delinearized * (double)255;
    }

    private final double chromaticAdaptation(double component) {
        double af = Math.pow(Math.abs(component), 0.42);
        return (double)CamUtils.INSTANCE.signum(component) * 400.0 * af / (af + 27.13);
    }

    private final double hueOf(double[] linrgb) {
        double[][] matrix = SCALED_DISCOUNT_FROM_LINRGB;
        double rD = linrgb[0] * matrix[0][0] + linrgb[1] * matrix[0][1] + linrgb[2] * matrix[0][2];
        double gD = linrgb[0] * matrix[1][0] + linrgb[1] * matrix[1][1] + linrgb[2] * matrix[1][2];
        double bD = linrgb[0] * matrix[2][0] + linrgb[1] * matrix[2][1] + linrgb[2] * matrix[2][2];
        double rA = this.chromaticAdaptation(rD);
        double gA = this.chromaticAdaptation(gD);
        double bA = this.chromaticAdaptation(bD);
        double a = (11.0 * rA + -12.0 * gA + bA) / 11.0;
        double b = (rA + gA - 2.0 * bA) / 9.0;
        return Math.atan2(b, a);
    }

    private final boolean areInCyclicOrder(double a, double b, double c) {
        double deltaAC;
        double deltaAB = this.sanitizeRadians(b - a);
        return deltaAB < (deltaAC = this.sanitizeRadians(c - a));
    }

    private final double intercept(double source, double mid, double target) {
        if (target == source) {
            return target;
        }
        return (mid - source) / (target - source);
    }

    private final double[] lerpPoint(double[] source, double t, double[] target) {
        double[] dArray = new double[]{source[0] + (target[0] - source[0]) * t, source[1] + (target[1] - source[1]) * t, source[2] + (target[2] - source[2]) * t};
        return dArray;
    }

    private final double[] setCoordinate(double[] source, double coordinate, double[] target, int axis) {
        double t = this.intercept(source[axis], coordinate, target[axis]);
        return this.lerpPoint(source, t, target);
    }

    private final boolean isBounded(double x) {
        return 0.0 <= x ? x <= 100.0 : false;
    }

    private final double[] nthVertex(double y, int n) {
        double[] dArray;
        double coordB;
        double kR = Y_FROM_LINRGB[0];
        double kG = Y_FROM_LINRGB[1];
        double kB = Y_FROM_LINRGB[2];
        double coordA = n % 4 <= 1 ? 0.0 : 100.0;
        double d = coordB = n % 2 == 0 ? 0.0 : 100.0;
        if (n < 4) {
            double[] dArray2;
            double r = (y - coordA * kG - coordB * kB) / kR;
            if (this.isBounded(r)) {
                double[] dArray3 = new double[]{r, coordA, coordB};
                dArray2 = dArray3;
            } else {
                double[] dArray4 = new double[]{-1.0, -1.0, -1.0};
                dArray2 = dArray4;
            }
            return dArray2;
        }
        if (n < 8) {
            double[] dArray5;
            double g = (y - coordB * kR - coordA * kB) / kG;
            if (this.isBounded(g)) {
                double[] dArray6 = new double[]{coordB, g, coordA};
                dArray5 = dArray6;
            } else {
                double[] dArray7 = new double[]{-1.0, -1.0, -1.0};
                dArray5 = dArray7;
            }
            return dArray5;
        }
        double b = (y - coordA * kR - coordB * kG) / kB;
        if (this.isBounded(b)) {
            double[] dArray8 = new double[]{coordA, coordB, b};
            dArray = dArray8;
        } else {
            double[] dArray9 = new double[]{-1.0, -1.0, -1.0};
            dArray = dArray9;
        }
        return dArray;
    }

    private final double[][] bisectToSegment(double y, double targetHue) {
        double[] left;
        double[] dArray = new double[]{-1.0, -1.0, -1.0};
        double[] right = left = dArray;
        double leftHue = 0.0;
        double rightHue = 0.0;
        boolean initialized = false;
        boolean uncut = true;
        for (int n = 0; n < 12; ++n) {
            double[] mid = this.nthVertex(y, n);
            if (mid[0] < 0.0) continue;
            double midHue = this.hueOf(mid);
            if (!initialized) {
                left = mid;
                right = mid;
                leftHue = midHue;
                rightHue = midHue;
                initialized = true;
                continue;
            }
            if (!uncut && !this.areInCyclicOrder(leftHue, midHue, rightHue)) continue;
            uncut = false;
            if (this.areInCyclicOrder(leftHue, targetHue, midHue)) {
                right = mid;
                rightHue = midHue;
                continue;
            }
            left = mid;
            leftHue = midHue;
        }
        double[][] dArrayArray = new double[][]{left, right};
        return dArrayArray;
    }

    private final int criticalPlaneBelow(double x) {
        return (int)Math.floor(x - 0.5);
    }

    private final int criticalPlaneAbove(double x) {
        return (int)Math.ceil(x - 0.5);
    }

    private final int bisectToLimit(double y, double targetHue) {
        double[][] segment = this.bisectToSegment(y, targetHue);
        double[] left = segment[0];
        double leftHue = this.hueOf(left);
        double[] right = segment[1];
        for (int axis = 0; axis < 3; ++axis) {
            if (left[axis] == right[axis]) continue;
            int lPlane = 0;
            int rPlane = 0;
            if (left[axis] < right[axis]) {
                lPlane = this.criticalPlaneBelow(this.trueDelinearized(left[axis]));
                rPlane = this.criticalPlaneAbove(this.trueDelinearized(right[axis]));
            } else {
                lPlane = this.criticalPlaneAbove(this.trueDelinearized(left[axis]));
                rPlane = this.criticalPlaneBelow(this.trueDelinearized(right[axis]));
            }
            for (int i = 0; i < 8 && !(Math.abs((double)(rPlane - lPlane)) <= 1.0); ++i) {
                int mPlane = (int)Math.floor((double)(lPlane + rPlane) / 2.0);
                double midPlaneCoordinate = CRITICAL_PLANES[mPlane];
                double[] mid = this.setCoordinate(left, midPlaneCoordinate, right, axis);
                double midHue = this.hueOf(mid);
                if (this.areInCyclicOrder(leftHue, targetHue, midHue)) {
                    right = mid;
                    rPlane = mPlane;
                    continue;
                }
                left = mid;
                leftHue = midHue;
                lPlane = mPlane;
            }
        }
        return CamUtils.INSTANCE.argbFromLinrgbComponents((left[0] + right[0]) / (double)2, (left[1] + right[1]) / (double)2, (left[2] + right[2]) / (double)2);
    }

    private final double inverseChromaticAdaptation(double adapted) {
        double adaptedAbs = Math.abs(adapted);
        double base = Math.max(0.0, 27.13 * adaptedAbs / (400.0 - adaptedAbs));
        return (double)CamUtils.INSTANCE.signum(adapted) * Math.pow(base, 2.380952380952381);
    }

    private final int findResultByJ(double hueRadians, double chroma, double y) {
        double j = Math.sqrt(y) * 11.0;
        Frame viewingConditions = Frame.Companion.getDefault();
        double tInnerCoeff = 1.0 / Math.pow(1.64 - Math.pow(0.29, viewingConditions.getN()), 0.73);
        double eHue = 0.25 * (Math.cos(hueRadians + 2.0) + 3.8);
        double p1 = eHue * 3846.153846153846 * (double)viewingConditions.getNc() * (double)viewingConditions.getNcb();
        double hSin = Math.sin(hueRadians);
        double hCos = Math.cos(hueRadians);
        for (int iterationRound = 0; iterationRound < 5; ++iterationRound) {
            double jNormalized = j / 100.0;
            double alpha2 = chroma == 0.0 || j == 0.0 ? 0.0 : chroma / Math.sqrt(jNormalized);
            double t = Math.pow(alpha2 * tInnerCoeff, 1.1111111111111112);
            double acExponent = 1.0 / (double)viewingConditions.getC() / (double)viewingConditions.getZ();
            double ac = (double)viewingConditions.getAw() * Math.pow(jNormalized, acExponent);
            double p2 = ac / (double)viewingConditions.getNbb();
            double gamma = 23.0 * (p2 + 0.305) * t / (23.0 * p1 + (double)11 * t * hCos + 108.0 * t * hSin);
            double a = gamma * hCos;
            double b = gamma * hSin;
            double rA = (460.0 * p2 + 451.0 * a + 288.0 * b) / 1403.0;
            double gA = (460.0 * p2 - 891.0 * a - 261.0 * b) / 1403.0;
            double bA = (460.0 * p2 - 220.0 * a - 6300.0 * b) / 1403.0;
            double rCScaled = this.inverseChromaticAdaptation(rA);
            double gCScaled = this.inverseChromaticAdaptation(gA);
            double bCScaled = this.inverseChromaticAdaptation(bA);
            double[][] matrix = LINRGB_FROM_SCALED_DISCOUNT;
            double linrgbR = rCScaled * matrix[0][0] + gCScaled * matrix[0][1] + bCScaled * matrix[0][2];
            double linrgbG = rCScaled * matrix[1][0] + gCScaled * matrix[1][1] + bCScaled * matrix[1][2];
            double linrgbB = rCScaled * matrix[2][0] + gCScaled * matrix[2][1] + bCScaled * matrix[2][2];
            if (linrgbR < 0.0 || linrgbG < 0.0 || linrgbB < 0.0) {
                return 0;
            }
            double kR = Y_FROM_LINRGB[0];
            double kG = Y_FROM_LINRGB[1];
            double kB = Y_FROM_LINRGB[2];
            double fnj = kR * linrgbR + kG * linrgbG + kB * linrgbB;
            if (fnj <= 0.0) {
                return 0;
            }
            if (iterationRound == 4 || Math.abs(fnj - y) < 0.002) {
                if (linrgbR > 100.01 || linrgbG > 100.01 || linrgbB > 100.01) {
                    return 0;
                }
                return CamUtils.INSTANCE.argbFromLinrgbComponents(linrgbR, linrgbG, linrgbB);
            }
            j -= (fnj - y) * j / ((double)2 * fnj);
        }
        return 0;
    }

    public final int solveToInt(double hueDegrees, double chroma, double lstar) {
        double y;
        double hueDegreesPrime = hueDegrees;
        if (chroma < 1.0E-4 || lstar < 1.0E-4 || lstar > 99.9999) {
            return CamUtils.INSTANCE.argbFromLstar(lstar);
        }
        double hueRadians = Math.toRadians(hueDegreesPrime = this.sanitizeDegreesDouble(hueDegreesPrime));
        int exactAnswer = this.findResultByJ(hueRadians, chroma, y = CamUtils.INSTANCE.yFromLstar(lstar));
        if (exactAnswer != 0) {
            return exactAnswer;
        }
        return this.bisectToLimit(y, hueRadians);
    }

    private final double sanitizeDegreesDouble(double degrees) {
        double degreesPrime = degrees;
        if ((degreesPrime %= 360.0) < 0.0) {
            degreesPrime += 360.0;
        }
        return degreesPrime;
    }

    static {
        Object object = new double[3][];
        double[] dArray = new double[]{0.001200833568784504, 0.002389694492170889, 2.795742885861124E-4};
        object[0] = dArray;
        dArray = new double[]{5.891086651375999E-4, 0.0029785502573438758, 3.270666104008398E-4};
        object[1] = dArray;
        dArray = new double[]{1.0146692491640572E-4, 5.364214359186694E-4, 0.0032979401770712076};
        object[2] = dArray;
        SCALED_DISCOUNT_FROM_LINRGB = object;
        object = new double[3][];
        dArray = new double[]{1373.2198709594231, -1100.4251190754821, -7.278681089101213};
        object[0] = dArray;
        dArray = new double[]{-271.815969077903, 559.6580465940733, -32.46047482791194};
        object[1] = dArray;
        dArray = new double[]{1.9622899599665666, -57.173814538844006, 308.7233197812385};
        object[2] = dArray;
        LINRGB_FROM_SCALED_DISCOUNT = object;
        object = new double[3];
        object[0] = (double[])0.2126;
        object[1] = (double[])0.7152;
        object[2] = (double[])0.0722;
        Y_FROM_LINRGB = (double[])object;
        object = new double[255];
        object[0] = (double[])0.015176349177441876;
        object[1] = (double[])0.045529047532325624;
        object[2] = (double[])0.07588174588720938;
        object[3] = (double[])0.10623444424209313;
        object[4] = (double[])0.13658714259697685;
        object[5] = (double[])0.16693984095186062;
        object[6] = (double[])0.19729253930674434;
        object[7] = (double[])0.2276452376616281;
        object[8] = (double[])0.2579979360165119;
        object[9] = (double[])0.28835063437139563;
        object[10] = (double[])0.3188300904430532;
        object[11] = (double[])0.350925934958123;
        object[12] = (double[])0.3848314933096426;
        object[13] = (double[])0.42057480301049466;
        object[14] = (double[])0.458183274052838;
        object[15] = (double[])0.4976837250274023;
        object[16] = (double[])0.5391024159806381;
        object[17] = (double[])0.5824650784040898;
        object[18] = (double[])0.6277969426914107;
        object[19] = (double[])0.6751227633498623;
        object[20] = (double[])0.7244668422128921;
        object[21] = (double[])0.775853049866786;
        object[22] = (double[])0.829304845476233;
        object[23] = (double[])0.8848452951698498;
        object[24] = (double[])0.942497089126609;
        object[25] = (double[])1.0022825574869039;
        object[26] = (double[])1.0642236851973577;
        object[27] = (double[])1.1283421258858297;
        object[28] = (double[])1.1946592148522128;
        object[29] = (double[])1.2631959812511864;
        object[30] = (double[])1.3339731595349034;
        object[31] = (double[])1.407011200216447;
        object[32] = (double[])1.4823302800086415;
        object[33] = (double[])1.5599503113873272;
        object[34] = (double[])1.6398909516233677;
        object[35] = (double[])1.7221716113234105;
        object[36] = (double[])1.8068114625156377;
        object[37] = (double[])1.8938294463134073;
        object[38] = (double[])1.9832442801866852;
        object[39] = (double[])2.075074464868551;
        object[40] = (double[])2.1693382909216234;
        object[41] = (double[])2.2660538449872063;
        object[42] = (double[])2.36523901573795;
        object[43] = (double[])2.4669114995532007;
        object[44] = (double[])2.5710888059345764;
        object[45] = (double[])2.6777882626779785;
        object[46] = (double[])2.7870270208169257;
        object[47] = (double[])2.898822059350997;
        object[48] = (double[])3.0131901897720907;
        object[49] = (double[])3.1301480604002863;
        object[50] = (double[])3.2497121605402226;
        object[51] = (double[])3.3718988244681087;
        object[52] = (double[])3.4967242352587946;
        object[53] = (double[])3.624204428461639;
        object[54] = (double[])3.754355295633311;
        object[55] = (double[])3.887192587735158;
        object[56] = (double[])4.022731918402185;
        object[57] = (double[])4.160988767090289;
        object[58] = (double[])4.301978482107941;
        object[59] = (double[])4.445716283538092;
        object[60] = (double[])4.592217266055746;
        object[61] = (double[])4.741496401646282;
        object[62] = (double[])4.893568542229298;
        object[63] = (double[])5.048448422192488;
        object[64] = (double[])5.20615066083972;
        object[65] = (double[])5.3666897647573375;
        object[66] = (double[])5.5300801301023865;
        object[67] = (double[])5.696336044816294;
        object[68] = (double[])5.865471690767354;
        object[69] = (double[])6.037501145825082;
        object[70] = (double[])6.212438385869475;
        object[71] = (double[])6.390297286737924;
        object[72] = (double[])6.571091626112461;
        object[73] = (double[])6.7548350853498045;
        object[74] = (double[])6.941541251256611;
        object[75] = (double[])7.131223617812143;
        object[76] = (double[])7.323895587840543;
        object[77] = (double[])7.5195704746346665;
        object[78] = (double[])7.7182615035334345;
        object[79] = (double[])7.919981813454504;
        object[80] = (double[])8.124744458384042;
        object[81] = (double[])8.332562408825165;
        object[82] = (double[])8.543448553206703;
        object[83] = (double[])8.757415699253682;
        object[84] = (double[])8.974476575321063;
        object[85] = (double[])9.194643831691977;
        object[86] = (double[])9.417930041841839;
        object[87] = (double[])9.644347703669503;
        object[88] = (double[])9.873909240696694;
        object[89] = (double[])10.106627003236781;
        object[90] = (double[])10.342513269534024;
        object[91] = (double[])10.58158024687427;
        object[92] = (double[])10.8238400726681;
        object[93] = (double[])11.069304815507364;
        object[94] = (double[])11.317986476196008;
        object[95] = (double[])11.569896988756009;
        object[96] = (double[])11.825048221409341;
        object[97] = (double[])12.083451977536606;
        object[98] = (double[])12.345119996613247;
        object[99] = (double[])12.610063955123938;
        object[100] = (double[])12.878295467455942;
        object[101] = (double[])13.149826086772048;
        object[102] = (double[])13.42466730586372;
        object[103] = (double[])13.702830557985108;
        object[104] = (double[])13.984327217668513;
        object[105] = (double[])14.269168601521828;
        object[106] = (double[])14.55736596900856;
        object[107] = (double[])14.848930523210871;
        object[108] = (double[])15.143873411576273;
        object[109] = (double[])15.44220572664832;
        object[110] = (double[])15.743938506781891;
        object[111] = (double[])16.04908273684337;
        object[112] = (double[])16.35764934889634;
        object[113] = (double[])16.66964922287304;
        object[114] = (double[])16.985093187232053;
        object[115] = (double[])17.30399201960269;
        object[116] = (double[])17.62635644741625;
        object[117] = (double[])17.95219714852476;
        object[118] = (double[])18.281524751807332;
        object[119] = (double[])18.614349837764564;
        object[120] = (double[])18.95068293910138;
        object[121] = (double[])19.290534541298456;
        object[122] = (double[])19.633915083172692;
        object[123] = (double[])19.98083495742689;
        object[124] = (double[])20.331304511189067;
        object[125] = (double[])20.685334046541502;
        object[126] = (double[])21.042933821039977;
        object[127] = (double[])21.404114048223256;
        object[128] = (double[])21.76888489811322;
        object[129] = (double[])22.137256497705877;
        object[130] = (double[])22.50923893145328;
        object[131] = (double[])22.884842241736916;
        object[132] = (double[])23.264076429332462;
        object[133] = (double[])23.6469514538663;
        object[134] = (double[])24.033477234264016;
        object[135] = (double[])24.42366364919083;
        object[136] = (double[])24.817520537484558;
        object[137] = (double[])25.21505769858089;
        object[138] = (double[])25.61628489293138;
        object[139] = (double[])26.021211842414342;
        object[140] = (double[])26.429848230738664;
        object[141] = (double[])26.842203703840827;
        object[142] = (double[])27.258287870275353;
        object[143] = (double[])27.678110301598522;
        object[144] = (double[])28.10168053274597;
        object[145] = (double[])28.529008062403893;
        object[146] = (double[])28.96010235337422;
        object[147] = (double[])29.39497283293396;
        object[148] = (double[])29.83362889318845;
        object[149] = (double[])30.276079891419332;
        object[150] = (double[])30.722335150426627;
        object[151] = (double[])31.172403958865512;
        object[152] = (double[])31.62629557157785;
        object[153] = (double[])32.08401920991837;
        object[154] = (double[])32.54558406207592;
        object[155] = (double[])33.010999283389665;
        object[156] = (double[])33.4802739966603;
        object[157] = (double[])33.953417292456834;
        object[158] = (double[])34.430438229418264;
        object[159] = (double[])34.911345834551085;
        object[160] = (double[])35.39614910352207;
        object[161] = (double[])35.88485700094671;
        object[162] = (double[])36.37747846067349;
        object[163] = (double[])36.87402238606382;
        object[164] = (double[])37.37449765026789;
        object[165] = (double[])37.87891309649659;
        object[166] = (double[])38.38727753828926;
        object[167] = (double[])38.89959975977785;
        object[168] = (double[])39.41588851594697;
        object[169] = (double[])39.93615253289054;
        object[170] = (double[])40.460400508064545;
        object[171] = (double[])40.98864111053629;
        object[172] = (double[])41.520882981230194;
        object[173] = (double[])42.05713473317016;
        object[174] = (double[])42.597404951718396;
        object[175] = (double[])43.141702194811224;
        object[176] = (double[])43.6900349931913;
        object[177] = (double[])44.24241185063697;
        object[178] = (double[])44.798841244188324;
        object[179] = (double[])45.35933162437017;
        object[180] = (double[])45.92389141541209;
        object[181] = (double[])46.49252901546552;
        object[182] = (double[])47.065252796817916;
        object[183] = (double[])47.64207110610409;
        object[184] = (double[])48.22299226451468;
        object[185] = (double[])48.808024568002054;
        object[186] = (double[])49.3971762874833;
        object[187] = (double[])49.9904556690408;
        object[188] = (double[])50.587870934119984;
        object[189] = (double[])51.189430279724725;
        object[190] = (double[])51.79514187861014;
        object[191] = (double[])52.40501387947288;
        object[192] = (double[])53.0190544071392;
        object[193] = (double[])53.637271562750364;
        object[194] = (double[])54.259673423945976;
        object[195] = (double[])54.88626804504493;
        object[196] = (double[])55.517063457223934;
        object[197] = (double[])56.15206766869424;
        object[198] = (double[])56.79128866487574;
        object[199] = (double[])57.43473440856916;
        object[200] = (double[])58.08241284012621;
        object[201] = (double[])58.734331877617365;
        object[202] = (double[])59.39049941699807;
        object[203] = (double[])60.05092333227251;
        object[204] = (double[])60.715611475655585;
        object[205] = (double[])61.38457167773311;
        object[206] = (double[])62.057811747619894;
        object[207] = (double[])62.7353394731159;
        object[208] = (double[])63.417162620860914;
        object[209] = (double[])64.10328893648692;
        object[210] = (double[])64.79372614476921;
        object[211] = (double[])65.48848194977529;
        object[212] = (double[])66.18756403501224;
        object[213] = (double[])66.89098006357258;
        object[214] = (double[])67.59873767827808;
        object[215] = (double[])68.31084450182222;
        object[216] = (double[])69.02730813691093;
        object[217] = (double[])69.74813616640164;
        object[218] = (double[])70.47333615344107;
        object[219] = (double[])71.20291564160104;
        object[220] = (double[])71.93688215501312;
        object[221] = (double[])72.67524319850172;
        object[222] = (double[])73.41800625771542;
        object[223] = (double[])74.16517879925733;
        object[224] = (double[])74.9167682708136;
        object[225] = (double[])75.67278210128072;
        object[226] = (double[])76.43322770089146;
        object[227] = (double[])77.1981124613393;
        object[228] = (double[])77.96744375590167;
        object[229] = (double[])78.74122893956174;
        object[230] = (double[])79.51947534912904;
        object[231] = (double[])80.30219030335869;
        object[232] = (double[])81.08938110306934;
        object[233] = (double[])81.88105503125999;
        object[234] = (double[])82.67721935322541;
        object[235] = (double[])83.4778813166706;
        object[236] = (double[])84.28304815182372;
        object[237] = (double[])85.09272707154808;
        object[238] = (double[])85.90692527145302;
        object[239] = (double[])86.72564993000343;
        object[240] = (double[])87.54890820862819;
        object[241] = (double[])88.3767072518277;
        object[242] = (double[])89.2090541872801;
        object[243] = (double[])90.04595612594655;
        object[244] = (double[])90.88742016217518;
        object[245] = (double[])91.73345337380438;
        object[246] = (double[])92.58406282226491;
        object[247] = (double[])93.43925555268066;
        object[248] = (double[])94.29903859396902;
        object[249] = (double[])95.16341895893969;
        object[250] = (double[])96.03240364439274;
        object[251] = (double[])96.9059996312159;
        object[252] = (double[])97.78421388448044;
        object[253] = (double[])98.6670533535366;
        object[254] = (double[])99.55452497210776;
        CRITICAL_PLANES = (double[])object;
        $stable = 8;
    }
}

