/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.annotation.FloatRange;
import androidx.compose.runtime.MutableIntState;
import androidx.compose.runtime.SnapshotIntStateKt;
import androidx.compose.ui.geometry.Size;
import androidx.graphics.shapes.CornerRounding;
import androidx.graphics.shapes.Morph;
import androidx.graphics.shapes.RoundedPolygon;
import androidx.graphics.shapes.ShapesKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00102\b\b\u0001\u0010\u001d\u001a\u00020\u00162\b\b\u0001\u0010\u001e\u001a\u00020\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010 R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\f\"\u0004\b\u0019\u0010\u000e\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006!"}, d2={"Landroidx/compose/material3/CircularShapes;", "", "()V", "activeIndicatorMorph", "Landroidx/graphics/shapes/Morph;", "getActiveIndicatorMorph", "()Landroidx/graphics/shapes/Morph;", "setActiveIndicatorMorph", "(Landroidx/graphics/shapes/Morph;)V", "activeIndicatorPolygon", "Landroidx/graphics/shapes/RoundedPolygon;", "getActiveIndicatorPolygon", "()Landroidx/graphics/shapes/RoundedPolygon;", "setActiveIndicatorPolygon", "(Landroidx/graphics/shapes/RoundedPolygon;)V", "currentSize", "Landroidx/compose/ui/geometry/Size;", "currentVertexCount", "Landroidx/compose/runtime/MutableIntState;", "getCurrentVertexCount", "()Landroidx/compose/runtime/MutableIntState;", "currentWavelength", "", "trackPolygon", "getTrackPolygon", "setTrackPolygon", "update", "", "size", "wavelength", "strokeWidth", "update-Pq9zytI", "(JFF)V", "material3_release"})
@SourceDebugExtension(value={"SMAP\nWavyProgressIndicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WavyProgressIndicator.kt\nandroidx/compose/material3/CircularShapes\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1971:1\n1#2:1972\n*E\n"})
final class CircularShapes {
    @Nullable
    private Size currentSize;
    private float currentWavelength = -1.0f;
    @Nullable
    private RoundedPolygon trackPolygon;
    @Nullable
    private RoundedPolygon activeIndicatorPolygon;
    @Nullable
    private Morph activeIndicatorMorph;
    @NotNull
    private final MutableIntState currentVertexCount = SnapshotIntStateKt.mutableIntStateOf((int)-1);

    @Nullable
    public final RoundedPolygon getTrackPolygon() {
        return this.trackPolygon;
    }

    public final void setTrackPolygon(@Nullable RoundedPolygon roundedPolygon) {
        this.trackPolygon = roundedPolygon;
    }

    @Nullable
    public final RoundedPolygon getActiveIndicatorPolygon() {
        return this.activeIndicatorPolygon;
    }

    public final void setActiveIndicatorPolygon(@Nullable RoundedPolygon roundedPolygon) {
        this.activeIndicatorPolygon = roundedPolygon;
    }

    @Nullable
    public final Morph getActiveIndicatorMorph() {
        return this.activeIndicatorMorph;
    }

    public final void setActiveIndicatorMorph(@Nullable Morph morph) {
        this.activeIndicatorMorph = morph;
    }

    @NotNull
    public final MutableIntState getCurrentVertexCount() {
        return this.currentVertexCount;
    }

    public final void update-Pq9zytI(long size, @FloatRange(from=0.0, fromInclusive=false) float wavelength, @FloatRange(from=0.0, fromInclusive=false) float strokeWidth) {
        if (!(wavelength > 0.0f)) {
            boolean $i$a$-require-CircularShapes$update$32 = false;
            String $i$a$-require-CircularShapes$update$32 = "Wavelength should be greater than zero";
            throw new IllegalArgumentException($i$a$-require-CircularShapes$update$32.toString());
        }
        if (!(Size.getMinDimension-impl((long)size) > 0.0f)) {
            boolean $i$a$-require-CircularShapes$update$42 = false;
            String $i$a$-require-CircularShapes$update$42 = "Size min dimension should be greater than zero";
            throw new IllegalArgumentException($i$a$-require-CircularShapes$update$42.toString());
        }
        if (Size.equals-impl((long)size, (Object)this.currentSize) && wavelength == this.currentWavelength) {
            return;
        }
        float r = Size.getMinDimension-impl((long)size) / (float)2 - strokeWidth / (float)2;
        int numVertices = Math.max(5, (int)(Math.PI * 2 * (double)r / (double)wavelength));
        this.trackPolygon = ShapesKt.circle$default((RoundedPolygon.Companion)RoundedPolygon.Companion, (int)numVertices, (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null).normalized();
        this.activeIndicatorPolygon = ShapesKt.star$default((RoundedPolygon.Companion)RoundedPolygon.Companion, (int)numVertices, (float)0.0f, (float)0.75f, (CornerRounding)new CornerRounding(0.35f, 0.4f), (CornerRounding)new CornerRounding(0.5f, 0.0f, 2, null), null, (float)0.0f, (float)0.0f, (int)226, null).normalized();
        RoundedPolygon roundedPolygon = this.trackPolygon;
        Intrinsics.checkNotNull((Object)roundedPolygon);
        RoundedPolygon roundedPolygon2 = this.activeIndicatorPolygon;
        Intrinsics.checkNotNull((Object)roundedPolygon2);
        this.activeIndicatorMorph = new Morph(roundedPolygon, roundedPolygon2);
        this.currentSize = Size.box-impl((long)size);
        this.currentWavelength = wavelength;
        this.currentVertexCount.setIntValue(numVertices);
    }
}

