/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.annotation.FloatRange;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.AndroidPathMeasure_androidKt;
import androidx.compose.ui.graphics.AndroidPath_androidKt;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathMeasure;
import androidx.compose.ui.graphics.StrokeCap;
import androidx.compose.ui.graphics.drawscope.Stroke;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00072\b\b\u0001\u0010,\u001a\u00020\u00042\b\b\u0001\u0010-\u001a\u00020\u0004H\u0002JH\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u00020\t2\b\b\u0001\u00100\u001a\u00020\u00042\b\b\u0001\u0010,\u001a\u00020\u00042\b\b\u0001\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020\f2\u0006\u00103\u001a\u00020\fH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b4\u00105JX\u00106\u001a\u00020(2\u0006\u0010/\u001a\u00020\t2\b\b\u0003\u00100\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u00072\b\b\u0001\u0010,\u001a\u00020\u00042\b\b\u0001\u0010-\u001a\u00020\u00042\b\b\u0001\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020\f2\u0006\u00103\u001a\u00020\f\u00f8\u0001\u0000\u00a2\u0006\u0004\b7\u00108R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00020\tX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010$\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010%\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0018\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00069"}, d2={"Landroidx/compose/material3/LinearProgressDrawingCache;", "", "()V", "currentAmplitude", "", "currentIndicatorTrackGapSize", "currentProgressFractions", "", "currentSize", "Landroidx/compose/ui/geometry/Size;", "J", "currentStroke", "Landroidx/compose/ui/graphics/drawscope/Stroke;", "currentStrokeCapWidth", "getCurrentStrokeCapWidth", "()F", "setCurrentStrokeCapWidth", "(F)V", "currentTrackStroke", "currentWaveOffset", "currentWavelength", "fullProgressPath", "Landroidx/compose/ui/graphics/Path;", "getFullProgressPath", "()Landroidx/compose/ui/graphics/Path;", "pathMeasure", "Landroidx/compose/ui/graphics/PathMeasure;", "getPathMeasure", "()Landroidx/compose/ui/graphics/PathMeasure;", "progressPathScale", "progressPathsToDraw", "", "getProgressPathsToDraw", "()[Landroidx/compose/ui/graphics/Path;", "setProgressPathsToDraw", "([Landroidx/compose/ui/graphics/Path;)V", "[Landroidx/compose/ui/graphics/Path;", "trackPathToDraw", "getTrackPathToDraw", "updateDrawPaths", "", "forceUpdate", "", "progressFractions", "amplitude", "waveOffset", "updateFullPaths", "size", "wavelength", "gapSize", "stroke", "trackStroke", "updateFullPaths-LjSzlW0", "(JFFFLandroidx/compose/ui/graphics/drawscope/Stroke;Landroidx/compose/ui/graphics/drawscope/Stroke;)Z", "updatePaths", "updatePaths-VygBpHg", "(JF[FFFFLandroidx/compose/ui/graphics/drawscope/Stroke;Landroidx/compose/ui/graphics/drawscope/Stroke;)V", "material3_release"})
final class LinearProgressDrawingCache {
    private float currentWavelength = -1.0f;
    private float currentAmplitude = -1.0f;
    private long currentSize = Size.Companion.getUnspecified-NH-jbRc();
    @Nullable
    private float[] currentProgressFractions;
    private float currentIndicatorTrackGapSize;
    private float currentWaveOffset = -1.0f;
    @NotNull
    private Stroke currentStroke;
    @NotNull
    private Stroke currentTrackStroke = this.currentStroke = new Stroke(0.0f, 0.0f, 0, 0, null, 31, null);
    private float progressPathScale = 1.0f;
    @NotNull
    private final Path fullProgressPath = AndroidPath_androidKt.Path();
    @NotNull
    private final PathMeasure pathMeasure = AndroidPathMeasure_androidKt.PathMeasure();
    @NotNull
    private final Path trackPathToDraw = AndroidPath_androidKt.Path();
    @Nullable
    private Path[] progressPathsToDraw;
    private float currentStrokeCapWidth;

    @NotNull
    public final Path getFullProgressPath() {
        return this.fullProgressPath;
    }

    @NotNull
    public final PathMeasure getPathMeasure() {
        return this.pathMeasure;
    }

    @NotNull
    public final Path getTrackPathToDraw() {
        return this.trackPathToDraw;
    }

    @Nullable
    public final Path[] getProgressPathsToDraw() {
        return this.progressPathsToDraw;
    }

    public final void setProgressPathsToDraw(@Nullable Path[] pathArray) {
        this.progressPathsToDraw = pathArray;
    }

    public final float getCurrentStrokeCapWidth() {
        return this.currentStrokeCapWidth;
    }

    public final void setCurrentStrokeCapWidth(float f) {
        this.currentStrokeCapWidth = f;
    }

    public final void updatePaths-VygBpHg(long size, @FloatRange(from=0.0) float wavelength, @NotNull float[] progressFractions, @FloatRange(from=0.0, to=1.0) float amplitude, @FloatRange(from=0.0, to=1.0) float waveOffset, @FloatRange(from=0.0) float gapSize, @NotNull Stroke stroke, @NotNull Stroke trackStroke) {
        if (this.currentProgressFractions == null) {
            this.currentProgressFractions = new float[progressFractions.length];
            int n = 0;
            int n2 = progressFractions.length / 2;
            Path[] pathArray = new Path[n2];
            LinearProgressDrawingCache linearProgressDrawingCache = this;
            while (n < n2) {
                int n3 = n++;
                pathArray[n3] = AndroidPath_androidKt.Path();
            }
            linearProgressDrawingCache.progressPathsToDraw = pathArray;
        }
        boolean pathsUpdates = this.updateFullPaths-LjSzlW0(size, wavelength, amplitude, gapSize, stroke, trackStroke);
        this.updateDrawPaths(pathsUpdates, progressFractions, amplitude, waveOffset);
    }

    public static /* synthetic */ void updatePaths-VygBpHg$default(LinearProgressDrawingCache linearProgressDrawingCache, long l, float f, float[] fArray, float f2, float f3, float f4, Stroke stroke, Stroke stroke2, int n, Object object) {
        if ((n & 2) != 0) {
            f = 0.0f;
        }
        linearProgressDrawingCache.updatePaths-VygBpHg(l, f, fArray, f2, f3, f4, stroke, stroke2);
    }

    private final boolean updateFullPaths-LjSzlW0(long size, @FloatRange(from=0.0) float wavelength, @FloatRange(from=0.0, to=1.0) float amplitude, @FloatRange(from=0.0) float gapSize, Stroke stroke, Stroke trackStroke) {
        if (Size.equals-impl0((long)this.currentSize, (long)size) && this.currentWavelength == wavelength && Intrinsics.areEqual((Object)this.currentStroke, (Object)stroke) && Intrinsics.areEqual((Object)this.currentTrackStroke, (Object)trackStroke) && this.currentIndicatorTrackGapSize == gapSize && (!(this.currentAmplitude == 0.0f) && !(amplitude == 0.0f) || this.currentAmplitude == 0.0f && amplitude == 0.0f)) {
            return false;
        }
        float height = Size.getHeight-impl((long)size);
        float width = Size.getWidth-impl((long)size);
        this.currentStrokeCapWidth = StrokeCap.equals-impl0((int)stroke.getCap-KaPHkGw(), (int)StrokeCap.Companion.getButt-KaPHkGw()) && StrokeCap.equals-impl0((int)trackStroke.getCap-KaPHkGw(), (int)StrokeCap.Companion.getButt-KaPHkGw()) || height > width ? 0.0f : Math.max(stroke.getWidth() / (float)2, trackStroke.getWidth() / (float)2);
        this.fullProgressPath.rewind();
        this.fullProgressPath.moveTo(0.0f, 0.0f);
        if (amplitude == 0.0f) {
            this.fullProgressPath.lineTo(width, 0.0f);
        } else {
            float halfWavelengthPx;
            float anchorX = halfWavelengthPx = wavelength / 2.0f;
            float anchorY = 0.0f;
            float controlX = halfWavelengthPx / 2.0f;
            float controlY = height - stroke.getWidth();
            float widthWithExtraPhase = width + wavelength * (float)2;
            int wavesCount = 0;
            while (anchorX <= widthWithExtraPhase) {
                this.fullProgressPath.quadraticTo(controlX, controlY, anchorX, anchorY);
                anchorX += halfWavelengthPx;
                controlX += halfWavelengthPx;
                controlY *= -1.0f;
                ++wavesCount;
            }
        }
        this.fullProgressPath.translate-k-4lQ0M(OffsetKt.Offset((float)0.0f, (float)(height / 2.0f)));
        this.pathMeasure.setPath(this.fullProgressPath, false);
        float fullPathLength = this.pathMeasure.getLength();
        this.progressPathScale = fullPathLength / (this.fullProgressPath.getBounds().getWidth() + 1.0E-8f);
        this.currentSize = size;
        this.currentWavelength = wavelength;
        this.currentStroke = stroke;
        this.currentTrackStroke = trackStroke;
        this.currentIndicatorTrackGapSize = gapSize;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateDrawPaths(boolean forceUpdate, float[] progressFractions, @FloatRange(from=0.0, to=1.0) float amplitude, @FloatRange(from=0.0, to=1.0) float waveOffset) {
        if (!(!Size.equals-impl0((long)this.currentSize, (long)Size.Companion.getUnspecified-NH-jbRc()))) {
            boolean $i$a$-require-LinearProgressDrawingCache$updateDrawPaths$32 = false;
            String $i$a$-require-LinearProgressDrawingCache$updateDrawPaths$32 = "updateDrawPaths was called before updateFullPaths";
            throw new IllegalArgumentException($i$a$-require-LinearProgressDrawingCache$updateDrawPaths$32.toString());
        }
        Intrinsics.checkNotNull((Object)this.progressPathsToDraw);
        if (!(this.progressPathsToDraw.length == progressFractions.length / 2)) {
            boolean $i$a$-require-LinearProgressDrawingCache$updateDrawPaths$42 = false;
            StringBuilder stringBuilder = new StringBuilder().append("the given progress fraction pairs do not match the expected number of progress paths to draw. updateDrawPaths called with ").append(progressFractions.length / 2).append(" pairs, while there are ");
            Intrinsics.checkNotNull((Object)this.progressPathsToDraw);
            String $i$a$-require-LinearProgressDrawingCache$updateDrawPaths$42 = stringBuilder.append(this.progressPathsToDraw.length).append(" expected progress paths.").toString();
            throw new IllegalArgumentException($i$a$-require-LinearProgressDrawingCache$updateDrawPaths$42.toString());
        }
        if (!forceUpdate && Arrays.equals(this.currentProgressFractions, progressFractions) && this.currentAmplitude == amplitude && this.currentWaveOffset == waveOffset) {
            return;
        }
        float width = Size.getWidth-impl((long)this.currentSize);
        float halfHeight = Size.getHeight-impl((long)this.currentSize) / 2.0f;
        float adjustedTrackGapSize = this.currentIndicatorTrackGapSize;
        boolean activeIndicatorVisible = false;
        float nextEndTrackOffset = width - this.currentStrokeCapWidth;
        this.trackPathToDraw.rewind();
        this.trackPathToDraw.moveTo(nextEndTrackOffset, halfHeight);
        Intrinsics.checkNotNull((Object)this.progressPathsToDraw);
        int n = this.progressPathsToDraw.length;
        for (int i = 0; i < n; ++i) {
            float adaptiveTrackSpacing;
            Intrinsics.checkNotNull((Object)this.progressPathsToDraw);
            this.progressPathsToDraw[i].rewind();
            float startProgressFraction = progressFractions[i * 2];
            float endProgressFraction = progressFractions[i * 2 + 1];
            float barTail = startProgressFraction * width;
            float barHead = endProgressFraction * width;
            if (i == 0) {
                adjustedTrackGapSize = barHead < this.currentStrokeCapWidth ? 0.0f : Math.min(barHead - this.currentStrokeCapWidth, this.currentIndicatorTrackGapSize);
                activeIndicatorVisible = barHead >= this.currentStrokeCapWidth;
            }
            ClosedFloatingPointRange coerceRange = RangesKt.rangeTo((float)this.currentStrokeCapWidth, (float)(width - this.currentStrokeCapWidth));
            float adjustedBarHead = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(barHead), (ClosedFloatingPointRange)coerceRange))).floatValue();
            float adjustedBarTail = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(barTail), (ClosedFloatingPointRange)coerceRange))).floatValue();
            if (Math.abs(endProgressFraction - startProgressFraction) > 0.0f) {
                void $this$updateDrawPaths_u24lambda_u242;
                float[] fArray;
                float waveShift = !(amplitude == 0.0f) ? waveOffset * this.currentWavelength : 0.0f;
                Intrinsics.checkNotNull((Object)this.progressPathsToDraw);
                PathMeasure.getSegment$default((PathMeasure)this.pathMeasure, (float)((adjustedBarTail + waveShift) * this.progressPathScale), (float)((adjustedBarHead + waveShift) * this.progressPathScale), (Path)this.progressPathsToDraw[i], (boolean)false, (int)8, null);
                Intrinsics.checkNotNull((Object)this.progressPathsToDraw);
                float[] fArray2 = fArray = Matrix.constructor-impl$default(null, (int)1, null);
                Path path = this.progressPathsToDraw[i];
                boolean bl = false;
                Matrix.translate-impl$default((float[])$this$updateDrawPaths_u24lambda_u242, (float)(waveShift > 0.0f ? -waveShift : 0.0f), (float)((1.0f - amplitude) * halfHeight), (float)0.0f, (int)4, null);
                if (!(amplitude == 1.0f)) {
                    Matrix.scale-impl$default((float[])$this$updateDrawPaths_u24lambda_u242, (float)0.0f, (float)amplitude, (float)0.0f, (int)5, null);
                }
                path.transform-58bKbWc(fArray);
            }
            float f = adaptiveTrackSpacing = activeIndicatorVisible ? adjustedTrackGapSize + this.currentStrokeCapWidth * (float)2 : adjustedTrackGapSize;
            if (nextEndTrackOffset > adjustedBarHead + adaptiveTrackSpacing) {
                this.trackPathToDraw.lineTo(Math.max(this.currentStrokeCapWidth, adjustedBarHead + adaptiveTrackSpacing), halfHeight);
            }
            if (!(barHead > barTail)) continue;
            nextEndTrackOffset = Math.max(this.currentStrokeCapWidth, adjustedBarTail - adaptiveTrackSpacing);
            this.trackPathToDraw.moveTo(nextEndTrackOffset, halfHeight);
        }
        if (nextEndTrackOffset > this.currentStrokeCapWidth) {
            this.trackPathToDraw.lineTo(this.currentStrokeCapWidth, halfHeight);
        }
        Intrinsics.checkNotNull((Object)this.currentProgressFractions);
        ArraysKt.copyInto$default((float[])progressFractions, (float[])this.currentProgressFractions, (int)0, (int)0, (int)0, (int)14, null);
        this.currentAmplitude = amplitude;
        this.currentWaveOffset = waveOffset;
    }
}

