/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.internal;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.os.Build;
import android.view.accessibility.AccessibilityManager;
import androidx.annotation.RequiresApi;
import androidx.compose.material3.internal.Listener;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.State;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\b\u0003\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006*\u0002\u0010\u0013\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\"B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0019J\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0019R+\u0010\b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00038B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u00020\u0003*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006#"}, d2={"Landroidx/compose/material3/internal/Listener;", "Landroid/view/accessibility/AccessibilityManager$AccessibilityStateChangeListener;", "Landroidx/compose/runtime/State;", "", "listenToTouchExplorationState", "listenToSwitchAccessState", "(ZZ)V", "<set-?>", "accessibilityEnabled", "getAccessibilityEnabled", "()Z", "setAccessibilityEnabled", "(Z)V", "accessibilityEnabled$delegate", "Landroidx/compose/runtime/MutableState;", "switchAccessListener", "androidx/compose/material3/internal/Listener$switchAccessListener$1", "Landroidx/compose/material3/internal/Listener$switchAccessListener$1;", "touchExplorationListener", "androidx/compose/material3/internal/Listener$touchExplorationListener$1", "Landroidx/compose/material3/internal/Listener$touchExplorationListener$1;", "value", "getValue", "()Ljava/lang/Boolean;", "switchAccessEnabled", "Landroid/view/accessibility/AccessibilityManager;", "getSwitchAccessEnabled", "(Landroid/view/accessibility/AccessibilityManager;)Z", "onAccessibilityStateChanged", "", "enabled", "register", "am", "unregister", "Api33Impl", "material3_release"})
@Stable
@SourceDebugExtension(value={"SMAP\nAccessibilityServiceStateProvider.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessibilityServiceStateProvider.android.kt\nandroidx/compose/material3/internal/Listener\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n83#2:181\n111#2,2:182\n101#3,2:184\n33#3,6:186\n103#3:192\n1#4:193\n*S KotlinDebug\n*F\n+ 1 AccessibilityServiceStateProvider.android.kt\nandroidx/compose/material3/internal/Listener\n*L\n90#1:181\n90#1:182,2\n120#1:184,2\n120#1:186,6\n120#1:192\n*E\n"})
final class Listener
implements AccessibilityManager.AccessibilityStateChangeListener,
State<Boolean> {
    @NotNull
    private final MutableState accessibilityEnabled$delegate = SnapshotStateKt.mutableStateOf$default((Object)false, null, (int)2, null);
    @Nullable
    private final touchExplorationListener.1 touchExplorationListener;
    @Nullable
    private final switchAccessListener.1 switchAccessListener;

    public Listener(boolean listenToTouchExplorationState, boolean listenToSwitchAccessState) {
        this.touchExplorationListener = listenToTouchExplorationState ? new AccessibilityManager.TouchExplorationStateChangeListener(){
            private final MutableState enabled$delegate;
            {
                this.enabled$delegate = SnapshotStateKt.mutableStateOf$default((Object)false, null, (int)2, null);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean getEnabled() {
                void $this$getValue$iv;
                State state2 = (State)this.enabled$delegate;
                Object property$iv = null;
                boolean $i$f$getValue = false;
                return (Boolean)$this$getValue$iv.getValue();
            }

            /*
             * WARNING - void declaration
             */
            public final void setEnabled(boolean bl) {
                void $this$setValue$iv;
                MutableState mutableState = this.enabled$delegate;
                Object var3_3 = null;
                Boolean value$iv = bl;
                boolean $i$f$setValue = false;
                $this$setValue$iv.setValue((Object)value$iv);
            }

            public void onTouchExplorationStateChanged(boolean enabled) {
                this.setEnabled(enabled);
            }
        } : null;
        this.switchAccessListener = listenToSwitchAccessState && Build.VERSION.SDK_INT >= 33 ? new AccessibilityManager.AccessibilityServicesStateChangeListener(this){
            private final MutableState enabled$delegate;
            final /* synthetic */ Listener this$0;
            {
                this.this$0 = $receiver;
                this.enabled$delegate = SnapshotStateKt.mutableStateOf$default((Object)false, null, (int)2, null);
            }

            /*
             * WARNING - void declaration
             */
            public final boolean getEnabled() {
                void $this$getValue$iv;
                State state2 = (State)this.enabled$delegate;
                Object property$iv = null;
                boolean $i$f$getValue = false;
                return (Boolean)$this$getValue$iv.getValue();
            }

            /*
             * WARNING - void declaration
             */
            public final void setEnabled(boolean bl) {
                void $this$setValue$iv;
                MutableState mutableState = this.enabled$delegate;
                Object var3_3 = null;
                Boolean value$iv = bl;
                boolean $i$f$setValue = false;
                $this$setValue$iv.setValue((Object)value$iv);
            }

            public void onAccessibilityServicesStateChanged(AccessibilityManager am) {
                this.setEnabled(Listener.access$getSwitchAccessEnabled(this.this$0, am));
            }
        } : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean getAccessibilityEnabled() {
        void $this$getValue$iv;
        State state2 = (State)this.accessibilityEnabled$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setAccessibilityEnabled(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this.accessibilityEnabled$delegate;
        Object var3_3 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    private final boolean getSwitchAccessEnabled(AccessibilityManager $this$switchAccessEnabled) {
        boolean bl;
        block1: {
            List $this$fastAny$iv = $this$switchAccessEnabled.getEnabledAccessibilityServiceList(16);
            boolean $i$f$fastAny = false;
            List $this$fastForEach$iv$iv = $this$fastAny$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Object item$iv$iv;
                Object it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl2 = false;
                AccessibilityServiceInfo it = (AccessibilityServiceInfo)it$iv;
                boolean bl3 = false;
                String string2 = it.getSettingsActivityName();
                boolean bl4 = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"SwitchAccess", (boolean)false, (int)2, null) : false;
                if (!bl4) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Boolean getValue() {
        boolean bl;
        block2: {
            block3: {
                if (!this.getAccessibilityEnabled()) break block2;
                touchExplorationListener.1 v0 = this.touchExplorationListener;
                if (v0 != null ? v0.getEnabled() : false) break block3;
                switchAccessListener.1 v1 = this.switchAccessListener;
                if (!(v1 != null ? v1.getEnabled() : false)) break block2;
            }
            bl = true;
            return bl;
        }
        bl = false;
        return bl;
    }

    public void onAccessibilityStateChanged(boolean enabled) {
        this.setAccessibilityEnabled(enabled);
    }

    public final void register(@NotNull AccessibilityManager am) {
        block2: {
            Object it;
            this.setAccessibilityEnabled(am.isEnabled());
            am.addAccessibilityStateChangeListener((AccessibilityManager.AccessibilityStateChangeListener)this);
            touchExplorationListener.1 v0 = this.touchExplorationListener;
            if (v0 != null) {
                it = v0;
                boolean bl = false;
                it.setEnabled(am.isTouchExplorationEnabled());
                am.addTouchExplorationStateChangeListener((AccessibilityManager.TouchExplorationStateChangeListener)it);
            }
            if (Build.VERSION.SDK_INT < 33) break block2;
            switchAccessListener.1 v1 = this.switchAccessListener;
            if (v1 != null) {
                it = v1;
                boolean bl = false;
                it.setEnabled(this.getSwitchAccessEnabled(am));
                Api33Impl.addAccessibilityServicesStateChangeListener(am, (AccessibilityManager.AccessibilityServicesStateChangeListener)it);
            }
        }
    }

    public final void unregister(@NotNull AccessibilityManager am) {
        block2: {
            Object it;
            am.removeAccessibilityStateChangeListener((AccessibilityManager.AccessibilityStateChangeListener)this);
            touchExplorationListener.1 v0 = this.touchExplorationListener;
            if (v0 != null) {
                it = v0;
                boolean bl = false;
                am.removeTouchExplorationStateChangeListener((AccessibilityManager.TouchExplorationStateChangeListener)it);
            }
            if (Build.VERSION.SDK_INT < 33) break block2;
            switchAccessListener.1 v1 = this.switchAccessListener;
            if (v1 != null) {
                it = v1;
                boolean bl = false;
                Api33Impl.removeAccessibilityServicesStateChangeListener(am, (AccessibilityManager.AccessibilityServicesStateChangeListener)it);
            }
        }
    }

    public static final /* synthetic */ boolean access$getSwitchAccessEnabled(Listener $this, AccessibilityManager $receiver) {
        return $this.getSwitchAccessEnabled($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\n"}, d2={"Landroidx/compose/material3/internal/Listener$Api33Impl;", "", "()V", "addAccessibilityServicesStateChangeListener", "", "am", "Landroid/view/accessibility/AccessibilityManager;", "listener", "Landroid/view/accessibility/AccessibilityManager$AccessibilityServicesStateChangeListener;", "removeAccessibilityServicesStateChangeListener", "material3_release"})
    @RequiresApi(value=33)
    private static final class Api33Impl {
        @NotNull
        public static final Api33Impl INSTANCE = new Api33Impl();

        private Api33Impl() {
        }

        @JvmStatic
        public static final void addAccessibilityServicesStateChangeListener(@NotNull AccessibilityManager am, @NotNull AccessibilityManager.AccessibilityServicesStateChangeListener listener2) {
            am.addAccessibilityServicesStateChangeListener(listener2);
        }

        @JvmStatic
        public static final void removeAccessibilityServicesStateChangeListener(@NotNull AccessibilityManager am, @NotNull AccessibilityManager.AccessibilityServicesStateChangeListener listener2) {
            am.removeAccessibilityServicesStateChangeListener(listener2);
        }
    }
}

