/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.internal;

import androidx.compose.material3.internal.MenuPosition;
import androidx.compose.runtime.Immutable;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.unit.IntRect;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c1\u0002\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Landroidx/compose/material3/internal/WindowAlignmentMarginPosition;", "", "()V", "Horizontal", "Vertical", "material3_release"})
@Immutable
public final class WindowAlignmentMarginPosition {
    @NotNull
    public static final WindowAlignmentMarginPosition INSTANCE = new WindowAlignmentMarginPosition();
    public static final int $stable;

    private WindowAlignmentMarginPosition() {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\b\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00d6\u0001J2\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001b"}, d2={"Landroidx/compose/material3/internal/WindowAlignmentMarginPosition$Horizontal;", "Landroidx/compose/material3/internal/MenuPosition$Horizontal;", "alignment", "Landroidx/compose/ui/Alignment$Horizontal;", "margin", "", "(Landroidx/compose/ui/Alignment$Horizontal;I)V", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "position", "anchorBounds", "Landroidx/compose/ui/unit/IntRect;", "windowSize", "Landroidx/compose/ui/unit/IntSize;", "menuWidth", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "position-95KtPRI", "(Landroidx/compose/ui/unit/IntRect;JILandroidx/compose/ui/unit/LayoutDirection;)I", "toString", "", "material3_release"})
    @Immutable
    public static final class Horizontal
    implements MenuPosition.Horizontal {
        @NotNull
        private final Alignment.Horizontal alignment;
        private final int margin;
        public static final int $stable;

        public Horizontal(@NotNull Alignment.Horizontal alignment, int margin) {
            this.alignment = alignment;
            this.margin = margin;
        }

        @Override
        public int position-95KtPRI(@NotNull IntRect anchorBounds, long windowSize, int menuWidth, @NotNull LayoutDirection layoutDirection) {
            if (menuWidth >= IntSize.getWidth-impl((long)windowSize) - 2 * this.margin) {
                return Alignment.Companion.getCenterHorizontally().align(menuWidth, IntSize.getWidth-impl((long)windowSize), layoutDirection);
            }
            int x = this.alignment.align(menuWidth, IntSize.getWidth-impl((long)windowSize), layoutDirection);
            return RangesKt.coerceIn((int)x, (int)this.margin, (int)(IntSize.getWidth-impl((long)windowSize) - this.margin - menuWidth));
        }

        private final Alignment.Horizontal component1() {
            return this.alignment;
        }

        private final int component2() {
            return this.margin;
        }

        @NotNull
        public final Horizontal copy(@NotNull Alignment.Horizontal alignment, int margin) {
            return new Horizontal(alignment, margin);
        }

        public static /* synthetic */ Horizontal copy$default(Horizontal horizontal, Alignment.Horizontal horizontal2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                horizontal2 = horizontal.alignment;
            }
            if ((n2 & 2) != 0) {
                n = horizontal.margin;
            }
            return horizontal.copy(horizontal2, n);
        }

        @NotNull
        public String toString() {
            return "Horizontal(alignment=" + this.alignment + ", margin=" + this.margin + ')';
        }

        public int hashCode() {
            int result = this.alignment.hashCode();
            result = result * 31 + Integer.hashCode(this.margin);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Horizontal)) {
                return false;
            }
            Horizontal horizontal = (Horizontal)other;
            if (!Intrinsics.areEqual((Object)this.alignment, (Object)horizontal.alignment)) {
                return false;
            }
            return this.margin == horizontal.margin;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\b\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00d6\u0001J*\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0019"}, d2={"Landroidx/compose/material3/internal/WindowAlignmentMarginPosition$Vertical;", "Landroidx/compose/material3/internal/MenuPosition$Vertical;", "alignment", "Landroidx/compose/ui/Alignment$Vertical;", "margin", "", "(Landroidx/compose/ui/Alignment$Vertical;I)V", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "position", "anchorBounds", "Landroidx/compose/ui/unit/IntRect;", "windowSize", "Landroidx/compose/ui/unit/IntSize;", "menuHeight", "position-JVtK1S4", "(Landroidx/compose/ui/unit/IntRect;JI)I", "toString", "", "material3_release"})
    @Immutable
    public static final class Vertical
    implements MenuPosition.Vertical {
        @NotNull
        private final Alignment.Vertical alignment;
        private final int margin;
        public static final int $stable;

        public Vertical(@NotNull Alignment.Vertical alignment, int margin) {
            this.alignment = alignment;
            this.margin = margin;
        }

        @Override
        public int position-JVtK1S4(@NotNull IntRect anchorBounds, long windowSize, int menuHeight) {
            if (menuHeight >= IntSize.getHeight-impl((long)windowSize) - 2 * this.margin) {
                return Alignment.Companion.getCenterVertically().align(menuHeight, IntSize.getHeight-impl((long)windowSize));
            }
            int y = this.alignment.align(menuHeight, IntSize.getHeight-impl((long)windowSize));
            return RangesKt.coerceIn((int)y, (int)this.margin, (int)(IntSize.getHeight-impl((long)windowSize) - this.margin - menuHeight));
        }

        private final Alignment.Vertical component1() {
            return this.alignment;
        }

        private final int component2() {
            return this.margin;
        }

        @NotNull
        public final Vertical copy(@NotNull Alignment.Vertical alignment, int margin) {
            return new Vertical(alignment, margin);
        }

        public static /* synthetic */ Vertical copy$default(Vertical vertical, Alignment.Vertical vertical2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                vertical2 = vertical.alignment;
            }
            if ((n2 & 2) != 0) {
                n = vertical.margin;
            }
            return vertical.copy(vertical2, n);
        }

        @NotNull
        public String toString() {
            return "Vertical(alignment=" + this.alignment + ", margin=" + this.margin + ')';
        }

        public int hashCode() {
            int result = this.alignment.hashCode();
            result = result * 31 + Integer.hashCode(this.margin);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Vertical)) {
                return false;
            }
            Vertical vertical = (Vertical)other;
            if (!Intrinsics.areEqual((Object)this.alignment, (Object)vertical.alignment)) {
                return false;
            }
            return this.margin == vertical.margin;
        }
    }
}

