/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.compose.lint;

import androidx.constraintlayout.compose.lint.ChainNode;
import androidx.constraintlayout.compose.lint.ChainParamsMethodBuilder;
import androidx.constraintlayout.compose.lint.ConstraintLayoutDslDetectorKt;
import androidx.constraintlayout.compose.lint.EvaluateableExpression;
import androidx.constraintlayout.compose.lint.ResolvedChainLikeExpression;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0016\u00a8\u0006\r"}, d2={"Landroidx/constraintlayout/compose/lint/ConstraintLayoutDslDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UExpression;", "Companion", "constraintlayout-compose-lint"})
public final class ConstraintLayoutDslDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue IncorrectReferencesDeclarationIssue = Issue.Companion.create("IncorrectReferencesDeclaration", "`createRefsFor(vararg ids: Any)` should have at least one argument and match assigned variables", "`createRefsFor(vararg ids: Any)` conveniently allows creating multiple references using destructuring. However, providing an un-equal amount of arguments to the assigned variables will result in unexpected behavior since the variables may reference a ConstrainedLayoutReference with unknown ID.", Category.CORRECTNESS, 5, Severity.ERROR, new Implementation(ConstraintLayoutDslDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE)));
    @NotNull
    private static final Issue IncorrectMatchParentUsageIssue = Issue.Companion.create("IncorrectMatchParentUsage", "Prefer using `Dimension.percent(1f)` when defining custom constraints.", "`Dimension.matchParent` forces the constraints to be an equivalent of `centerHorizontallyTo(parent)` or `centerVerticallyTo(parent)` according to the assigned dimension which can lead to unexpected behavior. To avoid that, prefer using `Dimension.percent(1f)`", Category.CORRECTNESS, 5, Severity.WARNING, new Implementation(ConstraintLayoutDslDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE)));
    @NotNull
    private static final Issue IncorrectChainMarginsUsageIssue = Issue.Companion.create("IncorrectChainMarginsUsage", "Use `LayoutReference.withChainParams()` to define margins for elements in a Chain.", "If you understand how a chain works, it might seem obvious to add margins by re-creating the constraints with the desired margin. However, in Compose, helpers will ignore custom constraints in favor of their layout implementation. So instead, use `LayoutReference.withChainParams()` to define margins for Chains.", Category.CORRECTNESS, 5, Severity.WARNING, new Implementation(ConstraintLayoutDslDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE)));

    @NotNull
    public List<Class<? extends UExpression>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UCallExpression.class, UBinaryExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        return new UElementHandler(context){
            final /* synthetic */ JavaContext $context;
            {
                this.$context = $context;
            }

            public void visitBinaryExpression(@NotNull UBinaryExpression node) {
                Object object = node.getRightOperand().getSourcePsi();
                if (object == null || (object = object.getText()) == null) {
                    return;
                }
                Object assignedReferenceText = object;
                if (Intrinsics.areEqual((Object)assignedReferenceText, (Object)"Dimension.matchParent")) {
                    this.detectMatchParentUsage(node);
                }
            }

            public void visitCallExpression(@NotNull UCallExpression node) {
                block13: {
                    String string = node.getMethodName();
                    if (string == null) break block13;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 855691361: {
                            if (string.equals("createHorizontalChain")) {
                                n = 1;
                            }
                            break;
                        }
                        case -963004979: {
                            if (string.equals("createRefsFor")) {
                                n = 2;
                            }
                            break;
                        }
                        case 483967311: {
                            if (string.equals("createVerticalChain")) {
                                n = 3;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            this.detectCreateRefsForUsage(node);
                            break;
                        }
                        case 1: {
                            this.detectChainParamsUsage(node, true);
                            break;
                        }
                        case 3: {
                            this.detectChainParamsUsage(node, false);
                        }
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void detectMatchParentUsage(UBinaryExpression node) {
                boolean containsErrorProneUsage2;
                boolean isHorizontal;
                block9: {
                    boolean bl;
                    void $this$any$iv;
                    UClass uClass;
                    boolean bl2;
                    UExpression assigneeNode = node.getLeftOperand();
                    Object object = assigneeNode.getSourcePsi();
                    if (object == null || (object = object.getText()) == null) {
                        return;
                    }
                    Object assigneeName = object;
                    Object object2 = assigneeName;
                    if (Intrinsics.areEqual((Object)object2, (Object)"width")) {
                        bl2 = true;
                    } else if (Intrinsics.areEqual((Object)object2, (Object)"height")) {
                        bl2 = false;
                    } else {
                        return;
                    }
                    isHorizontal = bl2;
                    object2 = UastLintUtils.Companion.tryResolveUDeclaration((UElement)assigneeNode);
                    if (!Intrinsics.areEqual(object2 != null && (uClass = UastUtils.getContainingUClass((UElement)((UElement)object2))) != null ? uClass.getQualifiedName() : null, (Object)"androidx.constraintlayout.compose.ConstrainScope")) {
                        return;
                    }
                    UElement $this$getParentOfType_u24default$iv = (UElement)node;
                    boolean strict$iv = true;
                    UElement $this$getParentOfType$iv$iv = $this$getParentOfType_u24default$iv;
                    boolean $i$f$getParentOfType = false;
                    UBlockExpression uBlockExpression = (UBlockExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv, UBlockExpression.class, (boolean)strict$iv);
                    if (uBlockExpression == null) {
                        return;
                    }
                    UBlockExpression containingBlock = uBlockExpression;
                    $this$getParentOfType_u24default$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)containingBlock.getExpressions()), (Function1)((Function1)new Function1<UExpression, EvaluateableExpression>(isHorizontal){
                        final /* synthetic */ boolean $isHorizontal;
                        {
                            this.$isHorizontal = $isHorizontal;
                            super(1);
                        }

                        @Nullable
                        public final EvaluateableExpression invoke(@NotNull UExpression expression) {
                            return EvaluateableExpression.Companion.createForMatchParentUsage(expression, this.$isHorizontal);
                        }
                    }));
                    boolean $i$f$any = false;
                    for (E element$iv : $this$any$iv) {
                        EvaluateableExpression p0 = (EvaluateableExpression)element$iv;
                        boolean bl3 = false;
                        if (!p0.isErrorProneForMatchParentUsage()) continue;
                        bl = true;
                        break block9;
                    }
                    bl = containsErrorProneUsage2 = false;
                }
                if (!containsErrorProneUsage2) {
                    return;
                }
                String overrideMethodName = isHorizontal ? "centerHorizontallyTo" : "centerVerticallyTo";
                this.$context.report(ConstraintLayoutDslDetector.Companion.getIncorrectMatchParentUsageIssue(), (UElement)node.getRightOperand(), this.$context.getNameLocation((UElement)node.getRightOperand()), "`Dimension.matchParent` will override constraints to an equivalent of `" + overrideMethodName + "(parent)`.\nUse `Dimension.percent(1f)` to respect constraints.", LintFix.Companion.create().replace().name("Replace `matchParent` with `percent(1f)`.").range(this.$context.getNameLocation((UElement)node.getRightOperand())).all().with("Dimension.percent(1f)").autoFix().build());
            }

            /*
             * WARNING - void declaration
             */
            private final void detectCreateRefsForUsage(UCallExpression node) {
                int varsReceived;
                PsiElement psiElement;
                block8: {
                    block7: {
                        void $this$getParentOfType$iv;
                        psiElement = node.getSourcePsi();
                        if (psiElement == null) break block7;
                        PsiElement psiElement2 = psiElement;
                        boolean strict$iv = true;
                        boolean $i$f$getParentOfType = false;
                        psiElement = (KtDestructuringDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtDestructuringDeclaration.class, (boolean)strict$iv);
                        if (psiElement != null) break block8;
                    }
                    return;
                }
                PsiElement destructuringDeclarationElement = psiElement;
                int argsGiven = node.getValueArgumentCount();
                if (argsGiven == (varsReceived = destructuringDeclarationElement.getEntries().size())) {
                    return;
                }
                Iterable $this$forEach$iv = node.getValueArguments();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    UExpression argExpression = (UExpression)element$iv;
                    boolean bl = false;
                    PsiType psiType = argExpression.getExpressionType();
                    if (Intrinsics.areEqual((Object)(psiType != null ? psiType.getCanonicalText() : null), (Object)String.class.getName())) continue;
                    return;
                }
                Object object = node.resolve();
                if (object == null || (object = object.getContainingClass()) == null || (object = object.getQualifiedName()) == null) {
                    return;
                }
                Object classOwnerFqName = object;
                if (!ConstraintLayoutDslDetectorKt.access$getKnownOwnersOfCreateRefsFor().contains(classOwnerFqName)) {
                    return;
                }
                JavaContext.report$default((JavaContext)this.$context, (Issue)ConstraintLayoutDslDetector.Companion.getIncorrectReferencesDeclarationIssue(), (UElement)((UElement)node), (Location)this.$context.getNameLocation((UElement)node), (String)("Arguments of `createRefsFor` (" + argsGiven + ") do not match assigned variables (" + varsReceived + ")"), null, (int)16, null);
            }

            /*
             * WARNING - void declaration
             */
            private final void detectChainParamsUsage(UCallExpression node, boolean isHorizontal) {
                void $this$forEachIndexed$iv;
                void $this$mapTo$iv$iv;
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Object p0;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                UElement $this$getParentOfType_u24default$iv = (UElement)node;
                boolean strict$iv22 = true;
                UElement $this$getParentOfType$iv$iv = $this$getParentOfType_u24default$iv;
                boolean $i$f$getParentOfType22 = false;
                UBlockExpression uBlockExpression = (UBlockExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv, UBlockExpression.class, (boolean)strict$iv22);
                if (uBlockExpression == null) {
                    return;
                }
                UBlockExpression containingBlock = uBlockExpression;
                ChainNode previousNode = null;
                Iterable strict$iv22 = node.getValueArguments();
                boolean $i$f$filter = false;
                void $i$f$getParentOfType22 = $this$filter$iv;
                Iterable<ChainNode> destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    p0 = (UExpression)element$iv$iv;
                    boolean bl = false;
                    if (!ConstraintLayoutDslDetectorKt.isOfLayoutReferenceType((UExpression)p0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                p0 = $this$forEach$iv$iv$iv.iterator();
                while (p0.hasNext()) {
                    ChainNode chainNode;
                    E element$iv$iv$iv;
                    E element$iv$iv = element$iv$iv$iv = p0.next();
                    boolean bl = false;
                    UExpression argumentExpression = (UExpression)element$iv$iv;
                    boolean bl2 = false;
                    if (ConstraintLayoutDslDetectorKt.findChildIdentifier(argumentExpression) != null) {
                        USimpleNameReferenceExpression identifier;
                        boolean bl3 = false;
                        ChainNode chainNode2 = new ChainNode(identifier, argumentExpression instanceof UQualifiedReferenceExpression || ConstraintLayoutDslDetectorKt.isChainParamsCalledInIdentifier(containingBlock, identifier));
                        if (previousNode != null) {
                            ChainNode prevNode;
                            boolean bl4 = false;
                            chainNode2.setPrev(prevNode);
                            prevNode.setNext(chainNode2);
                        }
                        previousNode = chainNode2;
                        chainNode = chainNode2;
                    } else {
                        chainNode = null;
                    }
                    if (chainNode == null) continue;
                    ChainNode it$iv$iv = chainNode;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List chainNodes = (List)destination$iv$iv;
                Iterable $this$map$iv = chainNodes;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ChainNode element$iv$iv$iv = (ChainNode)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(it.getHasChainParams() ? CollectionsKt.emptyList() : ConstraintLayoutDslDetectorKt.findChainLikeConstraints(containingBlock, (ChainNode)it, isHorizontal));
                }
                List resolvedChainLikeConstraintsPerNode = (List)destination$iv$iv2;
                $this$map$iv = resolvedChainLikeConstraintsPerNode;
                JavaContext javaContext = this.$context;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    void $this$mapTo$iv$iv2;
                    void chainLikeExpressions;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    List it = (List)item$iv;
                    int index = n;
                    boolean bl = false;
                    ChainParamsMethodBuilder chainParamsBuilder = new ChainParamsMethodBuilder();
                    Iterable $this$map$iv2 = (Iterable)chainLikeExpressions;
                    boolean $i$f$map2 = false;
                    Iterable bl3 = $this$map$iv2;
                    Collection destination$iv$iv3 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv2) {
                        void $this$getParentOfType_u24default$iv2;
                        void resolvedExpression;
                        ResolvedChainLikeExpression bl5 = (ResolvedChainLikeExpression)item$iv$iv;
                        Collection collection = destination$iv$iv3;
                        boolean bl6 = false;
                        if (resolvedExpression.getMarginExpression() != null) {
                            boolean bl7 = false;
                            chainParamsBuilder.append(resolvedExpression.getMarginParamName(), resolvedExpression.getMarginExpression());
                        }
                        if (resolvedExpression.getMarginGoneExpression() != null) {
                            boolean bl8 = false;
                            chainParamsBuilder.append(resolvedExpression.getMarginGoneParamName(), resolvedExpression.getMarginGoneExpression());
                        }
                        UElement uElement = (UElement)resolvedExpression.getFullExpression();
                        boolean strict$iv = true;
                        void $this$getParentOfType$iv$iv2 = $this$getParentOfType_u24default$iv2;
                        boolean $i$f$getParentOfType = false;
                        UQualifiedReferenceExpression expressionToDelete = (UQualifiedReferenceExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv$iv2, UQualifiedReferenceExpression.class, (boolean)strict$iv);
                        collection.add(LintFix.Companion.create().replace().name("Remove conflicting `linkTo` declaration.").range(Context.getLocation$default((Context)((Context)javaContext), (Object)expressionToDelete, null, (int)2, null)).all().with("").autoFix().build());
                    }
                    List removeLinkToFixes = (List)destination$iv$iv3;
                    ChainNode chainNode = (ChainNode)chainNodes.get(index);
                    if (chainParamsBuilder.isEmpty() || !(!((Collection)removeLinkToFixes).isEmpty())) continue;
                    Collection $this$toTypedArray$iv = removeLinkToFixes;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    LintFix[] lintFixArray = thisCollection$iv.toArray(new LintFix[0]);
                    javaContext.report(ConstraintLayoutDslDetector.Companion.getIncorrectChainMarginsUsageIssue(), (UElement)node, Context.getLocation$default((Context)((Context)javaContext), (Object)chainNode.getExpression().getSourcePsi(), null, (int)2, null), "Margins for elements in a Chain should be applied with `LayoutReference.withChainParams(...)`.", LintFix.Companion.create().composite().name("Add `.withChainParams(...)` and remove (" + removeLinkToFixes.size() + ") conflicting `linkTo` declarations.").join(Arrays.copyOf(lintFixArray, lintFixArray.length)).add(LintFix.Companion.create().replace().name("Add `.withChainParams(...)`.").range(Context.getLocation$default((Context)((Context)javaContext), (Object)chainNode.getExpression().getSourcePsi(), null, (int)2, null)).end().with(chainParamsBuilder.build()).autoFix().build()).build());
                }
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Landroidx/constraintlayout/compose/lint/ConstraintLayoutDslDetector$Companion;", "", "()V", "IncorrectChainMarginsUsageIssue", "Lcom/android/tools/lint/detector/api/Issue;", "getIncorrectChainMarginsUsageIssue", "()Lcom/android/tools/lint/detector/api/Issue;", "IncorrectMatchParentUsageIssue", "getIncorrectMatchParentUsageIssue", "IncorrectReferencesDeclarationIssue", "getIncorrectReferencesDeclarationIssue", "constraintlayout-compose-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getIncorrectReferencesDeclarationIssue() {
            return IncorrectReferencesDeclarationIssue;
        }

        @NotNull
        public final Issue getIncorrectMatchParentUsageIssue() {
            return IncorrectMatchParentUsageIssue;
        }

        @NotNull
        public final Issue getIncorrectChainMarginsUsageIssue() {
            return IncorrectChainMarginsUsageIssue;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

