/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.compose;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import androidx.constraintlayout.core.motion.Motion;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0014\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u0000\u0018\u0000 z2\u00020\u0001:\u0001zB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020\u00122\u0006\u0010Y\u001a\u00020\u00122\u0006\u0010Z\u001a\u00020\u00122\u0006\u0010[\u001a\u00020B2\u0006\u0010\\\u001a\u00020BJ6\u0010]\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020\u00122\u0006\u0010^\u001a\u00020\u00122\u0006\u0010Y\u001a\u00020\u00122\u0006\u0010Z\u001a\u00020\u0012JZ\u0010]\u001a\u00020S2\u0006\u0010T\u001a\u00020U2*\u0010_\u001a&\u0012\u0006\u0012\u0004\u0018\u00010a\u0012\u0004\u0012\u00020W\u0018\u00010`j\u0012\u0012\u0006\u0012\u0004\u0018\u00010a\u0012\u0004\u0012\u00020W\u0018\u0001`b2\u0006\u0010X\u001a\u00020\u00122\u0006\u0010^\u001a\u00020\u00122\u0006\u0010Y\u001a\u00020\u00122\u0006\u0010Z\u001a\u00020\u0012J6\u0010c\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010d\u001a\u00020\u00122\u0006\u0010e\u001a\u00020\u00122\u0006\u0010V\u001a\u00020W2\u0006\u0010Y\u001a\u00020\u00122\u0006\u0010Z\u001a\u00020\u0012J\u0010\u0010f\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0002J\u0010\u0010g\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0002J\u0010\u0010h\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0002J \u0010i\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010j\u001a\u00020\u00032\u0006\u0010k\u001a\u00020\u0003H\u0002J\u0010\u0010l\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0002J \u0010m\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010j\u001a\u00020\u00032\u0006\u0010k\u001a\u00020\u0003H\u0002J@\u0010n\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010j\u001a\u00020\u00032\u0006\u0010k\u001a\u00020\u00032\u0006\u0010o\u001a\u00020\u00122\u0006\u0010p\u001a\u00020\u00122\u0006\u0010Y\u001a\u00020\u00122\u0006\u0010Z\u001a\u00020\u0012H\u0002J\u0018\u0010q\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020WH\u0002J8\u0010\\\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010d\u001a\u00020\u00122\u0006\u0010e\u001a\u00020\u00122\u0006\u0010V\u001a\u00020W2\u0006\u0010Y\u001a\u00020\u00122\u0006\u0010Z\u001a\u00020\u0012H\u0002J0\u0010r\u001a\u00020S2\u0006\u0010T\u001a\u00020U2\u0006\u0010s\u001a\u00020\u00032\u0006\u0010t\u001a\u00020\u00032\u0006\u0010u\u001a\u00020\u00032\u0006\u0010v\u001a\u00020\u0003H\u0002J\u0016\u0010w\u001a\u00020S2\u0006\u0010x\u001a\u00020a2\u0006\u0010y\u001a\u00020\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0014R\u001a\u0010\u001d\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0014\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0014R\u001a\u0010)\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0018\"\u0004\b+\u0010\u001aR\u001a\u0010,\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0018\"\u0004\b.\u0010\u001aR\u001a\u0010/\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0018\"\u0004\b1\u0010\u001aR\u001c\u00102\u001a\u0004\u0018\u000103X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u000209X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001c\u0010>\u001a\u0004\u0018\u00010\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010$\"\u0004\b@\u0010&R\u001a\u0010A\u001a\u00020BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u000e\u0010G\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010H\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010\u0014R\u0014\u0010J\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\u0014R\u001a\u0010L\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010\u0014\"\u0004\bN\u0010 R\u001a\u0010O\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010\u0018\"\u0004\bQ\u0010\u001a\u00a8\u0006{"}, d2={"Landroidx/constraintlayout/compose/MotionRenderDebug;", "", "textSize", "", "(F)V", "mBounds", "Landroid/graphics/Rect;", "getMBounds", "()Landroid/graphics/Rect;", "setMBounds", "(Landroid/graphics/Rect;)V", "mDashPathEffect", "Landroid/graphics/DashPathEffect;", "getMDashPathEffect", "()Landroid/graphics/DashPathEffect;", "setMDashPathEffect", "(Landroid/graphics/DashPathEffect;)V", "mDiamondSize", "", "getMDiamondSize", "()I", "mFillPaint", "Landroid/graphics/Paint;", "getMFillPaint", "()Landroid/graphics/Paint;", "setMFillPaint", "(Landroid/graphics/Paint;)V", "mGraphColor", "getMGraphColor", "mKeyFrameCount", "getMKeyFrameCount", "setMKeyFrameCount", "(I)V", "mKeyFramePoints", "", "getMKeyFramePoints", "()[F", "setMKeyFramePoints", "([F)V", "mKeyframeColor", "getMKeyframeColor", "mPaint", "getMPaint", "setMPaint", "mPaintGraph", "getMPaintGraph", "setMPaintGraph", "mPaintKeyframes", "getMPaintKeyframes", "setMPaintKeyframes", "mPath", "Landroid/graphics/Path;", "getMPath", "()Landroid/graphics/Path;", "setMPath", "(Landroid/graphics/Path;)V", "mPathMode", "", "getMPathMode", "()[I", "setMPathMode", "([I)V", "mPoints", "getMPoints", "setMPoints", "mPresentationMode", "", "getMPresentationMode", "()Z", "setMPresentationMode", "(Z)V", "mRectangle", "mRedColor", "getMRedColor", "mShadowColor", "getMShadowColor", "mShadowTranslate", "getMShadowTranslate", "setMShadowTranslate", "mTextPaint", "getMTextPaint", "setMTextPaint", "basicDraw", "", "canvas", "Landroid/graphics/Canvas;", "motionController", "Landroidx/constraintlayout/core/motion/Motion;", "duration", "layoutWidth", "layoutHeight", "drawPath", "drawTicks", "draw", "debugPath", "frameArrayList", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "drawAll", "mode", "keyFrames", "drawBasicPath", "drawPathAsConfigured", "drawPathCartesian", "drawPathCartesianTicks", "x", "y", "drawPathRelative", "drawPathRelativeTicks", "drawPathScreenTicks", "viewWidth", "viewHeight", "drawRectangle", "drawTranslation", "x1", "y1", "x2", "y2", "getTextBounds", "text", "paint", "Companion", "constraintlayout-compose_release"})
public final class MotionRenderDebug {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private float[] mPoints;
    @NotNull
    private int[] mPathMode;
    @NotNull
    private float[] mKeyFramePoints;
    @Nullable
    private Path mPath;
    @NotNull
    private Paint mPaint;
    @NotNull
    private Paint mPaintKeyframes;
    @NotNull
    private Paint mPaintGraph;
    @NotNull
    private Paint mTextPaint;
    @NotNull
    private Paint mFillPaint;
    @NotNull
    private final float[] mRectangle;
    private final int mRedColor;
    private final int mKeyframeColor;
    private final int mGraphColor;
    private final int mShadowColor;
    private final int mDiamondSize;
    @NotNull
    private DashPathEffect mDashPathEffect;
    private int mKeyFrameCount;
    @NotNull
    private Rect mBounds = new Rect();
    private boolean mPresentationMode;
    private int mShadowTranslate = 1;
    public static final int DEBUG_SHOW_NONE = 0;
    public static final int DEBUG_SHOW_PROGRESS = 1;
    public static final int DEBUG_SHOW_PATH = 2;
    public static final int MAX_KEY_FRAMES = 50;
    private static final int DEBUG_PATH_TICKS_PER_MS = 16;

    public MotionRenderDebug(float textSize) {
        this.mRedColor = -21965;
        this.mKeyframeColor = -2067046;
        this.mGraphColor = -13391360;
        this.mShadowColor = 0x77000000;
        this.mDiamondSize = 10;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(this.mRedColor);
        this.mPaint.setStrokeWidth(2.0f);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaintKeyframes = new Paint();
        this.mPaintKeyframes.setAntiAlias(true);
        this.mPaintKeyframes.setColor(this.mKeyframeColor);
        this.mPaintKeyframes.setStrokeWidth(2.0f);
        this.mPaintKeyframes.setStyle(Paint.Style.STROKE);
        this.mPaintGraph = new Paint();
        this.mPaintGraph.setAntiAlias(true);
        this.mPaintGraph.setColor(this.mGraphColor);
        this.mPaintGraph.setStrokeWidth(2.0f);
        this.mPaintGraph.setStyle(Paint.Style.STROKE);
        this.mTextPaint = new Paint();
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setColor(this.mGraphColor);
        this.mTextPaint.setTextSize(textSize);
        this.mRectangle = new float[8];
        this.mFillPaint = new Paint();
        this.mFillPaint.setAntiAlias(true);
        float[] fArray = new float[]{4.0f, 8.0f};
        this.mDashPathEffect = new DashPathEffect(fArray, 0.0f);
        this.mPaintGraph.setPathEffect((PathEffect)this.mDashPathEffect);
        this.mKeyFramePoints = new float[100];
        this.mPathMode = new int[50];
        if (this.mPresentationMode) {
            this.mPaint.setStrokeWidth(8.0f);
            this.mFillPaint.setStrokeWidth(8.0f);
            this.mPaintKeyframes.setStrokeWidth(8.0f);
            this.mShadowTranslate = 4;
        }
    }

    @Nullable
    public final float[] getMPoints() {
        return this.mPoints;
    }

    public final void setMPoints(@Nullable float[] fArray) {
        this.mPoints = fArray;
    }

    @NotNull
    public final int[] getMPathMode() {
        return this.mPathMode;
    }

    public final void setMPathMode(@NotNull int[] nArray) {
        this.mPathMode = nArray;
    }

    @NotNull
    public final float[] getMKeyFramePoints() {
        return this.mKeyFramePoints;
    }

    public final void setMKeyFramePoints(@NotNull float[] fArray) {
        this.mKeyFramePoints = fArray;
    }

    @Nullable
    public final Path getMPath() {
        return this.mPath;
    }

    public final void setMPath(@Nullable Path path) {
        this.mPath = path;
    }

    @NotNull
    public final Paint getMPaint() {
        return this.mPaint;
    }

    public final void setMPaint(@NotNull Paint paint) {
        this.mPaint = paint;
    }

    @NotNull
    public final Paint getMPaintKeyframes() {
        return this.mPaintKeyframes;
    }

    public final void setMPaintKeyframes(@NotNull Paint paint) {
        this.mPaintKeyframes = paint;
    }

    @NotNull
    public final Paint getMPaintGraph() {
        return this.mPaintGraph;
    }

    public final void setMPaintGraph(@NotNull Paint paint) {
        this.mPaintGraph = paint;
    }

    @NotNull
    public final Paint getMTextPaint() {
        return this.mTextPaint;
    }

    public final void setMTextPaint(@NotNull Paint paint) {
        this.mTextPaint = paint;
    }

    @NotNull
    public final Paint getMFillPaint() {
        return this.mFillPaint;
    }

    public final void setMFillPaint(@NotNull Paint paint) {
        this.mFillPaint = paint;
    }

    public final int getMRedColor() {
        return this.mRedColor;
    }

    public final int getMKeyframeColor() {
        return this.mKeyframeColor;
    }

    public final int getMGraphColor() {
        return this.mGraphColor;
    }

    public final int getMShadowColor() {
        return this.mShadowColor;
    }

    public final int getMDiamondSize() {
        return this.mDiamondSize;
    }

    @NotNull
    public final DashPathEffect getMDashPathEffect() {
        return this.mDashPathEffect;
    }

    public final void setMDashPathEffect(@NotNull DashPathEffect dashPathEffect) {
        this.mDashPathEffect = dashPathEffect;
    }

    public final int getMKeyFrameCount() {
        return this.mKeyFrameCount;
    }

    public final void setMKeyFrameCount(int n) {
        this.mKeyFrameCount = n;
    }

    @NotNull
    public final Rect getMBounds() {
        return this.mBounds;
    }

    public final void setMBounds(@NotNull Rect rect) {
        this.mBounds = rect;
    }

    public final boolean getMPresentationMode() {
        return this.mPresentationMode;
    }

    public final void setMPresentationMode(boolean bl) {
        this.mPresentationMode = bl;
    }

    public final int getMShadowTranslate() {
        return this.mShadowTranslate;
    }

    public final void setMShadowTranslate(int n) {
        this.mShadowTranslate = n;
    }

    public final void draw(@NotNull Canvas canvas, @Nullable HashMap<String, Motion> frameArrayList, int duration, int debugPath, int layoutWidth, int layoutHeight) {
        if (frameArrayList == null || frameArrayList.size() == 0) {
            return;
        }
        canvas.save();
        for (Motion motionController : frameArrayList.values()) {
            this.draw(canvas, motionController, duration, debugPath, layoutWidth, layoutHeight);
        }
        canvas.restore();
    }

    public final void draw(@NotNull Canvas canvas, @NotNull Motion motionController, int duration, int debugPath, int layoutWidth, int layoutHeight) {
        block6: {
            int frames;
            int mode;
            block8: {
                block7: {
                    mode = motionController.getDrawPath();
                    if (debugPath > 0 && mode == 0) {
                        mode = 1;
                    }
                    if (mode == 0) {
                        return;
                    }
                    this.mKeyFrameCount = motionController.buildKeyFrames(this.mKeyFramePoints, this.mPathMode, null);
                    if (mode < 1) break block6;
                    frames = duration / 16;
                    if (this.mPoints == null) break block7;
                    Intrinsics.checkNotNull((Object)this.mPoints);
                    if (this.mPoints.length == frames * 2) break block8;
                }
                this.mPoints = new float[frames * 2];
                this.mPath = new Path();
            }
            canvas.translate((float)this.mShadowTranslate, (float)this.mShadowTranslate);
            this.mPaint.setColor(this.mShadowColor);
            this.mFillPaint.setColor(this.mShadowColor);
            this.mPaintKeyframes.setColor(this.mShadowColor);
            this.mPaintGraph.setColor(this.mShadowColor);
            motionController.buildPath(this.mPoints, frames);
            this.drawAll(canvas, mode, this.mKeyFrameCount, motionController, layoutWidth, layoutHeight);
            this.mPaint.setColor(this.mRedColor);
            this.mPaintKeyframes.setColor(this.mKeyframeColor);
            this.mFillPaint.setColor(this.mKeyframeColor);
            this.mPaintGraph.setColor(this.mGraphColor);
            canvas.translate(-((float)this.mShadowTranslate), -((float)this.mShadowTranslate));
            this.drawAll(canvas, mode, this.mKeyFrameCount, motionController, layoutWidth, layoutHeight);
            if (mode == 5) {
                this.drawRectangle(canvas, motionController);
            }
        }
    }

    public final void drawAll(@NotNull Canvas canvas, int mode, int keyFrames, @NotNull Motion motionController, int layoutWidth, int layoutHeight) {
        if (mode == 4) {
            this.drawPathAsConfigured(canvas);
        }
        if (mode == 2) {
            this.drawPathRelative(canvas);
        }
        if (mode == 3) {
            this.drawPathCartesian(canvas);
        }
        this.drawBasicPath(canvas);
        this.drawTicks(canvas, mode, keyFrames, motionController, layoutWidth, layoutHeight);
    }

    public final void basicDraw(@NotNull Canvas canvas, @NotNull Motion motionController, int duration, int layoutWidth, int layoutHeight, boolean drawPath, boolean drawTicks) {
        int frames;
        int mode;
        block8: {
            block7: {
                mode = 1;
                this.mKeyFrameCount = motionController.buildKeyFrames(this.mKeyFramePoints, this.mPathMode, null);
                frames = duration / 16;
                if (this.mPoints == null) break block7;
                Intrinsics.checkNotNull((Object)this.mPoints);
                if (this.mPoints.length == frames * 2) break block8;
            }
            this.mPoints = new float[frames * 2];
            this.mPath = new Path();
        }
        canvas.translate((float)this.mShadowTranslate, (float)this.mShadowTranslate);
        this.mPaint.setColor(this.mShadowColor);
        this.mFillPaint.setColor(this.mShadowColor);
        this.mPaintKeyframes.setColor(this.mShadowColor);
        this.mPaintGraph.setColor(this.mShadowColor);
        motionController.buildPath(this.mPoints, frames);
        if (drawPath) {
            this.drawBasicPath(canvas);
        }
        if (drawTicks) {
            this.drawTicks(canvas, mode, this.mKeyFrameCount, motionController, layoutWidth, layoutHeight);
        }
        this.mPaint.setColor(this.mRedColor);
        this.mPaintKeyframes.setColor(this.mKeyframeColor);
        this.mFillPaint.setColor(this.mKeyframeColor);
        this.mPaintGraph.setColor(this.mGraphColor);
        canvas.translate(-((float)this.mShadowTranslate), -((float)this.mShadowTranslate));
        if (drawPath) {
            this.drawBasicPath(canvas);
        }
        if (drawTicks) {
            this.drawTicks(canvas, mode, this.mKeyFrameCount, motionController, layoutWidth, layoutHeight);
        }
    }

    private final void drawBasicPath(Canvas canvas) {
        Intrinsics.checkNotNull((Object)this.mPoints);
        canvas.drawLines(this.mPoints, this.mPaint);
    }

    private final void drawTicks(Canvas canvas, int mode, int keyFrames, Motion motionController, int layoutWidth, int layoutHeight) {
        int viewWidth = 0;
        int viewHeight = 0;
        if (motionController.getView() != null) {
            viewWidth = motionController.getView().getWidth();
            viewHeight = motionController.getView().getHeight();
        }
        int n = keyFrames - 1;
        for (int i = 1; i < n; ++i) {
            if (mode == 4 && this.mPathMode[i - 1] == 0) continue;
            float x = this.mKeyFramePoints[i * 2];
            float y = this.mKeyFramePoints[i * 2 + 1];
            Path path = this.mPath;
            Intrinsics.checkNotNull((Object)path);
            path.reset();
            Path path2 = this.mPath;
            Intrinsics.checkNotNull((Object)path2);
            path2.moveTo(x, y + (float)this.mDiamondSize);
            Path path3 = this.mPath;
            Intrinsics.checkNotNull((Object)path3);
            path3.lineTo(x + (float)this.mDiamondSize, y);
            Path path4 = this.mPath;
            Intrinsics.checkNotNull((Object)path4);
            path4.lineTo(x, y - (float)this.mDiamondSize);
            Path path5 = this.mPath;
            Intrinsics.checkNotNull((Object)path5);
            path5.lineTo(x - (float)this.mDiamondSize, y);
            Path path6 = this.mPath;
            Intrinsics.checkNotNull((Object)path6);
            path6.close();
            float dx = 0.0f;
            float dy = 0.0f;
            if (mode == 4) {
                if (this.mPathMode[i - 1] == 1) {
                    this.drawPathRelativeTicks(canvas, x - dx, y - dy);
                } else if (this.mPathMode[i - 1] == 0) {
                    this.drawPathCartesianTicks(canvas, x - dx, y - dy);
                } else if (this.mPathMode[i - 1] == 2) {
                    this.drawPathScreenTicks(canvas, x - dx, y - dy, viewWidth, viewHeight, layoutWidth, layoutHeight);
                }
                Path path7 = this.mPath;
                Intrinsics.checkNotNull((Object)path7);
                canvas.drawPath(path7, this.mFillPaint);
            }
            if (mode == 2) {
                this.drawPathRelativeTicks(canvas, x - dx, y - dy);
            }
            if (mode == 3) {
                this.drawPathCartesianTicks(canvas, x - dx, y - dy);
            }
            if (mode == 6) {
                this.drawPathScreenTicks(canvas, x - dx, y - dy, viewWidth, viewHeight, layoutWidth, layoutHeight);
            }
            if (!(dx == 0.0f) || !(dy == 0.0f)) {
                this.drawTranslation(canvas, x - dx, y - dy, x, y);
                continue;
            }
            Path path8 = this.mPath;
            Intrinsics.checkNotNull((Object)path8);
            canvas.drawPath(path8, this.mFillPaint);
        }
        Intrinsics.checkNotNull((Object)this.mPoints);
        if (this.mPoints.length > 1) {
            Intrinsics.checkNotNull((Object)this.mPoints);
            float f = this.mPoints[0];
            Intrinsics.checkNotNull((Object)this.mPoints);
            canvas.drawCircle(f, this.mPoints[1], 8.0f, this.mPaintKeyframes);
            Intrinsics.checkNotNull((Object)this.mPoints);
            Intrinsics.checkNotNull((Object)this.mPoints);
            float f2 = this.mPoints[this.mPoints.length - 2];
            Intrinsics.checkNotNull((Object)this.mPoints);
            Intrinsics.checkNotNull((Object)this.mPoints);
            canvas.drawCircle(f2, this.mPoints[this.mPoints.length - 1], 8.0f, this.mPaintKeyframes);
        }
    }

    private final void drawTranslation(Canvas canvas, float x1, float y1, float x2, float y2) {
        canvas.drawRect(x1, y1, x2, y2, this.mPaintGraph);
        canvas.drawLine(x1, y1, x2, y2, this.mPaintGraph);
    }

    private final void drawPathRelative(Canvas canvas) {
        Intrinsics.checkNotNull((Object)this.mPoints);
        float f = this.mPoints[0];
        Intrinsics.checkNotNull((Object)this.mPoints);
        float f2 = this.mPoints[1];
        Intrinsics.checkNotNull((Object)this.mPoints);
        Intrinsics.checkNotNull((Object)this.mPoints);
        float f3 = this.mPoints[this.mPoints.length - 2];
        Intrinsics.checkNotNull((Object)this.mPoints);
        Intrinsics.checkNotNull((Object)this.mPoints);
        canvas.drawLine(f, f2, f3, this.mPoints[this.mPoints.length - 1], this.mPaintGraph);
    }

    private final void drawPathAsConfigured(Canvas canvas) {
        boolean path = false;
        boolean cart = false;
        int n = this.mKeyFrameCount;
        for (int i = 0; i < n; ++i) {
            if (this.mPathMode[i] == 1) {
                path = true;
            }
            if (this.mPathMode[i] != 0) continue;
            cart = true;
        }
        if (path) {
            this.drawPathRelative(canvas);
        }
        if (cart) {
            this.drawPathCartesian(canvas);
        }
    }

    private final void drawPathRelativeTicks(Canvas canvas, float x, float y) {
        Intrinsics.checkNotNull((Object)this.mPoints);
        float x1 = this.mPoints[0];
        Intrinsics.checkNotNull((Object)this.mPoints);
        float y1 = this.mPoints[1];
        Intrinsics.checkNotNull((Object)this.mPoints);
        Intrinsics.checkNotNull((Object)this.mPoints);
        float x2 = this.mPoints[this.mPoints.length - 2];
        Intrinsics.checkNotNull((Object)this.mPoints);
        Intrinsics.checkNotNull((Object)this.mPoints);
        float y2 = this.mPoints[this.mPoints.length - 1];
        float dist = (float)Math.hypot(x1 - x2, y1 - y2);
        float t = ((x - x1) * (x2 - x1) + (y - y1) * (y2 - y1)) / (dist * dist);
        float xp = x1 + t * (x2 - x1);
        float yp = y1 + t * (y2 - y1);
        Path path = new Path();
        path.moveTo(x, y);
        path.lineTo(xp, yp);
        float len = (float)Math.hypot(xp - x, yp - y);
        String text = "" + (float)((int)((float)100 * len / dist)) / 100.0f;
        this.getTextBounds(text, this.mTextPaint);
        float off = len / (float)2 - (float)(this.mBounds.width() / 2);
        canvas.drawTextOnPath(text, path, off, -20.0f, this.mTextPaint);
        canvas.drawLine(x, y, xp, yp, this.mPaintGraph);
    }

    public final void getTextBounds(@NotNull String text, @NotNull Paint paint) {
        paint.getTextBounds(text, 0, text.length(), this.mBounds);
    }

    private final void drawPathCartesian(Canvas canvas) {
        Intrinsics.checkNotNull((Object)this.mPoints);
        float x1 = this.mPoints[0];
        Intrinsics.checkNotNull((Object)this.mPoints);
        float y1 = this.mPoints[1];
        Intrinsics.checkNotNull((Object)this.mPoints);
        Intrinsics.checkNotNull((Object)this.mPoints);
        float x2 = this.mPoints[this.mPoints.length - 2];
        Intrinsics.checkNotNull((Object)this.mPoints);
        Intrinsics.checkNotNull((Object)this.mPoints);
        float y2 = this.mPoints[this.mPoints.length - 1];
        canvas.drawLine(Math.min(x1, x2), Math.max(y1, y2), Math.max(x1, x2), Math.max(y1, y2), this.mPaintGraph);
        canvas.drawLine(Math.min(x1, x2), Math.min(y1, y2), Math.min(x1, x2), Math.max(y1, y2), this.mPaintGraph);
    }

    private final void drawPathCartesianTicks(Canvas canvas, float x, float y) {
        Intrinsics.checkNotNull((Object)this.mPoints);
        float x1 = this.mPoints[0];
        Intrinsics.checkNotNull((Object)this.mPoints);
        float y1 = this.mPoints[1];
        Intrinsics.checkNotNull((Object)this.mPoints);
        Intrinsics.checkNotNull((Object)this.mPoints);
        float x2 = this.mPoints[this.mPoints.length - 2];
        Intrinsics.checkNotNull((Object)this.mPoints);
        Intrinsics.checkNotNull((Object)this.mPoints);
        float y2 = this.mPoints[this.mPoints.length - 1];
        float minx = Math.min(x1, x2);
        float maxy = Math.max(y1, y2);
        float xgap = x - Math.min(x1, x2);
        float ygap = Math.max(y1, y2) - y;
        String text = "" + (float)((int)(0.5 + (double)((float)100 * xgap / Math.abs(x2 - x1)))) / 100.0f;
        this.getTextBounds(text, this.mTextPaint);
        float off = xgap / (float)2 - (float)(this.mBounds.width() / 2);
        canvas.drawText(text, off + minx, y - (float)20, this.mTextPaint);
        canvas.drawLine(x, y, Math.min(x1, x2), y, this.mPaintGraph);
        text = "" + (float)((int)(0.5 + (double)((float)100 * ygap / Math.abs(y2 - y1)))) / 100.0f;
        this.getTextBounds(text, this.mTextPaint);
        off = ygap / (float)2 - (float)(this.mBounds.height() / 2);
        canvas.drawText(text, x + (float)5, maxy - off, this.mTextPaint);
        canvas.drawLine(x, y, x, Math.max(y1, y2), this.mPaintGraph);
    }

    private final void drawPathScreenTicks(Canvas canvas, float x, float y, int viewWidth, int viewHeight, int layoutWidth, int layoutHeight) {
        float x1 = 0.0f;
        float y1 = 0.0f;
        float x2 = 1.0f;
        float y2 = 1.0f;
        float minx = 0.0f;
        float maxy = 0.0f;
        String text = "" + (float)((int)(0.5 + (double)((float)100 * (x - (float)(viewWidth / 2)) / (float)(layoutWidth - viewWidth)))) / 100.0f;
        this.getTextBounds(text, this.mTextPaint);
        float off = x / (float)2 - (float)(this.mBounds.width() / 2);
        canvas.drawText(text, off + minx, y - (float)20, this.mTextPaint);
        canvas.drawLine(x, y, Math.min(x1, x2), y, this.mPaintGraph);
        text = "" + (float)((int)(0.5 + (double)((float)100 * (y - (float)(viewHeight / 2)) / (float)(layoutHeight - viewHeight)))) / 100.0f;
        this.getTextBounds(text, this.mTextPaint);
        off = y / (float)2 - (float)(this.mBounds.height() / 2);
        canvas.drawText(text, x + (float)5, maxy - off, this.mTextPaint);
        canvas.drawLine(x, y, x, Math.max(y1, y2), this.mPaintGraph);
    }

    private final void drawRectangle(Canvas canvas, Motion motionController) {
        Path path = this.mPath;
        Intrinsics.checkNotNull((Object)path);
        path.reset();
        int rectFrames = 50;
        int i = 0;
        while (true) {
            float p = (float)i / (float)rectFrames;
            motionController.buildRect(p, this.mRectangle, 0);
            Path path2 = this.mPath;
            Intrinsics.checkNotNull((Object)path2);
            path2.moveTo(this.mRectangle[0], this.mRectangle[1]);
            Path path3 = this.mPath;
            Intrinsics.checkNotNull((Object)path3);
            path3.lineTo(this.mRectangle[2], this.mRectangle[3]);
            Path path4 = this.mPath;
            Intrinsics.checkNotNull((Object)path4);
            path4.lineTo(this.mRectangle[4], this.mRectangle[5]);
            Path path5 = this.mPath;
            Intrinsics.checkNotNull((Object)path5);
            path5.lineTo(this.mRectangle[6], this.mRectangle[7]);
            Path path6 = this.mPath;
            Intrinsics.checkNotNull((Object)path6);
            path6.close();
            if (i == rectFrames) break;
            ++i;
        }
        this.mPaint.setColor(0x44000000);
        canvas.translate(2.0f, 2.0f);
        Path path7 = this.mPath;
        Intrinsics.checkNotNull((Object)path7);
        canvas.drawPath(path7, this.mPaint);
        canvas.translate(-2.0f, -2.0f);
        this.mPaint.setColor(-65536);
        Path path8 = this.mPath;
        Intrinsics.checkNotNull((Object)path8);
        canvas.drawPath(path8, this.mPaint);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Landroidx/constraintlayout/compose/MotionRenderDebug$Companion;", "", "()V", "DEBUG_PATH_TICKS_PER_MS", "", "DEBUG_SHOW_NONE", "DEBUG_SHOW_PATH", "DEBUG_SHOW_PROGRESS", "MAX_KEY_FRAMES", "constraintlayout-compose_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

