/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.compose;

import androidx.compose.ui.unit.Dp;
import androidx.constraintlayout.compose.LayoutVariables;
import androidx.constraintlayout.compose.State;
import androidx.constraintlayout.core.state.ConstraintReference;
import androidx.constraintlayout.core.state.Dimension;
import androidx.constraintlayout.core.state.State;
import androidx.constraintlayout.core.state.Transition;
import androidx.constraintlayout.core.state.helpers.BarrierReference;
import androidx.constraintlayout.core.state.helpers.ChainReference;
import androidx.constraintlayout.core.state.helpers.Facade;
import androidx.constraintlayout.core.state.helpers.GuidelineReference;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a&\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a0\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002\u001a \u0010\u0019\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002\u001a \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001e\u0010\u001c\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e\u001a&\u0010\u001f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a(\u0010 \u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0007H\u0002\u001a\u001e\u0010#\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u001e\u001a \u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0011H\u0000\u001a(\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0011H\u0000\u001a\u001e\u0010(\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e\u001a&\u0010)\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006*"}, d2={"PARSER_DEBUG", "", "getPARSER_DEBUG", "()Z", "lookForType", "", "element", "Lorg/json/JSONObject;", "parseBarrier", "", "state", "Landroidx/constraintlayout/compose/State;", "elementName", "parseChain", "orientation", "", "margins", "Landroidx/constraintlayout/compose/LayoutVariables;", "helper", "Lorg/json/JSONArray;", "parseConstraint", "layoutVariables", "reference", "Landroidx/constraintlayout/core/state/ConstraintReference;", "constraintName", "parseCustomProperties", "parseDimension", "Landroidx/constraintlayout/core/state/Dimension;", "parseGenerate", "json", "", "parseGuideline", "parseGuidelineParams", "guidelineId", "params", "parseHelpers", "parseJSON", "content", "transition", "Landroidx/constraintlayout/core/state/Transition;", "parseVariables", "parseWidget", "compose_release"})
public final class ConstraintSetParserKt {
    private static final boolean PARSER_DEBUG;

    public static final boolean getPARSER_DEBUG() {
        return PARSER_DEBUG;
    }

    public static final void parseJSON(@NotNull String content, @NotNull Transition transition, int state2, @NotNull LayoutVariables layoutVariables) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)transition, (String)"transition");
        Intrinsics.checkNotNullParameter((Object)layoutVariables, (String)"layoutVariables");
        JSONObject json = new JSONObject(content);
        JSONArray jSONArray = json.names();
        if (jSONArray == null) {
            return;
        }
        JSONArray elements = jSONArray;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)elements.length());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            JSONObject customProperties;
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            String elementName = elements.get(i).toString();
            Object element = json.get(elementName);
            if (!(element instanceof JSONObject) || (customProperties = ((JSONObject)element).optJSONObject("custom")) == null) continue;
            JSONArray jSONArray2 = customProperties.names();
            if (jSONArray2 == null) {
                return;
            }
            JSONArray properties = jSONArray2;
            Iterable $this$forEach$iv2 = (Iterable)RangesKt.until((int)0, (int)properties.length());
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                int n;
                String string;
                int element$iv2;
                int i2 = element$iv2 = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                String property = properties.get(i2).toString();
                Object value2 = customProperties.get(property);
                if (value2 instanceof Integer) {
                    transition.addCustomFloat(state2, elementName, property, (float)((Number)value2).intValue());
                    continue;
                }
                if (value2 instanceof Float) {
                    transition.addCustomFloat(state2, elementName, property, ((Number)value2).floatValue());
                    continue;
                }
                if (!(value2 instanceof String) || !StringsKt.startsWith$default((CharSequence)((CharSequence)value2), (char)'#', (boolean)false, (int)2, null)) continue;
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                float a = 1.0f;
                if (((String)value2).length() == 7 || ((String)value2).length() == 9) {
                    string = (String)value2;
                    int n2 = 1;
                    int n3 = 3;
                    n = 0;
                    String string2 = string.substring(n2, n3);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    Integer hr = Integer.valueOf(string2, 16);
                    String string3 = (String)value2;
                    n3 = 3;
                    n = 5;
                    int n4 = 0;
                    String string4 = string3.substring(n3, n);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    Integer hg = Integer.valueOf(string4, 16);
                    String string5 = (String)value2;
                    n = 5;
                    n4 = 7;
                    boolean bl3 = false;
                    String string6 = string5.substring(n, n4);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    Integer hb = Integer.valueOf(string6, 16);
                    r = (float)hr.intValue() / 255.0f;
                    g = (float)hg.intValue() / 255.0f;
                    b = (float)hb.intValue() / 255.0f;
                }
                if (((String)value2).length() == 9) {
                    string = (String)value2;
                    int n5 = 5;
                    int n6 = 7;
                    n = 0;
                    String string7 = string.substring(n5, n6);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    Integer ha = Integer.valueOf(string7, 16);
                    a = (float)ha.intValue() / 255.0f;
                }
                transition.addCustomColor(state2, elementName, property, r, g, b, a);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void parseJSON(@NotNull String content, @NotNull State state2, @NotNull LayoutVariables layoutVariables) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        Intrinsics.checkNotNullParameter((Object)layoutVariables, (String)"layoutVariables");
        JSONObject json = new JSONObject(content);
        JSONArray jSONArray = json.names();
        if (jSONArray == null) {
            return;
        }
        JSONArray elements = jSONArray;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)elements.length());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        block15: while (true) {
            Object element;
            String elementName;
            block21: {
                block22: {
                    block23: {
                        int element$iv;
                        if (!iterator.hasNext()) {
                            return;
                        }
                        int i = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl = false;
                        elementName = elements.get(i).toString();
                        element = json.get(elementName);
                        if (ConstraintSetParserKt.getPARSER_DEBUG()) {
                            System.out.println("element <" + elementName + " = " + element + "> " + element.getClass());
                        }
                        switch (elementName) {
                            case "Variables": {
                                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
                                ConstraintSetParserKt.parseVariables(state2, layoutVariables, element);
                                continue block15;
                            }
                            case "Helpers": {
                                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
                                ConstraintSetParserKt.parseHelpers(state2, layoutVariables, element);
                                continue block15;
                            }
                            case "Generate": {
                                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
                                ConstraintSetParserKt.parseGenerate(state2, layoutVariables, element);
                                continue block15;
                            }
                        }
                        if (!(element instanceof JSONObject)) continue;
                        String type = ConstraintSetParserKt.lookForType((JSONObject)element);
                        if (type == null) break block21;
                        String string = type;
                        switch (string.hashCode()) {
                            case -333143113: {
                                if (!string.equals("barrier")) {
                                    continue block15;
                                }
                                break block22;
                            }
                            case 965681512: {
                                if (string.equals("hGuideline")) break;
                                continue block15;
                            }
                            case -1785507558: {
                                if (!string.equals("vGuideline")) {
                                    continue block15;
                                }
                                break block23;
                            }
                        }
                        ConstraintSetParserKt.parseGuidelineParams(0, state2, elementName, (JSONObject)element);
                        continue;
                    }
                    ConstraintSetParserKt.parseGuidelineParams(1, state2, elementName, (JSONObject)element);
                    continue;
                }
                ConstraintSetParserKt.parseBarrier(state2, elementName, (JSONObject)element);
                continue;
            }
            ConstraintSetParserKt.parseWidget(state2, layoutVariables, elementName, (JSONObject)element);
        }
    }

    public static final void parseVariables(@NotNull State state2, @NotNull LayoutVariables layoutVariables, @NotNull Object json) {
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        Intrinsics.checkNotNullParameter((Object)layoutVariables, (String)"layoutVariables");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (!(json instanceof JSONObject)) {
            return;
        }
        JSONArray jSONArray = ((JSONObject)json).names();
        if (jSONArray == null) {
            return;
        }
        JSONArray elements = jSONArray;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)elements.length());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            ArrayList arrayIds;
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            String elementName = elements.get(i).toString();
            Object element = ((JSONObject)json).get(elementName);
            if (element instanceof Integer) {
                layoutVariables.put(elementName, ((Number)element).intValue());
                continue;
            }
            if (!(element instanceof JSONObject)) continue;
            if (((JSONObject)element).has("start") && ((JSONObject)element).has("increment")) {
                Object object = ((JSONObject)element).get("start");
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element[\"start\"]");
                float start = layoutVariables.get(object);
                Object object2 = ((JSONObject)element).get("increment");
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"element[\"increment\"]");
                float increment = layoutVariables.get(object2);
                layoutVariables.put(elementName, start, increment);
                continue;
            }
            if (((JSONObject)element).has("ids")) {
                JSONArray ids = ((JSONObject)element).getJSONArray("ids");
                int n = 0;
                ArrayList<String> arrayIds2 = new ArrayList<String>();
                n = 0;
                int n2 = ids.length() - 1;
                if (n <= n2) {
                    int i2;
                    do {
                        i2 = n++;
                        arrayIds2.add(ids.getString(i2));
                    } while (i2 != n2);
                }
                layoutVariables.put(elementName, arrayIds2);
                continue;
            }
            if (!((JSONObject)element).has("tag")) continue;
            ArrayList arrayList = arrayIds = state2.getIdsForTag(((JSONObject)element).getString("tag"));
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"arrayIds");
            layoutVariables.put(elementName, arrayList);
        }
    }

    public static final void parseHelpers(@NotNull State state2, @NotNull LayoutVariables layoutVariables, @NotNull Object element) {
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        Intrinsics.checkNotNullParameter((Object)layoutVariables, (String)"layoutVariables");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof JSONArray)) {
            return;
        }
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)((JSONArray)element).length());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Object helper = ((JSONArray)element).get(i);
            if (!(helper instanceof JSONArray) || ((JSONArray)helper).length() <= 1) continue;
            Object object = ((JSONArray)helper).get(0);
            if (Intrinsics.areEqual((Object)object, (Object)"hChain")) {
                ConstraintSetParserKt.parseChain(0, state2, layoutVariables, (JSONArray)helper);
                continue;
            }
            if (Intrinsics.areEqual((Object)object, (Object)"vChain")) {
                ConstraintSetParserKt.parseChain(1, state2, layoutVariables, (JSONArray)helper);
                continue;
            }
            if (Intrinsics.areEqual((Object)object, (Object)"hGuideline")) {
                ConstraintSetParserKt.parseGuideline(0, state2, layoutVariables, (JSONArray)helper);
                continue;
            }
            if (!Intrinsics.areEqual((Object)object, (Object)"vGuideline")) continue;
            ConstraintSetParserKt.parseGuideline(1, state2, layoutVariables, (JSONArray)helper);
        }
    }

    public static final void parseGenerate(@NotNull State state2, @NotNull LayoutVariables layoutVariables, @NotNull Object json) {
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        Intrinsics.checkNotNullParameter((Object)layoutVariables, (String)"layoutVariables");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (!(json instanceof JSONObject)) {
            return;
        }
        JSONArray jSONArray = ((JSONObject)json).names();
        if (jSONArray == null) {
            return;
        }
        JSONArray elements = jSONArray;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)elements.length());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            String elementName = elements.get(i).toString();
            Object element = ((JSONObject)json).get(elementName);
            ArrayList<String> arrayIds = layoutVariables.getList(elementName);
            if (arrayIds == null || !(element instanceof JSONObject)) continue;
            for (String id : arrayIds) {
                Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                ConstraintSetParserKt.parseWidget(state2, layoutVariables, id, (JSONObject)element);
            }
        }
    }

    public static final void parseChain(int orientation, @NotNull State state2, @NotNull LayoutVariables margins, @NotNull JSONArray helper) {
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        Intrinsics.checkNotNullParameter((Object)margins, (String)"margins");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        ChainReference chain = null;
        chain = orientation == 0 ? (ChainReference)state2.horizontalChain() : (ChainReference)state2.verticalChain();
        Object refs = null;
        refs = helper.get(1);
        if (!(refs instanceof JSONArray) || ((JSONArray)refs).length() < 1) {
            return;
        }
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)((JSONArray)refs).length());
        boolean $i$f$forEach = false;
        JSONArray jSONArray = $this$forEach$iv.iterator();
        while (jSONArray.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)jSONArray).nextInt();
            boolean bl = false;
            Object[] objectArray = new Object[]{((JSONArray)refs).get(i)};
            chain.add(objectArray);
        }
        if (helper.length() > 2) {
            Object params = null;
            params = helper.get(2);
            if (!(params instanceof JSONObject)) {
                return;
            }
            jSONArray = ((JSONObject)params).names();
            if (jSONArray == null) {
                return;
            }
            JSONArray constraints = jSONArray;
            Iterable $this$forEach$iv2 = (Iterable)RangesKt.until((int)0, (int)constraints.length());
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv2.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int i = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                String constraintName = constraints.get(i).toString();
                String string = constraintName;
                if (Intrinsics.areEqual((Object)string, (Object)"style")) {
                    Object styleObject = ((JSONObject)params).get(constraintName);
                    String styleValue = null;
                    if (styleObject instanceof JSONArray && ((JSONArray)styleObject).length() > 1) {
                        styleValue = ((JSONArray)styleObject).get(0).toString();
                        String string2 = ((JSONArray)styleObject).get(1).toString();
                        boolean bl2 = false;
                        float biasValue = Float.parseFloat(string2);
                        chain.bias(biasValue);
                    } else {
                        styleValue = styleObject.toString();
                    }
                    String string3 = styleValue;
                    if (Intrinsics.areEqual((Object)string3, (Object)"packed")) {
                        chain.style(State.Chain.PACKED);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)string3, (Object)"spread_inside")) {
                        chain.style(State.Chain.SPREAD_INSIDE);
                        continue;
                    }
                    chain.style(State.Chain.SPREAD);
                    continue;
                }
                Object object = params;
                JSONObject jSONObject = (JSONObject)object;
                object = chain;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.core.state.ConstraintReference");
                }
                ConstraintSetParserKt.parseConstraint(state2, margins, jSONObject, (ConstraintReference)object, constraintName);
            }
        }
    }

    public static final void parseGuideline(int orientation, @NotNull State state2, @NotNull LayoutVariables margins, @NotNull JSONArray helper) {
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        Intrinsics.checkNotNullParameter((Object)margins, (String)"margins");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Object params = helper.get(1);
        if (!(params instanceof JSONObject)) {
            return;
        }
        Object guidelineId = ((JSONObject)params).opt("id");
        if (guidelineId == null) {
            return;
        }
        Object object = params;
        ConstraintSetParserKt.parseGuidelineParams(orientation, state2, (String)guidelineId, (JSONObject)object);
    }

    private static final void parseGuidelineParams(int orientation, State state2, String guidelineId, JSONObject params) {
        JSONArray jSONArray = params.names();
        if (jSONArray == null) {
            return;
        }
        JSONArray constraints = jSONArray;
        ConstraintReference reference = state2.constraints(guidelineId);
        if (orientation == 0) {
            state2.horizontalGuideline(guidelineId);
        } else {
            state2.verticalGuideline(guidelineId);
        }
        GuidelineReference guidelineReference = null;
        Facade facade = reference.getFacade();
        if (facade == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.core.state.helpers.GuidelineReference");
        }
        guidelineReference = (GuidelineReference)facade;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)constraints.length());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            String constraintName;
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            switch (constraintName = constraints.get(i).toString()) {
                case "start": {
                    int margin = state2.convertDimension(Dp.box-impl((float)Dp.constructor-impl((float)params.getInt(constraintName))));
                    guidelineReference.start((Object)margin);
                    break;
                }
                case "end": {
                    int margin = state2.convertDimension(Dp.box-impl((float)Dp.constructor-impl((float)params.getInt(constraintName))));
                    guidelineReference.end((Object)margin);
                    break;
                }
                case "percent": {
                    guidelineReference.percent((float)params.getDouble(constraintName));
                }
            }
        }
    }

    public static final void parseBarrier(@NotNull State state2, @NotNull String elementName, @NotNull JSONObject element) {
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        Intrinsics.checkNotNullParameter((Object)elementName, (String)"elementName");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BarrierReference reference = state2.barrier(elementName, State.Direction.END);
        JSONArray jSONArray = element.names();
        if (jSONArray == null) {
            return;
        }
        JSONArray constraints = jSONArray;
        BarrierReference barrierReference = null;
        barrierReference = reference;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)constraints.length());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        block8: while (iterator.hasNext()) {
            int i;
            int n;
            int n2;
            JSONArray list;
            String string;
            String constraintName;
            block16: {
                block19: {
                    block17: {
                        block21: {
                            block18: {
                                block20: {
                                    int element$iv;
                                    int i2 = element$iv = ((IntIterator)iterator).nextInt();
                                    boolean bl = false;
                                    constraintName = constraints.get(i2).toString();
                                    string = constraintName;
                                    if (!Intrinsics.areEqual((Object)string, (Object)"direction")) break block16;
                                    String direction = element.getString(constraintName);
                                    String string2 = direction;
                                    if (string2 == null) continue;
                                    switch (string2.hashCode()) {
                                        case 115029: {
                                            if (!string2.equals("top")) {
                                                continue block8;
                                            }
                                            break block17;
                                        }
                                        case 3317767: {
                                            if (!string2.equals("left")) {
                                                continue block8;
                                            }
                                            break block18;
                                        }
                                        case -1383228885: {
                                            if (!string2.equals("bottom")) {
                                                continue block8;
                                            }
                                            break block19;
                                        }
                                        case 109757538: {
                                            if (string2.equals("start")) break;
                                            continue block8;
                                        }
                                        case 100571: {
                                            if (!string2.equals("end")) {
                                                continue block8;
                                            }
                                            break block20;
                                        }
                                        case 108511772: {
                                            if (!string2.equals("right")) {
                                                continue block8;
                                            }
                                            break block21;
                                        }
                                    }
                                    barrierReference.setBarrierDirection(State.Direction.START);
                                    continue;
                                }
                                barrierReference.setBarrierDirection(State.Direction.END);
                                continue;
                            }
                            barrierReference.setBarrierDirection(State.Direction.LEFT);
                            continue;
                        }
                        barrierReference.setBarrierDirection(State.Direction.RIGHT);
                        continue;
                    }
                    barrierReference.setBarrierDirection(State.Direction.TOP);
                    continue;
                }
                barrierReference.setBarrierDirection(State.Direction.BOTTOM);
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"contains") || (list = element.optJSONArray(constraintName)) == null || (n2 = 0) > (n = list.length() - 1)) continue;
            do {
                i = n2++;
                Object elementName2 = list.get(i);
                ConstraintReference reference2 = state2.constraints(elementName2);
                System.out.println("Add REFERENCE (" + elementName2 + " = " + reference2 + ") TO BARRIER ");
                Object[] objectArray = new Object[]{reference2};
                barrierReference.add(objectArray);
            } while (i != n);
        }
    }

    public static final void parseWidget(@NotNull State state2, @NotNull LayoutVariables layoutVariables, @NotNull String elementName, @NotNull JSONObject element) {
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        Intrinsics.checkNotNullParameter((Object)layoutVariables, (String)"layoutVariables");
        Intrinsics.checkNotNullParameter((Object)elementName, (String)"elementName");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ConstraintReference reference = state2.constraints(elementName);
        JSONArray jSONArray = element.names();
        if (jSONArray == null) {
            return;
        }
        JSONArray constraints = jSONArray;
        reference.setWidth(Dimension.Wrap());
        reference.setHeight(Dimension.Wrap());
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)constraints.length());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            String constraintName;
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            switch (constraintName = constraints.get(i).toString()) {
                case "width": {
                    reference.setWidth(ConstraintSetParserKt.parseDimension(element, constraintName, state2));
                    break;
                }
                case "height": {
                    reference.setHeight(ConstraintSetParserKt.parseDimension(element, constraintName, state2));
                    break;
                }
                case "center": {
                    String target = element.getString(constraintName);
                    ConstraintReference targetReference = target.toString().equals("parent") ? state2.constraints(androidx.constraintlayout.core.state.State.PARENT) : state2.constraints(target);
                    reference.startToStart((Object)targetReference);
                    reference.endToEnd((Object)targetReference);
                    reference.topToTop((Object)targetReference);
                    reference.bottomToBottom((Object)targetReference);
                    break;
                }
                case "centerHorizontally": {
                    String target = element.getString(constraintName);
                    ConstraintReference targetReference = target.toString().equals("parent") ? state2.constraints(androidx.constraintlayout.core.state.State.PARENT) : state2.constraints(target);
                    reference.startToStart((Object)targetReference);
                    reference.endToEnd((Object)targetReference);
                    break;
                }
                case "centerVertically": {
                    String target = element.getString(constraintName);
                    ConstraintReference targetReference = target.toString().equals("parent") ? state2.constraints(androidx.constraintlayout.core.state.State.PARENT) : state2.constraints(target);
                    reference.topToTop((Object)targetReference);
                    reference.bottomToBottom((Object)targetReference);
                    break;
                }
                case "alpha": {
                    Object object = element.get(constraintName);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element[constraintName]");
                    float value2 = layoutVariables.get(object);
                    reference.alpha(value2);
                    break;
                }
                case "scaleX": {
                    Object object = element.get(constraintName);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element[constraintName]");
                    float value3 = layoutVariables.get(object);
                    reference.scaleX(value3);
                    break;
                }
                case "scaleY": {
                    Object object = element.get(constraintName);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element[constraintName]");
                    float value4 = layoutVariables.get(object);
                    reference.scaleY(value4);
                    break;
                }
                case "translationX": {
                    Object object = element.get(constraintName);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element[constraintName]");
                    float value5 = layoutVariables.get(object);
                    reference.translationX(value5);
                    break;
                }
                case "translationY": {
                    Object object = element.get(constraintName);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element[constraintName]");
                    float value6 = layoutVariables.get(object);
                    reference.translationY(value6);
                    break;
                }
                case "pivotX": {
                    Object object = element.get(constraintName);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element[constraintName]");
                    float value7 = layoutVariables.get(object);
                    reference.pivotX(value7);
                    break;
                }
                case "pivotY": {
                    Object object = element.get(constraintName);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element[constraintName]");
                    float value8 = layoutVariables.get(object);
                    reference.pivotY(value8);
                    break;
                }
                case "rotationX": {
                    Object object = element.get(constraintName);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element[constraintName]");
                    float value9 = layoutVariables.get(object);
                    reference.rotationX(value9);
                    break;
                }
                case "rotationY": {
                    Object object = element.get(constraintName);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element[constraintName]");
                    float value10 = layoutVariables.get(object);
                    reference.rotationY(value10);
                    break;
                }
                case "rotationZ": {
                    Object object = element.get(constraintName);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element[constraintName]");
                    float value11 = layoutVariables.get(object);
                    reference.rotationZ(value11);
                    break;
                }
                case "custom": {
                    Intrinsics.checkNotNullExpressionValue((Object)reference, (String)"reference");
                    ConstraintSetParserKt.parseCustomProperties(element, reference, constraintName);
                    break;
                }
                default: {
                    Intrinsics.checkNotNullExpressionValue((Object)reference, (String)"reference");
                    ConstraintSetParserKt.parseConstraint(state2, layoutVariables, element, reference, constraintName);
                }
            }
        }
    }

    private static final void parseCustomProperties(JSONObject element, ConstraintReference reference, String constraintName) {
        JSONObject json = null;
        json = element.optJSONObject(constraintName);
        if (json == null) {
            return;
        }
        JSONArray jSONArray = json.names();
        if (jSONArray == null) {
            return;
        }
        JSONArray properties = jSONArray;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)properties.length());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int n;
            String string;
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            String property = properties.get(i).toString();
            Object value2 = json.get(property);
            if (value2 instanceof Integer) {
                reference.addCustomFloat(property, (float)((Number)value2).intValue());
                continue;
            }
            if (value2 instanceof Float) {
                reference.addCustomFloat(property, ((Number)value2).floatValue());
                continue;
            }
            if (!(value2 instanceof String) || !StringsKt.startsWith$default((CharSequence)((CharSequence)value2), (char)'#', (boolean)false, (int)2, null)) continue;
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            float a = 1.0f;
            if (((String)value2).length() == 7 || ((String)value2).length() == 9) {
                string = (String)value2;
                int n2 = 1;
                int n3 = 3;
                n = 0;
                String string2 = string.substring(n2, n3);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                Integer hr = Integer.valueOf(string2, 16);
                String string3 = (String)value2;
                n3 = 3;
                n = 5;
                int n4 = 0;
                String string4 = string3.substring(n3, n);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                Integer hg = Integer.valueOf(string4, 16);
                String string5 = (String)value2;
                n = 5;
                n4 = 7;
                boolean bl2 = false;
                String string6 = string5.substring(n, n4);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                Integer hb = Integer.valueOf(string6, 16);
                r = (float)hr.intValue() / 255.0f;
                g = (float)hg.intValue() / 255.0f;
                b = (float)hb.intValue() / 255.0f;
            }
            if (((String)value2).length() == 9) {
                string = (String)value2;
                int n5 = 5;
                int n6 = 7;
                n = 0;
                String string7 = string.substring(n5, n6);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                Integer ha = Integer.valueOf(string7, 16);
                a = (float)ha.intValue() / 255.0f;
            }
            reference.addCustomColor(property, r, g, b, a);
        }
    }

    private static final void parseConstraint(State state2, LayoutVariables layoutVariables, JSONObject element, ConstraintReference reference, String constraintName) {
        block42: {
            block40: {
                JSONArray constraint = element.optJSONArray(constraintName);
                if (constraint == null || constraint.length() <= 1) break block40;
                Object target = constraint.get(0);
                Object anchor = constraint.get(1);
                int margin = 0;
                if (constraint.length() > 2) {
                    Object object = constraint.get(2);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"constraint[2]");
                    margin = (int)layoutVariables.get(object);
                }
                margin = state2.convertDimension(Dp.box-impl((float)Dp.constructor-impl((float)margin)));
                ConstraintReference targetReference = target.toString().equals("parent") ? state2.constraints(androidx.constraintlayout.core.state.State.PARENT) : state2.constraints(target);
                switch (constraintName) {
                    case "circular": {
                        Object object = constraint.get(1);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"constraint[1]");
                        float angle = layoutVariables.get(object);
                        reference.circularConstraint((Object)targetReference, angle, 0.0f);
                        break;
                    }
                    case "start": {
                        Object object = anchor;
                        if (Intrinsics.areEqual((Object)object, (Object)"start")) {
                            reference.startToStart((Object)targetReference);
                            break;
                        }
                        if (!Intrinsics.areEqual((Object)object, (Object)"end")) break;
                        reference.startToEnd((Object)targetReference);
                        break;
                    }
                    case "end": {
                        Object object = anchor;
                        if (Intrinsics.areEqual((Object)object, (Object)"start")) {
                            reference.endToStart((Object)targetReference);
                            break;
                        }
                        if (!Intrinsics.areEqual((Object)object, (Object)"end")) break;
                        reference.endToEnd((Object)targetReference);
                        break;
                    }
                    case "top": {
                        Object object = anchor;
                        if (Intrinsics.areEqual((Object)object, (Object)"top")) {
                            reference.topToTop((Object)targetReference);
                            break;
                        }
                        if (!Intrinsics.areEqual((Object)object, (Object)"bottom")) break;
                        reference.topToBottom((Object)targetReference);
                        break;
                    }
                    case "bottom": {
                        Object object = anchor;
                        if (Intrinsics.areEqual((Object)object, (Object)"top")) {
                            reference.bottomToTop((Object)targetReference);
                            break;
                        }
                        if (!Intrinsics.areEqual((Object)object, (Object)"bottom")) break;
                        reference.bottomToBottom((Object)targetReference);
                    }
                }
                reference.margin(margin);
                break block42;
            }
            String target = element.optString(constraintName);
            if (target == null) break block42;
            ConstraintReference targetReference = target.toString().equals("parent") ? state2.constraints(androidx.constraintlayout.core.state.State.PARENT) : state2.constraints(target);
            switch (constraintName) {
                case "start": {
                    reference.startToStart((Object)targetReference);
                    break;
                }
                case "end": {
                    reference.endToEnd((Object)targetReference);
                    break;
                }
                case "top": {
                    reference.topToTop((Object)targetReference);
                    break;
                }
                case "bottom": {
                    reference.bottomToBottom((Object)targetReference);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final Dimension parseDimension(JSONObject element, String constraintName, State state2) {
        void var4_11;
        String dimensionString = element.getString(constraintName);
        Object var4_4 = null;
        String string = dimensionString;
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case -995424086: {
                    if (!string.equals("parent")) break;
                    n = 1;
                    break;
                }
                case 3657802: {
                    if (!string.equals("wrap")) break;
                    n = 2;
                    break;
                }
                case -895684237: {
                    if (!string.equals("spread")) break;
                    n = 3;
                    break;
                }
            }
            switch (n) {
                case 2: {
                    Dimension dimension = Dimension.Wrap();
                    Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"Wrap()");
                    Dimension dimension2 = dimension;
                    return var4_11;
                }
                case 3: {
                    Dimension dimension = Dimension.Suggested((Object)Dimension.SPREAD_DIMENSION);
                    Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"Suggested(SPREAD_DIMENSION)");
                    Dimension dimension3 = dimension;
                    return var4_11;
                }
                case 1: {
                    Dimension dimension = Dimension.Parent();
                    Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"Parent()");
                    Dimension dimension4 = dimension;
                    return var4_11;
                }
            }
        }
        String string2 = dimensionString;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dimensionString");
        if (StringsKt.endsWith$default((CharSequence)string2, (char)'%', (boolean)false, (int)2, null)) {
            String percentString;
            String string3 = dimensionString;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"dimensionString");
            String string4 = percentString = StringsKt.substringBefore$default((String)string3, (char)'%', null, (int)2, null);
            boolean bl = false;
            float percentValue = Float.parseFloat(string4) / 100.0f;
            string4 = Dimension.Percent((Object)0, (float)percentValue).suggested(0);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"Percent(0, percentValue).suggested(0)");
            String string5 = string4;
            return var4_11;
        }
        string2 = dimensionString;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dimensionString");
        if (StringsKt.contains$default((CharSequence)string2, (char)':', (boolean)false, (int)2, null)) {
            string2 = Dimension.Ratio((String)dimensionString).suggested(0);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Ratio(dimensionString).suggested(0)");
            String string6 = string2;
            return var4_11;
        }
        string2 = Dimension.Fixed((int)state2.convertDimension(Dp.box-impl((float)Dp.constructor-impl((float)element.getInt(constraintName)))));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Fixed(\n                    state.convertDimension(\n                        Dp(\n                            element.getInt(constraintName).toFloat()\n                        )\n                    )\n                )");
        String string7 = string2;
        return var4_11;
    }

    @Nullable
    public static final String lookForType(@NotNull JSONObject element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        JSONArray jSONArray = element.names();
        if (jSONArray == null) {
            return null;
        }
        JSONArray constraints = jSONArray;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)constraints.length());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            String constraintName = constraints.get(i).toString();
            if (!constraintName.equals("type")) continue;
            return element.getString("type");
        }
        return null;
    }
}

