/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets;

import androidx.constraintlayout.core.LinearSystem;
import androidx.constraintlayout.core.Metrics;
import androidx.constraintlayout.core.SolverVariable;
import androidx.constraintlayout.core.widgets.Barrier;
import androidx.constraintlayout.core.widgets.Chain;
import androidx.constraintlayout.core.widgets.ChainHead;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.Guideline;
import androidx.constraintlayout.core.widgets.Optimizer;
import androidx.constraintlayout.core.widgets.VirtualLayout;
import androidx.constraintlayout.core.widgets.WidgetContainer;
import androidx.constraintlayout.core.widgets.analyzer.BasicMeasure;
import androidx.constraintlayout.core.widgets.analyzer.DependencyGraph;
import androidx.constraintlayout.core.widgets.analyzer.Direct;
import androidx.constraintlayout.core.widgets.analyzer.Grouping;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class ConstraintWidgetContainer
extends WidgetContainer {
    private static final int MAX_ITERATIONS = 8;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_LAYOUT = false;
    static final boolean DEBUG_GRAPH = false;
    BasicMeasure mBasicMeasureSolver = new BasicMeasure(this);
    public DependencyGraph mDependencyGraph = new DependencyGraph(this);
    private int pass;
    protected BasicMeasure.Measurer mMeasurer = null;
    private boolean mIsRtl = false;
    public Metrics mMetrics;
    protected LinearSystem mSystem = new LinearSystem();
    int mPaddingLeft;
    int mPaddingTop;
    int mPaddingRight;
    int mPaddingBottom;
    public int mHorizontalChainsSize = 0;
    public int mVerticalChainsSize = 0;
    ChainHead[] mVerticalChainsArray = new ChainHead[4];
    ChainHead[] mHorizontalChainsArray = new ChainHead[4];
    public boolean mGroupsWrapOptimized = false;
    public boolean mHorizontalWrapOptimized = false;
    public boolean mVerticalWrapOptimized = false;
    public int mWrapFixedWidth = 0;
    public int mWrapFixedHeight = 0;
    private int mOptimizationLevel = 257;
    public boolean mSkipSolver = false;
    private boolean mWidthMeasuredTooSmall = false;
    private boolean mHeightMeasuredTooSmall = false;
    int mDebugSolverPassCount = 0;
    private WeakReference<ConstraintAnchor> verticalWrapMin = null;
    private WeakReference<ConstraintAnchor> horizontalWrapMin = null;
    private WeakReference<ConstraintAnchor> verticalWrapMax = null;
    private WeakReference<ConstraintAnchor> horizontalWrapMax = null;
    HashSet<ConstraintWidget> widgetsToAdd = new HashSet();
    public BasicMeasure.Measure mMeasure = new BasicMeasure.Measure();
    static int myCounter = 0;

    public void invalidateGraph() {
        this.mDependencyGraph.invalidateGraph();
    }

    public void invalidateMeasures() {
        this.mDependencyGraph.invalidateMeasures();
    }

    public boolean directMeasure(boolean optimizeWrap) {
        return this.mDependencyGraph.directMeasure(optimizeWrap);
    }

    public boolean directMeasureSetup(boolean optimizeWrap) {
        return this.mDependencyGraph.directMeasureSetup(optimizeWrap);
    }

    public boolean directMeasureWithOrientation(boolean optimizeWrap, int orientation) {
        return this.mDependencyGraph.directMeasureWithOrientation(optimizeWrap, orientation);
    }

    public void defineTerminalWidgets() {
        this.mDependencyGraph.defineTerminalWidgets(this.getHorizontalDimensionBehaviour(), this.getVerticalDimensionBehaviour());
    }

    public long measure(int optimizationLevel, int widthMode, int widthSize, int heightMode, int heightSize, int lastMeasureWidth, int lastMeasureHeight, int paddingX, int paddingY) {
        this.mPaddingLeft = paddingX;
        this.mPaddingTop = paddingY;
        return this.mBasicMeasureSolver.solverMeasure(this, optimizationLevel, paddingX, paddingY, widthMode, widthSize, heightMode, heightSize, lastMeasureWidth, lastMeasureHeight);
    }

    public void updateHierarchy() {
        this.mBasicMeasureSolver.updateHierarchy(this);
    }

    public void setMeasurer(BasicMeasure.Measurer measurer) {
        this.mMeasurer = measurer;
        this.mDependencyGraph.setMeasurer(measurer);
    }

    public BasicMeasure.Measurer getMeasurer() {
        return this.mMeasurer;
    }

    public void fillMetrics(Metrics metrics) {
        this.mMetrics = metrics;
        this.mSystem.fillMetrics(metrics);
    }

    public ConstraintWidgetContainer() {
    }

    public ConstraintWidgetContainer(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public ConstraintWidgetContainer(int width, int height) {
        super(width, height);
    }

    public ConstraintWidgetContainer(String debugName, int width, int height) {
        super(width, height);
        this.setDebugName(debugName);
    }

    public void setOptimizationLevel(int value) {
        this.mOptimizationLevel = value;
        LinearSystem.USE_DEPENDENCY_ORDERING = this.optimizeFor(512);
    }

    public int getOptimizationLevel() {
        return this.mOptimizationLevel;
    }

    public boolean optimizeFor(int feature) {
        return (this.mOptimizationLevel & feature) == feature;
    }

    @Override
    public String getType() {
        return "ConstraintLayout";
    }

    @Override
    public void reset() {
        this.mSystem.reset();
        this.mPaddingLeft = 0;
        this.mPaddingRight = 0;
        this.mPaddingTop = 0;
        this.mPaddingBottom = 0;
        this.mSkipSolver = false;
        super.reset();
    }

    public boolean isWidthMeasuredTooSmall() {
        return this.mWidthMeasuredTooSmall;
    }

    public boolean isHeightMeasuredTooSmall() {
        return this.mHeightMeasuredTooSmall;
    }

    void addVerticalWrapMinVariable(ConstraintAnchor top) {
        if (this.verticalWrapMin == null || this.verticalWrapMin.get() == null || top.getFinalValue() > ((ConstraintAnchor)this.verticalWrapMin.get()).getFinalValue()) {
            this.verticalWrapMin = new WeakReference<ConstraintAnchor>(top);
        }
    }

    public void addHorizontalWrapMinVariable(ConstraintAnchor left) {
        if (this.horizontalWrapMin == null || this.horizontalWrapMin.get() == null || left.getFinalValue() > ((ConstraintAnchor)this.horizontalWrapMin.get()).getFinalValue()) {
            this.horizontalWrapMin = new WeakReference<ConstraintAnchor>(left);
        }
    }

    void addVerticalWrapMaxVariable(ConstraintAnchor bottom) {
        if (this.verticalWrapMax == null || this.verticalWrapMax.get() == null || bottom.getFinalValue() > ((ConstraintAnchor)this.verticalWrapMax.get()).getFinalValue()) {
            this.verticalWrapMax = new WeakReference<ConstraintAnchor>(bottom);
        }
    }

    public void addHorizontalWrapMaxVariable(ConstraintAnchor right) {
        if (this.horizontalWrapMax == null || this.horizontalWrapMax.get() == null || right.getFinalValue() > ((ConstraintAnchor)this.horizontalWrapMax.get()).getFinalValue()) {
            this.horizontalWrapMax = new WeakReference<ConstraintAnchor>(right);
        }
    }

    private void addMinWrap(ConstraintAnchor constraintAnchor, SolverVariable parentMin) {
        SolverVariable variable = this.mSystem.createObjectVariable(constraintAnchor);
        int wrapStrength = 5;
        this.mSystem.addGreaterThan(variable, parentMin, 0, wrapStrength);
    }

    private void addMaxWrap(ConstraintAnchor constraintAnchor, SolverVariable parentMax) {
        SolverVariable variable = this.mSystem.createObjectVariable(constraintAnchor);
        int wrapStrength = 5;
        this.mSystem.addGreaterThan(parentMax, variable, 0, wrapStrength);
    }

    public boolean addChildrenToSolver(LinearSystem system) {
        ConstraintWidget widget;
        int i;
        boolean optimize = this.optimizeFor(64);
        this.addToSolver(system, optimize);
        int count = this.mChildren.size();
        boolean hasBarriers = false;
        for (i = 0; i < count; ++i) {
            widget = (ConstraintWidget)this.mChildren.get(i);
            widget.setInBarrier(0, false);
            widget.setInBarrier(1, false);
            if (!(widget instanceof Barrier)) continue;
            hasBarriers = true;
        }
        if (hasBarriers) {
            for (i = 0; i < count; ++i) {
                widget = (ConstraintWidget)this.mChildren.get(i);
                if (!(widget instanceof Barrier)) continue;
                ((Barrier)widget).markWidgets();
            }
        }
        this.widgetsToAdd.clear();
        for (i = 0; i < count; ++i) {
            widget = (ConstraintWidget)this.mChildren.get(i);
            if (!widget.addFirst()) continue;
            if (widget instanceof VirtualLayout) {
                this.widgetsToAdd.add(widget);
                continue;
            }
            widget.addToSolver(system, optimize);
        }
        while (this.widgetsToAdd.size() > 0) {
            int numLayouts = this.widgetsToAdd.size();
            VirtualLayout layout = null;
            for (ConstraintWidget widget2 : this.widgetsToAdd) {
                layout = (VirtualLayout)widget2;
                if (!layout.contains(this.widgetsToAdd)) continue;
                layout.addToSolver(system, optimize);
                this.widgetsToAdd.remove(layout);
                break;
            }
            if (numLayouts != this.widgetsToAdd.size()) continue;
            for (ConstraintWidget widget2 : this.widgetsToAdd) {
                widget2.addToSolver(system, optimize);
            }
            this.widgetsToAdd.clear();
        }
        if (LinearSystem.USE_DEPENDENCY_ORDERING) {
            HashSet<ConstraintWidget> widgetsToAdd = new HashSet<ConstraintWidget>();
            for (int i2 = 0; i2 < count; ++i2) {
                ConstraintWidget widget3 = (ConstraintWidget)this.mChildren.get(i2);
                if (widget3.addFirst()) continue;
                widgetsToAdd.add(widget3);
            }
            int orientation = 1;
            if (this.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                orientation = 0;
            }
            this.addChildrenToSolverByDependency(this, system, widgetsToAdd, orientation, false);
            for (ConstraintWidget widget2 : widgetsToAdd) {
                Optimizer.checkMatchParent(this, system, widget2);
                widget2.addToSolver(system, optimize);
            }
        } else {
            for (i = 0; i < count; ++i) {
                widget = (ConstraintWidget)this.mChildren.get(i);
                if (widget instanceof ConstraintWidgetContainer) {
                    ConstraintWidget.DimensionBehaviour horizontalBehaviour = widget.mListDimensionBehaviors[0];
                    ConstraintWidget.DimensionBehaviour verticalBehaviour = widget.mListDimensionBehaviors[1];
                    if (horizontalBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    }
                    if (verticalBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    }
                    widget.addToSolver(system, optimize);
                    if (horizontalBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                        widget.setHorizontalDimensionBehaviour(horizontalBehaviour);
                    }
                    if (verticalBehaviour != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) continue;
                    widget.setVerticalDimensionBehaviour(verticalBehaviour);
                    continue;
                }
                Optimizer.checkMatchParent(this, system, widget);
                if (widget.addFirst()) continue;
                widget.addToSolver(system, optimize);
            }
        }
        if (this.mHorizontalChainsSize > 0) {
            Chain.applyChainConstraints(this, system, null, 0);
        }
        if (this.mVerticalChainsSize > 0) {
            Chain.applyChainConstraints(this, system, null, 1);
        }
        return true;
    }

    public boolean updateChildrenFromSolver(LinearSystem system, boolean[] flags) {
        flags[2] = false;
        boolean optimize = this.optimizeFor(64);
        this.updateFromSolver(system, optimize);
        int count = this.mChildren.size();
        boolean hasOverride = false;
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            widget.updateFromSolver(system, optimize);
            if (!widget.hasDimensionOverride()) continue;
            hasOverride = true;
        }
        return hasOverride;
    }

    @Override
    public void updateFromRuns(boolean updateHorizontal, boolean updateVertical) {
        super.updateFromRuns(updateHorizontal, updateVertical);
        int count = this.mChildren.size();
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            widget.updateFromRuns(updateHorizontal, updateVertical);
        }
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.mPaddingLeft = left;
        this.mPaddingTop = top;
        this.mPaddingRight = right;
        this.mPaddingBottom = bottom;
    }

    public void setRtl(boolean isRtl) {
        this.mIsRtl = isRtl;
    }

    public boolean isRtl() {
        return this.mIsRtl;
    }

    public static boolean measure(int level, ConstraintWidget widget, BasicMeasure.Measurer measurer, BasicMeasure.Measure measure, int measureStrategy) {
        boolean verticalUseRatio;
        if (measurer == null) {
            return false;
        }
        if (widget.getVisibility() == 8 || widget instanceof Guideline || widget instanceof Barrier) {
            measure.measuredWidth = 0;
            measure.measuredHeight = 0;
            return false;
        }
        measure.horizontalBehavior = widget.getHorizontalDimensionBehaviour();
        measure.verticalBehavior = widget.getVerticalDimensionBehaviour();
        measure.horizontalDimension = widget.getWidth();
        measure.verticalDimension = widget.getHeight();
        measure.measuredNeedsSolverPass = false;
        measure.measureStrategy = measureStrategy;
        boolean horizontalMatchConstraints = measure.horizontalBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
        boolean verticalMatchConstraints = measure.verticalBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
        boolean horizontalUseRatio = horizontalMatchConstraints && widget.mDimensionRatio > 0.0f;
        boolean bl = verticalUseRatio = verticalMatchConstraints && widget.mDimensionRatio > 0.0f;
        if (horizontalMatchConstraints && widget.hasDanglingDimension(0) && widget.mMatchConstraintDefaultWidth == 0 && !horizontalUseRatio) {
            horizontalMatchConstraints = false;
            measure.horizontalBehavior = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            if (verticalMatchConstraints && widget.mMatchConstraintDefaultHeight == 0) {
                measure.horizontalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
            }
        }
        if (verticalMatchConstraints && widget.hasDanglingDimension(1) && widget.mMatchConstraintDefaultHeight == 0 && !verticalUseRatio) {
            verticalMatchConstraints = false;
            measure.verticalBehavior = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            if (horizontalMatchConstraints && widget.mMatchConstraintDefaultWidth == 0) {
                measure.verticalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
            }
        }
        if (widget.isResolvedHorizontally()) {
            horizontalMatchConstraints = false;
            measure.horizontalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
        }
        if (widget.isResolvedVertically()) {
            verticalMatchConstraints = false;
            measure.verticalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
        }
        if (horizontalUseRatio) {
            if (widget.mResolvedMatchConstraintDefault[0] == 4) {
                measure.horizontalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
            } else if (!verticalMatchConstraints) {
                int measuredHeight;
                if (measure.verticalBehavior == ConstraintWidget.DimensionBehaviour.FIXED) {
                    measuredHeight = measure.verticalDimension;
                } else {
                    measure.horizontalBehavior = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                    measurer.measure(widget, measure);
                    measuredHeight = measure.measuredHeight;
                }
                measure.horizontalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
                measure.horizontalDimension = (int)(widget.getDimensionRatio() * (float)measuredHeight);
            }
        }
        if (verticalUseRatio) {
            if (widget.mResolvedMatchConstraintDefault[1] == 4) {
                measure.verticalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
            } else if (!horizontalMatchConstraints) {
                int measuredWidth;
                if (measure.horizontalBehavior == ConstraintWidget.DimensionBehaviour.FIXED) {
                    measuredWidth = measure.horizontalDimension;
                } else {
                    measure.verticalBehavior = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                    measurer.measure(widget, measure);
                    measuredWidth = measure.measuredWidth;
                }
                measure.verticalBehavior = ConstraintWidget.DimensionBehaviour.FIXED;
                measure.verticalDimension = widget.getDimensionRatioSide() == -1 ? (int)((float)measuredWidth / widget.getDimensionRatio()) : (int)(widget.getDimensionRatio() * (float)measuredWidth);
            }
        }
        measurer.measure(widget, measure);
        widget.setWidth(measure.measuredWidth);
        widget.setHeight(measure.measuredHeight);
        widget.setHasBaseline(measure.measuredHasBaseline);
        widget.setBaselineDistance(measure.measuredBaseline);
        measure.measureStrategy = BasicMeasure.Measure.SELF_DIMENSIONS;
        return measure.measuredNeedsSolverPass;
    }

    @Override
    public void layout() {
        this.mX = 0;
        this.mY = 0;
        this.mWidthMeasuredTooSmall = false;
        this.mHeightMeasuredTooSmall = false;
        int count = this.mChildren.size();
        int preW = Math.max(0, this.getWidth());
        int preH = Math.max(0, this.getHeight());
        ConstraintWidget.DimensionBehaviour originalVerticalDimensionBehaviour = this.mListDimensionBehaviors[1];
        ConstraintWidget.DimensionBehaviour originalHorizontalDimensionBehaviour = this.mListDimensionBehaviors[0];
        if (this.mMetrics != null) {
            ++this.mMetrics.layouts;
        }
        boolean wrap_override = false;
        if (this.pass == 0 && Optimizer.enabled(this.mOptimizationLevel, 1)) {
            Direct.solvingPass(this, this.getMeasurer());
            for (int i = 0; i < count; ++i) {
                boolean skip;
                ConstraintWidget child = (ConstraintWidget)this.mChildren.get(i);
                if (!child.isMeasureRequested() || child instanceof Guideline || child instanceof Barrier || child instanceof VirtualLayout || child.isInVirtualLayout()) continue;
                ConstraintWidget.DimensionBehaviour widthBehavior = child.getDimensionBehaviour(0);
                ConstraintWidget.DimensionBehaviour heightBehavior = child.getDimensionBehaviour(1);
                boolean bl = skip = widthBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && child.mMatchConstraintDefaultWidth != 1 && heightBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && child.mMatchConstraintDefaultHeight != 1;
                if (skip) continue;
                BasicMeasure.Measure measure = new BasicMeasure.Measure();
                ConstraintWidgetContainer.measure(0, child, this.mMeasurer, measure, BasicMeasure.Measure.SELF_DIMENSIONS);
            }
        }
        if (count > 2 && (originalHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || originalVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) && Optimizer.enabled(this.mOptimizationLevel, 1024) && Grouping.simpleSolvingPass(this, this.getMeasurer())) {
            if (originalHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                if (preW < this.getWidth() && preW > 0) {
                    this.setWidth(preW);
                    this.mWidthMeasuredTooSmall = true;
                } else {
                    preW = this.getWidth();
                }
            }
            if (originalVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                if (preH < this.getHeight() && preH > 0) {
                    this.setHeight(preH);
                    this.mHeightMeasuredTooSmall = true;
                } else {
                    preH = this.getHeight();
                }
            }
            wrap_override = true;
        }
        boolean useGraphOptimizer = this.optimizeFor(64) || this.optimizeFor(128);
        this.mSystem.graphOptimizer = false;
        this.mSystem.newgraphOptimizer = false;
        if (this.mOptimizationLevel != 0 && useGraphOptimizer) {
            this.mSystem.newgraphOptimizer = true;
        }
        int countSolve = 0;
        ArrayList allChildren = this.mChildren;
        boolean hasWrapContent = this.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || this.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
        this.resetChains();
        countSolve = 0;
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (!(widget instanceof WidgetContainer)) continue;
            ((WidgetContainer)widget).layout();
        }
        boolean optimize = this.optimizeFor(64);
        boolean needsSolving = true;
        while (needsSolving) {
            int height;
            int width;
            int i;
            ++countSolve;
            try {
                this.mSystem.reset();
                this.resetChains();
                this.createObjectVariables(this.mSystem);
                for (i = 0; i < count; ++i) {
                    ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
                    widget.createObjectVariables(this.mSystem);
                }
                needsSolving = this.addChildrenToSolver(this.mSystem);
                if (this.verticalWrapMin != null && this.verticalWrapMin.get() != null) {
                    this.addMinWrap((ConstraintAnchor)this.verticalWrapMin.get(), this.mSystem.createObjectVariable(this.mTop));
                    this.verticalWrapMin = null;
                }
                if (this.verticalWrapMax != null && this.verticalWrapMax.get() != null) {
                    this.addMaxWrap((ConstraintAnchor)this.verticalWrapMax.get(), this.mSystem.createObjectVariable(this.mBottom));
                    this.verticalWrapMax = null;
                }
                if (this.horizontalWrapMin != null && this.horizontalWrapMin.get() != null) {
                    this.addMinWrap((ConstraintAnchor)this.horizontalWrapMin.get(), this.mSystem.createObjectVariable(this.mLeft));
                    this.horizontalWrapMin = null;
                }
                if (this.horizontalWrapMax != null && this.horizontalWrapMax.get() != null) {
                    this.addMaxWrap((ConstraintAnchor)this.horizontalWrapMax.get(), this.mSystem.createObjectVariable(this.mRight));
                    this.horizontalWrapMax = null;
                }
                if (needsSolving) {
                    this.mSystem.minimize();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("EXCEPTION : " + e);
            }
            if (needsSolving) {
                needsSolving = this.updateChildrenFromSolver(this.mSystem, Optimizer.flags);
            } else {
                this.updateFromSolver(this.mSystem, optimize);
                for (i = 0; i < count; ++i) {
                    ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
                    widget.updateFromSolver(this.mSystem, optimize);
                }
                needsSolving = false;
            }
            if (hasWrapContent && countSolve < 8 && Optimizer.flags[2]) {
                int maxX = 0;
                int maxY = 0;
                for (int i2 = 0; i2 < count; ++i2) {
                    ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i2);
                    maxX = Math.max(maxX, widget.mX + widget.getWidth());
                    maxY = Math.max(maxY, widget.mY + widget.getHeight());
                }
                maxX = Math.max(this.mMinWidth, maxX);
                maxY = Math.max(this.mMinHeight, maxY);
                if (originalHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && this.getWidth() < maxX) {
                    this.setWidth(maxX);
                    this.mListDimensionBehaviors[0] = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                    wrap_override = true;
                    needsSolving = true;
                }
                if (originalVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && this.getHeight() < maxY) {
                    this.setHeight(maxY);
                    this.mListDimensionBehaviors[1] = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                    wrap_override = true;
                    needsSolving = true;
                }
            }
            if ((width = Math.max(this.mMinWidth, this.getWidth())) > this.getWidth()) {
                this.setWidth(width);
                this.mListDimensionBehaviors[0] = ConstraintWidget.DimensionBehaviour.FIXED;
                wrap_override = true;
                needsSolving = true;
            }
            if ((height = Math.max(this.mMinHeight, this.getHeight())) > this.getHeight()) {
                this.setHeight(height);
                this.mListDimensionBehaviors[1] = ConstraintWidget.DimensionBehaviour.FIXED;
                wrap_override = true;
                needsSolving = true;
            }
            if (wrap_override) continue;
            if (this.mListDimensionBehaviors[0] == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT && preW > 0 && this.getWidth() > preW) {
                this.mWidthMeasuredTooSmall = true;
                wrap_override = true;
                this.mListDimensionBehaviors[0] = ConstraintWidget.DimensionBehaviour.FIXED;
                this.setWidth(preW);
                needsSolving = true;
            }
            if (this.mListDimensionBehaviors[1] != ConstraintWidget.DimensionBehaviour.WRAP_CONTENT || preH <= 0 || this.getHeight() <= preH) continue;
            this.mHeightMeasuredTooSmall = true;
            wrap_override = true;
            this.mListDimensionBehaviors[1] = ConstraintWidget.DimensionBehaviour.FIXED;
            this.setHeight(preH);
            needsSolving = true;
        }
        this.mChildren = allChildren;
        if (wrap_override) {
            this.mListDimensionBehaviors[0] = originalHorizontalDimensionBehaviour;
            this.mListDimensionBehaviors[1] = originalVerticalDimensionBehaviour;
        }
        this.resetSolverVariables(this.mSystem.getCache());
    }

    public boolean handlesInternalConstraints() {
        return false;
    }

    public ArrayList<Guideline> getVerticalGuidelines() {
        ArrayList<Guideline> guidelines = new ArrayList<Guideline>();
        int mChildrenSize = this.mChildren.size();
        for (int i = 0; i < mChildrenSize; ++i) {
            Guideline guideline;
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (!(widget instanceof Guideline) || (guideline = (Guideline)widget).getOrientation() != 1) continue;
            guidelines.add(guideline);
        }
        return guidelines;
    }

    public ArrayList<Guideline> getHorizontalGuidelines() {
        ArrayList<Guideline> guidelines = new ArrayList<Guideline>();
        int mChildrenSize = this.mChildren.size();
        for (int i = 0; i < mChildrenSize; ++i) {
            Guideline guideline;
            ConstraintWidget widget = (ConstraintWidget)this.mChildren.get(i);
            if (!(widget instanceof Guideline) || (guideline = (Guideline)widget).getOrientation() != 0) continue;
            guidelines.add(guideline);
        }
        return guidelines;
    }

    public LinearSystem getSystem() {
        return this.mSystem;
    }

    private void resetChains() {
        this.mHorizontalChainsSize = 0;
        this.mVerticalChainsSize = 0;
    }

    void addChain(ConstraintWidget constraintWidget, int type) {
        ConstraintWidget widget = constraintWidget;
        if (type == 0) {
            this.addHorizontalChain(widget);
        } else if (type == 1) {
            this.addVerticalChain(widget);
        }
    }

    private void addHorizontalChain(ConstraintWidget widget) {
        if (this.mHorizontalChainsSize + 1 >= this.mHorizontalChainsArray.length) {
            this.mHorizontalChainsArray = Arrays.copyOf(this.mHorizontalChainsArray, this.mHorizontalChainsArray.length * 2);
        }
        this.mHorizontalChainsArray[this.mHorizontalChainsSize] = new ChainHead(widget, 0, this.isRtl());
        ++this.mHorizontalChainsSize;
    }

    private void addVerticalChain(ConstraintWidget widget) {
        if (this.mVerticalChainsSize + 1 >= this.mVerticalChainsArray.length) {
            this.mVerticalChainsArray = Arrays.copyOf(this.mVerticalChainsArray, this.mVerticalChainsArray.length * 2);
        }
        this.mVerticalChainsArray[this.mVerticalChainsSize] = new ChainHead(widget, 1, this.isRtl());
        ++this.mVerticalChainsSize;
    }

    public void setPass(int pass) {
        this.pass = pass;
    }
}

