/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.utils.MonotonicCurveFit;
import java.util.Arrays;

public class Oscillator {
    public static String TAG = "Oscillator";
    float[] mPeriod = new float[0];
    double[] mPosition = new double[0];
    double[] mArea;
    public static final int SIN_WAVE = 0;
    public static final int SQUARE_WAVE = 1;
    public static final int TRIANGLE_WAVE = 2;
    public static final int SAW_WAVE = 3;
    public static final int REVERSE_SAW_WAVE = 4;
    public static final int COS_WAVE = 5;
    public static final int BOUNCE = 6;
    public static final int CUSTOM = 7;
    String mCustomType;
    MonotonicCurveFit mCustomCurve;
    int mType;
    double PI2 = Math.PI * 2;
    private boolean mNormalized = false;

    public String toString() {
        return "pos =" + Arrays.toString(this.mPosition) + " period=" + Arrays.toString(this.mPeriod);
    }

    public void setType(int type, String customType) {
        this.mType = type;
        this.mCustomType = customType;
        if (this.mCustomType != null) {
            this.mCustomCurve = MonotonicCurveFit.buildWave(customType);
        }
    }

    public void addPoint(double position, float period) {
        int len = this.mPeriod.length + 1;
        int j = Arrays.binarySearch(this.mPosition, position);
        if (j < 0) {
            j = -j - 1;
        }
        this.mPosition = Arrays.copyOf(this.mPosition, len);
        this.mPeriod = Arrays.copyOf(this.mPeriod, len);
        this.mArea = new double[len];
        System.arraycopy(this.mPosition, j, this.mPosition, j + 1, len - j - 1);
        this.mPosition[j] = position;
        this.mPeriod[j] = period;
        this.mNormalized = false;
    }

    public void normalize() {
        double w;
        float h;
        int i;
        double totalArea = 0.0;
        double totalCount = 0.0;
        for (i = 0; i < this.mPeriod.length; ++i) {
            totalCount += (double)this.mPeriod[i];
        }
        for (i = 1; i < this.mPeriod.length; ++i) {
            h = (this.mPeriod[i - 1] + this.mPeriod[i]) / 2.0f;
            w = this.mPosition[i] - this.mPosition[i - 1];
            totalArea += w * (double)h;
        }
        i = 0;
        while (i < this.mPeriod.length) {
            int n = i++;
            this.mPeriod[n] = (float)((double)this.mPeriod[n] * (totalCount / totalArea));
        }
        this.mArea[0] = 0.0;
        for (i = 1; i < this.mPeriod.length; ++i) {
            h = (this.mPeriod[i - 1] + this.mPeriod[i]) / 2.0f;
            w = this.mPosition[i] - this.mPosition[i - 1];
            this.mArea[i] = this.mArea[i - 1] + w * (double)h;
        }
        this.mNormalized = true;
    }

    double getP(double time) {
        if (time < 0.0) {
            time = 0.0;
        } else if (time > 1.0) {
            time = 1.0;
        }
        int index = Arrays.binarySearch(this.mPosition, time);
        double p = 0.0;
        if (index > 0) {
            p = 1.0;
        } else if (index != 0) {
            index = -index - 1;
            double t = time;
            double m = (double)(this.mPeriod[index] - this.mPeriod[index - 1]) / (this.mPosition[index] - this.mPosition[index - 1]);
            p = this.mArea[index - 1] + ((double)this.mPeriod[index - 1] - m * this.mPosition[index - 1]) * (t - this.mPosition[index - 1]) + m * (t * t - this.mPosition[index - 1] * this.mPosition[index - 1]) / 2.0;
        }
        return p;
    }

    public double getValue(double time, double phase) {
        double angle = phase + this.getP(time);
        switch (this.mType) {
            default: {
                return Math.sin(this.PI2 * angle);
            }
            case 1: {
                return Math.signum(0.5 - angle % 1.0);
            }
            case 2: {
                return 1.0 - Math.abs((angle * 4.0 + 1.0) % 4.0 - 2.0);
            }
            case 3: {
                return (angle * 2.0 + 1.0) % 2.0 - 1.0;
            }
            case 4: {
                return 1.0 - (angle * 2.0 + 1.0) % 2.0;
            }
            case 5: {
                return Math.cos(this.PI2 * (phase + angle));
            }
            case 6: {
                double x = 1.0 - Math.abs(angle * 4.0 % 4.0 - 2.0);
                return 1.0 - x * x;
            }
            case 7: 
        }
        return this.mCustomCurve.getPos(angle % 1.0, 0);
    }

    double getDP(double time) {
        if (time <= 0.0) {
            time = 1.0E-5;
        } else if (time >= 1.0) {
            time = 0.999999;
        }
        int index = Arrays.binarySearch(this.mPosition, time);
        double p = 0.0;
        if (index > 0) {
            return 0.0;
        }
        if (index != 0) {
            index = -index - 1;
            double t = time;
            double m = (double)(this.mPeriod[index] - this.mPeriod[index - 1]) / (this.mPosition[index] - this.mPosition[index - 1]);
            p = m * t + ((double)this.mPeriod[index - 1] - m * this.mPosition[index - 1]);
        }
        return p;
    }

    public double getSlope(double time, double phase, double dphase) {
        double angle = phase + this.getP(time);
        double dangle_dtime = this.getDP(time) + dphase;
        switch (this.mType) {
            default: {
                return this.PI2 * dangle_dtime * Math.cos(this.PI2 * angle);
            }
            case 1: {
                return 0.0;
            }
            case 2: {
                return 4.0 * dangle_dtime * Math.signum((angle * 4.0 + 3.0) % 4.0 - 2.0);
            }
            case 3: {
                return dangle_dtime * 2.0;
            }
            case 4: {
                return -dangle_dtime * 2.0;
            }
            case 5: {
                return -this.PI2 * dangle_dtime * Math.sin(this.PI2 * angle);
            }
            case 6: {
                return 4.0 * dangle_dtime * ((angle * 4.0 + 2.0) % 4.0 - 2.0);
            }
            case 7: 
        }
        return this.mCustomCurve.getSlope(angle % 1.0, 0);
    }
}

