/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state;

import androidx.constraintlayout.core.state.WidgetFrame;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import java.util.ArrayList;
import java.util.HashMap;

public class Transition {
    HashMap<String, WidgetState> state = new HashMap();
    public static final int START = 0;
    public static final int END = 1;
    public static final int CURRENT = 2;

    public boolean isEmpty() {
        return this.state.isEmpty();
    }

    public void clear() {
        this.state.clear();
    }

    public boolean contains(String key) {
        return this.state.containsKey(key);
    }

    public void addCustomFloat(int state, String widgetId, String property, float value) {
        WidgetState widgetState = this.state.get(widgetId);
        if (widgetState == null) {
            widgetState = new WidgetState();
            this.state.put(widgetId, widgetState);
        }
        if (state == 0) {
            widgetState.start.addCustomFloat(property, value);
        } else if (state == 1) {
            widgetState.end.addCustomFloat(property, value);
        } else {
            widgetState.interpolated.addCustomFloat(property, value);
        }
    }

    public void addCustomColor(int state, String widgetId, String property, float r, float g, float b, float a) {
        WidgetState widgetState = this.state.get(widgetId);
        if (widgetState == null) {
            widgetState = new WidgetState();
            this.state.put(widgetId, widgetState);
        }
        if (state == 0) {
            widgetState.start.addCustomColor(property, r, g, b, a);
        } else if (state == 1) {
            widgetState.end.addCustomColor(property, r, g, b, a);
        } else {
            widgetState.interpolated.addCustomColor(property, r, g, b, a);
        }
    }

    public void updateFrom(WidgetFrame frame, int state, String id) {
        WidgetState widgetState = this.state.get(id);
        if (widgetState == null) {
            widgetState = new WidgetState(null);
        }
        if (state == 0) {
            widgetState.start = frame;
        } else if (state == 1) {
            widgetState.end = frame;
        } else {
            widgetState.interpolated = frame;
        }
        this.state.put(id, widgetState);
    }

    public void updateFrom(ConstraintWidgetContainer container, int state) {
        ArrayList<ConstraintWidget> children = container.getChildren();
        int count = children.size();
        for (int i = 0; i < count; ++i) {
            ConstraintWidget child = children.get(i);
            WidgetState widgetState = this.state.get(child.stringId);
            if (widgetState == null) {
                widgetState = new WidgetState(child);
                this.state.put(child.stringId, widgetState);
            }
            if (state == 0) {
                widgetState.start.update(child);
                continue;
            }
            if (state == 1) {
                widgetState.end.update(child);
                continue;
            }
            widgetState.interpolated.update(child);
        }
    }

    public void interpolate(float progress) {
        for (String key : this.state.keySet()) {
            WidgetState widget = this.state.get(key);
            widget.interpolate(progress);
        }
    }

    public WidgetFrame getStart(String id) {
        WidgetState widgetState = this.state.get(id);
        if (widgetState == null) {
            return null;
        }
        return widgetState.start;
    }

    public WidgetFrame getEnd(String id) {
        WidgetState widgetState = this.state.get(id);
        if (widgetState == null) {
            return null;
        }
        return widgetState.end;
    }

    public WidgetFrame getInterpolated(String id) {
        WidgetState widgetState = this.state.get(id);
        if (widgetState == null) {
            return null;
        }
        return widgetState.interpolated;
    }

    public WidgetFrame getStart(ConstraintWidget child) {
        WidgetState widgetState = this.state.get(child.stringId);
        if (widgetState == null) {
            widgetState = new WidgetState(child);
            this.state.put(child.stringId, widgetState);
        }
        return widgetState.start;
    }

    public WidgetFrame getEnd(ConstraintWidget child) {
        WidgetState widgetState = this.state.get(child.stringId);
        if (widgetState == null) {
            widgetState = new WidgetState(child);
            this.state.put(child.stringId, widgetState);
        }
        return widgetState.end;
    }

    public WidgetFrame getInterpolated(ConstraintWidget child) {
        WidgetState widgetState = this.state.get(child.stringId);
        if (widgetState == null) {
            widgetState = new WidgetState(child);
            this.state.put(child.stringId, widgetState);
        }
        return widgetState.interpolated;
    }

    static class WidgetState {
        WidgetFrame start;
        WidgetFrame end;
        WidgetFrame interpolated;

        public WidgetState() {
            this.start = new WidgetFrame();
            this.end = new WidgetFrame();
            this.interpolated = new WidgetFrame();
        }

        public WidgetState(ConstraintWidget child) {
            this.start = new WidgetFrame(child);
            this.end = new WidgetFrame(child);
            this.interpolated = new WidgetFrame(child);
        }

        public void interpolate(float progress) {
            WidgetFrame.interpolate(this.interpolated, this.start, this.end, progress);
        }
    }
}

