/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import java.util.Arrays;
import java.util.HashMap;

public class KeyCache {
    HashMap<Object, HashMap<String, float[]>> map = new HashMap();

    public void setFloatValue(Object view, String type, int element, float value) {
        if (!this.map.containsKey(view)) {
            HashMap<String, float[]> array = new HashMap<String, float[]>();
            float[] vArray = new float[element + 1];
            vArray[element] = value;
            array.put(type, vArray);
            this.map.put(view, array);
        } else {
            HashMap<String, Object> array = this.map.get(view);
            if (array == null) {
                array = new HashMap();
            }
            if (!array.containsKey(type)) {
                float[] vArray = new float[element + 1];
                vArray[element] = value;
                array.put(type, vArray);
                this.map.put(view, array);
            } else {
                float[] vArray = (float[])array.get(type);
                if (vArray == null) {
                    vArray = new float[]{};
                }
                if (vArray.length <= element) {
                    vArray = Arrays.copyOf(vArray, element + 1);
                }
                vArray[element] = value;
                array.put(type, vArray);
            }
        }
    }

    public float getFloatValue(Object view, String type, int element) {
        if (!this.map.containsKey(view)) {
            return Float.NaN;
        }
        HashMap<String, float[]> array = this.map.get(view);
        if (array == null || !array.containsKey(type)) {
            return Float.NaN;
        }
        float[] vArray = array.get(type);
        if (vArray == null) {
            return Float.NaN;
        }
        if (vArray.length > element) {
            return vArray[element];
        }
        return Float.NaN;
    }
}

