/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.parser;

import androidx.constraintlayout.core.parser.CLContainer;
import androidx.constraintlayout.core.parser.CLElement;
import androidx.constraintlayout.core.parser.CLKey;
import java.util.Iterator;

public class CLObject
extends CLContainer
implements Iterable<CLKey> {
    public CLObject(char[] content) {
        super(content);
    }

    public static CLObject allocate(char[] content) {
        return new CLObject(content);
    }

    @Override
    public String toJSON() {
        StringBuilder json = new StringBuilder(this.getDebugName() + "{ ");
        boolean first = true;
        for (CLElement element : this.mElements) {
            if (!first) {
                json.append(", ");
            } else {
                first = false;
            }
            json.append(element.toJSON());
        }
        json.append(" }");
        return json.toString();
    }

    public String toFormattedJSON() {
        return this.toFormattedJSON(0, 0);
    }

    @Override
    public String toFormattedJSON(int indent, int forceIndent) {
        StringBuilder json = new StringBuilder(this.getDebugName());
        json.append("{\n");
        boolean first = true;
        for (CLElement element : this.mElements) {
            if (!first) {
                json.append(",\n");
            } else {
                first = false;
            }
            json.append(element.toFormattedJSON(indent + BASE_INDENT, forceIndent - 1));
        }
        json.append("\n");
        this.addIndent(json, indent);
        json.append("}");
        return json.toString();
    }

    @Override
    public Iterator iterator() {
        return new CLObjectIterator(this);
    }

    private class CLObjectIterator
    implements Iterator {
        CLObject myObject;
        int index = 0;

        public CLObjectIterator(CLObject clObject) {
            this.myObject = clObject;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.myObject.size();
        }

        public Object next() {
            CLKey key = (CLKey)this.myObject.mElements.get(this.index);
            ++this.index;
            return key;
        }
    }
}

