/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import androidx.constraintlayout.core.motion.utils.Oscillator;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public abstract class KeyCycleOscillator {
    private static final String TAG = "KeyCycleOscillator";
    private CurveFit mCurveFit;
    private CycleOscillator mCycleOscillator;
    private String mType;
    private int mWaveShape = 0;
    private String mWaveString = null;
    public int mVariesBy = 0;
    ArrayList<WavePoint> mWavePoints = new ArrayList();

    public static KeyCycleOscillator makeWidgetCycle(String attribute) {
        if (attribute.equals("pathRotate")) {
            return new PathRotateSet(attribute);
        }
        return new CoreSpline(attribute);
    }

    public boolean variesByPath() {
        return this.mVariesBy == 1;
    }

    public String toString() {
        String str = this.mType;
        DecimalFormat df = new DecimalFormat("##.##");
        for (WavePoint wp : this.mWavePoints) {
            str = str + "[" + wp.mPosition + " , " + df.format(wp.mValue) + "] ";
        }
        return str;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public float get(float t) {
        return (float)this.mCycleOscillator.getValues(t);
    }

    public float getSlope(float position) {
        return (float)this.mCycleOscillator.getSlope(position);
    }

    public CurveFit getCurveFit() {
        return this.mCurveFit;
    }

    protected void setCustom(Object custom) {
    }

    public void setPoint(int framePosition, int shape, String waveString, int variesBy, float period, float offset, float phase, float value, Object custom) {
        this.mWavePoints.add(new WavePoint(framePosition, period, offset, phase, value));
        if (variesBy != -1) {
            this.mVariesBy = variesBy;
        }
        this.mWaveShape = shape;
        this.setCustom(custom);
        this.mWaveString = waveString;
    }

    public void setPoint(int framePosition, int shape, String waveString, int variesBy, float period, float offset, float phase, float value) {
        this.mWavePoints.add(new WavePoint(framePosition, period, offset, phase, value));
        if (variesBy != -1) {
            this.mVariesBy = variesBy;
        }
        this.mWaveShape = shape;
        this.mWaveString = waveString;
    }

    public void setup(float pathLength) {
        int count = this.mWavePoints.size();
        if (count == 0) {
            return;
        }
        Collections.sort(this.mWavePoints, new Comparator<WavePoint>(){

            @Override
            public int compare(WavePoint lhs, WavePoint rhs) {
                return Integer.compare(lhs.mPosition, rhs.mPosition);
            }
        });
        double[] time = new double[count];
        double[][] values = new double[count][3];
        this.mCycleOscillator = new CycleOscillator(this.mWaveShape, this.mWaveString, this.mVariesBy, count);
        int i = 0;
        for (WavePoint wp : this.mWavePoints) {
            time[i] = (double)wp.mPeriod * 0.01;
            values[i][0] = wp.mValue;
            values[i][1] = wp.mOffset;
            values[i][2] = wp.mPhase;
            this.mCycleOscillator.setPoint(i, wp.mPosition, wp.mPeriod, wp.mOffset, wp.mPhase, wp.mValue);
            ++i;
        }
        this.mCycleOscillator.setup(pathLength);
        this.mCurveFit = CurveFit.get(0, time, values);
    }

    public void setProperty(MotionWidget widget, float t) {
    }

    static class CycleOscillator {
        static final int UNSET = -1;
        private static final String TAG = "CycleOscillator";
        private final int mVariesBy;
        Oscillator mOscillator = new Oscillator();
        private final int OFFST = 0;
        private final int PHASE = 1;
        private final int VALUE = 2;
        float[] mValues;
        double[] mPosition;
        float[] mPeriod;
        float[] mOffset;
        float[] mPhase;
        float[] mScale;
        int mWaveShape;
        CurveFit mCurveFit;
        double[] mSplineValueCache;
        double[] mSplineSlopeCache;
        float mPathLength;

        CycleOscillator(int waveShape, String customShape, int variesBy, int steps) {
            this.mWaveShape = waveShape;
            this.mVariesBy = variesBy;
            this.mOscillator.setType(waveShape, customShape);
            this.mValues = new float[steps];
            this.mPosition = new double[steps];
            this.mPeriod = new float[steps];
            this.mOffset = new float[steps];
            this.mPhase = new float[steps];
            this.mScale = new float[steps];
        }

        public double getValues(float time) {
            if (this.mCurveFit != null) {
                this.mCurveFit.getPos((double)time, this.mSplineValueCache);
            } else {
                this.mSplineValueCache[0] = this.mOffset[0];
                this.mSplineValueCache[1] = this.mPhase[0];
                this.mSplineValueCache[2] = this.mValues[0];
            }
            double offset = this.mSplineValueCache[0];
            double phase = this.mSplineValueCache[1];
            double waveValue = this.mOscillator.getValue(time, phase);
            return offset + waveValue * this.mSplineValueCache[2];
        }

        public double getLastPhase() {
            return this.mSplineValueCache[1];
        }

        public double getSlope(float time) {
            if (this.mCurveFit != null) {
                this.mCurveFit.getSlope((double)time, this.mSplineSlopeCache);
                this.mCurveFit.getPos((double)time, this.mSplineValueCache);
            } else {
                this.mSplineSlopeCache[0] = 0.0;
                this.mSplineSlopeCache[1] = 0.0;
                this.mSplineSlopeCache[2] = 0.0;
            }
            double waveValue = this.mOscillator.getValue(time, this.mSplineValueCache[1]);
            double waveSlope = this.mOscillator.getSlope(time, this.mSplineValueCache[1], this.mSplineSlopeCache[1]);
            return this.mSplineSlopeCache[0] + waveValue * this.mSplineSlopeCache[2] + waveSlope * this.mSplineValueCache[2];
        }

        public void setPoint(int index, int framePosition, float wavePeriod, float offset, float phase, float values) {
            this.mPosition[index] = (double)framePosition / 100.0;
            this.mPeriod[index] = wavePeriod;
            this.mOffset[index] = offset;
            this.mPhase[index] = phase;
            this.mValues[index] = values;
        }

        public void setup(float pathLength) {
            int last;
            this.mPathLength = pathLength;
            double[][] splineValues = new double[this.mPosition.length][3];
            this.mSplineValueCache = new double[2 + this.mValues.length];
            this.mSplineSlopeCache = new double[2 + this.mValues.length];
            if (this.mPosition[0] > 0.0) {
                this.mOscillator.addPoint(0.0, this.mPeriod[0]);
            }
            if (this.mPosition[last = this.mPosition.length - 1] < 1.0) {
                this.mOscillator.addPoint(1.0, this.mPeriod[last]);
            }
            for (int i = 0; i < splineValues.length; ++i) {
                splineValues[i][0] = this.mOffset[i];
                splineValues[i][1] = this.mPhase[i];
                splineValues[i][2] = this.mValues[i];
                this.mOscillator.addPoint(this.mPosition[i], this.mPeriod[i]);
            }
            this.mOscillator.normalize();
            this.mCurveFit = this.mPosition.length > 1 ? CurveFit.get(0, this.mPosition, splineValues) : null;
        }
    }

    private static class IntFloatFloatSort {
        private IntFloatFloatSort() {
        }

        static void sort(int[] key, float[] value1, float[] value2, int low, int hi) {
            int[] stack = new int[key.length + 10];
            int count = 0;
            stack[count++] = hi;
            stack[count++] = low;
            while (count > 0) {
                --count;
                low = stack[count];
                if (low >= (hi = stack[--count])) continue;
                int p = IntFloatFloatSort.partition(key, value1, value2, low, hi);
                stack[count++] = p - 1;
                stack[count++] = low;
                stack[count++] = hi;
                stack[count++] = p + 1;
            }
        }

        private static int partition(int[] array, float[] value1, float[] value2, int low, int hi) {
            int pivot = array[hi];
            int i = low;
            for (int j = low; j < hi; ++j) {
                if (array[j] > pivot) continue;
                IntFloatFloatSort.swap(array, value1, value2, i, j);
                ++i;
            }
            IntFloatFloatSort.swap(array, value1, value2, i, hi);
            return i;
        }

        private static void swap(int[] array, float[] value1, float[] value2, int a, int b) {
            int tmp = array[a];
            array[a] = array[b];
            array[b] = tmp;
            float tmpFloat = value1[a];
            value1[a] = value1[b];
            value1[b] = tmpFloat;
            tmpFloat = value2[a];
            value2[a] = value2[b];
            value2[b] = tmpFloat;
        }
    }

    private static class IntDoubleSort {
        private IntDoubleSort() {
        }

        static void sort(int[] key, float[] value, int low, int hi) {
            int[] stack = new int[key.length + 10];
            int count = 0;
            stack[count++] = hi;
            stack[count++] = low;
            while (count > 0) {
                --count;
                low = stack[count];
                if (low >= (hi = stack[--count])) continue;
                int p = IntDoubleSort.partition(key, value, low, hi);
                stack[count++] = p - 1;
                stack[count++] = low;
                stack[count++] = hi;
                stack[count++] = p + 1;
            }
        }

        private static int partition(int[] array, float[] value, int low, int hi) {
            int pivot = array[hi];
            int i = low;
            for (int j = low; j < hi; ++j) {
                if (array[j] > pivot) continue;
                IntDoubleSort.swap(array, value, i, j);
                ++i;
            }
            IntDoubleSort.swap(array, value, i, hi);
            return i;
        }

        private static void swap(int[] array, float[] value, int a, int b) {
            int tmp = array[a];
            array[a] = array[b];
            array[b] = tmp;
            float tmpv = value[a];
            value[a] = value[b];
            value[b] = tmpv;
        }
    }

    static class WavePoint {
        int mPosition;
        float mValue;
        float mOffset;
        float mPeriod;
        float mPhase;

        public WavePoint(int position, float period, float offset, float phase, float value) {
            this.mPosition = position;
            this.mValue = value;
            this.mOffset = offset;
            this.mPeriod = period;
            this.mPhase = phase;
        }
    }

    public static class PathRotateSet
    extends KeyCycleOscillator {
        String type;
        int typeId;

        public PathRotateSet(String str) {
            this.type = str;
            this.typeId = TypedValues.CycleType.getId(this.type);
        }

        @Override
        public void setProperty(MotionWidget widget, float t) {
            widget.setValue(this.typeId, this.get(t));
        }

        public void setPathRotate(MotionWidget view, float t, double dx, double dy) {
            view.setRotationZ(this.get(t) + (float)Math.toDegrees(Math.atan2(dy, dx)));
        }
    }

    private static class CoreSpline
    extends KeyCycleOscillator {
        String type;
        int typeId;

        public CoreSpline(String str) {
            this.type = str;
            this.typeId = TypedValues.CycleType.getId(this.type);
        }

        @Override
        public void setProperty(MotionWidget widget, float t) {
            widget.setValue(this.typeId, this.get(t));
        }
    }
}

