/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.state.helpers;

import androidx.constraintlayout.core.state.ConstraintReference;
import androidx.constraintlayout.core.state.HelperReference;
import androidx.constraintlayout.core.state.State;
import androidx.constraintlayout.core.widgets.Barrier;
import androidx.constraintlayout.core.widgets.HelperWidget;

public class BarrierReference
extends HelperReference {
    private State.Direction mDirection;
    private int mMargin;
    private Barrier mBarrierWidget;

    public BarrierReference(State state) {
        super(state, State.Helper.BARRIER);
    }

    public void setBarrierDirection(State.Direction barrierDirection) {
        this.mDirection = barrierDirection;
    }

    @Override
    public ConstraintReference margin(Object marginValue) {
        this.margin(this.mState.convertDimension(marginValue));
        return this;
    }

    @Override
    public ConstraintReference margin(int value) {
        this.mMargin = value;
        return this;
    }

    @Override
    public HelperWidget getHelperWidget() {
        if (this.mBarrierWidget == null) {
            this.mBarrierWidget = new Barrier();
        }
        return this.mBarrierWidget;
    }

    @Override
    public void apply() {
        this.getHelperWidget();
        int direction = 0;
        switch (this.mDirection) {
            case LEFT: 
            case START: {
                break;
            }
            case RIGHT: 
            case END: {
                direction = 1;
                break;
            }
            case TOP: {
                direction = 2;
                break;
            }
            case BOTTOM: {
                direction = 3;
            }
        }
        this.mBarrierWidget.setBarrierType(direction);
        this.mBarrierWidget.setMargin(this.mMargin);
    }
}

