/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core;

import androidx.constraintlayout.core.ArrayRow;
import androidx.constraintlayout.core.Cache;
import androidx.constraintlayout.core.Metrics;
import androidx.constraintlayout.core.PriorityGoalRow;
import androidx.constraintlayout.core.SolverVariable;
import androidx.constraintlayout.core.SolverVariableValues;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import java.util.Arrays;
import java.util.HashMap;

public class LinearSystem {
    public static final boolean FULL_DEBUG = false;
    public static final boolean DEBUG = false;
    private static final boolean DO_NOT_USE = false;
    public static final boolean MEASURE = false;
    private static final boolean DEBUG_CONSTRAINTS = false;
    public static boolean USE_DEPENDENCY_ORDERING = false;
    public static boolean USE_BASIC_SYNONYMS = true;
    public static boolean SIMPLIFY_SYNONYMS = true;
    public static boolean USE_SYNONYMS = true;
    public static boolean SKIP_COLUMNS = true;
    public static boolean OPTIMIZED_ENGINE = false;
    private static int sPoolSize = 1000;
    public boolean hasSimpleDefinition = false;
    int mVariablesID = 0;
    private HashMap<String, SolverVariable> mVariables = null;
    private Row mGoal;
    private int mTableSize;
    private int mMaxColumns = this.mTableSize = 32;
    ArrayRow[] mRows = null;
    public boolean graphOptimizer = false;
    public boolean newgraphOptimizer = false;
    private boolean[] mAlreadyTestedCandidates = new boolean[this.mTableSize];
    int mNumColumns = 1;
    int mNumRows = 0;
    private int mMaxRows = this.mTableSize;
    final Cache mCache;
    private SolverVariable[] mPoolVariables = new SolverVariable[sPoolSize];
    private int mPoolVariablesCount = 0;
    public static Metrics sMetrics;
    private Row mTempGoal;
    public static long ARRAY_ROW_CREATION;
    public static long OPTIMIZED_ARRAY_ROW_CREATION;

    public LinearSystem() {
        this.mRows = new ArrayRow[this.mTableSize];
        this.releaseRows();
        this.mCache = new Cache();
        this.mGoal = new PriorityGoalRow(this.mCache);
        this.mTempGoal = OPTIMIZED_ENGINE ? new ValuesRow(this.mCache) : new ArrayRow(this.mCache);
    }

    public void fillMetrics(Metrics metrics) {
        sMetrics = metrics;
    }

    public static Metrics getMetrics() {
        return sMetrics;
    }

    private void increaseTableSize() {
        this.mTableSize *= 2;
        this.mRows = Arrays.copyOf(this.mRows, this.mTableSize);
        this.mCache.mIndexedVariables = Arrays.copyOf(this.mCache.mIndexedVariables, this.mTableSize);
        this.mAlreadyTestedCandidates = new boolean[this.mTableSize];
        this.mMaxColumns = this.mTableSize;
        this.mMaxRows = this.mTableSize;
        if (sMetrics != null) {
            ++LinearSystem.sMetrics.tableSizeIncrease;
            LinearSystem.sMetrics.lastTableSize = LinearSystem.sMetrics.maxTableSize = Math.max(LinearSystem.sMetrics.maxTableSize, (long)this.mTableSize);
        }
    }

    private void releaseRows() {
        if (OPTIMIZED_ENGINE) {
            for (int i = 0; i < this.mNumRows; ++i) {
                ArrayRow row = this.mRows[i];
                if (row != null) {
                    this.mCache.mOptimizedArrayRowPool.release(row);
                }
                this.mRows[i] = null;
            }
        } else {
            for (int i = 0; i < this.mNumRows; ++i) {
                ArrayRow row = this.mRows[i];
                if (row != null) {
                    this.mCache.mArrayRowPool.release(row);
                }
                this.mRows[i] = null;
            }
        }
    }

    public void reset() {
        int i;
        for (i = 0; i < this.mCache.mIndexedVariables.length; ++i) {
            SolverVariable variable = this.mCache.mIndexedVariables[i];
            if (variable == null) continue;
            variable.reset();
        }
        this.mCache.mSolverVariablePool.releaseAll((SolverVariable[])this.mPoolVariables, this.mPoolVariablesCount);
        this.mPoolVariablesCount = 0;
        Arrays.fill(this.mCache.mIndexedVariables, null);
        if (this.mVariables != null) {
            this.mVariables.clear();
        }
        this.mVariablesID = 0;
        this.mGoal.clear();
        this.mNumColumns = 1;
        for (i = 0; i < this.mNumRows; ++i) {
            if (this.mRows[i] == null) continue;
            this.mRows[i].mUsed = false;
        }
        this.releaseRows();
        this.mNumRows = 0;
        this.mTempGoal = OPTIMIZED_ENGINE ? new ValuesRow(this.mCache) : new ArrayRow(this.mCache);
    }

    public SolverVariable createObjectVariable(Object anchor) {
        if (anchor == null) {
            return null;
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = null;
        if (anchor instanceof ConstraintAnchor) {
            variable = ((ConstraintAnchor)anchor).getSolverVariable();
            if (variable == null) {
                ((ConstraintAnchor)anchor).resetSolverVariable(this.mCache);
                variable = ((ConstraintAnchor)anchor).getSolverVariable();
            }
            if (variable.id == -1 || variable.id > this.mVariablesID || this.mCache.mIndexedVariables[variable.id] == null) {
                if (variable.id != -1) {
                    variable.reset();
                }
                ++this.mVariablesID;
                ++this.mNumColumns;
                variable.id = this.mVariablesID;
                variable.mType = SolverVariable.Type.UNRESTRICTED;
                this.mCache.mIndexedVariables[this.mVariablesID] = variable;
            }
        }
        return variable;
    }

    public ArrayRow createRow() {
        ArrayRow row;
        if (OPTIMIZED_ENGINE) {
            row = this.mCache.mOptimizedArrayRowPool.acquire();
            if (row == null) {
                row = new ValuesRow(this.mCache);
                ++OPTIMIZED_ARRAY_ROW_CREATION;
            } else {
                row.reset();
            }
        } else {
            row = this.mCache.mArrayRowPool.acquire();
            if (row == null) {
                row = new ArrayRow(this.mCache);
                ++ARRAY_ROW_CREATION;
            } else {
                row.reset();
            }
        }
        SolverVariable.increaseErrorId();
        return row;
    }

    public SolverVariable createSlackVariable() {
        if (sMetrics != null) {
            ++LinearSystem.sMetrics.slackvariables;
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = this.acquireSolverVariable(SolverVariable.Type.SLACK, null);
        ++this.mVariablesID;
        ++this.mNumColumns;
        variable.id = this.mVariablesID;
        this.mCache.mIndexedVariables[this.mVariablesID] = variable;
        return variable;
    }

    public SolverVariable createExtraVariable() {
        if (sMetrics != null) {
            ++LinearSystem.sMetrics.extravariables;
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = this.acquireSolverVariable(SolverVariable.Type.SLACK, null);
        ++this.mVariablesID;
        ++this.mNumColumns;
        variable.id = this.mVariablesID;
        this.mCache.mIndexedVariables[this.mVariablesID] = variable;
        return variable;
    }

    void addSingleError(ArrayRow row, int sign, int strength) {
        String prefix = null;
        SolverVariable error = this.createErrorVariable(strength, prefix);
        row.addSingleError(error, sign);
    }

    private SolverVariable createVariable(String name, SolverVariable.Type type) {
        if (sMetrics != null) {
            ++LinearSystem.sMetrics.variables;
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = this.acquireSolverVariable(type, null);
        variable.setName(name);
        ++this.mVariablesID;
        ++this.mNumColumns;
        variable.id = this.mVariablesID;
        if (this.mVariables == null) {
            this.mVariables = new HashMap();
        }
        this.mVariables.put(name, variable);
        this.mCache.mIndexedVariables[this.mVariablesID] = variable;
        return variable;
    }

    public SolverVariable createErrorVariable(int strength, String prefix) {
        if (sMetrics != null) {
            ++LinearSystem.sMetrics.errors;
        }
        if (this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        SolverVariable variable = this.acquireSolverVariable(SolverVariable.Type.ERROR, prefix);
        ++this.mVariablesID;
        ++this.mNumColumns;
        variable.id = this.mVariablesID;
        variable.strength = strength;
        this.mCache.mIndexedVariables[this.mVariablesID] = variable;
        this.mGoal.addError(variable);
        return variable;
    }

    private SolverVariable acquireSolverVariable(SolverVariable.Type type, String prefix) {
        SolverVariable variable = this.mCache.mSolverVariablePool.acquire();
        if (variable == null) {
            variable = new SolverVariable(type, prefix);
            variable.setType(type, prefix);
        } else {
            variable.reset();
            variable.setType(type, prefix);
        }
        if (this.mPoolVariablesCount >= sPoolSize) {
            this.mPoolVariables = Arrays.copyOf(this.mPoolVariables, sPoolSize *= 2);
        }
        this.mPoolVariables[this.mPoolVariablesCount++] = variable;
        return variable;
    }

    Row getGoal() {
        return this.mGoal;
    }

    ArrayRow getRow(int n) {
        return this.mRows[n];
    }

    float getValueFor(String name) {
        SolverVariable v = this.getVariable(name, SolverVariable.Type.UNRESTRICTED);
        if (v == null) {
            return 0.0f;
        }
        return v.computedValue;
    }

    public int getObjectVariableValue(Object object) {
        ConstraintAnchor anchor = (ConstraintAnchor)object;
        SolverVariable variable = anchor.getSolverVariable();
        if (variable != null) {
            return (int)(variable.computedValue + 0.5f);
        }
        return 0;
    }

    SolverVariable getVariable(String name, SolverVariable.Type type) {
        SolverVariable variable;
        if (this.mVariables == null) {
            this.mVariables = new HashMap();
        }
        if ((variable = this.mVariables.get(name)) == null) {
            variable = this.createVariable(name, type);
        }
        return variable;
    }

    public void minimize() throws Exception {
        if (sMetrics != null) {
            ++LinearSystem.sMetrics.minimize;
        }
        if (this.mGoal.isEmpty()) {
            this.computeValues();
            return;
        }
        if (this.graphOptimizer || this.newgraphOptimizer) {
            if (sMetrics != null) {
                ++LinearSystem.sMetrics.graphOptimizer;
            }
            boolean fullySolved = true;
            for (int i = 0; i < this.mNumRows; ++i) {
                ArrayRow r = this.mRows[i];
                if (r.mIsSimpleDefinition) continue;
                fullySolved = false;
                break;
            }
            if (!fullySolved) {
                this.minimizeGoal(this.mGoal);
            } else {
                if (sMetrics != null) {
                    ++LinearSystem.sMetrics.fullySolved;
                }
                this.computeValues();
            }
        } else {
            this.minimizeGoal(this.mGoal);
        }
    }

    void minimizeGoal(Row goal) throws Exception {
        if (sMetrics != null) {
            ++LinearSystem.sMetrics.minimizeGoal;
            LinearSystem.sMetrics.maxVariables = Math.max(LinearSystem.sMetrics.maxVariables, (long)this.mNumColumns);
            LinearSystem.sMetrics.maxRows = Math.max(LinearSystem.sMetrics.maxRows, (long)this.mNumRows);
        }
        this.enforceBFS(goal);
        this.optimize(goal, false);
        this.computeValues();
    }

    final void cleanupRows() {
        for (int i = 0; i < this.mNumRows; ++i) {
            ArrayRow current = this.mRows[i];
            if (current.variables.getCurrentSize() == 0) {
                current.mIsSimpleDefinition = true;
            }
            if (!current.mIsSimpleDefinition) continue;
            current.mVariable.computedValue = current.mConstantValue;
            current.mVariable.removeFromRow(current);
            for (int j = i; j < this.mNumRows - 1; ++j) {
                this.mRows[j] = this.mRows[j + 1];
            }
            this.mRows[this.mNumRows - 1] = null;
            --this.mNumRows;
            --i;
            if (OPTIMIZED_ENGINE) {
                this.mCache.mOptimizedArrayRowPool.release(current);
                continue;
            }
            this.mCache.mArrayRowPool.release(current);
        }
    }

    public void addConstraint(ArrayRow row) {
        if (row == null) {
            return;
        }
        if (sMetrics != null) {
            ++LinearSystem.sMetrics.constraints;
            if (row.mIsSimpleDefinition) {
                ++LinearSystem.sMetrics.simpleconstraints;
            }
        }
        if (this.mNumRows + 1 >= this.mMaxRows || this.mNumColumns + 1 >= this.mMaxColumns) {
            this.increaseTableSize();
        }
        boolean added = false;
        if (!row.mIsSimpleDefinition) {
            row.updateFromSystem(this);
            if (row.isEmpty()) {
                return;
            }
            row.ensurePositiveConstant();
            if (row.chooseSubject(this)) {
                SolverVariable extra;
                row.mVariable = extra = this.createExtraVariable();
                int numRows = this.mNumRows;
                this.addRow(row);
                if (this.mNumRows == numRows + 1) {
                    added = true;
                    this.mTempGoal.initFromRow(row);
                    this.optimize(this.mTempGoal, true);
                    if (extra.mDefinitionId == -1) {
                        SolverVariable pivotCandidate;
                        if (row.mVariable == extra && (pivotCandidate = row.pickPivot(extra)) != null) {
                            if (sMetrics != null) {
                                ++LinearSystem.sMetrics.pivots;
                            }
                            row.pivot(pivotCandidate);
                        }
                        if (!row.mIsSimpleDefinition) {
                            row.mVariable.updateReferencesWithNewDefinition(this, row);
                        }
                        if (OPTIMIZED_ENGINE) {
                            this.mCache.mOptimizedArrayRowPool.release(row);
                        } else {
                            this.mCache.mArrayRowPool.release(row);
                        }
                        --this.mNumRows;
                    }
                }
            }
            if (!row.hasKeyVariable()) {
                return;
            }
        }
        if (!added) {
            this.addRow(row);
        }
    }

    private void addRow(ArrayRow row) {
        if (SIMPLIFY_SYNONYMS && row.mIsSimpleDefinition) {
            row.mVariable.setFinalValue(this, row.mConstantValue);
        } else {
            this.mRows[this.mNumRows] = row;
            row.mVariable.mDefinitionId = this.mNumRows++;
            row.mVariable.updateReferencesWithNewDefinition(this, row);
        }
        if (SIMPLIFY_SYNONYMS && this.hasSimpleDefinition) {
            for (int i = 0; i < this.mNumRows; ++i) {
                if (this.mRows[i] == null) {
                    System.out.println("WTF");
                }
                if (this.mRows[i] == null || !this.mRows[i].mIsSimpleDefinition) continue;
                ArrayRow removedRow = this.mRows[i];
                removedRow.mVariable.setFinalValue(this, removedRow.mConstantValue);
                if (OPTIMIZED_ENGINE) {
                    this.mCache.mOptimizedArrayRowPool.release(removedRow);
                } else {
                    this.mCache.mArrayRowPool.release(removedRow);
                }
                this.mRows[i] = null;
                int lastRow = i + 1;
                int j = i + 1;
                while (j < this.mNumRows) {
                    this.mRows[j - 1] = this.mRows[j];
                    if (this.mRows[j - 1].mVariable.mDefinitionId == j) {
                        this.mRows[j - 1].mVariable.mDefinitionId = j - 1;
                    }
                    lastRow = j++;
                }
                if (lastRow < this.mNumRows) {
                    this.mRows[lastRow] = null;
                }
                --this.mNumRows;
                --i;
            }
            this.hasSimpleDefinition = false;
        }
    }

    public void removeRow(ArrayRow row) {
        if (row.mIsSimpleDefinition && row.mVariable != null) {
            if (row.mVariable.mDefinitionId != -1) {
                for (int i = row.mVariable.mDefinitionId; i < this.mNumRows - 1; ++i) {
                    SolverVariable rowVariable = this.mRows[i + 1].mVariable;
                    if (rowVariable.mDefinitionId == i + 1) {
                        rowVariable.mDefinitionId = i;
                    }
                    this.mRows[i] = this.mRows[i + 1];
                }
                --this.mNumRows;
            }
            if (!row.mVariable.isFinalValue) {
                row.mVariable.setFinalValue(this, row.mConstantValue);
            }
            if (OPTIMIZED_ENGINE) {
                this.mCache.mOptimizedArrayRowPool.release(row);
            } else {
                this.mCache.mArrayRowPool.release(row);
            }
        }
    }

    private int optimize(Row goal, boolean b) {
        if (sMetrics != null) {
            ++LinearSystem.sMetrics.optimize;
        }
        boolean done = false;
        int tries = 0;
        for (int i = 0; i < this.mNumColumns; ++i) {
            this.mAlreadyTestedCandidates[i] = false;
        }
        while (!done) {
            SolverVariable pivotCandidate;
            if (sMetrics != null) {
                ++LinearSystem.sMetrics.iterations;
            }
            if (++tries >= 2 * this.mNumColumns) {
                return tries;
            }
            if (goal.getKey() != null) {
                this.mAlreadyTestedCandidates[goal.getKey().id] = true;
            }
            if ((pivotCandidate = goal.getPivotCandidate(this, this.mAlreadyTestedCandidates)) != null) {
                if (this.mAlreadyTestedCandidates[pivotCandidate.id]) {
                    return tries;
                }
                this.mAlreadyTestedCandidates[pivotCandidate.id] = true;
            }
            if (pivotCandidate != null) {
                float min = Float.MAX_VALUE;
                int pivotRowIndex = -1;
                for (int i = 0; i < this.mNumRows; ++i) {
                    float value;
                    float a_j;
                    ArrayRow current = this.mRows[i];
                    SolverVariable variable = current.mVariable;
                    if (variable.mType == SolverVariable.Type.UNRESTRICTED || current.mIsSimpleDefinition || !current.hasVariable(pivotCandidate) || !((a_j = current.variables.get(pivotCandidate)) < 0.0f) || !((value = -current.mConstantValue / a_j) < min)) continue;
                    min = value;
                    pivotRowIndex = i;
                }
                if (pivotRowIndex <= -1) continue;
                ArrayRow pivotEquation = this.mRows[pivotRowIndex];
                pivotEquation.mVariable.mDefinitionId = -1;
                if (sMetrics != null) {
                    ++LinearSystem.sMetrics.pivots;
                }
                pivotEquation.pivot(pivotCandidate);
                pivotEquation.mVariable.mDefinitionId = pivotRowIndex;
                pivotEquation.mVariable.updateReferencesWithNewDefinition(this, pivotEquation);
                continue;
            }
            done = true;
        }
        return tries;
    }

    private int enforceBFS(Row goal) throws Exception {
        int tries = 0;
        boolean infeasibleSystem = false;
        for (int i = 0; i < this.mNumRows; ++i) {
            SolverVariable variable = this.mRows[i].mVariable;
            if (variable.mType == SolverVariable.Type.UNRESTRICTED || !(this.mRows[i].mConstantValue < 0.0f)) continue;
            infeasibleSystem = true;
            break;
        }
        if (infeasibleSystem) {
            boolean done = false;
            tries = 0;
            while (!done) {
                if (sMetrics != null) {
                    ++LinearSystem.sMetrics.bfs;
                }
                ++tries;
                float min = Float.MAX_VALUE;
                int strength = 0;
                int pivotRowIndex = -1;
                int pivotColumnIndex = -1;
                for (int i = 0; i < this.mNumRows; ++i) {
                    ArrayRow current = this.mRows[i];
                    SolverVariable variable = current.mVariable;
                    if (variable.mType == SolverVariable.Type.UNRESTRICTED || current.mIsSimpleDefinition || !(current.mConstantValue < 0.0f)) continue;
                    if (SKIP_COLUMNS) {
                        int size = current.variables.getCurrentSize();
                        for (int j = 0; j < size; ++j) {
                            SolverVariable candidate = current.variables.getVariable(j);
                            float a_j = current.variables.get(candidate);
                            if (a_j <= 0.0f) continue;
                            for (int k = 0; k < 9; ++k) {
                                float value = candidate.mStrengthVector[k] / a_j;
                                if (!(value < min && k == strength) && k <= strength) continue;
                                min = value;
                                pivotRowIndex = i;
                                pivotColumnIndex = candidate.id;
                                strength = k;
                            }
                        }
                        continue;
                    }
                    for (int j = 1; j < this.mNumColumns; ++j) {
                        SolverVariable candidate = this.mCache.mIndexedVariables[j];
                        float a_j = current.variables.get(candidate);
                        if (a_j <= 0.0f) continue;
                        for (int k = 0; k < 9; ++k) {
                            float value = candidate.mStrengthVector[k] / a_j;
                            if (!(value < min && k == strength) && k <= strength) continue;
                            min = value;
                            pivotRowIndex = i;
                            pivotColumnIndex = j;
                            strength = k;
                        }
                    }
                }
                if (pivotRowIndex != -1) {
                    ArrayRow pivotEquation = this.mRows[pivotRowIndex];
                    pivotEquation.mVariable.mDefinitionId = -1;
                    if (sMetrics != null) {
                        ++LinearSystem.sMetrics.pivots;
                    }
                    pivotEquation.pivot(this.mCache.mIndexedVariables[pivotColumnIndex]);
                    pivotEquation.mVariable.mDefinitionId = pivotRowIndex;
                    pivotEquation.mVariable.updateReferencesWithNewDefinition(this, pivotEquation);
                } else {
                    done = true;
                }
                if (tries <= this.mNumColumns / 2) continue;
                done = true;
            }
        }
        return tries;
    }

    private void computeValues() {
        for (int i = 0; i < this.mNumRows; ++i) {
            ArrayRow row = this.mRows[i];
            row.mVariable.computedValue = row.mConstantValue;
        }
    }

    private void displayRows() {
        this.displaySolverVariables();
        Object s = "";
        for (int i = 0; i < this.mNumRows; ++i) {
            s = (String)s + this.mRows[i];
            s = (String)s + "\n";
        }
        s = (String)s + this.mGoal + "\n";
        System.out.println((String)s);
    }

    public void displayReadableRows() {
        SolverVariable variable;
        int i;
        this.displaySolverVariables();
        String s = " num vars " + this.mVariablesID + "\n";
        for (i = 0; i < this.mVariablesID + 1; ++i) {
            variable = this.mCache.mIndexedVariables[i];
            if (variable == null || !variable.isFinalValue) continue;
            s = s + " $[" + i + "] => " + variable + " = " + variable.computedValue + "\n";
        }
        s = s + "\n";
        for (i = 0; i < this.mVariablesID + 1; ++i) {
            variable = this.mCache.mIndexedVariables[i];
            if (variable == null || !variable.mIsSynonym) continue;
            SolverVariable synonym = this.mCache.mIndexedVariables[variable.mSynonym];
            s = s + " ~[" + i + "] => " + variable + " = " + synonym + " + " + variable.mSynonymDelta + "\n";
        }
        s = s + "\n\n #  ";
        for (i = 0; i < this.mNumRows; ++i) {
            s = s + this.mRows[i].toReadableString();
            s = s + "\n #  ";
        }
        if (this.mGoal != null) {
            s = s + "Goal: " + this.mGoal + "\n";
        }
        System.out.println(s);
    }

    public void displayVariablesReadableRows() {
        this.displaySolverVariables();
        Object s = "";
        for (int i = 0; i < this.mNumRows; ++i) {
            if (this.mRows[i].mVariable.mType != SolverVariable.Type.UNRESTRICTED) continue;
            s = (String)s + this.mRows[i].toReadableString();
            s = (String)s + "\n";
        }
        s = (String)s + this.mGoal + "\n";
        System.out.println((String)s);
    }

    public int getMemoryUsed() {
        int actualRowSize = 0;
        for (int i = 0; i < this.mNumRows; ++i) {
            if (this.mRows[i] == null) continue;
            actualRowSize += this.mRows[i].sizeInBytes();
        }
        return actualRowSize;
    }

    public int getNumEquations() {
        return this.mNumRows;
    }

    public int getNumVariables() {
        return this.mVariablesID;
    }

    void displaySystemInformation() {
        int count = 0;
        int rowSize = 0;
        for (int i = 0; i < this.mTableSize; ++i) {
            if (this.mRows[i] == null) continue;
            rowSize += this.mRows[i].sizeInBytes();
        }
        int actualRowSize = 0;
        for (int i = 0; i < this.mNumRows; ++i) {
            if (this.mRows[i] == null) continue;
            actualRowSize += this.mRows[i].sizeInBytes();
        }
        System.out.println("Linear System -> Table size: " + this.mTableSize + " (" + this.getDisplaySize(this.mTableSize * this.mTableSize) + ") -- row sizes: " + this.getDisplaySize(rowSize) + ", actual size: " + this.getDisplaySize(actualRowSize) + " rows: " + this.mNumRows + "/" + this.mMaxRows + " cols: " + this.mNumColumns + "/" + this.mMaxColumns + " " + count + " occupied cells, " + this.getDisplaySize(count));
    }

    private void displaySolverVariables() {
        String s = "Display Rows (" + this.mNumRows + "x" + this.mNumColumns + ")\n";
        System.out.println(s);
    }

    private String getDisplaySize(int n) {
        int mb = n * 4 / 1024 / 1024;
        if (mb > 0) {
            return mb + " Mb";
        }
        int kb = n * 4 / 1024;
        if (kb > 0) {
            return kb + " Kb";
        }
        return n * 4 + " bytes";
    }

    public Cache getCache() {
        return this.mCache;
    }

    private String getDisplayStrength(int strength) {
        if (strength == 1) {
            return "LOW";
        }
        if (strength == 2) {
            return "MEDIUM";
        }
        if (strength == 3) {
            return "HIGH";
        }
        if (strength == 4) {
            return "HIGHEST";
        }
        if (strength == 5) {
            return "EQUALITY";
        }
        if (strength == 8) {
            return "FIXED";
        }
        if (strength == 6) {
            return "BARRIER";
        }
        return "NONE";
    }

    public void addGreaterThan(SolverVariable a, SolverVariable b, int margin, int strength) {
        ArrayRow row = this.createRow();
        SolverVariable slack = this.createSlackVariable();
        slack.strength = 0;
        row.createRowGreaterThan(a, b, slack, margin);
        if (strength != 8) {
            float slackValue = row.variables.get(slack);
            this.addSingleError(row, (int)(-1.0f * slackValue), strength);
        }
        this.addConstraint(row);
    }

    public void addGreaterBarrier(SolverVariable a, SolverVariable b, int margin, boolean hasMatchConstraintWidgets) {
        ArrayRow row = this.createRow();
        SolverVariable slack = this.createSlackVariable();
        slack.strength = 0;
        row.createRowGreaterThan(a, b, slack, margin);
        this.addConstraint(row);
    }

    public void addLowerThan(SolverVariable a, SolverVariable b, int margin, int strength) {
        ArrayRow row = this.createRow();
        SolverVariable slack = this.createSlackVariable();
        slack.strength = 0;
        row.createRowLowerThan(a, b, slack, margin);
        if (strength != 8) {
            float slackValue = row.variables.get(slack);
            this.addSingleError(row, (int)(-1.0f * slackValue), strength);
        }
        this.addConstraint(row);
    }

    public void addLowerBarrier(SolverVariable a, SolverVariable b, int margin, boolean hasMatchConstraintWidgets) {
        ArrayRow row = this.createRow();
        SolverVariable slack = this.createSlackVariable();
        slack.strength = 0;
        row.createRowLowerThan(a, b, slack, margin);
        this.addConstraint(row);
    }

    public void addCentering(SolverVariable a, SolverVariable b, int m1, float bias, SolverVariable c, SolverVariable d, int m2, int strength) {
        ArrayRow row = this.createRow();
        row.createRowCentering(a, b, m1, bias, c, d, m2);
        if (strength != 8) {
            row.addError(this, strength);
        }
        this.addConstraint(row);
    }

    public void addRatio(SolverVariable a, SolverVariable b, SolverVariable c, SolverVariable d, float ratio, int strength) {
        ArrayRow row = this.createRow();
        row.createRowDimensionRatio(a, b, c, d, ratio);
        if (strength != 8) {
            row.addError(this, strength);
        }
        this.addConstraint(row);
    }

    public void addSynonym(SolverVariable a, SolverVariable b, int margin) {
        if (a.mDefinitionId == -1 && margin == 0) {
            if (b.mIsSynonym) {
                margin += (int)b.mSynonymDelta;
                b = this.mCache.mIndexedVariables[b.mSynonym];
            }
            if (a.mIsSynonym) {
                margin -= (int)a.mSynonymDelta;
                a = this.mCache.mIndexedVariables[a.mSynonym];
            } else {
                a.setSynonym(this, b, 0.0f);
            }
        } else {
            this.addEquality(a, b, margin, 8);
        }
    }

    public ArrayRow addEquality(SolverVariable a, SolverVariable b, int margin, int strength) {
        if (USE_BASIC_SYNONYMS && strength == 8 && b.isFinalValue && a.mDefinitionId == -1) {
            a.setFinalValue(this, b.computedValue + (float)margin);
            return null;
        }
        ArrayRow row = this.createRow();
        row.createRowEquals(a, b, margin);
        if (strength != 8) {
            row.addError(this, strength);
        }
        this.addConstraint(row);
        return row;
    }

    public void addEquality(SolverVariable a, int value) {
        if (USE_BASIC_SYNONYMS && a.mDefinitionId == -1) {
            a.setFinalValue(this, value);
            for (int i = 0; i < this.mVariablesID + 1; ++i) {
                SolverVariable variable = this.mCache.mIndexedVariables[i];
                if (variable == null || !variable.mIsSynonym || variable.mSynonym != a.id) continue;
                variable.setFinalValue(this, (float)value + variable.mSynonymDelta);
            }
            return;
        }
        int idx = a.mDefinitionId;
        if (a.mDefinitionId != -1) {
            ArrayRow row = this.mRows[idx];
            if (row.mIsSimpleDefinition) {
                row.mConstantValue = value;
            } else if (row.variables.getCurrentSize() == 0) {
                row.mIsSimpleDefinition = true;
                row.mConstantValue = value;
            } else {
                ArrayRow newRow = this.createRow();
                newRow.createRowEquals(a, value);
                this.addConstraint(newRow);
            }
        } else {
            ArrayRow row = this.createRow();
            row.createRowDefinition(a, value);
            this.addConstraint(row);
        }
    }

    public static ArrayRow createRowDimensionPercent(LinearSystem linearSystem, SolverVariable variableA, SolverVariable variableC, float percent) {
        ArrayRow row = linearSystem.createRow();
        return row.createRowDimensionPercent(variableA, variableC, percent);
    }

    public void addCenterPoint(ConstraintWidget widget, ConstraintWidget target, float angle, int radius) {
        SolverVariable Al = this.createObjectVariable(widget.getAnchor(ConstraintAnchor.Type.LEFT));
        SolverVariable At = this.createObjectVariable(widget.getAnchor(ConstraintAnchor.Type.TOP));
        SolverVariable Ar = this.createObjectVariable(widget.getAnchor(ConstraintAnchor.Type.RIGHT));
        SolverVariable Ab = this.createObjectVariable(widget.getAnchor(ConstraintAnchor.Type.BOTTOM));
        SolverVariable Bl = this.createObjectVariable(target.getAnchor(ConstraintAnchor.Type.LEFT));
        SolverVariable Bt = this.createObjectVariable(target.getAnchor(ConstraintAnchor.Type.TOP));
        SolverVariable Br = this.createObjectVariable(target.getAnchor(ConstraintAnchor.Type.RIGHT));
        SolverVariable Bb = this.createObjectVariable(target.getAnchor(ConstraintAnchor.Type.BOTTOM));
        ArrayRow row = this.createRow();
        float angleComponent = (float)(Math.sin(angle) * (double)radius);
        row.createRowWithAngle(At, Ab, Bt, Bb, angleComponent);
        this.addConstraint(row);
        row = this.createRow();
        angleComponent = (float)(Math.cos(angle) * (double)radius);
        row.createRowWithAngle(Al, Ar, Bl, Br, angleComponent);
        this.addConstraint(row);
    }

    static {
        ARRAY_ROW_CREATION = 0L;
        OPTIMIZED_ARRAY_ROW_CREATION = 0L;
    }

    static interface Row {
        public SolverVariable getPivotCandidate(LinearSystem var1, boolean[] var2);

        public void clear();

        public void initFromRow(Row var1);

        public void addError(SolverVariable var1);

        public void updateFromSystem(LinearSystem var1);

        public SolverVariable getKey();

        public boolean isEmpty();

        public void updateFromRow(LinearSystem var1, ArrayRow var2, boolean var3);

        public void updateFromFinalVariable(LinearSystem var1, SolverVariable var2, boolean var3);
    }

    static class ValuesRow
    extends ArrayRow {
        ValuesRow(Cache cache) {
            this.variables = new SolverVariableValues(this, cache);
        }
    }
}

