/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

public class HyperSpline {
    int mPoints;
    Cubic[][] mCurve;
    int mDimensionality;
    double[] mCurveLength;
    double mTotalLength;
    double[][] mCtl;

    public HyperSpline(double[][] points) {
        this.setup(points);
    }

    public HyperSpline() {
    }

    public void setup(double[][] points) {
        int p;
        int d;
        this.mDimensionality = points[0].length;
        this.mPoints = points.length;
        this.mCtl = new double[this.mDimensionality][this.mPoints];
        this.mCurve = new Cubic[this.mDimensionality][];
        for (d = 0; d < this.mDimensionality; ++d) {
            for (p = 0; p < this.mPoints; ++p) {
                this.mCtl[d][p] = points[p][d];
            }
        }
        for (d = 0; d < this.mDimensionality; ++d) {
            this.mCurve[d] = HyperSpline.calcNaturalCubic(this.mCtl[d].length, this.mCtl[d]);
        }
        this.mCurveLength = new double[this.mPoints - 1];
        this.mTotalLength = 0.0;
        Cubic[] temp = new Cubic[this.mDimensionality];
        for (p = 0; p < this.mCurveLength.length; ++p) {
            for (int d2 = 0; d2 < this.mDimensionality; ++d2) {
                temp[d2] = this.mCurve[d2][p];
            }
            this.mCurveLength[p] = this.approxLength(temp);
            this.mTotalLength += this.mCurveLength[p];
        }
    }

    public void getVelocity(double p, double[] v) {
        int k;
        double pos = p * this.mTotalLength;
        double sum = 0.0;
        for (k = 0; k < this.mCurveLength.length - 1 && this.mCurveLength[k] < pos; pos -= this.mCurveLength[k], ++k) {
        }
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.mCurve[i][k].vel(pos / this.mCurveLength[k]);
        }
    }

    public void getPos(double p, double[] x) {
        int k;
        double pos = p * this.mTotalLength;
        double sum = 0.0;
        for (k = 0; k < this.mCurveLength.length - 1 && this.mCurveLength[k] < pos; pos -= this.mCurveLength[k], ++k) {
        }
        for (int i = 0; i < x.length; ++i) {
            x[i] = this.mCurve[i][k].eval(pos / this.mCurveLength[k]);
        }
    }

    public void getPos(double p, float[] x) {
        int k;
        double pos = p * this.mTotalLength;
        double sum = 0.0;
        for (k = 0; k < this.mCurveLength.length - 1 && this.mCurveLength[k] < pos; pos -= this.mCurveLength[k], ++k) {
        }
        for (int i = 0; i < x.length; ++i) {
            x[i] = (float)this.mCurve[i][k].eval(pos / this.mCurveLength[k]);
        }
    }

    public double getPos(double p, int splineNumber) {
        int k;
        double pos = p * this.mTotalLength;
        double sum = 0.0;
        for (k = 0; k < this.mCurveLength.length - 1 && this.mCurveLength[k] < pos; pos -= this.mCurveLength[k], ++k) {
        }
        return this.mCurve[splineNumber][k].eval(pos / this.mCurveLength[k]);
    }

    public double approxLength(Cubic[] curve) {
        double sum = 0.0;
        int n = curve.length;
        double[] old = new double[curve.length];
        for (double i = 0.0; i < 1.0; i += 0.1) {
            double s = 0.0;
            for (int j = 0; j < curve.length; ++j) {
                double tmp = old[j];
                old[j] = curve[j].eval(i);
                s += (tmp -= old[j]) * tmp;
            }
            if (!(i > 0.0)) continue;
            sum += Math.sqrt(s);
        }
        double s = 0.0;
        for (int j = 0; j < curve.length; ++j) {
            double tmp = old[j];
            old[j] = curve[j].eval(1.0);
            s += (tmp -= old[j]) * tmp;
        }
        return sum += Math.sqrt(s);
    }

    static Cubic[] calcNaturalCubic(int n, double[] x) {
        int i;
        double[] gamma = new double[n];
        double[] delta = new double[n];
        double[] d = new double[n];
        --n;
        gamma[0] = 0.5;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0 / (4.0 - gamma[i - 1]);
        }
        gamma[n] = 1.0 / (2.0 - gamma[n - 1]);
        delta[0] = 3.0 * (x[1] - x[0]) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = (3.0 * (x[i + 1] - x[i - 1]) - delta[i - 1]) * gamma[i];
        }
        delta[n] = (3.0 * (x[n] - x[n - 1]) - delta[n - 1]) * gamma[n];
        d[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            d[i] = delta[i] - gamma[i] * d[i + 1];
        }
        Cubic[] c = new Cubic[n];
        for (int i2 = 0; i2 < n; ++i2) {
            c[i2] = new Cubic((float)x[i2], d[i2], 3.0 * (x[i2 + 1] - x[i2]) - 2.0 * d[i2] - d[i2 + 1], 2.0 * (x[i2] - x[i2 + 1]) + d[i2] + d[i2 + 1]);
        }
        return c;
    }

    public static class Cubic {
        double mA;
        double mB;
        double mC;
        double mD;

        public Cubic(double a, double b, double c, double d) {
            this.mA = a;
            this.mB = b;
            this.mC = c;
            this.mD = d;
        }

        public double eval(double u) {
            return ((this.mD * u + this.mC) * u + this.mB) * u + this.mA;
        }

        public double vel(double v) {
            return (this.mD * 3.0 * v + this.mC * 2.0) * v + this.mB;
        }
    }
}

