/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.parser;

import androidx.constraintlayout.core.parser.CLArray;
import androidx.constraintlayout.core.parser.CLContainer;
import androidx.constraintlayout.core.parser.CLElement;
import androidx.constraintlayout.core.parser.CLKey;
import androidx.constraintlayout.core.parser.CLNumber;
import androidx.constraintlayout.core.parser.CLObject;
import androidx.constraintlayout.core.parser.CLParsingException;
import androidx.constraintlayout.core.parser.CLString;
import androidx.constraintlayout.core.parser.CLToken;

public class CLParser {
    static boolean sDebug = false;
    private String mContent;
    private boolean mHasComment = false;
    private int mLineNumber;

    public static CLObject parse(String string) throws CLParsingException {
        return new CLParser(string).parse();
    }

    public CLParser(String content) {
        this.mContent = content;
    }

    public CLObject parse() throws CLParsingException {
        char c;
        int i;
        CLObject root = null;
        char[] content = this.mContent.toCharArray();
        CLElement currentElement = null;
        int length = content.length;
        this.mLineNumber = 1;
        int startIndex = -1;
        for (i = 0; i < length; ++i) {
            c = content[i];
            if (c == '{') {
                startIndex = i;
                break;
            }
            if (c != '\n') continue;
            ++this.mLineNumber;
        }
        if (startIndex == -1) {
            throw new CLParsingException("invalid json content", null);
        }
        root = CLObject.allocate(content);
        root.setLine(this.mLineNumber);
        root.setStart(startIndex);
        currentElement = root;
        for (i = startIndex + 1; i < length; ++i) {
            c = content[i];
            if (c == '\n') {
                ++this.mLineNumber;
            }
            if (this.mHasComment) {
                if (c != '\n') continue;
                this.mHasComment = false;
            }
            if (currentElement == null) break;
            if (currentElement.isDone()) {
                currentElement = this.getNextJsonElement(i, c, currentElement, content);
            } else if (currentElement instanceof CLObject) {
                if (c == '}') {
                    currentElement.setEnd(i - 1);
                } else {
                    currentElement = this.getNextJsonElement(i, c, currentElement, content);
                }
            } else if (currentElement instanceof CLArray) {
                if (c == ']') {
                    currentElement.setEnd(i - 1);
                } else {
                    currentElement = this.getNextJsonElement(i, c, currentElement, content);
                }
            } else if (currentElement instanceof CLString) {
                char ck = content[(int)currentElement.mStart];
                if (ck == c) {
                    currentElement.setStart(currentElement.mStart + 1L);
                    currentElement.setEnd(i - 1);
                }
            } else {
                char ck;
                CLToken token;
                if (currentElement instanceof CLToken && !(token = (CLToken)currentElement).validate(c, i)) {
                    throw new CLParsingException("parsing incorrect token " + token.content() + " at line " + this.mLineNumber, token);
                }
                if ((currentElement instanceof CLKey || currentElement instanceof CLString) && ((ck = content[(int)currentElement.mStart]) == '\'' || ck == '\"') && ck == c) {
                    currentElement.setStart(currentElement.mStart + 1L);
                    currentElement.setEnd(i - 1);
                }
                if (!(currentElement.isDone() || c != '}' && c != ']' && c != ',' && c != ' ' && c != '\t' && c != '\r' && c != '\n' && c != ':')) {
                    currentElement.setEnd(i - 1);
                    if (c == '}' || c == ']') {
                        currentElement = currentElement.getContainer();
                        currentElement.setEnd(i - 1);
                        if (currentElement instanceof CLKey) {
                            currentElement = currentElement.getContainer();
                            currentElement.setEnd(i - 1);
                        }
                    }
                }
            }
            if (!currentElement.isDone() || currentElement instanceof CLKey && ((CLKey)currentElement).mElements.size() <= 0) continue;
            currentElement = currentElement.getContainer();
        }
        while (currentElement != null && !currentElement.isDone()) {
            if (currentElement instanceof CLString) {
                currentElement.setStart((int)currentElement.mStart + 1);
            }
            currentElement.setEnd(length - 1);
            currentElement = currentElement.getContainer();
        }
        if (sDebug) {
            System.out.println("Root: " + root.toJSON());
        }
        return root;
    }

    private CLElement getNextJsonElement(int position, char c, CLElement currentElement, char[] content) throws CLParsingException {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': 
            case ',': 
            case ':': {
                break;
            }
            case '{': {
                currentElement = this.createElement(currentElement, position, TYPE.OBJECT, true, content);
                break;
            }
            case '[': {
                currentElement = this.createElement(currentElement, position, TYPE.ARRAY, true, content);
                break;
            }
            case ']': 
            case '}': {
                currentElement.setEnd(position - 1);
                currentElement = currentElement.getContainer();
                currentElement.setEnd(position);
                break;
            }
            case '\"': 
            case '\'': {
                if (currentElement instanceof CLObject) {
                    currentElement = this.createElement(currentElement, position, TYPE.KEY, true, content);
                    break;
                }
                currentElement = this.createElement(currentElement, position, TYPE.STRING, true, content);
                break;
            }
            case '/': {
                if (position + 1 >= content.length || content[position + 1] != '/') break;
                this.mHasComment = true;
                break;
            }
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                currentElement = this.createElement(currentElement, position, TYPE.NUMBER, true, content);
                break;
            }
            default: {
                if (currentElement instanceof CLContainer && !(currentElement instanceof CLObject)) {
                    CLToken token = (CLToken)(currentElement = this.createElement(currentElement, position, TYPE.TOKEN, true, content));
                    if (token.validate(c, position)) break;
                    throw new CLParsingException("incorrect token <" + c + "> at line " + this.mLineNumber, token);
                }
                currentElement = this.createElement(currentElement, position, TYPE.KEY, true, content);
            }
        }
        return currentElement;
    }

    private CLElement createElement(CLElement currentElement, int position, TYPE type, boolean applyStart, char[] content) {
        CLElement newElement = null;
        if (sDebug) {
            System.out.println("CREATE " + type + " at " + content[position]);
        }
        switch (type) {
            case OBJECT: {
                newElement = CLObject.allocate(content);
                ++position;
                break;
            }
            case ARRAY: {
                newElement = CLArray.allocate(content);
                ++position;
                break;
            }
            case STRING: {
                newElement = CLString.allocate(content);
                break;
            }
            case NUMBER: {
                newElement = CLNumber.allocate(content);
                break;
            }
            case KEY: {
                newElement = CLKey.allocate(content);
                break;
            }
            case TOKEN: {
                newElement = CLToken.allocate(content);
                break;
            }
        }
        if (newElement == null) {
            return null;
        }
        newElement.setLine(this.mLineNumber);
        if (applyStart) {
            newElement.setStart(position);
        }
        if (currentElement instanceof CLContainer) {
            CLContainer container = (CLContainer)currentElement;
            newElement.setContainer(container);
        }
        return newElement;
    }

    static enum TYPE {
        UNKNOWN,
        OBJECT,
        ARRAY,
        NUMBER,
        STRING,
        KEY,
        TOKEN;

    }
}

