/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.dsl;

import androidx.constraintlayout.core.dsl.Chain;
import androidx.constraintlayout.core.dsl.Constraint;
import androidx.constraintlayout.core.dsl.Helper;
import androidx.constraintlayout.core.dsl.Ref;

public class VChain
extends Chain {
    private VAnchor mTop = new VAnchor(Constraint.VSide.TOP);
    private VAnchor mBottom = new VAnchor(Constraint.VSide.BOTTOM);
    private VAnchor mBaseline = new VAnchor(Constraint.VSide.BASELINE);

    public VChain(String name) {
        super(name);
        this.type = new Helper.HelperType((String)typeMap.get((Object)Helper.Type.VERTICAL_CHAIN));
    }

    public VChain(String name, String config) {
        super(name);
        this.config = config;
        this.type = new Helper.HelperType((String)typeMap.get((Object)Helper.Type.VERTICAL_CHAIN));
        this.configMap = this.convertConfigToMap();
        if (this.configMap.containsKey("contains")) {
            Ref.addStringToReferences((String)this.configMap.get("contains"), this.references);
        }
    }

    public VAnchor getTop() {
        return this.mTop;
    }

    public void linkToTop(Constraint.VAnchor anchor) {
        this.linkToTop(anchor, 0);
    }

    public void linkToTop(Constraint.VAnchor anchor, int margin) {
        this.linkToTop(anchor, margin, Integer.MIN_VALUE);
    }

    public void linkToTop(Constraint.VAnchor anchor, int margin, int goneMargin) {
        this.mTop.mConnection = anchor;
        this.mTop.mMargin = margin;
        this.mTop.mGoneMargin = goneMargin;
        this.configMap.put("top", this.mTop.toString());
    }

    public VAnchor getBottom() {
        return this.mBottom;
    }

    public void linkToBottom(Constraint.VAnchor anchor) {
        this.linkToBottom(anchor, 0);
    }

    public void linkToBottom(Constraint.VAnchor anchor, int margin) {
        this.linkToBottom(anchor, margin, Integer.MIN_VALUE);
    }

    public void linkToBottom(Constraint.VAnchor anchor, int margin, int goneMargin) {
        this.mBottom.mConnection = anchor;
        this.mBottom.mMargin = margin;
        this.mBottom.mGoneMargin = goneMargin;
        this.configMap.put("bottom", this.mBottom.toString());
    }

    public VAnchor getBaseline() {
        return this.mBaseline;
    }

    public void linkToBaseline(Constraint.VAnchor anchor) {
        this.linkToBaseline(anchor, 0);
    }

    public void linkToBaseline(Constraint.VAnchor anchor, int margin) {
        this.linkToBaseline(anchor, margin, Integer.MIN_VALUE);
    }

    public void linkToBaseline(Constraint.VAnchor anchor, int margin, int goneMargin) {
        this.mBaseline.mConnection = anchor;
        this.mBaseline.mMargin = margin;
        this.mBaseline.mGoneMargin = goneMargin;
        this.configMap.put("baseline", this.mBaseline.toString());
    }

    public class VAnchor
    extends Chain.Anchor {
        VAnchor(Constraint.VSide side) {
            super(Constraint.Side.valueOf(side.name()));
        }
    }
}

