/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.utils;

import androidx.constraintlayout.core.motion.utils.ArcCurveFit;
import androidx.constraintlayout.core.motion.utils.LinearCurveFit;
import androidx.constraintlayout.core.motion.utils.MonotonicCurveFit;

public abstract class CurveFit {
    public static final int SPLINE = 0;
    public static final int LINEAR = 1;
    public static final int CONSTANT = 2;

    public static CurveFit get(int type, double[] time, double[][] y) {
        if (time.length == 1) {
            type = 2;
        }
        switch (type) {
            case 0: {
                return new MonotonicCurveFit(time, y);
            }
            case 2: {
                return new Constant(time[0], y[0]);
            }
        }
        return new LinearCurveFit(time, y);
    }

    public static CurveFit getArc(int[] arcModes, double[] time, double[][] y) {
        return new ArcCurveFit(arcModes, time, y);
    }

    public abstract void getPos(double var1, double[] var3);

    public abstract void getPos(double var1, float[] var3);

    public abstract double getPos(double var1, int var3);

    public abstract void getSlope(double var1, double[] var3);

    public abstract double getSlope(double var1, int var3);

    public abstract double[] getTimePoints();

    static class Constant
    extends CurveFit {
        double mTime;
        double[] mValue;

        Constant(double time, double[] value) {
            this.mTime = time;
            this.mValue = value;
        }

        @Override
        public void getPos(double t, double[] v) {
            System.arraycopy(this.mValue, 0, v, 0, this.mValue.length);
        }

        @Override
        public void getPos(double t, float[] v) {
            for (int i = 0; i < this.mValue.length; ++i) {
                v[i] = (float)this.mValue[i];
            }
        }

        @Override
        public double getPos(double t, int j) {
            return this.mValue[j];
        }

        @Override
        public void getSlope(double t, double[] v) {
            for (int i = 0; i < this.mValue.length; ++i) {
                v[i] = 0.0;
            }
        }

        @Override
        public double getSlope(double t, int j) {
            return 0.0;
        }

        @Override
        public double[] getTimePoints() {
            return new double[]{this.mTime};
        }
    }
}

