/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion;

public class CustomAttribute {
    private static final String TAG = "TransitionLayout";
    private boolean mMethod = false;
    String mName;
    private AttributeType mType;
    private int mIntegerValue;
    private float mFloatValue;
    private String mStringValue;
    boolean mBooleanValue;
    private int mColorValue;

    public AttributeType getType() {
        return this.mType;
    }

    public boolean isContinuous() {
        switch (this.mType.ordinal()) {
            case 4: 
            case 5: 
            case 7: {
                return false;
            }
        }
        return true;
    }

    public void setFloatValue(float value) {
        this.mFloatValue = value;
    }

    public void setColorValue(int value) {
        this.mColorValue = value;
    }

    public void setIntValue(int value) {
        this.mIntegerValue = value;
    }

    public void setStringValue(String value) {
        this.mStringValue = value;
    }

    public int numberOfInterpolatedValues() {
        switch (this.mType.ordinal()) {
            case 2: 
            case 3: {
                return 4;
            }
        }
        return 1;
    }

    public float getValueToInterpolate() {
        switch (this.mType.ordinal()) {
            case 0: {
                return this.mIntegerValue;
            }
            case 1: {
                return this.mFloatValue;
            }
            case 2: 
            case 3: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case 4: {
                throw new RuntimeException("Cannot interpolate String");
            }
            case 5: {
                return this.mBooleanValue ? 1.0f : 0.0f;
            }
            case 6: {
                return this.mFloatValue;
            }
        }
        return Float.NaN;
    }

    public void getValuesToInterpolate(float[] ret) {
        switch (this.mType.ordinal()) {
            case 0: {
                ret[0] = this.mIntegerValue;
                break;
            }
            case 1: {
                ret[0] = this.mFloatValue;
                break;
            }
            case 2: 
            case 3: {
                int a = 0xFF & this.mColorValue >> 24;
                int r = 0xFF & this.mColorValue >> 16;
                int g = 0xFF & this.mColorValue >> 8;
                int b = 0xFF & this.mColorValue;
                float f_r = (float)Math.pow((float)r / 255.0f, 2.2);
                float f_g = (float)Math.pow((float)g / 255.0f, 2.2);
                float f_b = (float)Math.pow((float)b / 255.0f, 2.2);
                ret[0] = f_r;
                ret[1] = f_g;
                ret[2] = f_b;
                ret[3] = (float)a / 255.0f;
                break;
            }
            case 4: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case 5: {
                ret[0] = this.mBooleanValue ? 1.0f : 0.0f;
                break;
            }
            case 6: {
                ret[0] = this.mFloatValue;
                break;
            }
        }
    }

    public void setValue(float[] value) {
        switch (this.mType.ordinal()) {
            case 0: 
            case 7: {
                this.mIntegerValue = (int)value[0];
                break;
            }
            case 1: {
                this.mFloatValue = value[0];
                break;
            }
            case 2: 
            case 3: {
                this.mColorValue = CustomAttribute.hsvToRgb(value[0], value[1], value[2]);
                this.mColorValue = this.mColorValue & 0xFFFFFF | CustomAttribute.clamp((int)(255.0f * value[3])) << 24;
                break;
            }
            case 4: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case 5: {
                this.mBooleanValue = (double)value[0] > 0.5;
                break;
            }
            case 6: {
                this.mFloatValue = value[0];
                break;
            }
        }
    }

    public static int hsvToRgb(float hue, float saturation, float value) {
        int h = (int)(hue * 6.0f);
        float f = hue * 6.0f - (float)h;
        int p = (int)(0.5f + 255.0f * value * (1.0f - saturation));
        int q = (int)(0.5f + 255.0f * value * (1.0f - f * saturation));
        int t = (int)(0.5f + 255.0f * value * (1.0f - (1.0f - f) * saturation));
        int v = (int)(0.5f + 255.0f * value);
        switch (h) {
            case 0: {
                return 0xFF000000 | (v << 16) + (t << 8) + p;
            }
            case 1: {
                return 0xFF000000 | (q << 16) + (v << 8) + p;
            }
            case 2: {
                return 0xFF000000 | (p << 16) + (v << 8) + t;
            }
            case 3: {
                return 0xFF000000 | (p << 16) + (q << 8) + v;
            }
            case 4: {
                return 0xFF000000 | (t << 16) + (p << 8) + v;
            }
            case 5: {
                return 0xFF000000 | (v << 16) + (p << 8) + q;
            }
        }
        return 0;
    }

    public boolean diff(CustomAttribute customAttribute) {
        if (customAttribute == null || this.mType != customAttribute.mType) {
            return false;
        }
        switch (this.mType.ordinal()) {
            case 0: 
            case 7: {
                return this.mIntegerValue == customAttribute.mIntegerValue;
            }
            case 1: {
                return this.mFloatValue == customAttribute.mFloatValue;
            }
            case 2: 
            case 3: {
                return this.mColorValue == customAttribute.mColorValue;
            }
            case 4: {
                return this.mIntegerValue == customAttribute.mIntegerValue;
            }
            case 5: {
                return this.mBooleanValue == customAttribute.mBooleanValue;
            }
            case 6: {
                return this.mFloatValue == customAttribute.mFloatValue;
            }
        }
        return false;
    }

    public CustomAttribute(String name, AttributeType attributeType) {
        this.mName = name;
        this.mType = attributeType;
    }

    public CustomAttribute(String name, AttributeType attributeType, Object value, boolean method) {
        this.mName = name;
        this.mType = attributeType;
        this.mMethod = method;
        this.setValue(value);
    }

    public CustomAttribute(CustomAttribute source, Object value) {
        this.mName = source.mName;
        this.mType = source.mType;
        this.setValue(value);
    }

    public void setValue(Object value) {
        switch (this.mType.ordinal()) {
            case 0: 
            case 7: {
                this.mIntegerValue = (Integer)value;
                break;
            }
            case 1: {
                this.mFloatValue = ((Float)value).floatValue();
                break;
            }
            case 2: 
            case 3: {
                this.mColorValue = (Integer)value;
                break;
            }
            case 4: {
                this.mStringValue = (String)value;
                break;
            }
            case 5: {
                this.mBooleanValue = (Boolean)value;
                break;
            }
            case 6: {
                this.mFloatValue = ((Float)value).floatValue();
                break;
            }
        }
    }

    private static int clamp(int c) {
        int n = 255;
        c &= ~(c >> 31);
        c -= n;
        c &= c >> 31;
        return c += n;
    }

    public static enum AttributeType {
        INT_TYPE,
        FLOAT_TYPE,
        COLOR_TYPE,
        COLOR_DRAWABLE_TYPE,
        STRING_TYPE,
        BOOLEAN_TYPE,
        DIMENSION_TYPE,
        REFERENCE_TYPE;

    }
}

