/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.dsl;

import java.util.HashMap;
import java.util.Map;

public class Constraint {
    private final String mId;
    public static final Constraint PARENT = new Constraint("parent");
    static int UNSET = Integer.MIN_VALUE;
    static Map<ChainMode, String> chainModeMap = new HashMap<ChainMode, String>();
    String helperType = null;
    String helperJason = null;
    private HAnchor mLeft = new HAnchor(HSide.LEFT);
    private HAnchor mRight = new HAnchor(HSide.RIGHT);
    private VAnchor mTop = new VAnchor(VSide.TOP);
    private VAnchor mBottom = new VAnchor(VSide.BOTTOM);
    private HAnchor mStart = new HAnchor(HSide.START);
    private HAnchor mEnd = new HAnchor(HSide.END);
    private VAnchor mBaseline = new VAnchor(VSide.BASELINE);
    private int mWidth = UNSET;
    private int mHeight = UNSET;
    private float mHorizontalBias = Float.NaN;
    private float mVerticalBias = Float.NaN;
    private String mDimensionRatio = null;
    private String mCircleConstraint = null;
    private int mCircleRadius = Integer.MIN_VALUE;
    private float mCircleAngle = Float.NaN;
    private int mEditorAbsoluteX = Integer.MIN_VALUE;
    private int mEditorAbsoluteY = Integer.MIN_VALUE;
    private float mVerticalWeight = Float.NaN;
    private float mHorizontalWeight = Float.NaN;
    private ChainMode mHorizontalChainStyle = null;
    private ChainMode mVerticalChainStyle = null;
    private Behaviour mWidthDefault = null;
    private Behaviour mHeightDefault = null;
    private int mWidthMax = UNSET;
    private int mHeightMax = UNSET;
    private int mWidthMin = UNSET;
    private int mHeightMin = UNSET;
    private float mWidthPercent = Float.NaN;
    private float mHeightPercent = Float.NaN;
    private String[] mReferenceIds = null;
    private boolean mConstrainedWidth = false;
    private boolean mConstrainedHeight = false;

    public Constraint(String id) {
        this.mId = id;
    }

    public HAnchor getLeft() {
        return this.mLeft;
    }

    public HAnchor getRight() {
        return this.mRight;
    }

    public VAnchor getTop() {
        return this.mTop;
    }

    public VAnchor getBottom() {
        return this.mBottom;
    }

    public HAnchor getStart() {
        return this.mStart;
    }

    public HAnchor getEnd() {
        return this.mEnd;
    }

    public VAnchor getBaseline() {
        return this.mBaseline;
    }

    public float getHorizontalBias() {
        return this.mHorizontalBias;
    }

    public void setHorizontalBias(float horizontalBias) {
        this.mHorizontalBias = horizontalBias;
    }

    public float getVerticalBias() {
        return this.mVerticalBias;
    }

    public void setVerticalBias(float verticalBias) {
        this.mVerticalBias = verticalBias;
    }

    public String getDimensionRatio() {
        return this.mDimensionRatio;
    }

    public void setDimensionRatio(String dimensionRatio) {
        this.mDimensionRatio = dimensionRatio;
    }

    public String getCircleConstraint() {
        return this.mCircleConstraint;
    }

    public void setCircleConstraint(String circleConstraint) {
        this.mCircleConstraint = circleConstraint;
    }

    public int getCircleRadius() {
        return this.mCircleRadius;
    }

    public void setCircleRadius(int circleRadius) {
        this.mCircleRadius = circleRadius;
    }

    public float getCircleAngle() {
        return this.mCircleAngle;
    }

    public void setCircleAngle(float circleAngle) {
        this.mCircleAngle = circleAngle;
    }

    public int getEditorAbsoluteX() {
        return this.mEditorAbsoluteX;
    }

    public void setEditorAbsoluteX(int editorAbsoluteX) {
        this.mEditorAbsoluteX = editorAbsoluteX;
    }

    public int getEditorAbsoluteY() {
        return this.mEditorAbsoluteY;
    }

    public void setEditorAbsoluteY(int editorAbsoluteY) {
        this.mEditorAbsoluteY = editorAbsoluteY;
    }

    public float getVerticalWeight() {
        return this.mVerticalWeight;
    }

    public void setVerticalWeight(float verticalWeight) {
        this.mVerticalWeight = verticalWeight;
    }

    public float getHorizontalWeight() {
        return this.mHorizontalWeight;
    }

    public void setHorizontalWeight(float horizontalWeight) {
        this.mHorizontalWeight = horizontalWeight;
    }

    public ChainMode getHorizontalChainStyle() {
        return this.mHorizontalChainStyle;
    }

    public void setHorizontalChainStyle(ChainMode horizontalChainStyle) {
        this.mHorizontalChainStyle = horizontalChainStyle;
    }

    public ChainMode getVerticalChainStyle() {
        return this.mVerticalChainStyle;
    }

    public void setVerticalChainStyle(ChainMode verticalChainStyle) {
        this.mVerticalChainStyle = verticalChainStyle;
    }

    public Behaviour getWidthDefault() {
        return this.mWidthDefault;
    }

    public void setWidthDefault(Behaviour widthDefault) {
        this.mWidthDefault = widthDefault;
    }

    public Behaviour getHeightDefault() {
        return this.mHeightDefault;
    }

    public void setHeightDefault(Behaviour heightDefault) {
        this.mHeightDefault = heightDefault;
    }

    public int getWidthMax() {
        return this.mWidthMax;
    }

    public void setWidthMax(int widthMax) {
        this.mWidthMax = widthMax;
    }

    public int getHeightMax() {
        return this.mHeightMax;
    }

    public void setHeightMax(int heightMax) {
        this.mHeightMax = heightMax;
    }

    public int getWidthMin() {
        return this.mWidthMin;
    }

    public void setWidthMin(int widthMin) {
        this.mWidthMin = widthMin;
    }

    public int getHeightMin() {
        return this.mHeightMin;
    }

    public void setHeightMin(int heightMin) {
        this.mHeightMin = heightMin;
    }

    public float getWidthPercent() {
        return this.mWidthPercent;
    }

    public void setWidthPercent(float widthPercent) {
        this.mWidthPercent = widthPercent;
    }

    public float getHeightPercent() {
        return this.mHeightPercent;
    }

    public void setHeightPercent(float heightPercent) {
        this.mHeightPercent = heightPercent;
    }

    public String[] getReferenceIds() {
        return this.mReferenceIds;
    }

    public void setReferenceIds(String[] referenceIds) {
        this.mReferenceIds = referenceIds;
    }

    public boolean isConstrainedWidth() {
        return this.mConstrainedWidth;
    }

    public void setConstrainedWidth(boolean constrainedWidth) {
        this.mConstrainedWidth = constrainedWidth;
    }

    public boolean isConstrainedHeight() {
        return this.mConstrainedHeight;
    }

    public void setConstrainedHeight(boolean constrainedHeight) {
        this.mConstrainedHeight = constrainedHeight;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void setWidth(int width) {
        this.mWidth = width;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void setHeight(int height) {
        this.mHeight = height;
    }

    public void linkToTop(VAnchor anchor) {
        this.linkToTop(anchor, 0);
    }

    public void linkToLeft(HAnchor anchor) {
        this.linkToLeft(anchor, 0);
    }

    public void linkToRight(HAnchor anchor) {
        this.linkToRight(anchor, 0);
    }

    public void linkToStart(HAnchor anchor) {
        this.linkToStart(anchor, 0);
    }

    public void linkToEnd(HAnchor anchor) {
        this.linkToEnd(anchor, 0);
    }

    public void linkToBottom(VAnchor anchor) {
        this.linkToBottom(anchor, 0);
    }

    public void linkToBaseline(VAnchor anchor) {
        this.linkToBaseline(anchor, 0);
    }

    public void linkToTop(VAnchor anchor, int margin) {
        this.linkToTop(anchor, margin, Integer.MIN_VALUE);
    }

    public void linkToLeft(HAnchor anchor, int margin) {
        this.linkToLeft(anchor, margin, Integer.MIN_VALUE);
    }

    public void linkToRight(HAnchor anchor, int margin) {
        this.linkToRight(anchor, margin, Integer.MIN_VALUE);
    }

    public void linkToStart(HAnchor anchor, int margin) {
        this.linkToStart(anchor, margin, Integer.MIN_VALUE);
    }

    public void linkToEnd(HAnchor anchor, int margin) {
        this.linkToEnd(anchor, margin, Integer.MIN_VALUE);
    }

    public void linkToBottom(VAnchor anchor, int margin) {
        this.linkToBottom(anchor, margin, Integer.MIN_VALUE);
    }

    public void linkToBaseline(VAnchor anchor, int margin) {
        this.linkToBaseline(anchor, margin, Integer.MIN_VALUE);
    }

    public void linkToTop(VAnchor anchor, int margin, int goneMargin) {
        this.mTop.mConnection = anchor;
        this.mTop.mMargin = margin;
        this.mTop.mGoneMargin = goneMargin;
    }

    public void linkToLeft(HAnchor anchor, int margin, int goneMargin) {
        this.mLeft.mConnection = anchor;
        this.mLeft.mMargin = margin;
        this.mLeft.mGoneMargin = goneMargin;
    }

    public void linkToRight(HAnchor anchor, int margin, int goneMargin) {
        this.mRight.mConnection = anchor;
        this.mRight.mMargin = margin;
        this.mRight.mGoneMargin = goneMargin;
    }

    public void linkToStart(HAnchor anchor, int margin, int goneMargin) {
        this.mStart.mConnection = anchor;
        this.mStart.mMargin = margin;
        this.mStart.mGoneMargin = goneMargin;
    }

    public void linkToEnd(HAnchor anchor, int margin, int goneMargin) {
        this.mEnd.mConnection = anchor;
        this.mEnd.mMargin = margin;
        this.mEnd.mGoneMargin = goneMargin;
    }

    public void linkToBottom(VAnchor anchor, int margin, int goneMargin) {
        this.mBottom.mConnection = anchor;
        this.mBottom.mMargin = margin;
        this.mBottom.mGoneMargin = goneMargin;
    }

    public void linkToBaseline(VAnchor anchor, int margin, int goneMargin) {
        this.mBaseline.mConnection = anchor;
        this.mBaseline.mMargin = margin;
        this.mBaseline.mGoneMargin = goneMargin;
    }

    public String convertStringArrayToString(String[] str) {
        StringBuilder ret = new StringBuilder("[");
        for (int i = 0; i < str.length; ++i) {
            ret.append(i == 0 ? "'" : ",'");
            ret.append(str[i]);
            ret.append("'");
        }
        ret.append("]");
        return ret.toString();
    }

    protected void append(StringBuilder builder, String name, float value) {
        if (Float.isNaN(value)) {
            return;
        }
        builder.append(name);
        builder.append(":").append(value).append(",\n");
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(this.mId + ":{\n");
        this.mLeft.build(ret);
        this.mRight.build(ret);
        this.mTop.build(ret);
        this.mBottom.build(ret);
        this.mStart.build(ret);
        this.mEnd.build(ret);
        this.mBaseline.build(ret);
        if (this.mWidth != UNSET) {
            ret.append("width:").append(this.mWidth).append(",\n");
        }
        if (this.mHeight != UNSET) {
            ret.append("height:").append(this.mHeight).append(",\n");
        }
        this.append(ret, "horizontalBias", this.mHorizontalBias);
        this.append(ret, "verticalBias", this.mVerticalBias);
        if (this.mDimensionRatio != null) {
            ret.append("dimensionRatio:'").append(this.mDimensionRatio).append("',\n");
        }
        if (!(this.mCircleConstraint == null || Float.isNaN(this.mCircleAngle) && this.mCircleRadius == Integer.MIN_VALUE)) {
            ret.append("circular:['").append(this.mCircleConstraint).append("'");
            if (!Float.isNaN(this.mCircleAngle)) {
                ret.append(",").append(this.mCircleAngle);
            }
            if (this.mCircleRadius != Integer.MIN_VALUE) {
                if (Float.isNaN(this.mCircleAngle)) {
                    ret.append(",0,").append(this.mCircleRadius);
                } else {
                    ret.append(",").append(this.mCircleRadius);
                }
            }
            ret.append("],\n");
        }
        this.append(ret, "verticalWeight", this.mVerticalWeight);
        this.append(ret, "horizontalWeight", this.mHorizontalWeight);
        if (this.mHorizontalChainStyle != null) {
            ret.append("horizontalChainStyle:'").append(chainModeMap.get((Object)this.mHorizontalChainStyle)).append("',\n");
        }
        if (this.mVerticalChainStyle != null) {
            ret.append("verticalChainStyle:'").append(chainModeMap.get((Object)this.mVerticalChainStyle)).append("',\n");
        }
        if (this.mWidthDefault != null) {
            if (this.mWidthMax == UNSET && this.mWidthMin == UNSET) {
                ret.append("width:'").append(this.mWidthDefault.toString().toLowerCase()).append("',\n");
            } else {
                ret.append("width:{value:'").append(this.mWidthDefault.toString().toLowerCase()).append("'");
                if (this.mWidthMax != UNSET) {
                    ret.append(",max:").append(this.mWidthMax);
                }
                if (this.mWidthMin != UNSET) {
                    ret.append(",min:").append(this.mWidthMin);
                }
                ret.append("},\n");
            }
        }
        if (this.mHeightDefault != null) {
            if (this.mHeightMax == UNSET && this.mHeightMin == UNSET) {
                ret.append("height:'").append(this.mHeightDefault.toString().toLowerCase()).append("',\n");
            } else {
                ret.append("height:{value:'").append(this.mHeightDefault.toString().toLowerCase()).append("'");
                if (this.mHeightMax != UNSET) {
                    ret.append(",max:").append(this.mHeightMax);
                }
                if (this.mHeightMin != UNSET) {
                    ret.append(",min:").append(this.mHeightMin);
                }
                ret.append("},\n");
            }
        }
        if (!Double.isNaN(this.mWidthPercent)) {
            ret.append("width:'").append((int)this.mWidthPercent).append("%',\n");
        }
        if (!Double.isNaN(this.mHeightPercent)) {
            ret.append("height:'").append((int)this.mHeightPercent).append("%',\n");
        }
        if (this.mReferenceIds != null) {
            ret.append("referenceIds:").append(this.convertStringArrayToString(this.mReferenceIds)).append(",\n");
        }
        if (this.mConstrainedWidth) {
            ret.append("constrainedWidth:").append(this.mConstrainedWidth).append(",\n");
        }
        if (this.mConstrainedHeight) {
            ret.append("constrainedHeight:").append(this.mConstrainedHeight).append(",\n");
        }
        ret.append("},\n");
        return ret.toString();
    }

    static {
        chainModeMap.put(ChainMode.SPREAD, "spread");
        chainModeMap.put(ChainMode.SPREAD_INSIDE, "spread_inside");
        chainModeMap.put(ChainMode.PACKED, "packed");
    }

    public class HAnchor
    extends Anchor {
        HAnchor(HSide side) {
            super(Side.valueOf(side.name()));
        }
    }

    public static enum HSide {
        LEFT,
        RIGHT,
        START,
        END;

    }

    public class VAnchor
    extends Anchor {
        VAnchor(VSide side) {
            super(Side.valueOf(side.name()));
        }
    }

    public static enum VSide {
        TOP,
        BOTTOM,
        BASELINE;

    }

    public static enum ChainMode {
        SPREAD,
        SPREAD_INSIDE,
        PACKED;

    }

    public static enum Behaviour {
        SPREAD,
        WRAP,
        PERCENT,
        RATIO,
        RESOLVED;

    }

    public class Anchor {
        final Side mSide;
        Anchor mConnection = null;
        int mMargin;
        int mGoneMargin = Integer.MIN_VALUE;

        Anchor(Side side) {
            this.mSide = side;
        }

        public String getId() {
            return Constraint.this.mId;
        }

        Constraint getParent() {
            return Constraint.this;
        }

        public void build(StringBuilder builder) {
            if (this.mConnection != null) {
                builder.append(this.mSide.toString().toLowerCase()).append(":").append(this).append(",\n");
            }
        }

        public String toString() {
            StringBuilder ret = new StringBuilder("[");
            if (this.mConnection != null) {
                ret.append("'").append(this.mConnection.getId()).append("',").append("'").append(this.mConnection.mSide.toString().toLowerCase()).append("'");
            }
            if (this.mMargin != 0) {
                ret.append(",").append(this.mMargin);
            }
            if (this.mGoneMargin != Integer.MIN_VALUE) {
                if (this.mMargin == 0) {
                    ret.append(",0,").append(this.mGoneMargin);
                } else {
                    ret.append(",").append(this.mGoneMargin);
                }
            }
            ret.append("]");
            return ret.toString();
        }
    }

    public static enum Side {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        START,
        END,
        BASELINE;

    }
}

