/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.motion.key;

import androidx.constraintlayout.core.motion.MotionWidget;
import androidx.constraintlayout.core.motion.key.MotionKey;
import androidx.constraintlayout.core.motion.utils.FloatRect;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.core.motion.utils.TypedValues;
import java.util.HashMap;
import java.util.HashSet;

public class MotionKeyPosition
extends MotionKey {
    static final String NAME = "KeyPosition";
    protected static final float SELECTION_SLOPE = 20.0f;
    public int mCurveFit = UNSET;
    public String mTransitionEasing = null;
    public int mPathMotionArc = UNSET;
    public int mDrawPath = 0;
    public float mPercentWidth = Float.NaN;
    public float mPercentHeight = Float.NaN;
    public float mPercentX = Float.NaN;
    public float mPercentY = Float.NaN;
    public float mAltPercentX = Float.NaN;
    public float mAltPercentY = Float.NaN;
    public static final int TYPE_SCREEN = 2;
    public static final int TYPE_PATH = 1;
    public static final int TYPE_CARTESIAN = 0;
    public int mPositionType = 0;
    private float mCalculatedPositionX = Float.NaN;
    private float mCalculatedPositionY = Float.NaN;
    static final int KEY_TYPE = 2;

    public MotionKeyPosition() {
        this.mType = 2;
    }

    private void calcScreenPosition(int layoutWidth, int layoutHeight) {
        int viewWidth = 0;
        int viewHeight = 0;
        this.mCalculatedPositionX = (float)(layoutWidth - viewWidth) * this.mPercentX + (float)(viewWidth / 2);
        this.mCalculatedPositionY = (float)(layoutHeight - viewHeight) * this.mPercentX + (float)(viewHeight / 2);
    }

    private void calcPathPosition(float startX, float startY, float endX, float endY) {
        float pathVectorX = endX - startX;
        float pathVectorY = endY - startY;
        float perpendicularX = -pathVectorY;
        float perpendicularY = pathVectorX;
        this.mCalculatedPositionX = startX + pathVectorX * this.mPercentX + perpendicularX * this.mPercentY;
        this.mCalculatedPositionY = startY + pathVectorY * this.mPercentX + perpendicularY * this.mPercentY;
    }

    private void calcCartesianPosition(float startX, float startY, float endX, float endY) {
        float pathVectorX = endX - startX;
        float pathVectorY = endY - startY;
        float dxdx = Float.isNaN(this.mPercentX) ? 0.0f : this.mPercentX;
        float dydx = Float.isNaN(this.mAltPercentY) ? 0.0f : this.mAltPercentY;
        float dydy = Float.isNaN(this.mPercentY) ? 0.0f : this.mPercentY;
        float dxdy = Float.isNaN(this.mAltPercentX) ? 0.0f : this.mAltPercentX;
        this.mCalculatedPositionX = (int)(startX + pathVectorX * dxdx + pathVectorY * dxdy);
        this.mCalculatedPositionY = (int)(startY + pathVectorX * dydx + pathVectorY * dydy);
    }

    float getPositionX() {
        return this.mCalculatedPositionX;
    }

    float getPositionY() {
        return this.mCalculatedPositionY;
    }

    public void positionAttributes(MotionWidget view, FloatRect start, FloatRect end, float x, float y, String[] attribute, float[] value) {
        switch (this.mPositionType) {
            case 1: {
                this.positionPathAttributes(start, end, x, y, attribute, value);
                return;
            }
            case 2: {
                this.positionScreenAttributes(view, start, end, x, y, attribute, value);
                return;
            }
        }
        this.positionCartAttributes(start, end, x, y, attribute, value);
    }

    void positionPathAttributes(FloatRect start, FloatRect end, float x, float y, String[] attribute, float[] value) {
        float endCenterY;
        float pathVectorY;
        float startCenterX = start.centerX();
        float startCenterY = start.centerY();
        float endCenterX = end.centerX();
        float pathVectorX = endCenterX - startCenterX;
        float distance = (float)Math.hypot(pathVectorX, pathVectorY = (endCenterY = end.centerY()) - startCenterY);
        if ((double)distance < 1.0E-4) {
            System.out.println("distance ~ 0");
            value[0] = 0.0f;
            value[1] = 0.0f;
            return;
        }
        float dx = pathVectorX / distance;
        float dy = pathVectorY / distance;
        float perpendicular = (dx * (y - startCenterY) - (x - startCenterX) * dy) / distance;
        float dist = (dx * (x - startCenterX) + dy * (y - startCenterY)) / distance;
        if (attribute[0] != null) {
            if ("percentX".equals(attribute[0])) {
                value[0] = dist;
                value[1] = perpendicular;
            }
        } else {
            attribute[0] = "percentX";
            attribute[1] = "percentY";
            value[0] = dist;
            value[1] = perpendicular;
        }
    }

    void positionScreenAttributes(MotionWidget view, FloatRect start, FloatRect end, float x, float y, String[] attribute, float[] value) {
        float startCenterX = start.centerX();
        float startCenterY = start.centerY();
        float endCenterX = end.centerX();
        float endCenterY = end.centerY();
        float pathVectorX = endCenterX - startCenterX;
        float pathVectorY = endCenterY - startCenterY;
        MotionWidget viewGroup = view.getParent();
        int width = viewGroup.getWidth();
        int height = viewGroup.getHeight();
        if (attribute[0] != null) {
            if ("percentX".equals(attribute[0])) {
                value[0] = x / (float)width;
                value[1] = y / (float)height;
            } else {
                value[1] = x / (float)width;
                value[0] = y / (float)height;
            }
        } else {
            attribute[0] = "percentX";
            value[0] = x / (float)width;
            attribute[1] = "percentY";
            value[1] = y / (float)height;
        }
    }

    void positionCartAttributes(FloatRect start, FloatRect end, float x, float y, String[] attribute, float[] value) {
        float startCenterX = start.centerX();
        float startCenterY = start.centerY();
        float endCenterX = end.centerX();
        float endCenterY = end.centerY();
        float pathVectorX = endCenterX - startCenterX;
        float pathVectorY = endCenterY - startCenterY;
        if (attribute[0] != null) {
            if ("percentX".equals(attribute[0])) {
                value[0] = (x - startCenterX) / pathVectorX;
                value[1] = (y - startCenterY) / pathVectorY;
            } else {
                value[1] = (x - startCenterX) / pathVectorX;
                value[0] = (y - startCenterY) / pathVectorY;
            }
        } else {
            attribute[0] = "percentX";
            value[0] = (x - startCenterX) / pathVectorX;
            attribute[1] = "percentY";
            value[1] = (y - startCenterY) / pathVectorY;
        }
    }

    public boolean intersects(int layoutWidth, int layoutHeight, FloatRect start, FloatRect end, float x, float y) {
        this.calcPosition(layoutWidth, layoutHeight, start.centerX(), start.centerY(), end.centerX(), end.centerY());
        return Math.abs(x - this.mCalculatedPositionX) < 20.0f && Math.abs(y - this.mCalculatedPositionY) < 20.0f;
    }

    @Override
    public MotionKey copy(MotionKey src) {
        super.copy(src);
        MotionKeyPosition k = (MotionKeyPosition)src;
        this.mTransitionEasing = k.mTransitionEasing;
        this.mPathMotionArc = k.mPathMotionArc;
        this.mDrawPath = k.mDrawPath;
        this.mPercentWidth = k.mPercentWidth;
        this.mPercentHeight = Float.NaN;
        this.mPercentX = k.mPercentX;
        this.mPercentY = k.mPercentY;
        this.mAltPercentX = k.mAltPercentX;
        this.mAltPercentY = k.mAltPercentY;
        this.mCalculatedPositionX = k.mCalculatedPositionX;
        this.mCalculatedPositionY = k.mCalculatedPositionY;
        return this;
    }

    @Override
    public MotionKey clone() {
        return new MotionKeyPosition().copy(this);
    }

    void calcPosition(int layoutWidth, int layoutHeight, float startX, float startY, float endX, float endY) {
        switch (this.mPositionType) {
            case 2: {
                this.calcScreenPosition(layoutWidth, layoutHeight);
                return;
            }
            case 1: {
                this.calcPathPosition(startX, startY, endX, endY);
                return;
            }
        }
        this.calcCartesianPosition(startX, startY, endX, endY);
    }

    @Override
    public void getAttributeNames(HashSet<String> attributes) {
    }

    @Override
    public void addValues(HashMap<String, SplineSet> splines) {
    }

    @Override
    public boolean setValue(int type, int value) {
        switch (type) {
            case 510: {
                this.mPositionType = value;
                break;
            }
            case 100: {
                this.mFramePosition = value;
                break;
            }
            case 508: {
                this.mCurveFit = value;
                break;
            }
            default: {
                return super.setValue(type, value);
            }
        }
        return true;
    }

    @Override
    public boolean setValue(int type, float value) {
        switch (type) {
            case 503: {
                this.mPercentWidth = value;
                break;
            }
            case 504: {
                this.mPercentHeight = value;
                break;
            }
            case 505: {
                this.mPercentHeight = this.mPercentWidth = value;
                break;
            }
            case 506: {
                this.mPercentX = value;
                break;
            }
            case 507: {
                this.mPercentY = value;
                break;
            }
            default: {
                return super.setValue(type, value);
            }
        }
        return true;
    }

    @Override
    public boolean setValue(int type, String value) {
        switch (type) {
            case 501: {
                this.mTransitionEasing = value.toString();
                break;
            }
            default: {
                return super.setValue(type, value);
            }
        }
        return true;
    }

    @Override
    public int getId(String name) {
        return TypedValues.PositionType.getId(name);
    }
}

