/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.Helper;
import androidx.constraintlayout.core.widgets.analyzer.BaselineDimensionDependency;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.core.widgets.analyzer.DimensionDependency;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;

public class VerticalWidgetRun
extends WidgetRun {
    private static final boolean FORCE_USE = true;
    public DependencyNode baseline = new DependencyNode(this);
    DimensionDependency mBaselineDimension = null;

    public VerticalWidgetRun(ConstraintWidget widget) {
        super(widget);
        this.start.mType = DependencyNode.Type.TOP;
        this.end.mType = DependencyNode.Type.BOTTOM;
        this.baseline.mType = DependencyNode.Type.BASELINE;
        this.orientation = 1;
    }

    public String toString() {
        return "VerticalRun " + this.mWidget.getDebugName();
    }

    @Override
    void clear() {
        this.mRunGroup = null;
        this.start.clear();
        this.end.clear();
        this.baseline.clear();
        this.mDimension.clear();
        this.mResolved = false;
    }

    @Override
    void reset() {
        this.mResolved = false;
        this.start.clear();
        this.start.resolved = false;
        this.end.clear();
        this.end.resolved = false;
        this.baseline.clear();
        this.baseline.resolved = false;
        this.mDimension.resolved = false;
    }

    @Override
    boolean supportsWrapComputation() {
        if (this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            return this.mWidget.mMatchConstraintDefaultHeight == 0;
        }
        return true;
    }

    @Override
    public void update(Dependency dependency) {
        int endPos;
        int startPos;
        switch (this.mRunType) {
            case START: {
                this.updateRunStart(dependency);
                break;
            }
            case END: {
                this.updateRunEnd(dependency);
                break;
            }
            case CENTER: {
                this.updateRunCenter(dependency, this.mWidget.mTop, this.mWidget.mBottom, 1);
                return;
            }
        }
        if (this.mDimension.readyToSolve && !this.mDimension.resolved && this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            switch (this.mWidget.mMatchConstraintDefaultHeight) {
                case 3: {
                    if (!this.mWidget.mHorizontalRun.mDimension.resolved) break;
                    int size = 0;
                    int ratioSide = this.mWidget.getDimensionRatioSide();
                    switch (ratioSide) {
                        case 0: {
                            size = (int)(0.5f + (float)this.mWidget.mHorizontalRun.mDimension.value * this.mWidget.getDimensionRatio());
                            break;
                        }
                        case 1: {
                            size = (int)(0.5f + (float)this.mWidget.mHorizontalRun.mDimension.value / this.mWidget.getDimensionRatio());
                            break;
                        }
                        case -1: {
                            size = (int)(0.5f + (float)this.mWidget.mHorizontalRun.mDimension.value / this.mWidget.getDimensionRatio());
                            break;
                        }
                    }
                    this.mDimension.resolve(size);
                    break;
                }
                case 2: {
                    ConstraintWidget parent = this.mWidget.getParent();
                    if (parent == null || !parent.mVerticalRun.mDimension.resolved) break;
                    float percent = this.mWidget.mMatchConstraintPercentHeight;
                    int targetDimensionValue = parent.mVerticalRun.mDimension.value;
                    int size = (int)(0.5f + (float)targetDimensionValue * percent);
                    this.mDimension.resolve(size);
                    break;
                }
            }
        }
        if (!this.start.readyToSolve || !this.end.readyToSolve) {
            return;
        }
        if (this.start.resolved && this.end.resolved && this.mDimension.resolved) {
            return;
        }
        if (!this.mDimension.resolved && this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && this.mWidget.mMatchConstraintDefaultWidth == 0 && !this.mWidget.isInVerticalChain()) {
            DependencyNode startTarget = this.start.mTargets.get(0);
            DependencyNode endTarget = this.end.mTargets.get(0);
            startPos = startTarget.value + this.start.mMargin;
            endPos = endTarget.value + this.end.mMargin;
            int distance = endPos - startPos;
            this.start.resolve(startPos);
            this.end.resolve(endPos);
            this.mDimension.resolve(distance);
            return;
        }
        if (!this.mDimension.resolved && this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && this.matchConstraintsType == 1 && this.start.mTargets.size() > 0 && this.end.mTargets.size() > 0) {
            DependencyNode startTarget = this.start.mTargets.get(0);
            DependencyNode endTarget = this.end.mTargets.get(0);
            endPos = endTarget.value + this.end.mMargin;
            startPos = startTarget.value + this.start.mMargin;
            int availableSpace = endPos - startPos;
            if (availableSpace < this.mDimension.wrapValue) {
                this.mDimension.resolve(availableSpace);
            } else {
                this.mDimension.resolve(this.mDimension.wrapValue);
            }
        }
        if (!this.mDimension.resolved) {
            return;
        }
        if (this.start.mTargets.size() > 0 && this.end.mTargets.size() > 0) {
            DependencyNode startTarget = this.start.mTargets.get(0);
            DependencyNode endTarget = this.end.mTargets.get(0);
            startPos = startTarget.value + this.start.mMargin;
            endPos = endTarget.value + this.end.mMargin;
            float bias = this.mWidget.getVerticalBiasPercent();
            if (startTarget == endTarget) {
                startPos = startTarget.value;
                endPos = endTarget.value;
                bias = 0.5f;
            }
            int distance = endPos - startPos - this.mDimension.value;
            this.start.resolve((int)(0.5f + (float)startPos + (float)distance * bias));
            this.end.resolve(this.start.value + this.mDimension.value);
        }
    }

    @Override
    void apply() {
        block58: {
            DependencyNode top;
            DependencyNode target;
            DependencyNode startTarget;
            block60: {
                block59: {
                    ConstraintWidget parent;
                    block57: {
                        if (this.mWidget.measured) {
                            this.mDimension.resolve(this.mWidget.getHeight());
                        }
                        if (!this.mDimension.resolved) {
                            this.mDimensionBehavior = this.mWidget.getVerticalDimensionBehaviour();
                            if (this.mWidget.hasBaseline()) {
                                this.mBaselineDimension = new BaselineDimensionDependency(this);
                            }
                            if (this.mDimensionBehavior != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                                if (this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_PARENT && (parent = this.mWidget.getParent()) != null && parent.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED) {
                                    int resolvedDimension = parent.getHeight() - this.mWidget.mTop.getMargin() - this.mWidget.mBottom.getMargin();
                                    this.addTarget(this.start, parent.mVerticalRun.start, this.mWidget.mTop.getMargin());
                                    this.addTarget(this.end, parent.mVerticalRun.end, -this.mWidget.mBottom.getMargin());
                                    this.mDimension.resolve(resolvedDimension);
                                    return;
                                }
                                if (this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.FIXED) {
                                    this.mDimension.resolve(this.mWidget.getHeight());
                                }
                            }
                        } else if (this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_PARENT && (parent = this.mWidget.getParent()) != null && parent.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED) {
                            this.addTarget(this.start, parent.mVerticalRun.start, this.mWidget.mTop.getMargin());
                            this.addTarget(this.end, parent.mVerticalRun.end, -this.mWidget.mBottom.getMargin());
                            return;
                        }
                        if (!this.mDimension.resolved || !this.mWidget.measured) break block57;
                        if (this.mWidget.mListAnchors[2].mTarget != null && this.mWidget.mListAnchors[3].mTarget != null) {
                            if (this.mWidget.isInVerticalChain()) {
                                this.start.mMargin = this.mWidget.mListAnchors[2].getMargin();
                                this.end.mMargin = -this.mWidget.mListAnchors[3].getMargin();
                            } else {
                                DependencyNode endTarget;
                                startTarget = this.getTarget(this.mWidget.mListAnchors[2]);
                                if (startTarget != null) {
                                    this.addTarget(this.start, startTarget, this.mWidget.mListAnchors[2].getMargin());
                                }
                                if ((endTarget = this.getTarget(this.mWidget.mListAnchors[3])) != null) {
                                    this.addTarget(this.end, endTarget, -this.mWidget.mListAnchors[3].getMargin());
                                }
                                this.start.delegateToWidgetRun = true;
                                this.end.delegateToWidgetRun = true;
                            }
                            if (this.mWidget.hasBaseline()) {
                                this.addTarget(this.baseline, this.start, this.mWidget.getBaselineDistance());
                            }
                        } else if (this.mWidget.mListAnchors[2].mTarget != null) {
                            target = this.getTarget(this.mWidget.mListAnchors[2]);
                            if (target != null) {
                                this.addTarget(this.start, target, this.mWidget.mListAnchors[2].getMargin());
                                this.addTarget(this.end, this.start, this.mDimension.value);
                                if (this.mWidget.hasBaseline()) {
                                    this.addTarget(this.baseline, this.start, this.mWidget.getBaselineDistance());
                                }
                            }
                        } else if (this.mWidget.mListAnchors[3].mTarget != null) {
                            target = this.getTarget(this.mWidget.mListAnchors[3]);
                            if (target != null) {
                                this.addTarget(this.end, target, -this.mWidget.mListAnchors[3].getMargin());
                                this.addTarget(this.start, this.end, -this.mDimension.value);
                            }
                            if (this.mWidget.hasBaseline()) {
                                this.addTarget(this.baseline, this.start, this.mWidget.getBaselineDistance());
                            }
                        } else if (this.mWidget.mListAnchors[4].mTarget != null) {
                            target = this.getTarget(this.mWidget.mListAnchors[4]);
                            if (target != null) {
                                this.addTarget(this.baseline, target, 0);
                                this.addTarget(this.start, this.baseline, -this.mWidget.getBaselineDistance());
                                this.addTarget(this.end, this.start, this.mDimension.value);
                            }
                        } else if (!(this.mWidget instanceof Helper) && this.mWidget.getParent() != null && this.mWidget.getAnchor((ConstraintAnchor.Type)ConstraintAnchor.Type.CENTER).mTarget == null) {
                            top = this.mWidget.getParent().mVerticalRun.start;
                            this.addTarget(this.start, top, this.mWidget.getY());
                            this.addTarget(this.end, this.start, this.mDimension.value);
                            if (this.mWidget.hasBaseline()) {
                                this.addTarget(this.baseline, this.start, this.mWidget.getBaselineDistance());
                            }
                        }
                        break block58;
                    }
                    if (this.mDimension.resolved || this.mDimensionBehavior != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) break block59;
                    switch (this.mWidget.mMatchConstraintDefaultHeight) {
                        case 3: {
                            if (!this.mWidget.isInVerticalChain()) {
                                if (this.mWidget.mMatchConstraintDefaultWidth == 3) break;
                                DimensionDependency targetDimension = this.mWidget.mHorizontalRun.mDimension;
                                this.mDimension.mTargets.add(targetDimension);
                                targetDimension.mDependencies.add(this.mDimension);
                                this.mDimension.delegateToWidgetRun = true;
                                this.mDimension.mDependencies.add(this.start);
                                this.mDimension.mDependencies.add(this.end);
                                break;
                            }
                            break block60;
                        }
                        case 2: {
                            parent = this.mWidget.getParent();
                            if (parent == null) break;
                            DimensionDependency targetDimension = parent.mVerticalRun.mDimension;
                            this.mDimension.mTargets.add(targetDimension);
                            targetDimension.mDependencies.add(this.mDimension);
                            this.mDimension.delegateToWidgetRun = true;
                            this.mDimension.mDependencies.add(this.start);
                            this.mDimension.mDependencies.add(this.end);
                            break;
                        }
                        case 0: {
                            break;
                        }
                    }
                    break block60;
                }
                this.mDimension.addDependency(this);
            }
            if (this.mWidget.mListAnchors[2].mTarget != null && this.mWidget.mListAnchors[3].mTarget != null) {
                if (this.mWidget.isInVerticalChain()) {
                    this.start.mMargin = this.mWidget.mListAnchors[2].getMargin();
                    this.end.mMargin = -this.mWidget.mListAnchors[3].getMargin();
                } else {
                    startTarget = this.getTarget(this.mWidget.mListAnchors[2]);
                    DependencyNode endTarget = this.getTarget(this.mWidget.mListAnchors[3]);
                    if (startTarget != null) {
                        startTarget.addDependency(this);
                    }
                    if (endTarget != null) {
                        endTarget.addDependency(this);
                    }
                    this.mRunType = WidgetRun.RunType.CENTER;
                }
                if (this.mWidget.hasBaseline()) {
                    this.addTarget(this.baseline, this.start, 1, this.mBaselineDimension);
                }
            } else if (this.mWidget.mListAnchors[2].mTarget != null) {
                target = this.getTarget(this.mWidget.mListAnchors[2]);
                if (target != null) {
                    this.addTarget(this.start, target, this.mWidget.mListAnchors[2].getMargin());
                    this.addTarget(this.end, this.start, 1, this.mDimension);
                    if (this.mWidget.hasBaseline()) {
                        this.addTarget(this.baseline, this.start, 1, this.mBaselineDimension);
                    }
                    if (this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && this.mWidget.getDimensionRatio() > 0.0f && this.mWidget.mHorizontalRun.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        this.mWidget.mHorizontalRun.mDimension.mDependencies.add(this.mDimension);
                        this.mDimension.mTargets.add(this.mWidget.mHorizontalRun.mDimension);
                        this.mDimension.updateDelegate = this;
                    }
                }
            } else if (this.mWidget.mListAnchors[3].mTarget != null) {
                target = this.getTarget(this.mWidget.mListAnchors[3]);
                if (target != null) {
                    this.addTarget(this.end, target, -this.mWidget.mListAnchors[3].getMargin());
                    this.addTarget(this.start, this.end, -1, this.mDimension);
                    if (this.mWidget.hasBaseline()) {
                        this.addTarget(this.baseline, this.start, 1, this.mBaselineDimension);
                    }
                }
            } else if (this.mWidget.mListAnchors[4].mTarget != null) {
                target = this.getTarget(this.mWidget.mListAnchors[4]);
                if (target != null) {
                    this.addTarget(this.baseline, target, 0);
                    this.addTarget(this.start, this.baseline, -1, this.mBaselineDimension);
                    this.addTarget(this.end, this.start, 1, this.mDimension);
                }
            } else if (!(this.mWidget instanceof Helper) && this.mWidget.getParent() != null) {
                top = this.mWidget.getParent().mVerticalRun.start;
                this.addTarget(this.start, top, this.mWidget.getY());
                this.addTarget(this.end, this.start, 1, this.mDimension);
                if (this.mWidget.hasBaseline()) {
                    this.addTarget(this.baseline, this.start, 1, this.mBaselineDimension);
                }
                if (this.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && this.mWidget.getDimensionRatio() > 0.0f && this.mWidget.mHorizontalRun.mDimensionBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    this.mWidget.mHorizontalRun.mDimension.mDependencies.add(this.mDimension);
                    this.mDimension.mTargets.add(this.mWidget.mHorizontalRun.mDimension);
                    this.mDimension.updateDelegate = this;
                }
            }
            if (this.mDimension.mTargets.size() == 0) {
                this.mDimension.readyToSolve = true;
            }
        }
    }

    @Override
    public void applyToWidget() {
        if (this.start.resolved) {
            this.mWidget.setY(this.start.value);
        }
    }
}

