/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.dsl;

import java.util.ArrayList;
import java.util.Arrays;

public class Ref {
    private String mId;
    private float mWeight = Float.NaN;
    private float mPreMargin = Float.NaN;
    private float mPostMargin = Float.NaN;

    Ref(String id) {
        this.mId = id;
    }

    Ref(String id, float weight) {
        this.mId = id;
        this.mWeight = weight;
    }

    Ref(String id, float weight, float preMargin) {
        this.mId = id;
        this.mWeight = weight;
        this.mPreMargin = preMargin;
    }

    Ref(String id, float weight, float preMargin, float postMargin) {
        this.mId = id;
        this.mWeight = weight;
        this.mPreMargin = preMargin;
        this.mPostMargin = postMargin;
    }

    public String getId() {
        return this.mId;
    }

    public void setId(String id) {
        this.mId = id;
    }

    public float getWeight() {
        return this.mWeight;
    }

    public void setWeight(float weight) {
        this.mWeight = weight;
    }

    public float getPreMargin() {
        return this.mPreMargin;
    }

    public void setPreMargin(float preMargin) {
        this.mPreMargin = preMargin;
    }

    public float getPostMargin() {
        return this.mPostMargin;
    }

    public void setPostMargin(float postMargin) {
        this.mPostMargin = postMargin;
    }

    public static float parseFloat(Object obj) {
        float val = Float.NaN;
        try {
            val = Float.parseFloat(obj.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public static Ref parseStringToRef(String str) {
        String[] values = str.replaceAll("[\\[\\]\\']", "").split(",");
        if (values.length == 0) {
            return null;
        }
        Object[] arr = new Object[4];
        for (int i = 0; i < values.length && i < 4; ++i) {
            arr[i] = values[i];
        }
        return new Ref(arr[0].toString().replace("'", ""), Ref.parseFloat(arr[1]), Ref.parseFloat(arr[2]), Ref.parseFloat(arr[3]));
    }

    public static void addStringToReferences(String str, ArrayList<Ref> refs) {
        if (str == null || str.length() == 0) {
            return;
        }
        Object[] arr = new Object[4];
        StringBuilder builder = new StringBuilder();
        int squareBrackets = 0;
        int varCount = 0;
        block6: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '[': {
                    ++squareBrackets;
                    continue block6;
                }
                case ']': {
                    if (squareBrackets <= 0) continue block6;
                    --squareBrackets;
                    arr[varCount] = builder.toString();
                    builder.setLength(0);
                    if (arr[0] == null) continue block6;
                    refs.add(new Ref(arr[0].toString(), Ref.parseFloat(arr[1]), Ref.parseFloat(arr[2]), Ref.parseFloat(arr[3])));
                    varCount = 0;
                    Arrays.fill(arr, null);
                    continue block6;
                }
                case ',': {
                    if (varCount < 3) {
                        arr[varCount++] = builder.toString();
                        builder.setLength(0);
                    }
                    if (squareBrackets != 1 || arr[0] == null) continue block6;
                    refs.add(new Ref(arr[0].toString()));
                    varCount = 0;
                    arr[0] = null;
                    continue block6;
                }
                case ' ': 
                case '\'': {
                    continue block6;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
    }

    public String toString() {
        if (this.mId == null || this.mId.length() == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        boolean isArray = false;
        if (!(Float.isNaN(this.mWeight) && Float.isNaN(this.mPreMargin) && Float.isNaN(this.mPostMargin))) {
            isArray = true;
        }
        if (isArray) {
            ret.append("[");
        }
        ret.append("'").append(this.mId).append("'");
        if (!Float.isNaN(this.mPostMargin)) {
            ret.append(",").append(!Float.isNaN(this.mWeight) ? this.mWeight : 0.0f).append(",");
            ret.append(!Float.isNaN(this.mPreMargin) ? this.mPreMargin : 0.0f).append(",");
            ret.append(this.mPostMargin);
        } else if (!Float.isNaN(this.mPreMargin)) {
            ret.append(",").append(!Float.isNaN(this.mWeight) ? this.mWeight : 0.0f).append(",");
            ret.append(this.mPreMargin);
        } else if (!Float.isNaN(this.mWeight)) {
            ret.append(",").append(this.mWeight);
        }
        if (isArray) {
            ret.append("]");
        }
        ret.append(",");
        return ret.toString();
    }
}

