/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.core.widgets.analyzer;

import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.analyzer.ChainRun;
import androidx.constraintlayout.core.widgets.analyzer.Dependency;
import androidx.constraintlayout.core.widgets.analyzer.DependencyNode;
import androidx.constraintlayout.core.widgets.analyzer.HelperReferences;
import androidx.constraintlayout.core.widgets.analyzer.HorizontalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.VerticalWidgetRun;
import androidx.constraintlayout.core.widgets.analyzer.WidgetRun;
import java.util.ArrayList;

class RunGroup {
    public static final int START = 0;
    public static final int END = 1;
    public static final int BASELINE = 2;
    public static int index;
    public int position = 0;
    public boolean dual = false;
    WidgetRun mFirstRun = null;
    WidgetRun mLastRun = null;
    ArrayList<WidgetRun> mRuns = new ArrayList();
    int mGroupIndex = index++;
    int mDirection;

    RunGroup(WidgetRun run, int dir) {
        this.mFirstRun = run;
        this.mLastRun = run;
        this.mDirection = dir;
    }

    public void add(WidgetRun run) {
        this.mRuns.add(run);
        this.mLastRun = run;
    }

    private long traverseStart(DependencyNode node, long startPosition) {
        WidgetRun run = node.mRun;
        if (run instanceof HelperReferences) {
            return startPosition;
        }
        long position = startPosition;
        int count = node.mDependencies.size();
        for (int i = 0; i < count; ++i) {
            Dependency dependency = node.mDependencies.get(i);
            if (!(dependency instanceof DependencyNode)) continue;
            DependencyNode nextNode = (DependencyNode)dependency;
            if (nextNode.mRun == run) continue;
            position = Math.max(position, this.traverseStart(nextNode, startPosition + (long)nextNode.mMargin));
        }
        if (node == run.start) {
            long dimension = run.getWrapDimension();
            position = Math.max(position, this.traverseStart(run.end, startPosition + dimension));
            position = Math.max(position, startPosition + dimension - (long)run.end.mMargin);
        }
        return position;
    }

    private long traverseEnd(DependencyNode node, long startPosition) {
        WidgetRun run = node.mRun;
        if (run instanceof HelperReferences) {
            return startPosition;
        }
        long position = startPosition;
        int count = node.mDependencies.size();
        for (int i = 0; i < count; ++i) {
            Dependency dependency = node.mDependencies.get(i);
            if (!(dependency instanceof DependencyNode)) continue;
            DependencyNode nextNode = (DependencyNode)dependency;
            if (nextNode.mRun == run) continue;
            position = Math.min(position, this.traverseEnd(nextNode, startPosition + (long)nextNode.mMargin));
        }
        if (node == run.end) {
            long dimension = run.getWrapDimension();
            position = Math.min(position, this.traverseEnd(run.start, startPosition - dimension));
            position = Math.min(position, startPosition - dimension - (long)run.start.mMargin);
        }
        return position;
    }

    public long computeWrapSize(ConstraintWidgetContainer container, int orientation) {
        if (this.mFirstRun instanceof ChainRun) {
            ChainRun chainRun = (ChainRun)this.mFirstRun;
            if (chainRun.orientation != orientation) {
                return 0L;
            }
        } else if (orientation == 0 ? !(this.mFirstRun instanceof HorizontalWidgetRun) : !(this.mFirstRun instanceof VerticalWidgetRun)) {
            return 0L;
        }
        DependencyNode containerStart = orientation == 0 ? container.mHorizontalRun.start : container.mVerticalRun.start;
        DependencyNode containerEnd = orientation == 0 ? container.mHorizontalRun.end : container.mVerticalRun.end;
        boolean runWithStartTarget = this.mFirstRun.start.mTargets.contains(containerStart);
        boolean runWithEndTarget = this.mFirstRun.end.mTargets.contains(containerEnd);
        long dimension = this.mFirstRun.getWrapDimension();
        if (runWithStartTarget && runWithEndTarget) {
            long startGap;
            long maxPosition = this.traverseStart(this.mFirstRun.start, 0L);
            long minPosition = this.traverseEnd(this.mFirstRun.end, 0L);
            long endGap = maxPosition - dimension;
            if (endGap >= (long)(-this.mFirstRun.end.mMargin)) {
                endGap += (long)this.mFirstRun.end.mMargin;
            }
            if ((startGap = -minPosition - dimension - (long)this.mFirstRun.start.mMargin) >= (long)this.mFirstRun.start.mMargin) {
                startGap -= (long)this.mFirstRun.start.mMargin;
            }
            float bias = this.mFirstRun.mWidget.getBiasPercent(orientation);
            long gap = 0L;
            if (bias > 0.0f) {
                gap = (long)((float)startGap / bias + (float)endGap / (1.0f - bias));
            }
            startGap = (long)(0.5f + (float)gap * bias);
            endGap = (long)(0.5f + (float)gap * (1.0f - bias));
            long runDimension = startGap + dimension + endGap;
            dimension = (long)this.mFirstRun.start.mMargin + runDimension - (long)this.mFirstRun.end.mMargin;
        } else if (runWithStartTarget) {
            long maxPosition = this.traverseStart(this.mFirstRun.start, this.mFirstRun.start.mMargin);
            long runDimension = (long)this.mFirstRun.start.mMargin + dimension;
            dimension = Math.max(maxPosition, runDimension);
        } else if (runWithEndTarget) {
            long minPosition = this.traverseEnd(this.mFirstRun.end, this.mFirstRun.end.mMargin);
            long runDimension = (long)(-this.mFirstRun.end.mMargin) + dimension;
            dimension = Math.max(-minPosition, runDimension);
        } else {
            dimension = (long)this.mFirstRun.start.mMargin + this.mFirstRun.getWrapDimension() - (long)this.mFirstRun.end.mMargin;
        }
        return dimension;
    }

    private boolean defineTerminalWidget(WidgetRun run, int orientation) {
        ChainRun chainRun;
        DependencyNode node;
        if (!run.mWidget.isTerminalWidget[orientation]) {
            return false;
        }
        for (Dependency dependency : run.start.mDependencies) {
            if (!(dependency instanceof DependencyNode)) continue;
            node = (DependencyNode)dependency;
            if (node.mRun == run || node != node.mRun.start) continue;
            if (run instanceof ChainRun) {
                chainRun = (ChainRun)run;
                for (WidgetRun widgetChainRun : chainRun.mWidgets) {
                    this.defineTerminalWidget(widgetChainRun, orientation);
                }
            } else if (!(run instanceof HelperReferences)) {
                run.mWidget.isTerminalWidget[orientation] = false;
            }
            this.defineTerminalWidget(node.mRun, orientation);
        }
        for (Dependency dependency : run.end.mDependencies) {
            if (!(dependency instanceof DependencyNode)) continue;
            node = (DependencyNode)dependency;
            if (node.mRun == run || node != node.mRun.start) continue;
            if (run instanceof ChainRun) {
                chainRun = (ChainRun)run;
                for (WidgetRun widgetChainRun : chainRun.mWidgets) {
                    this.defineTerminalWidget(widgetChainRun, orientation);
                }
            } else if (!(run instanceof HelperReferences)) {
                run.mWidget.isTerminalWidget[orientation] = false;
            }
            this.defineTerminalWidget(node.mRun, orientation);
        }
        return false;
    }

    public void defineTerminalWidgets(boolean horizontalCheck, boolean verticalCheck) {
        if (horizontalCheck && this.mFirstRun instanceof HorizontalWidgetRun) {
            this.defineTerminalWidget(this.mFirstRun, 0);
        }
        if (verticalCheck && this.mFirstRun instanceof VerticalWidgetRun) {
            this.defineTerminalWidget(this.mFirstRun, 1);
        }
    }
}

