/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.animation.ValueAnimator;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.Choreographer;
import androidx.annotation.RequiresApi;
import androidx.core.animation.Animator;
import androidx.core.animation.ObjectAnimator;
import java.util.ArrayList;

class AnimationHandler {
    public static final ThreadLocal<AnimationHandler> sAnimationHandler = new ThreadLocal();
    private static AnimationHandler sTestHandler = null;
    private final AnimationFrameCallbackProvider mProvider;
    private final ArrayList<AnimationFrameCallback> mAnimationCallbacks = new ArrayList();
    boolean mListDirty = false;

    void onAnimationFrame(long frameTime) {
        this.doAnimationFrame(frameTime);
        if (this.mAnimationCallbacks.size() > 0) {
            this.mProvider.postFrameCallback();
        }
    }

    AnimationHandler(AnimationFrameCallbackProvider provider) {
        this.mProvider = provider == null ? (Build.VERSION.SDK_INT >= 16 ? new FrameCallbackProvider16() : new FrameCallbackProvider14(this)) : provider;
    }

    public static AnimationHandler getInstance() {
        if (sTestHandler != null) {
            return sTestHandler;
        }
        if (sAnimationHandler.get() == null) {
            sAnimationHandler.set(new AnimationHandler(null));
        }
        return sAnimationHandler.get();
    }

    static void setTestHandler(AnimationHandler handler) {
        sTestHandler = handler;
    }

    void setFrameDelay(long frameDelay) {
        this.mProvider.setFrameDelay(frameDelay);
    }

    long getFrameDelay() {
        return this.mProvider.getFrameDelay();
    }

    void addAnimationFrameCallback(AnimationFrameCallback callback) {
        if (this.mAnimationCallbacks.size() == 0) {
            this.mProvider.postFrameCallback();
        }
        if (!this.mAnimationCallbacks.contains(callback)) {
            this.mAnimationCallbacks.add(callback);
        }
        this.mProvider.onNewCallbackAdded(callback);
    }

    public void removeCallback(AnimationFrameCallback callback) {
        int id = this.mAnimationCallbacks.indexOf(callback);
        if (id >= 0) {
            this.mAnimationCallbacks.set(id, null);
            this.mListDirty = true;
        }
    }

    void autoCancelBasedOn(ObjectAnimator objectAnimator) {
        for (int i = this.mAnimationCallbacks.size() - 1; i >= 0; --i) {
            AnimationFrameCallback cb = this.mAnimationCallbacks.get(i);
            if (cb == null || !objectAnimator.shouldAutoCancel(cb)) continue;
            ((Animator)((Object)this.mAnimationCallbacks.get(i))).cancel();
        }
    }

    private void doAnimationFrame(long frameTime) {
        for (int i = 0; i < this.mAnimationCallbacks.size(); ++i) {
            AnimationFrameCallback callback = this.mAnimationCallbacks.get(i);
            if (callback == null) continue;
            callback.doAnimationFrame(frameTime);
        }
        this.cleanUpList();
    }

    private void cleanUpList() {
        if (this.mListDirty) {
            for (int i = this.mAnimationCallbacks.size() - 1; i >= 0; --i) {
                if (this.mAnimationCallbacks.get(i) != null) continue;
                this.mAnimationCallbacks.remove(i);
            }
            this.mListDirty = false;
        }
    }

    private int getCallbackSize() {
        int count = 0;
        int size = this.mAnimationCallbacks.size();
        for (int i = size - 1; i >= 0; --i) {
            if (this.mAnimationCallbacks.get(i) == null) continue;
            ++count;
        }
        return count;
    }

    public static int getAnimationCount() {
        AnimationHandler handler = AnimationHandler.getInstance();
        if (handler == null) {
            return 0;
        }
        return handler.getCallbackSize();
    }

    static interface AnimationFrameCallbackProvider {
        public void onNewCallbackAdded(AnimationFrameCallback var1);

        public void postFrameCallback();

        public void setFrameDelay(long var1);

        public long getFrameDelay();
    }

    @RequiresApi(value=16)
    private class FrameCallbackProvider16
    implements AnimationFrameCallbackProvider,
    Choreographer.FrameCallback {
        FrameCallbackProvider16() {
        }

        public void doFrame(long frameTimeNanos) {
            AnimationHandler.this.onAnimationFrame(frameTimeNanos / 1000000L);
        }

        @Override
        public void onNewCallbackAdded(AnimationFrameCallback callback) {
        }

        @Override
        public void postFrameCallback() {
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
        }

        @Override
        public void setFrameDelay(long delay) {
            ValueAnimator.setFrameDelay((long)delay);
        }

        @Override
        public long getFrameDelay() {
            return ValueAnimator.getFrameDelay();
        }
    }

    private static class FrameCallbackProvider14
    implements AnimationFrameCallbackProvider,
    Runnable {
        private static final ThreadLocal<Handler> sHandler = new ThreadLocal();
        private long mLastFrameTime = -1L;
        private long mFrameDelay = 16L;
        AnimationHandler mAnimationHandler;

        FrameCallbackProvider14(AnimationHandler animationHandler) {
            this.mAnimationHandler = animationHandler;
        }

        Handler getHandler() {
            if (sHandler.get() == null) {
                sHandler.set(new Handler(Looper.myLooper()));
            }
            return sHandler.get();
        }

        @Override
        public void run() {
            this.mLastFrameTime = SystemClock.uptimeMillis();
            this.mAnimationHandler.onAnimationFrame(this.mLastFrameTime);
        }

        @Override
        public void onNewCallbackAdded(AnimationFrameCallback callback) {
        }

        @Override
        public void postFrameCallback() {
            long delay = this.mFrameDelay - (SystemClock.uptimeMillis() - this.mLastFrameTime);
            delay = Math.max(delay, 0L);
            this.getHandler().postDelayed((Runnable)this, delay);
        }

        @Override
        public void setFrameDelay(long delay) {
            this.mFrameDelay = delay > 0L ? delay : 0L;
        }

        @Override
        public long getFrameDelay() {
            return this.mFrameDelay;
        }
    }

    static interface AnimationFrameCallback {
        public boolean doAnimationFrame(long var1);
    }
}

