/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.annotation.SuppressLint;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.animation.AnimationHandler;
import androidx.core.animation.Interpolator;
import java.util.ArrayList;

public abstract class Animator
implements Cloneable {
    public static final long DURATION_INFINITE = -1L;
    ArrayList<AnimatorListener> mListeners = null;
    ArrayList<AnimatorPauseListener> mPauseListeners = null;
    ArrayList<AnimatorUpdateListener> mUpdateListeners = null;
    boolean mPaused = false;

    public void start() {
    }

    public void cancel() {
    }

    public void end() {
    }

    public void pause() {
        if (this.isStarted() && !this.mPaused) {
            Object clone;
            this.mPaused = true;
            if (this.mPauseListeners != null && (clone = this.mPauseListeners.clone()) instanceof ArrayList) {
                ArrayList tmpListeners = (ArrayList)clone;
                int numListeners = tmpListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((AnimatorPauseListener)tmpListeners.get(i)).onAnimationPause(this);
                }
            }
        }
    }

    public void resume() {
        if (this.mPaused) {
            Object clone;
            this.mPaused = false;
            if (this.mPauseListeners != null && (clone = this.mPauseListeners.clone()) instanceof ArrayList) {
                ArrayList tmpListeners = (ArrayList)clone;
                int numListeners = tmpListeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    ((AnimatorPauseListener)tmpListeners.get(i)).onAnimationResume(this);
                }
            }
        }
    }

    public boolean isPaused() {
        return this.mPaused;
    }

    public abstract long getStartDelay();

    public abstract void setStartDelay(@IntRange(from=0L) long var1);

    @NonNull
    public abstract Animator setDuration(@IntRange(from=0L) long var1);

    public abstract long getDuration();

    public long getTotalDuration() {
        long duration = this.getDuration();
        if (duration == -1L) {
            return -1L;
        }
        return this.getStartDelay() + duration;
    }

    public abstract void setInterpolator(@Nullable Interpolator var1);

    @Nullable
    public Interpolator getInterpolator() {
        return null;
    }

    public abstract boolean isRunning();

    public boolean isStarted() {
        return this.isRunning();
    }

    public void addListener(@NonNull AnimatorListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(listener);
    }

    public void removeListener(@NonNull AnimatorListener listener) {
        if (this.mListeners == null) {
            return;
        }
        this.mListeners.remove(listener);
        if (this.mListeners.size() == 0) {
            this.mListeners = null;
        }
    }

    @Nullable
    ArrayList<AnimatorListener> getListeners() {
        return this.mListeners;
    }

    public void addUpdateListener(@NonNull AnimatorUpdateListener listener) {
        if (this.mUpdateListeners == null) {
            this.mUpdateListeners = new ArrayList();
        }
        this.mUpdateListeners.add(listener);
    }

    public void removeAllUpdateListeners() {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.clear();
        this.mUpdateListeners = null;
    }

    public void removeUpdateListener(@NonNull AnimatorUpdateListener listener) {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.remove(listener);
        if (this.mUpdateListeners.size() == 0) {
            this.mUpdateListeners = null;
        }
    }

    public void addPauseListener(@NonNull AnimatorPauseListener listener) {
        if (this.mPauseListeners == null) {
            this.mPauseListeners = new ArrayList();
        }
        this.mPauseListeners.add(listener);
    }

    public void removePauseListener(@NonNull AnimatorPauseListener listener) {
        if (this.mPauseListeners == null) {
            return;
        }
        this.mPauseListeners.remove(listener);
        if (this.mPauseListeners.size() == 0) {
            this.mPauseListeners = null;
        }
    }

    public void removeAllListeners() {
        if (this.mListeners != null) {
            this.mListeners.clear();
            this.mListeners = null;
        }
        if (this.mPauseListeners != null) {
            this.mPauseListeners.clear();
            this.mPauseListeners = null;
        }
    }

    @SuppressLint(value={"NoClone"})
    @NonNull
    public Animator clone() {
        try {
            Animator anim = (Animator)super.clone();
            if (this.mListeners != null) {
                anim.mListeners = new ArrayList<AnimatorListener>(this.mListeners);
            }
            if (this.mPauseListeners != null) {
                anim.mPauseListeners = new ArrayList<AnimatorPauseListener>(this.mPauseListeners);
            }
            return anim;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    static void addAnimationCallback(AnimationHandler.AnimationFrameCallback callback) {
        AnimationHandler handler = AnimationHandler.getInstance();
        handler.addAnimationFrameCallback(callback);
    }

    static void removeAnimationCallback(AnimationHandler.AnimationFrameCallback callback) {
        AnimationHandler handler = AnimationHandler.getInstance();
        handler.removeCallback(callback);
    }

    public void setupStartValues() {
    }

    public void setupEndValues() {
    }

    public void setTarget(@Nullable Object target) {
    }

    boolean canReverse() {
        return false;
    }

    void reverse() {
        throw new IllegalStateException("Reverse is not supported");
    }

    boolean pulseAnimationFrame(long frameTime) {
        return false;
    }

    void startWithoutPulsing(boolean inReverse) {
        if (inReverse) {
            this.reverse();
        } else {
            this.start();
        }
    }

    void skipToEndValue(boolean inReverse) {
    }

    boolean isInitialized() {
        return true;
    }

    void animateBasedOnPlayTime(long currentPlayTime, long lastPlayTime, boolean inReverse) {
    }

    public static interface AnimatorPauseListener {
        public void onAnimationPause(@NonNull Animator var1);

        public void onAnimationResume(@NonNull Animator var1);
    }

    public static interface AnimatorUpdateListener {
        public void onAnimationUpdate(@NonNull Animator var1);
    }

    public static interface AnimatorListener {
        default public void onAnimationStart(@NonNull Animator animation, boolean isReverse) {
            this.onAnimationStart(animation);
        }

        default public void onAnimationEnd(@NonNull Animator animation, boolean isReverse) {
            this.onAnimationEnd(animation);
        }

        public void onAnimationStart(@NonNull Animator var1);

        public void onAnimationEnd(@NonNull Animator var1);

        public void onAnimationCancel(@NonNull Animator var1);

        public void onAnimationRepeat(@NonNull Animator var1);
    }
}

