/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Path;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.util.Xml;
import android.view.InflateException;
import androidx.annotation.AnimatorRes;
import androidx.annotation.InterpolatorRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.animation.AccelerateDecelerateInterpolator;
import androidx.core.animation.AccelerateInterpolator;
import androidx.core.animation.AndroidResources;
import androidx.core.animation.Animator;
import androidx.core.animation.AnimatorSet;
import androidx.core.animation.AnticipateInterpolator;
import androidx.core.animation.AnticipateOvershootInterpolator;
import androidx.core.animation.ArgbEvaluator;
import androidx.core.animation.BounceInterpolator;
import androidx.core.animation.CycleInterpolator;
import androidx.core.animation.DecelerateInterpolator;
import androidx.core.animation.Interpolator;
import androidx.core.animation.Keyframe;
import androidx.core.animation.KeyframeSet;
import androidx.core.animation.Keyframes;
import androidx.core.animation.LinearInterpolator;
import androidx.core.animation.ObjectAnimator;
import androidx.core.animation.OvershootInterpolator;
import androidx.core.animation.PathInterpolator;
import androidx.core.animation.PathKeyframes;
import androidx.core.animation.PropertyValuesHolder;
import androidx.core.animation.TypeEvaluator;
import androidx.core.animation.ValueAnimator;
import androidx.core.graphics.PathParser;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatorInflater {
    private static final String TAG = "AnimatorInflater";
    private static final int TOGETHER = 0;
    private static final int SEQUENTIALLY = 1;
    private static final int VALUE_TYPE_FLOAT = 0;
    private static final int VALUE_TYPE_INT = 1;
    private static final int VALUE_TYPE_PATH = 2;
    private static final int VALUE_TYPE_COLOR = 3;
    private static final int VALUE_TYPE_UNDEFINED = 4;

    private AnimatorInflater() {
    }

    @NonNull
    public static Animator loadAnimator(@NonNull Context context, @AnimatorRes int id) throws Resources.NotFoundException {
        return AnimatorInflater.loadAnimator(context.getResources(), context.getTheme(), id);
    }

    @NonNull
    public static Animator loadAnimator(@NonNull Resources resources, @Nullable Resources.Theme theme, @AnimatorRes int id) throws Resources.NotFoundException {
        return AnimatorInflater.loadAnimator(resources, theme, id, 1.0f);
    }

    static Animator loadAnimator(Resources resources, Resources.Theme theme, int id, float pathErrorScale) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            Animator animator;
            parser = resources.getAnimation(id);
            Animator animator2 = animator = AnimatorInflater.createAnimatorFromXml(resources, theme, (XmlPullParser)parser, pathErrorScale);
            return animator2;
        }
    }

    private static PropertyValuesHolder getPVH(TypedArray styledAttributes, int valueType, int valueFromId, int valueToId, String propertyName) {
        int toType;
        TypedValue tvFrom = styledAttributes.peekValue(valueFromId);
        boolean hasFrom = tvFrom != null;
        int fromType = hasFrom ? tvFrom.type : 0;
        TypedValue tvTo = styledAttributes.peekValue(valueToId);
        boolean hasTo = tvTo != null;
        int n = toType = hasTo ? tvTo.type : 0;
        if (valueType == 4) {
            valueType = hasFrom && AnimatorInflater.isColorType(fromType) || hasTo && AnimatorInflater.isColorType(toType) ? 3 : 0;
        }
        boolean getFloats = valueType == 0;
        PropertyValuesHolder returnValue = null;
        if (valueType == 2) {
            PathParser.PathDataNode[] nodesTo;
            String fromString = styledAttributes.getString(valueFromId);
            String toString = styledAttributes.getString(valueToId);
            PathParser.PathDataNode[] nodesFrom = fromString == null ? null : PathParser.createNodesFromPathData((String)fromString);
            PathParser.PathDataNode[] pathDataNodeArray = nodesTo = toString == null ? null : PathParser.createNodesFromPathData((String)toString);
            if (nodesFrom != null || nodesTo != null) {
                if (nodesFrom != null) {
                    PathDataEvaluator evaluator = new PathDataEvaluator();
                    if (nodesTo != null) {
                        if (!PathParser.canMorph((PathParser.PathDataNode[])nodesFrom, (PathParser.PathDataNode[])nodesTo)) {
                            throw new InflateException(" Can't morph from " + fromString + " to " + toString);
                        }
                        returnValue = PropertyValuesHolder.ofObject(propertyName, (TypeEvaluator)evaluator, nodesFrom, nodesTo);
                    } else {
                        returnValue = PropertyValuesHolder.ofObject(propertyName, (TypeEvaluator)evaluator, new Object[]{nodesFrom});
                    }
                } else if (nodesTo != null) {
                    PathDataEvaluator evaluator = new PathDataEvaluator();
                    returnValue = PropertyValuesHolder.ofObject(propertyName, (TypeEvaluator)evaluator, new Object[]{nodesTo});
                }
            }
        } else {
            ArgbEvaluator evaluator = null;
            if (valueType == 3) {
                evaluator = ArgbEvaluator.getInstance();
            }
            if (getFloats) {
                if (hasFrom) {
                    float valueFrom = fromType == 5 ? styledAttributes.getDimension(valueFromId, 0.0f) : styledAttributes.getFloat(valueFromId, 0.0f);
                    if (hasTo) {
                        float valueTo = toType == 5 ? styledAttributes.getDimension(valueToId, 0.0f) : styledAttributes.getFloat(valueToId, 0.0f);
                        returnValue = PropertyValuesHolder.ofFloat(propertyName, valueFrom, valueTo);
                    } else {
                        returnValue = PropertyValuesHolder.ofFloat(propertyName, valueFrom);
                    }
                } else {
                    float valueTo = toType == 5 ? styledAttributes.getDimension(valueToId, 0.0f) : styledAttributes.getFloat(valueToId, 0.0f);
                    returnValue = PropertyValuesHolder.ofFloat(propertyName, valueTo);
                }
            } else if (hasFrom) {
                int valueFrom = fromType == 5 ? (int)styledAttributes.getDimension(valueFromId, 0.0f) : (AnimatorInflater.isColorType(fromType) ? styledAttributes.getColor(valueFromId, 0) : styledAttributes.getInt(valueFromId, 0));
                if (hasTo) {
                    int valueTo = toType == 5 ? (int)styledAttributes.getDimension(valueToId, 0.0f) : (AnimatorInflater.isColorType(toType) ? styledAttributes.getColor(valueToId, 0) : styledAttributes.getInt(valueToId, 0));
                    returnValue = PropertyValuesHolder.ofInt(propertyName, valueFrom, valueTo);
                } else {
                    returnValue = PropertyValuesHolder.ofInt(propertyName, valueFrom);
                }
            } else if (hasTo) {
                int valueTo = toType == 5 ? (int)styledAttributes.getDimension(valueToId, 0.0f) : (AnimatorInflater.isColorType(toType) ? styledAttributes.getColor(valueToId, 0) : styledAttributes.getInt(valueToId, 0));
                returnValue = PropertyValuesHolder.ofInt(propertyName, valueTo);
            }
            if (returnValue != null && evaluator != null) {
                returnValue.setEvaluator(evaluator);
            }
        }
        return returnValue;
    }

    private static void parseAnimatorFromTypeArray(ValueAnimator anim, TypedArray arrayAnimator, TypedArray arrayObjectAnimator, float pixelSize) {
        PropertyValuesHolder pvh;
        long duration = arrayAnimator.getInt(1, 300);
        long startDelay = arrayAnimator.getInt(2, 0);
        int valueType = arrayAnimator.getInt(7, 4);
        if (valueType == 4) {
            valueType = AnimatorInflater.inferValueTypeFromValues(arrayAnimator, 5, 6);
        }
        if ((pvh = AnimatorInflater.getPVH(arrayAnimator, valueType, 5, 6, "")) != null) {
            anim.setValues(pvh);
        }
        anim.setDuration(duration);
        anim.setStartDelay(startDelay);
        if (arrayAnimator.hasValue(3)) {
            anim.setRepeatCount(arrayAnimator.getInt(3, 0));
        }
        if (arrayAnimator.hasValue(4)) {
            anim.setRepeatMode(arrayAnimator.getInt(4, 1));
        }
        if (arrayObjectAnimator != null) {
            AnimatorInflater.setupObjectAnimator(anim, arrayObjectAnimator, valueType, pixelSize);
        }
    }

    private static void setupObjectAnimator(ValueAnimator anim, TypedArray arrayObjectAnimator, int valueType, float pixelSize) {
        ObjectAnimator oa = (ObjectAnimator)anim;
        String pathData = null;
        TypedValue typedValue = new TypedValue();
        arrayObjectAnimator.getValue(1, typedValue);
        if (typedValue.type == 3) {
            pathData = typedValue.string.toString();
        }
        if (pathData != null) {
            Keyframes<Float> yKeyframes;
            Keyframes<Float> xKeyframes;
            String propertyXName = arrayObjectAnimator.getString(2);
            String propertyYName = arrayObjectAnimator.getString(3);
            if (valueType == 2 || valueType == 4) {
                valueType = 0;
            }
            if (propertyXName == null && propertyYName == null) {
                throw new InflateException(arrayObjectAnimator.getPositionDescription() + " propertyXName or propertyYName is needed for PathData");
            }
            Path path = PathParser.createPathFromPathData((String)pathData);
            float error = 0.5f * pixelSize;
            PathKeyframes keyframeSet = KeyframeSet.ofPath(path, error);
            if (valueType == 0) {
                xKeyframes = keyframeSet.createXFloatKeyframes();
                yKeyframes = keyframeSet.createYFloatKeyframes();
            } else {
                xKeyframes = keyframeSet.createXIntKeyframes();
                yKeyframes = keyframeSet.createYIntKeyframes();
            }
            PropertyValuesHolder x = null;
            PropertyValuesHolder y = null;
            if (propertyXName != null) {
                x = PropertyValuesHolder.ofKeyframes(propertyXName, (Keyframes)xKeyframes);
            }
            if (propertyYName != null) {
                y = PropertyValuesHolder.ofKeyframes(propertyYName, (Keyframes)yKeyframes);
            }
            if (x == null) {
                oa.setValues(y);
            } else if (y == null) {
                oa.setValues(x);
            } else {
                oa.setValues(x, y);
            }
        } else {
            String propertyName = arrayObjectAnimator.getString(0);
            oa.setPropertyName(propertyName);
        }
    }

    private static Animator createAnimatorFromXml(Resources res, Resources.Theme theme, XmlPullParser parser, float pixelSize) throws XmlPullParserException, IOException {
        return AnimatorInflater.createAnimatorFromXml(res, theme, parser, Xml.asAttributeSet((XmlPullParser)parser), null, 0, pixelSize);
    }

    private static Animator createAnimatorFromXml(Resources res, Resources.Theme theme, XmlPullParser parser, AttributeSet attrs, AnimatorSet parent, int sequenceOrdering, float pixelSize) throws XmlPullParserException, IOException {
        int type;
        Animator anim = null;
        ArrayList<ObjectAnimator> childAnims = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            boolean gotValues = false;
            if (name.equals("objectAnimator")) {
                anim = AnimatorInflater.loadObjectAnimator(res, theme, attrs, pixelSize);
            } else if (name.equals("animator")) {
                anim = AnimatorInflater.loadAnimator(res, theme, attrs, null, pixelSize);
            } else if (name.equals("set")) {
                anim = new AnimatorSet();
                TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, AndroidResources.STYLEABLE_ANIMATOR_SET, 0, 0) : res.obtainAttributes(attrs, AndroidResources.STYLEABLE_ANIMATOR_SET);
                int n = a.getInt(0, 0);
                AnimatorInflater.createAnimatorFromXml(res, theme, parser, attrs, (AnimatorSet)anim, n, pixelSize);
                a.recycle();
            } else if (name.equals("propertyValuesHolder")) {
                PropertyValuesHolder[] values = AnimatorInflater.loadValues(res, theme, parser, Xml.asAttributeSet((XmlPullParser)parser));
                if (values != null && anim != null && anim instanceof ValueAnimator) {
                    ((ValueAnimator)anim).setValues(values);
                }
                gotValues = true;
            } else {
                throw new RuntimeException("Unknown animator name: " + parser.getName());
            }
            if (parent == null || gotValues) continue;
            if (childAnims == null) {
                childAnims = new ArrayList<ObjectAnimator>();
            }
            childAnims.add((ObjectAnimator)anim);
        }
        if (parent != null && childAnims != null) {
            Animator[] animsArray = new Animator[childAnims.size()];
            int index = 0;
            for (Animator animator : childAnims) {
                animsArray[index++] = animator;
            }
            if (sequenceOrdering == 0) {
                parent.playTogether(animsArray);
            } else {
                parent.playSequentially(animsArray);
            }
        }
        return anim;
    }

    private static PropertyValuesHolder[] loadValues(Resources res, Resources.Theme theme, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        ArrayList<PropertyValuesHolder> values = null;
        while ((type = parser.getEventType()) != 3 && type != 1) {
            if (type != 2) {
                parser.next();
                continue;
            }
            String name = parser.getName();
            if (name.equals("propertyValuesHolder")) {
                int valueType;
                TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, AndroidResources.STYLEABLE_PROPERTY_VALUES_HOLDER, 0, 0) : res.obtainAttributes(attrs, AndroidResources.STYLEABLE_PROPERTY_VALUES_HOLDER);
                String propertyName = a.getString(3);
                PropertyValuesHolder pvh = AnimatorInflater.loadPvh(res, theme, parser, propertyName, valueType = a.getInt(2, 4));
                if (pvh == null) {
                    pvh = AnimatorInflater.getPVH(a, valueType, 0, 1, propertyName);
                }
                if (pvh != null) {
                    if (values == null) {
                        values = new ArrayList<PropertyValuesHolder>();
                    }
                    values.add(pvh);
                }
                a.recycle();
            }
            parser.next();
        }
        PropertyValuesHolder[] valuesArray = null;
        if (values != null) {
            int count = values.size();
            valuesArray = new PropertyValuesHolder[count];
            for (int i = 0; i < count; ++i) {
                valuesArray[i] = (PropertyValuesHolder)values.get(i);
            }
        }
        return valuesArray;
    }

    private static int inferValueTypeOfKeyframe(Resources res, Resources.Theme theme, AttributeSet attrs) {
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, AndroidResources.STYLEABLE_KEYFRAME, 0, 0) : res.obtainAttributes(attrs, AndroidResources.STYLEABLE_KEYFRAME);
        TypedValue keyframeValue = a.peekValue(0);
        boolean hasValue = keyframeValue != null;
        int valueType = hasValue && AnimatorInflater.isColorType(keyframeValue.type) ? 3 : 0;
        a.recycle();
        return valueType;
    }

    private static int inferValueTypeFromValues(TypedArray styledAttributes, int valueFromId, int valueToId) {
        TypedValue tvFrom = styledAttributes.peekValue(valueFromId);
        boolean hasFrom = tvFrom != null;
        int fromType = hasFrom ? tvFrom.type : 0;
        TypedValue tvTo = styledAttributes.peekValue(valueToId);
        boolean hasTo = tvTo != null;
        int toType = hasTo ? tvTo.type : 0;
        int valueType = hasFrom && AnimatorInflater.isColorType(fromType) || hasTo && AnimatorInflater.isColorType(toType) ? 3 : 0;
        return valueType;
    }

    private static PropertyValuesHolder loadPvh(Resources res, Resources.Theme theme, XmlPullParser parser, String propertyName, int valueType) throws XmlPullParserException, IOException {
        int count;
        int type;
        PropertyValuesHolder value = null;
        ArrayList<Keyframe> keyframes = null;
        while ((type = parser.next()) != 3 && type != 1) {
            Keyframe keyframe;
            String name = parser.getName();
            if (!name.equals("keyframe")) continue;
            if (valueType == 4) {
                valueType = AnimatorInflater.inferValueTypeOfKeyframe(res, theme, Xml.asAttributeSet((XmlPullParser)parser));
            }
            if ((keyframe = AnimatorInflater.loadKeyframe(res, theme, Xml.asAttributeSet((XmlPullParser)parser), valueType)) != null) {
                if (keyframes == null) {
                    keyframes = new ArrayList<Keyframe>();
                }
                keyframes.add(keyframe);
            }
            parser.next();
        }
        if (keyframes != null && (count = keyframes.size()) > 0) {
            float startFraction;
            Keyframe firstKeyframe = (Keyframe)keyframes.get(0);
            Keyframe lastKeyframe = (Keyframe)keyframes.get(count - 1);
            float endFraction = lastKeyframe.getFraction();
            if (endFraction < 1.0f) {
                if (endFraction < 0.0f) {
                    lastKeyframe.setFraction(1.0f);
                } else {
                    keyframes.add(keyframes.size(), AnimatorInflater.createNewKeyframe(lastKeyframe, 1.0f));
                    ++count;
                }
            }
            if ((startFraction = firstKeyframe.getFraction()) != 0.0f) {
                if (startFraction < 0.0f) {
                    firstKeyframe.setFraction(0.0f);
                } else {
                    keyframes.add(0, AnimatorInflater.createNewKeyframe(firstKeyframe, 0.0f));
                    ++count;
                }
            }
            Keyframe[] keyframeArray = new Keyframe[count];
            keyframes.toArray(keyframeArray);
            for (int i = 0; i < count; ++i) {
                Keyframe keyframe = keyframeArray[i];
                if (!(keyframe.getFraction() < 0.0f)) continue;
                if (i == 0) {
                    keyframe.setFraction(0.0f);
                    continue;
                }
                if (i == count - 1) {
                    keyframe.setFraction(1.0f);
                    continue;
                }
                int startIndex = i;
                int endIndex = i;
                int j = startIndex + 1;
                while (j < count - 1 && !(keyframeArray[j].getFraction() >= 0.0f)) {
                    endIndex = j++;
                }
                float gap = keyframeArray[endIndex + 1].getFraction() - keyframeArray[startIndex - 1].getFraction();
                AnimatorInflater.distributeKeyframes(keyframeArray, gap, startIndex, endIndex);
            }
            value = PropertyValuesHolder.ofKeyframe(propertyName, keyframeArray);
            if (valueType == 3) {
                value.setEvaluator(ArgbEvaluator.getInstance());
            }
        }
        return value;
    }

    private static Keyframe createNewKeyframe(Keyframe sampleKeyframe, float fraction) {
        Class<?> type = sampleKeyframe.getType();
        if (type == Float.TYPE) {
            return Keyframe.ofFloat(fraction);
        }
        if (type == Integer.TYPE) {
            return Keyframe.ofInt(fraction);
        }
        return Keyframe.ofObject(fraction);
    }

    private static void distributeKeyframes(Keyframe[] keyframes, float gap, int startIndex, int endIndex) {
        int count = endIndex - startIndex + 2;
        float increment = gap / (float)count;
        for (int i = startIndex; i <= endIndex; ++i) {
            keyframes[i].setFraction(keyframes[i - 1].getFraction() + increment);
        }
    }

    private static Keyframe loadKeyframe(Resources res, Resources.Theme theme, AttributeSet attrs, int valueType) throws XmlPullParserException, IOException {
        boolean hasValue;
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, AndroidResources.STYLEABLE_KEYFRAME, 0, 0) : res.obtainAttributes(attrs, AndroidResources.STYLEABLE_KEYFRAME);
        Keyframe<Number> keyframe = null;
        float fraction = a.getFloat(3, -1.0f);
        TypedValue keyframeValue = a.peekValue(0);
        boolean bl = hasValue = keyframeValue != null;
        if (valueType == 4) {
            valueType = hasValue && AnimatorInflater.isColorType(keyframeValue.type) ? 3 : 0;
        }
        if (hasValue) {
            switch (valueType) {
                case 0: {
                    float value = a.getFloat(0, 0.0f);
                    keyframe = Keyframe.ofFloat(fraction, value);
                    break;
                }
                case 1: 
                case 3: {
                    int intValue = a.getInt(0, 0);
                    keyframe = Keyframe.ofInt(fraction, intValue);
                }
            }
        } else {
            keyframe = valueType == 0 ? Keyframe.ofFloat(fraction) : Keyframe.ofInt(fraction);
        }
        int resID = a.getResourceId(1, 0);
        if (resID > 0) {
            Interpolator interpolator = AnimatorInflater.loadInterpolator(res, theme, resID);
            keyframe.setInterpolator(interpolator);
        }
        a.recycle();
        return keyframe;
    }

    private static ObjectAnimator loadObjectAnimator(Resources res, Resources.Theme theme, AttributeSet attrs, float pathErrorScale) throws Resources.NotFoundException {
        ObjectAnimator anim = new ObjectAnimator();
        AnimatorInflater.loadAnimator(res, theme, attrs, anim, pathErrorScale);
        return anim;
    }

    private static ValueAnimator loadAnimator(Resources res, Resources.Theme theme, AttributeSet attrs, ValueAnimator anim, float pathErrorScale) throws Resources.NotFoundException {
        TypedArray arrayAnimator = null;
        TypedArray arrayObjectAnimator = null;
        arrayAnimator = theme != null ? theme.obtainStyledAttributes(attrs, AndroidResources.STYLEABLE_ANIMATOR, 0, 0) : res.obtainAttributes(attrs, AndroidResources.STYLEABLE_ANIMATOR);
        if (anim != null) {
            arrayObjectAnimator = theme != null ? theme.obtainStyledAttributes(attrs, AndroidResources.STYLEABLE_PROPERTY_ANIMATOR, 0, 0) : res.obtainAttributes(attrs, AndroidResources.STYLEABLE_PROPERTY_ANIMATOR);
        }
        if (anim == null) {
            anim = new ValueAnimator();
        }
        AnimatorInflater.parseAnimatorFromTypeArray(anim, arrayAnimator, arrayObjectAnimator, pathErrorScale);
        int resID = arrayAnimator.getResourceId(0, 0);
        if (resID > 0) {
            Interpolator interpolator = AnimatorInflater.loadInterpolator(res, theme, resID);
            anim.setInterpolator(interpolator);
        }
        arrayAnimator.recycle();
        if (arrayObjectAnimator != null) {
            arrayObjectAnimator.recycle();
        }
        return anim;
    }

    private static boolean isColorType(int type) {
        return type >= 28 && type <= 31;
    }

    @NonNull
    public static Interpolator loadInterpolator(@NonNull Context context, @AnimatorRes @InterpolatorRes int id) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            parser = context.getResources().getAnimation(id);
            Interpolator interpolator = AnimatorInflater.createInterpolatorFromXml(context.getResources(), context.getTheme(), (XmlPullParser)parser);
            return interpolator;
        }
    }

    static Interpolator loadInterpolator(Resources res, Resources.Theme theme, int id) throws Resources.NotFoundException {
        if (id == 17563663) {
            return new PathInterpolator(0.4f, 0.0f, 1.0f, 1.0f);
        }
        if (id == 17563661) {
            return new PathInterpolator(0.4f, 0.0f, 0.2f, 1.0f);
        }
        if (id == 17563662) {
            return new PathInterpolator(0.0f, 0.0f, 0.2f, 1.0f);
        }
        try (XmlResourceParser parser = null;){
            parser = res.getAnimation(id);
            Interpolator interpolator = AnimatorInflater.createInterpolatorFromXml(res, theme, (XmlPullParser)parser);
            return interpolator;
        }
    }

    private static Interpolator createInterpolatorFromXml(Resources res, Resources.Theme theme, XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        Interpolator interpolator = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            String name = parser.getName();
            if (name.equals("linearInterpolator")) {
                interpolator = new LinearInterpolator();
                continue;
            }
            if (name.equals("accelerateInterpolator")) {
                interpolator = new AccelerateInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("decelerateInterpolator")) {
                interpolator = new DecelerateInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("accelerateDecelerateInterpolator")) {
                interpolator = new AccelerateDecelerateInterpolator();
                continue;
            }
            if (name.equals("cycleInterpolator")) {
                interpolator = new CycleInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("anticipateInterpolator")) {
                interpolator = new AnticipateInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("overshootInterpolator")) {
                interpolator = new OvershootInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("anticipateOvershootInterpolator")) {
                interpolator = new AnticipateOvershootInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("bounceInterpolator")) {
                interpolator = new BounceInterpolator();
                continue;
            }
            if (name.equals("pathInterpolator")) {
                interpolator = new PathInterpolator(res, theme, attrs, parser);
                continue;
            }
            throw new RuntimeException("Unknown interpolator name: " + name);
        }
        return interpolator;
    }

    static class PathDataEvaluator
    implements TypeEvaluator<PathParser.PathDataNode[]> {
        private PathParser.PathDataNode[] mPathData;

        PathDataEvaluator() {
        }

        @Override
        @NonNull
        public PathParser.PathDataNode[] evaluate(float fraction, @NonNull PathParser.PathDataNode[] startPathData, @NonNull PathParser.PathDataNode[] endPathData) {
            if (this.mPathData == null) {
                this.mPathData = PathParser.deepCopyNodes((PathParser.PathDataNode[])endPathData);
            }
            if (!PathParser.interpolatePathDataNodes((PathParser.PathDataNode[])this.mPathData, (PathParser.PathDataNode[])startPathData, (PathParser.PathDataNode[])endPathData, (float)fraction)) {
                throw new IllegalArgumentException("Can't interpolate between two incompatible pathData");
            }
            return this.mPathData;
        }
    }
}

