/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.animation.AndroidResources;
import androidx.core.animation.Interpolator;

public class AnticipateInterpolator
implements Interpolator {
    private final float mTension;

    public AnticipateInterpolator() {
        this.mTension = 2.0f;
    }

    public AnticipateInterpolator(float tension) {
        this.mTension = tension;
    }

    public AnticipateInterpolator(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context.getResources(), context.getTheme(), attrs);
    }

    AnticipateInterpolator(Resources res, Resources.Theme theme, AttributeSet attrs) {
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, AndroidResources.STYLEABLE_ANTICIPATEOVERSHOOT_INTERPOLATOR, 0, 0) : res.obtainAttributes(attrs, AndroidResources.STYLEABLE_ANTICIPATEOVERSHOOT_INTERPOLATOR);
        this.mTension = a.getFloat(0, 2.0f);
        a.recycle();
    }

    @Override
    @FloatRange(to=1.0)
    public float getInterpolation(@FloatRange(from=0.0, to=1.0) float input) {
        return input * input * ((this.mTension + 1.0f) * input - this.mTension);
    }
}

