/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.animation.AndroidResources;
import androidx.core.animation.Interpolator;

public class AnticipateOvershootInterpolator
implements Interpolator {
    private final float mTension;

    public AnticipateOvershootInterpolator() {
        this.mTension = 3.0f;
    }

    public AnticipateOvershootInterpolator(float tension) {
        this.mTension = tension * 1.5f;
    }

    public AnticipateOvershootInterpolator(float tension, float extraTension) {
        this.mTension = tension * extraTension;
    }

    public AnticipateOvershootInterpolator(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context.getResources(), context.getTheme(), attrs);
    }

    AnticipateOvershootInterpolator(Resources res, Resources.Theme theme, AttributeSet attrs) {
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, AndroidResources.STYLEABLE_ANTICIPATEOVERSHOOT_INTERPOLATOR, 0, 0) : res.obtainAttributes(attrs, AndroidResources.STYLEABLE_ANTICIPATEOVERSHOOT_INTERPOLATOR);
        this.mTension = a.getFloat(0, 2.0f) * a.getFloat(1, 1.5f);
        a.recycle();
    }

    private static float a(float t, float s) {
        return t * t * ((s + 1.0f) * t - s);
    }

    private static float o(float t, float s) {
        return t * t * ((s + 1.0f) * t + s);
    }

    @Override
    @FloatRange(to=1.0)
    public float getInterpolation(@FloatRange(from=0.0, to=1.0) float input) {
        if (input < 0.5f) {
            return 0.5f * AnticipateOvershootInterpolator.a(input * 2.0f, this.mTension);
        }
        return 0.5f * (AnticipateOvershootInterpolator.o(input * 2.0f - 2.0f, this.mTension) + 2.0f);
    }
}

