/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import androidx.annotation.NonNull;
import androidx.core.animation.TypeConverter;

public abstract class BidirectionalTypeConverter<T, V>
extends TypeConverter<T, V> {
    private BidirectionalTypeConverter<V, T> mInvertedConverter;

    public BidirectionalTypeConverter(@NonNull Class<T> fromClass, @NonNull Class<V> toClass) {
        super(fromClass, toClass);
    }

    @NonNull
    public abstract T convertBack(@NonNull V var1);

    @NonNull
    public BidirectionalTypeConverter<V, T> invert() {
        if (this.mInvertedConverter == null) {
            this.mInvertedConverter = new InvertedConverter<V, T>(this);
        }
        return this.mInvertedConverter;
    }

    private static class InvertedConverter<From, To>
    extends BidirectionalTypeConverter<From, To> {
        private BidirectionalTypeConverter<To, From> mConverter;

        InvertedConverter(@NonNull BidirectionalTypeConverter<To, From> converter) {
            super(converter.getTargetType(), converter.getSourceType());
            this.mConverter = converter;
        }

        @Override
        @NonNull
        public From convertBack(@NonNull To value) {
            return (From)this.mConverter.convert(value);
        }

        @Override
        @NonNull
        public To convert(@NonNull From value) {
            return this.mConverter.convertBack(value);
        }
    }
}

