/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import androidx.annotation.FloatRange;
import androidx.core.animation.Interpolator;

public class BounceInterpolator
implements Interpolator {
    private static float bounce(float t) {
        return t * t * 8.0f;
    }

    @Override
    @FloatRange(from=0.0, to=1.0)
    public float getInterpolation(@FloatRange(from=0.0, to=1.0) float input) {
        float t = 1.1226f * input;
        if (t < 0.3535f) {
            return BounceInterpolator.bounce(t);
        }
        if (t < 0.7408f) {
            return BounceInterpolator.bounce(t - 0.54719f) + 0.7f;
        }
        if (t < 0.9644f) {
            return BounceInterpolator.bounce(t - 0.8526f) + 0.9f;
        }
        return BounceInterpolator.bounce(t - 1.0435f) + 0.95f;
    }
}

