/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.animation.TypeEvaluator;

public class IntArrayEvaluator
implements TypeEvaluator<int[]> {
    private int[] mArray;

    public IntArrayEvaluator() {
    }

    public IntArrayEvaluator(@Nullable int[] reuseArray) {
        this.mArray = reuseArray;
    }

    @Override
    @NonNull
    public int[] evaluate(float fraction, @NonNull int[] startValue, @NonNull int[] endValue) {
        int[] array = this.mArray;
        if (array == null) {
            array = new int[startValue.length];
        }
        for (int i = 0; i < array.length; ++i) {
            int start = startValue[i];
            int end = endValue[i];
            array[i] = (int)((float)start + fraction * (float)(end - start));
        }
        return array;
    }
}

