/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.graphics.Path;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.animation.FloatKeyframeSet;
import androidx.core.animation.IntKeyframeSet;
import androidx.core.animation.Interpolator;
import androidx.core.animation.Keyframe;
import androidx.core.animation.Keyframes;
import androidx.core.animation.PathKeyframes;
import androidx.core.animation.TypeEvaluator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class KeyframeSet<T>
implements Keyframes<T> {
    int mNumKeyframes;
    Keyframe<T> mFirstKeyframe;
    Keyframe<T> mLastKeyframe;
    Interpolator mInterpolator;
    List<Keyframe<T>> mKeyframes;
    TypeEvaluator<T> mEvaluator;

    @SafeVarargs
    KeyframeSet(Keyframe<T> ... keyframes) {
        this.mNumKeyframes = keyframes.length;
        this.mKeyframes = Arrays.asList(keyframes);
        this.mFirstKeyframe = keyframes[0];
        this.mLastKeyframe = keyframes[this.mNumKeyframes - 1];
        this.mInterpolator = this.mLastKeyframe.getInterpolator();
    }

    KeyframeSet(List<Keyframe<T>> keyframes) {
        this.mKeyframes = keyframes;
        this.mNumKeyframes = keyframes.size();
        this.mFirstKeyframe = keyframes.get(0);
        this.mLastKeyframe = keyframes.get(this.mNumKeyframes - 1);
        this.mInterpolator = this.mLastKeyframe.getInterpolator();
    }

    @Override
    public List<Keyframe<T>> getKeyframes() {
        return this.mKeyframes;
    }

    static KeyframeSet<Integer> ofInt(int ... values) {
        int numKeyframes = values.length;
        Keyframe.IntKeyframe[] keyframes = new Keyframe.IntKeyframe[Math.max(numKeyframes, 2)];
        if (numKeyframes == 1) {
            keyframes[0] = (Keyframe.IntKeyframe)Keyframe.ofInt(0.0f);
            keyframes[1] = (Keyframe.IntKeyframe)Keyframe.ofInt(1.0f, values[0]);
        } else {
            keyframes[0] = (Keyframe.IntKeyframe)Keyframe.ofInt(0.0f, values[0]);
            for (int i = 1; i < numKeyframes; ++i) {
                keyframes[i] = (Keyframe.IntKeyframe)Keyframe.ofInt((float)i / (float)(numKeyframes - 1), values[i]);
            }
        }
        return new IntKeyframeSet(keyframes);
    }

    static KeyframeSet<Float> ofFloat(float ... values) {
        boolean badValue = false;
        int numKeyframes = values.length;
        Keyframe.FloatKeyframe[] keyframes = new Keyframe.FloatKeyframe[Math.max(numKeyframes, 2)];
        if (numKeyframes == 1) {
            keyframes[0] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(0.0f);
            keyframes[1] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(1.0f, values[0]);
            if (Float.isNaN(values[0])) {
                badValue = true;
            }
        } else {
            keyframes[0] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(0.0f, values[0]);
            for (int i = 1; i < numKeyframes; ++i) {
                keyframes[i] = (Keyframe.FloatKeyframe)Keyframe.ofFloat((float)i / (float)(numKeyframes - 1), values[i]);
                if (!Float.isNaN(values[i])) continue;
                badValue = true;
            }
        }
        if (badValue) {
            Log.w((String)"Animator", (String)"Bad value (NaN) in float animator");
        }
        return new FloatKeyframeSet(keyframes);
    }

    @SafeVarargs
    public static <T> KeyframeSet<T> ofKeyframe(Keyframe<T> ... keyframes) {
        int numKeyframes = keyframes.length;
        boolean hasFloat = false;
        boolean hasInt = false;
        boolean hasOther = false;
        for (int i = 0; i < numKeyframes; ++i) {
            if (keyframes[i] instanceof Keyframe.FloatKeyframe) {
                hasFloat = true;
                continue;
            }
            if (keyframes[i] instanceof Keyframe.IntKeyframe) {
                hasInt = true;
                continue;
            }
            hasOther = true;
        }
        if (hasFloat && !hasInt && !hasOther) {
            Keyframe.FloatKeyframe[] floatKeyframes = new Keyframe.FloatKeyframe[numKeyframes];
            for (int i = 0; i < numKeyframes; ++i) {
                floatKeyframes[i] = (Keyframe.FloatKeyframe)keyframes[i];
            }
            return new FloatKeyframeSet(floatKeyframes);
        }
        if (hasInt && !hasFloat && !hasOther) {
            Keyframe.IntKeyframe[] intKeyframes = new Keyframe.IntKeyframe[numKeyframes];
            for (int i = 0; i < numKeyframes; ++i) {
                intKeyframes[i] = (Keyframe.IntKeyframe)keyframes[i];
            }
            return new IntKeyframeSet(intKeyframes);
        }
        return new KeyframeSet<T>(keyframes);
    }

    @SafeVarargs
    public static <T> KeyframeSet<T> ofObject(T ... values) {
        int numKeyframes = values.length;
        ArrayList<Keyframe<T>> keyframes = new ArrayList<Keyframe<T>>(Math.max(numKeyframes, 2));
        if (numKeyframes == 1) {
            keyframes.add(Keyframe.ofObject(0.0f));
            keyframes.add(Keyframe.ofObject(1.0f, values[0]));
        } else {
            keyframes.add(Keyframe.ofObject(0.0f, values[0]));
            for (int i = 1; i < numKeyframes; ++i) {
                keyframes.add(Keyframe.ofObject((float)i / (float)(numKeyframes - 1), values[i]));
            }
        }
        return new KeyframeSet<T>(keyframes);
    }

    public static PathKeyframes ofPath(Path path) {
        return new PathKeyframes(path);
    }

    public static PathKeyframes ofPath(Path path, float error) {
        return new PathKeyframes(path, error);
    }

    @Override
    public void setEvaluator(TypeEvaluator<T> evaluator) {
        this.mEvaluator = evaluator;
    }

    @Override
    public Class<?> getType() {
        return this.mFirstKeyframe.getType();
    }

    @Override
    @NonNull
    public KeyframeSet<T> clone() {
        List<Keyframe<T>> keyframes = this.mKeyframes;
        int numKeyframes = this.mKeyframes.size();
        ArrayList<Keyframe<T>> newKeyframes = new ArrayList<Keyframe<T>>(numKeyframes);
        for (int i = 0; i < numKeyframes; ++i) {
            Object clone = keyframes.get(i).clone();
            newKeyframes.add((Keyframe<T>)clone);
        }
        KeyframeSet<T> newSet = new KeyframeSet<T>(newKeyframes);
        return newSet;
    }

    @Override
    public T getValue(float fraction) {
        if (this.mNumKeyframes == 2) {
            if (this.mInterpolator != null) {
                fraction = this.mInterpolator.getInterpolation(fraction);
            }
            return this.mEvaluator.evaluate(fraction, this.mFirstKeyframe.getValue(), this.mLastKeyframe.getValue());
        }
        if (fraction <= 0.0f) {
            Keyframe<T> nextKeyframe = this.mKeyframes.get(1);
            Interpolator interpolator = nextKeyframe.getInterpolator();
            if (interpolator != null) {
                fraction = interpolator.getInterpolation(fraction);
            }
            float prevFraction = this.mFirstKeyframe.getFraction();
            float intervalFraction = (fraction - prevFraction) / (nextKeyframe.getFraction() - prevFraction);
            return this.mEvaluator.evaluate(intervalFraction, this.mFirstKeyframe.getValue(), nextKeyframe.getValue());
        }
        if (fraction >= 1.0f) {
            Keyframe<T> prevKeyframe = this.mKeyframes.get(this.mNumKeyframes - 2);
            Interpolator interpolator = this.mLastKeyframe.getInterpolator();
            if (interpolator != null) {
                fraction = interpolator.getInterpolation(fraction);
            }
            float prevFraction = prevKeyframe.getFraction();
            float intervalFraction = (fraction - prevFraction) / (this.mLastKeyframe.getFraction() - prevFraction);
            return this.mEvaluator.evaluate(intervalFraction, prevKeyframe.getValue(), this.mLastKeyframe.getValue());
        }
        Keyframe<T> prevKeyframe = this.mFirstKeyframe;
        for (int i = 1; i < this.mNumKeyframes; ++i) {
            Keyframe<T> nextKeyframe = this.mKeyframes.get(i);
            if (fraction < nextKeyframe.getFraction()) {
                Interpolator interpolator = nextKeyframe.getInterpolator();
                float prevFraction = prevKeyframe.getFraction();
                float intervalFraction = (fraction - prevFraction) / (nextKeyframe.getFraction() - prevFraction);
                if (interpolator != null) {
                    intervalFraction = interpolator.getInterpolation(intervalFraction);
                }
                return this.mEvaluator.evaluate(intervalFraction, prevKeyframe.getValue(), nextKeyframe.getValue());
            }
            prevKeyframe = nextKeyframe;
        }
        return this.mLastKeyframe.getValue();
    }

    @NonNull
    public String toString() {
        String returnVal = " ";
        for (int i = 0; i < this.mNumKeyframes; ++i) {
            returnVal = returnVal + this.mKeyframes.get(i).getValue() + "  ";
        }
        return returnVal;
    }
}

