/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.annotation.SuppressLint;
import android.graphics.Path;
import android.graphics.PointF;
import android.util.Property;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.animation.AnimationHandler;
import androidx.core.animation.Animator;
import androidx.core.animation.ArgbEvaluator;
import androidx.core.animation.KeyframeSet;
import androidx.core.animation.Keyframes;
import androidx.core.animation.PathKeyframes;
import androidx.core.animation.PropertyValuesHolder;
import androidx.core.animation.TypeConverter;
import androidx.core.animation.TypeEvaluator;
import androidx.core.animation.ValueAnimator;
import java.lang.ref.WeakReference;

public final class ObjectAnimator
extends ValueAnimator {
    private static final String LOG_TAG = "ObjectAnimator";
    private static final boolean DBG = false;
    private WeakReference<Object> mTarget;
    private String mPropertyName;
    private Property mProperty;
    private boolean mAutoCancel = false;

    public void setPropertyName(@NonNull String propertyName) {
        if (this.mValues != null) {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            String oldName = valuesHolder.getPropertyName();
            valuesHolder.setPropertyName(propertyName);
            this.mValuesMap.remove(oldName);
            this.mValuesMap.put(propertyName, valuesHolder);
        }
        this.mPropertyName = propertyName;
        this.mInitialized = false;
    }

    public void setProperty(@NonNull Property property) {
        if (this.mValues != null) {
            PropertyValuesHolder valuesHolder = this.mValues[0];
            String oldName = valuesHolder.getPropertyName();
            valuesHolder.setProperty(property);
            this.mValuesMap.remove(oldName);
            this.mValuesMap.put(this.mPropertyName, valuesHolder);
        }
        if (this.mProperty != null) {
            this.mPropertyName = property.getName();
        }
        this.mProperty = property;
        this.mInitialized = false;
    }

    @NonNull
    public String getPropertyName() {
        String propertyName = null;
        if (this.mPropertyName != null) {
            propertyName = this.mPropertyName;
        } else if (this.mProperty != null) {
            propertyName = this.mProperty.getName();
        } else if (this.mValues != null && this.mValues.length > 0) {
            for (int i = 0; i < this.mValues.length; ++i) {
                propertyName = i == 0 ? "" : propertyName + ",";
                propertyName = propertyName + this.mValues[i].getPropertyName();
            }
        }
        return propertyName;
    }

    @Override
    @NonNull
    public String getNameForTrace() {
        return this.mAnimTraceName == null ? "animator:" + this.getPropertyName() : this.mAnimTraceName;
    }

    public ObjectAnimator() {
    }

    private ObjectAnimator(Object target, String propertyName) {
        this.setTarget(target);
        this.setPropertyName(propertyName);
    }

    private <T> ObjectAnimator(T target, Property<T, ?> property) {
        this.setTarget(target);
        this.setProperty(property);
    }

    @NonNull
    public static ObjectAnimator ofInt(@NonNull Object target, @NonNull String propertyName, int ... values) {
        ObjectAnimator anim = new ObjectAnimator(target, propertyName);
        anim.setIntValues(values);
        return anim;
    }

    @NonNull
    public static ObjectAnimator ofInt(@NonNull Object target, @NonNull String xPropertyName, @NonNull String yPropertyName, @NonNull Path path) {
        PathKeyframes keyframes = KeyframeSet.ofPath(path);
        PropertyValuesHolder x = PropertyValuesHolder.ofKeyframes(xPropertyName, (Keyframes)keyframes.createXIntKeyframes());
        PropertyValuesHolder y = PropertyValuesHolder.ofKeyframes(yPropertyName, (Keyframes)keyframes.createYIntKeyframes());
        return ObjectAnimator.ofPropertyValuesHolder(target, x, y);
    }

    @NonNull
    public static <T> ObjectAnimator ofInt(@NonNull T target, @NonNull Property<T, Integer> property, int ... values) {
        ObjectAnimator anim = new ObjectAnimator(target, property);
        anim.setIntValues(values);
        return anim;
    }

    @NonNull
    public static <T> ObjectAnimator ofInt(@NonNull T target, @Nullable Property<T, Integer> xProperty, @Nullable Property<T, Integer> yProperty, @NonNull Path path) {
        PathKeyframes keyframes = KeyframeSet.ofPath(path);
        PropertyValuesHolder x = PropertyValuesHolder.ofKeyframes(xProperty, (Keyframes)keyframes.createXIntKeyframes());
        PropertyValuesHolder y = PropertyValuesHolder.ofKeyframes(yProperty, (Keyframes)keyframes.createYIntKeyframes());
        return ObjectAnimator.ofPropertyValuesHolder(target, x, y);
    }

    @NonNull
    public static ObjectAnimator ofMultiInt(@NonNull Object target, @NonNull String propertyName, @SuppressLint(value={"ArrayReturn"}) @NonNull int[][] values) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofMultiInt(propertyName, values);
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    @NonNull
    public static ObjectAnimator ofMultiInt(@NonNull Object target, @NonNull String propertyName, @NonNull Path path) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofMultiInt(propertyName, path);
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    @SafeVarargs
    @NonNull
    public static <T> ObjectAnimator ofMultiInt(@NonNull Object target, @NonNull String propertyName, @NonNull TypeConverter<T, int[]> converter, @NonNull TypeEvaluator<T> evaluator, T ... values) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofMultiInt(propertyName, converter, evaluator, values);
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    @NonNull
    public static ObjectAnimator ofArgb(@NonNull Object target, @NonNull String propertyName, int ... values) {
        ObjectAnimator animator = ObjectAnimator.ofInt(target, propertyName, values);
        animator.setEvaluator(ArgbEvaluator.getInstance());
        return animator;
    }

    @NonNull
    public static <T> ObjectAnimator ofArgb(@NonNull T target, @NonNull Property<T, Integer> property, int ... values) {
        ObjectAnimator animator = ObjectAnimator.ofInt(target, property, values);
        animator.setEvaluator(ArgbEvaluator.getInstance());
        return animator;
    }

    @NonNull
    public static ObjectAnimator ofFloat(@NonNull Object target, @NonNull String propertyName, float ... values) {
        ObjectAnimator anim = new ObjectAnimator(target, propertyName);
        anim.setFloatValues(values);
        return anim;
    }

    @NonNull
    public static ObjectAnimator ofFloat(@NonNull Object target, @Nullable String xPropertyName, @Nullable String yPropertyName, @NonNull Path path) {
        PathKeyframes keyframes = KeyframeSet.ofPath(path);
        PropertyValuesHolder x = PropertyValuesHolder.ofKeyframes(xPropertyName, (Keyframes)keyframes.createXFloatKeyframes());
        PropertyValuesHolder y = PropertyValuesHolder.ofKeyframes(yPropertyName, (Keyframes)keyframes.createYFloatKeyframes());
        return ObjectAnimator.ofPropertyValuesHolder(target, x, y);
    }

    @NonNull
    public static <T> ObjectAnimator ofFloat(@NonNull T target, @NonNull Property<T, Float> property, float ... values) {
        ObjectAnimator anim = new ObjectAnimator(target, property);
        anim.setFloatValues(values);
        return anim;
    }

    @NonNull
    public static <T> ObjectAnimator ofFloat(@NonNull T target, @Nullable Property<T, Float> xProperty, @Nullable Property<T, Float> yProperty, @NonNull Path path) {
        PathKeyframes keyframes = KeyframeSet.ofPath(path);
        PropertyValuesHolder x = PropertyValuesHolder.ofKeyframes(xProperty, (Keyframes)keyframes.createXFloatKeyframes());
        PropertyValuesHolder y = PropertyValuesHolder.ofKeyframes(yProperty, (Keyframes)keyframes.createYFloatKeyframes());
        return ObjectAnimator.ofPropertyValuesHolder(target, x, y);
    }

    @NonNull
    public static ObjectAnimator ofMultiFloat(@NonNull Object target, @NonNull String propertyName, @SuppressLint(value={"ArrayReturn"}) @NonNull float[][] values) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofMultiFloat(propertyName, values);
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    @NonNull
    public static ObjectAnimator ofMultiFloat(@NonNull Object target, @NonNull String propertyName, @NonNull Path path) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofMultiFloat(propertyName, path);
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    @SafeVarargs
    @NonNull
    public static <T> ObjectAnimator ofMultiFloat(@NonNull Object target, @NonNull String propertyName, @NonNull TypeConverter<T, float[]> converter, @NonNull TypeEvaluator<T> evaluator, T ... values) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofMultiFloat(propertyName, converter, evaluator, values);
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    @NonNull
    public static ObjectAnimator ofObject(@NonNull Object target, @NonNull String propertyName, @NonNull TypeEvaluator evaluator, Object ... values) {
        ObjectAnimator anim = new ObjectAnimator(target, propertyName);
        anim.setObjectValues(values);
        anim.setEvaluator(evaluator);
        return anim;
    }

    @NonNull
    public static ObjectAnimator ofObject(@NonNull Object target, @NonNull String propertyName, @Nullable TypeConverter<PointF, ?> converter, @NonNull Path path) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofObject(propertyName, converter, path);
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    @SafeVarargs
    @NonNull
    public static <T, V> ObjectAnimator ofObject(@NonNull T target, @NonNull Property<T, V> property, @NonNull TypeEvaluator<V> evaluator, V ... values) {
        ObjectAnimator anim = new ObjectAnimator(target, property);
        anim.setObjectValues(values);
        anim.setEvaluator(evaluator);
        return anim;
    }

    @SafeVarargs
    @NonNull
    public static <T, V, P> ObjectAnimator ofObject(@NonNull T target, @NonNull Property<T, P> property, @NonNull TypeConverter<V, P> converter, @NonNull TypeEvaluator<V> evaluator, V ... values) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofObject(property, converter, evaluator, values);
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    @NonNull
    public static <T, V> ObjectAnimator ofObject(@NonNull T target, @NonNull Property<T, V> property, @Nullable TypeConverter<PointF, V> converter, @NonNull Path path) {
        PropertyValuesHolder pvh = PropertyValuesHolder.ofObject(property, converter, path);
        return ObjectAnimator.ofPropertyValuesHolder(target, pvh);
    }

    @NonNull
    public static ObjectAnimator ofPropertyValuesHolder(@NonNull Object target, PropertyValuesHolder ... values) {
        ObjectAnimator anim = new ObjectAnimator();
        anim.setTarget(target);
        anim.setValues(values);
        return anim;
    }

    @Override
    public void setIntValues(int ... values) {
        if (this.mValues == null || this.mValues.length == 0) {
            if (this.mProperty != null) {
                this.setValues(PropertyValuesHolder.ofInt(this.mProperty, values));
            } else {
                this.setValues(PropertyValuesHolder.ofInt(this.mPropertyName, values));
            }
        } else {
            super.setIntValues(values);
        }
    }

    @Override
    public void setFloatValues(float ... values) {
        if (this.mValues == null || this.mValues.length == 0) {
            if (this.mProperty != null) {
                this.setValues(PropertyValuesHolder.ofFloat(this.mProperty, values));
            } else {
                this.setValues(PropertyValuesHolder.ofFloat(this.mPropertyName, values));
            }
        } else {
            super.setFloatValues(values);
        }
    }

    @Override
    public void setObjectValues(Object ... values) {
        if (this.mValues == null || this.mValues.length == 0) {
            if (this.mProperty != null) {
                this.setValues(PropertyValuesHolder.ofObject(this.mProperty, (TypeEvaluator)null, values));
            } else {
                this.setValues(PropertyValuesHolder.ofObject(this.mPropertyName, (TypeEvaluator)null, values));
            }
        } else {
            super.setObjectValues(values);
        }
    }

    public void setAutoCancel(boolean cancel) {
        this.mAutoCancel = cancel;
    }

    private boolean hasSameTargetAndProperties(@Nullable Animator anim) {
        if (anim instanceof ObjectAnimator) {
            PropertyValuesHolder[] theirValues = ((ObjectAnimator)anim).getValues();
            if (((ObjectAnimator)anim).getTarget() == this.getTarget() && this.mValues.length == theirValues.length) {
                for (int i = 0; i < this.mValues.length; ++i) {
                    PropertyValuesHolder pvhMine = this.mValues[i];
                    PropertyValuesHolder pvhTheirs = theirValues[i];
                    if (pvhMine.getPropertyName() != null && pvhMine.getPropertyName().equals(pvhTheirs.getPropertyName())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void start() {
        AnimationHandler.getInstance().autoCancelBasedOn(this);
        super.start();
    }

    boolean shouldAutoCancel(AnimationHandler.AnimationFrameCallback anim) {
        if (anim == null) {
            return false;
        }
        if (anim instanceof ObjectAnimator) {
            ObjectAnimator objAnim = (ObjectAnimator)anim;
            if (objAnim.mAutoCancel && this.hasSameTargetAndProperties(objAnim)) {
                return true;
            }
        }
        return false;
    }

    @Override
    @CallSuper
    void initAnimation() {
        if (!this.mInitialized) {
            Object target = this.getTarget();
            if (target != null) {
                int numValues = this.mValues.length;
                for (int i = 0; i < numValues; ++i) {
                    this.mValues[i].setupSetterAndGetter(target);
                }
            }
            super.initAnimation();
        }
    }

    @Override
    @NonNull
    public ObjectAnimator setDuration(long duration) {
        super.setDuration(duration);
        return this;
    }

    @Nullable
    public Object getTarget() {
        return this.mTarget == null ? null : this.mTarget.get();
    }

    @Override
    public void setTarget(@Nullable Object target) {
        Object oldTarget = this.getTarget();
        if (oldTarget != target) {
            if (this.isStarted()) {
                this.cancel();
            }
            this.mTarget = target == null ? null : new WeakReference<Object>(target);
            this.mInitialized = false;
        }
    }

    @Override
    public void setupStartValues() {
        this.initAnimation();
        Object target = this.getTarget();
        if (target != null) {
            int numValues = this.mValues.length;
            for (int i = 0; i < numValues; ++i) {
                this.mValues[i].setupStartValue(target);
            }
        }
    }

    @Override
    public void setupEndValues() {
        this.initAnimation();
        Object target = this.getTarget();
        if (target != null) {
            int numValues = this.mValues.length;
            for (int i = 0; i < numValues; ++i) {
                this.mValues[i].setupEndValue(target);
            }
        }
    }

    @Override
    @CallSuper
    void animateValue(float fraction) {
        Object target = this.getTarget();
        if (this.mTarget != null && target == null) {
            this.cancel();
            return;
        }
        super.animateValue(fraction);
        int numValues = this.mValues.length;
        for (int i = 0; i < numValues; ++i) {
            this.mValues[i].setAnimatedValue(target);
        }
    }

    @Override
    boolean isInitialized() {
        return this.mInitialized;
    }

    @Override
    @SuppressLint(value={"NoClone"})
    @NonNull
    public ObjectAnimator clone() {
        ObjectAnimator anim = (ObjectAnimator)super.clone();
        return anim;
    }

    @Override
    @NonNull
    public String toString() {
        String returnVal = "ObjectAnimator@" + Integer.toHexString(this.hashCode()) + ", target " + this.getTarget();
        if (this.mValues != null) {
            for (int i = 0; i < this.mValues.length; ++i) {
                returnVal = returnVal + "\n    " + this.mValues[i].toString();
            }
        }
        return returnVal;
    }
}

