/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.InflateException;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.animation.AndroidResources;
import androidx.core.animation.Interpolator;
import androidx.core.animation.PathUtils;
import androidx.core.content.res.TypedArrayUtils;
import androidx.core.graphics.PathParser;
import org.xmlpull.v1.XmlPullParser;

public class PathInterpolator
implements Interpolator {
    private static final float PRECISION = 0.002f;
    private static final float EPSILON = 0.01f;
    private float[] mData;

    public PathInterpolator(@NonNull Path path) {
        this.initPath(path);
    }

    public PathInterpolator(float controlX, float controlY) {
        this.initQuad(controlX, controlY);
    }

    public PathInterpolator(float controlX1, float controlY1, float controlX2, float controlY2) {
        this.initCubic(controlX1, controlY1, controlX2, controlY2);
    }

    public PathInterpolator(@NonNull Context context, @Nullable AttributeSet attrs, @NonNull XmlPullParser parser) {
        this(context.getResources(), context.getTheme(), attrs, parser);
    }

    public PathInterpolator(@NonNull Resources res, @Nullable Resources.Theme theme, @Nullable AttributeSet attrs, @NonNull XmlPullParser parser) {
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, AndroidResources.STYLEABLE_PATH_INTERPOLATOR, 0, 0) : res.obtainAttributes(attrs, AndroidResources.STYLEABLE_PATH_INTERPOLATOR);
        this.parseInterpolatorFromTypeArray(a, parser);
        a.recycle();
    }

    private void parseInterpolatorFromTypeArray(TypedArray a, XmlPullParser parser) {
        if (TypedArrayUtils.hasAttribute((XmlPullParser)parser, (String)"pathData")) {
            String pathData = TypedArrayUtils.getNamedString((TypedArray)a, (XmlPullParser)parser, (String)"pathData", (int)4);
            Path path = PathParser.createPathFromPathData((String)pathData);
            if (path == null) {
                throw new InflateException("The path is null, which is created from " + pathData);
            }
            this.initPath(path);
        } else {
            boolean hasY2;
            if (!TypedArrayUtils.hasAttribute((XmlPullParser)parser, (String)"controlX1")) {
                throw new InflateException("pathInterpolator requires the controlX1 attribute");
            }
            if (!TypedArrayUtils.hasAttribute((XmlPullParser)parser, (String)"controlY1")) {
                throw new InflateException("pathInterpolator requires the controlY1 attribute");
            }
            float x1 = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"controlX1", (int)0, (float)0.0f);
            float y1 = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"controlY1", (int)1, (float)0.0f);
            boolean hasX2 = TypedArrayUtils.hasAttribute((XmlPullParser)parser, (String)"controlX2");
            if (hasX2 != (hasY2 = TypedArrayUtils.hasAttribute((XmlPullParser)parser, (String)"controlY2"))) {
                throw new InflateException("pathInterpolator requires both controlX2 and controlY2 for cubic Beziers.");
            }
            if (!hasX2) {
                this.initQuad(x1, y1);
            } else {
                float x2 = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"controlX2", (int)2, (float)0.0f);
                float y2 = TypedArrayUtils.getNamedFloat((TypedArray)a, (XmlPullParser)parser, (String)"controlY2", (int)3, (float)0.0f);
                this.initCubic(x1, y1, x2, y2);
            }
        }
    }

    private void initQuad(float controlX, float controlY) {
        Path path = new Path();
        path.moveTo(0.0f, 0.0f);
        path.quadTo(controlX, controlY, 1.0f, 1.0f);
        this.initPath(path);
    }

    private void initCubic(float x1, float y1, float x2, float y2) {
        Path path = new Path();
        path.moveTo(0.0f, 0.0f);
        path.cubicTo(x1, y1, x2, y2, 1.0f, 1.0f);
        this.initPath(path);
    }

    private void initPath(Path path) {
        this.mData = PathUtils.createKeyFrameData(path, 0.002f);
        int numPoints = this.getNumOfPoints();
        if (!(PathInterpolator.floatEquals(this.getXAtIndex(0), 0.0f) && PathInterpolator.floatEquals(this.getYAtIndex(0), 0.0f) && PathInterpolator.floatEquals(this.getXAtIndex(numPoints - 1), 1.0f) && PathInterpolator.floatEquals(this.getYAtIndex(numPoints - 1), 1.0f))) {
            throw new IllegalArgumentException("The Path must start at (0,0) and end at (1,1)");
        }
        float prevX = 0.0f;
        float prevFraction = 0.0f;
        for (int i = 0; i < numPoints; ++i) {
            float fraction = this.getFractionAtIndex(i);
            float x = this.getXAtIndex(i);
            if (fraction == prevFraction && x != prevX) {
                throw new IllegalArgumentException("The Path cannot have discontinuity in the X axis.");
            }
            if (x < prevX) {
                throw new IllegalArgumentException("The Path cannot loop back on itself.");
            }
            prevFraction = fraction;
            prevX = x;
        }
    }

    @Override
    public float getInterpolation(@FloatRange(from=0.0, to=1.0) float input) {
        if (input <= 0.0f) {
            return 0.0f;
        }
        if (input >= 1.0f) {
            return 1.0f;
        }
        int startIndex = 0;
        int endIndex = this.getNumOfPoints() - 1;
        while (endIndex - startIndex > 1) {
            int midIndex = (startIndex + endIndex) / 2;
            if (input < this.getXAtIndex(midIndex)) {
                endIndex = midIndex;
                continue;
            }
            startIndex = midIndex;
        }
        float xRange = this.getXAtIndex(endIndex) - this.getXAtIndex(startIndex);
        if (xRange == 0.0f) {
            return this.getYAtIndex(startIndex);
        }
        float tInRange = input - this.getXAtIndex(startIndex);
        float fraction = tInRange / xRange;
        float startY = this.getYAtIndex(startIndex);
        float endY = this.getYAtIndex(endIndex);
        return startY + fraction * (endY - startY);
    }

    private float getFractionAtIndex(int index) {
        return this.mData[3 * index];
    }

    private float getXAtIndex(int index) {
        return this.mData[3 * index + 1];
    }

    private float getYAtIndex(int index) {
        return this.mData[3 * index + 2];
    }

    private int getNumOfPoints() {
        return this.mData.length / 3;
    }

    private static boolean floatEquals(float a, float b) {
        return Math.abs(a - b) < 0.01f;
    }
}

