/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.graphics.Path;
import android.graphics.PointF;
import androidx.annotation.NonNull;
import androidx.core.animation.Keyframe;
import androidx.core.animation.Keyframes;
import androidx.core.animation.PathUtils;
import androidx.core.animation.TypeEvaluator;
import java.util.ArrayList;
import java.util.List;

class PathKeyframes
implements Keyframes<PointF> {
    private static final int FRACTION_OFFSET = 0;
    private static final int X_OFFSET = 1;
    private static final int Y_OFFSET = 2;
    private static final int NUM_COMPONENTS = 3;
    private static final ArrayList<Keyframe<PointF>> EMPTY_KEYFRAMES = new ArrayList();
    private PointF mTempPointF = new PointF();
    private final float[] mKeyframeData;

    PathKeyframes(Path path) {
        this(path, 0.5f);
    }

    PathKeyframes(Path path, float error) {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("The path must not be null or empty");
        }
        this.mKeyframeData = PathUtils.createKeyFrameData(path, error);
    }

    @Override
    public List<Keyframe<PointF>> getKeyframes() {
        return EMPTY_KEYFRAMES;
    }

    @Override
    public PointF getValue(float fraction) {
        int numPoints = this.mKeyframeData.length / 3;
        if (fraction < 0.0f) {
            return this.interpolateInRange(fraction, 0, 1);
        }
        if (fraction > 1.0f) {
            return this.interpolateInRange(fraction, numPoints - 2, numPoints - 1);
        }
        if (fraction == 0.0f) {
            return this.pointForIndex(0);
        }
        if (fraction == 1.0f) {
            return this.pointForIndex(numPoints - 1);
        }
        int low = 0;
        int high = numPoints - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            float midFraction = this.mKeyframeData[mid * 3 + 0];
            if (fraction < midFraction) {
                high = mid - 1;
                continue;
            }
            if (fraction > midFraction) {
                low = mid + 1;
                continue;
            }
            return this.pointForIndex(mid);
        }
        return this.interpolateInRange(fraction, high, low);
    }

    private PointF interpolateInRange(float fraction, int startIndex, int endIndex) {
        int startBase = startIndex * 3;
        int endBase = endIndex * 3;
        float startFraction = this.mKeyframeData[startBase + 0];
        float endFraction = this.mKeyframeData[endBase + 0];
        float intervalFraction = (fraction - startFraction) / (endFraction - startFraction);
        float startX = this.mKeyframeData[startBase + 1];
        float endX = this.mKeyframeData[endBase + 1];
        float startY = this.mKeyframeData[startBase + 2];
        float endY = this.mKeyframeData[endBase + 2];
        float x = PathKeyframes.interpolate(intervalFraction, startX, endX);
        float y = PathKeyframes.interpolate(intervalFraction, startY, endY);
        this.mTempPointF.set(x, y);
        return this.mTempPointF;
    }

    @Override
    public void setEvaluator(TypeEvaluator evaluator) {
    }

    @Override
    public Class<PointF> getType() {
        return PointF.class;
    }

    @Override
    @NonNull
    public Keyframes clone() {
        Keyframes clone = null;
        try {
            clone = (Keyframes)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    private PointF pointForIndex(int index) {
        int base = index * 3;
        int xOffset = base + 1;
        int yOffset = base + 2;
        this.mTempPointF.set(this.mKeyframeData[xOffset], this.mKeyframeData[yOffset]);
        return this.mTempPointF;
    }

    private static float interpolate(float fraction, float startValue, float endValue) {
        float diff = endValue - startValue;
        return startValue + diff * fraction;
    }

    public Keyframes.FloatKeyframes createXFloatKeyframes() {
        return new FloatKeyframesBase(){

            @Override
            public float getFloatValue(float fraction) {
                PointF pointF = PathKeyframes.this.getValue(fraction);
                return pointF.x;
            }
        };
    }

    public Keyframes.FloatKeyframes createYFloatKeyframes() {
        return new FloatKeyframesBase(){

            @Override
            public float getFloatValue(float fraction) {
                PointF pointF = PathKeyframes.this.getValue(fraction);
                return pointF.y;
            }
        };
    }

    public Keyframes.IntKeyframes createXIntKeyframes() {
        return new IntKeyframesBase(){

            @Override
            public int getIntValue(float fraction) {
                PointF pointF = PathKeyframes.this.getValue(fraction);
                return Math.round(pointF.x);
            }
        };
    }

    public Keyframes.IntKeyframes createYIntKeyframes() {
        return new IntKeyframesBase(){

            @Override
            public int getIntValue(float fraction) {
                PointF pointF = PathKeyframes.this.getValue(fraction);
                return Math.round(pointF.y);
            }
        };
    }

    static abstract class FloatKeyframesBase
    extends SimpleKeyframes<Float>
    implements Keyframes.FloatKeyframes {
        FloatKeyframesBase() {
        }

        @Override
        public Class<Float> getType() {
            return Float.class;
        }

        @Override
        public Float getValue(float fraction) {
            return Float.valueOf(this.getFloatValue(fraction));
        }
    }

    static abstract class IntKeyframesBase
    extends SimpleKeyframes<Integer>
    implements Keyframes.IntKeyframes {
        IntKeyframesBase() {
        }

        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }

        @Override
        public Integer getValue(float fraction) {
            return this.getIntValue(fraction);
        }
    }

    private static abstract class SimpleKeyframes<T>
    implements Keyframes<T> {
        private final ArrayList<Keyframe<T>> mEmptyFrames = new ArrayList();

        private SimpleKeyframes() {
        }

        @Override
        public void setEvaluator(TypeEvaluator<T> evaluator) {
        }

        @Override
        public List<Keyframe<T>> getKeyframes() {
            return this.mEmptyFrames;
        }

        @Override
        @NonNull
        public Keyframes<T> clone() {
            Keyframes clone = null;
            try {
                clone = (Keyframes)super.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return clone;
        }
    }
}

