/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.graphics.PointF;
import androidx.annotation.NonNull;
import androidx.core.animation.TypeEvaluator;

public class PointFEvaluator
implements TypeEvaluator<PointF> {
    private PointF mPoint;

    public PointFEvaluator() {
    }

    public PointFEvaluator(@NonNull PointF reuse) {
        this.mPoint = reuse;
    }

    @Override
    @NonNull
    public PointF evaluate(float fraction, @NonNull PointF startValue, @NonNull PointF endValue) {
        float x = startValue.x + fraction * (endValue.x - startValue.x);
        float y = startValue.y + fraction * (endValue.y - startValue.y);
        if (this.mPoint != null) {
            this.mPoint.set(x, y);
            return this.mPoint;
        }
        return new PointF(x, y);
    }
}

