/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.animation;

import android.annotation.SuppressLint;
import android.graphics.Path;
import android.graphics.PointF;
import android.util.Log;
import android.util.Property;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.animation.BidirectionalTypeConverter;
import androidx.core.animation.FloatArrayEvaluator;
import androidx.core.animation.FloatEvaluator;
import androidx.core.animation.FloatProperty;
import androidx.core.animation.IntArrayEvaluator;
import androidx.core.animation.IntEvaluator;
import androidx.core.animation.IntProperty;
import androidx.core.animation.Keyframe;
import androidx.core.animation.KeyframeSet;
import androidx.core.animation.Keyframes;
import androidx.core.animation.PathKeyframes;
import androidx.core.animation.TypeConverter;
import androidx.core.animation.TypeEvaluator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;

public class PropertyValuesHolder
implements Cloneable {
    String mPropertyName;
    Property mProperty;
    Method mSetter = null;
    private Method mGetter = null;
    Class<?> mValueType;
    Keyframes mKeyframes = null;
    private static final Class<?>[] FLOAT_VARIANTS = new Class[]{Float.TYPE, Float.class, Double.TYPE, Integer.TYPE, Double.class, Integer.class};
    private static final Class<?>[] INTEGER_VARIANTS = new Class[]{Integer.TYPE, Integer.class, Float.TYPE, Double.TYPE, Float.class, Double.class};
    private static final Class<?>[] DOUBLE_VARIANTS = new Class[]{Double.TYPE, Double.class, Float.TYPE, Integer.TYPE, Float.class, Integer.class};
    static final HashMap<Class<?>, HashMap<String, Method>> sSetterPropertyMap = new HashMap();
    private static final HashMap<Class<?>, HashMap<String, Method>> sGetterPropertyMap = new HashMap();
    final Object[] mTmpValueArray = new Object[1];
    private TypeEvaluator mEvaluator;
    private Object mAnimatedValue;
    private TypeConverter mConverter;

    PropertyValuesHolder(String propertyName) {
        this.mPropertyName = propertyName;
    }

    PropertyValuesHolder(Property property) {
        this.mProperty = property;
        if (property != null) {
            this.mPropertyName = property.getName();
        }
    }

    @NonNull
    public static PropertyValuesHolder ofInt(@NonNull String propertyName, int ... values) {
        return new IntPropertyValuesHolder(propertyName, values);
    }

    @NonNull
    public static PropertyValuesHolder ofInt(@NonNull Property<?, Integer> property, int ... values) {
        return new IntPropertyValuesHolder(property, values);
    }

    @NonNull
    public static PropertyValuesHolder ofMultiInt(@NonNull String propertyName, @SuppressLint(value={"ArrayReturn"}) @NonNull int[][] values) {
        if (values.length < 2) {
            throw new IllegalArgumentException("At least 2 values must be supplied");
        }
        int numParameters = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("values must not be null");
            }
            int length = values[i].length;
            if (i == 0) {
                numParameters = length;
                continue;
            }
            if (length == numParameters) continue;
            throw new IllegalArgumentException("Values must all have the same length");
        }
        IntArrayEvaluator evaluator = new IntArrayEvaluator(new int[numParameters]);
        return new MultiIntValuesHolder(propertyName, null, (TypeEvaluator)evaluator, (Object[])values);
    }

    @NonNull
    public static PropertyValuesHolder ofMultiInt(@NonNull String propertyName, @NonNull Path path) {
        PathKeyframes keyframes = KeyframeSet.ofPath(path);
        PointFToIntArray converter = new PointFToIntArray();
        return new MultiIntValuesHolder(propertyName, (TypeConverter)converter, null, keyframes);
    }

    @SafeVarargs
    @NonNull
    public static <V> PropertyValuesHolder ofMultiInt(@NonNull String propertyName, @NonNull TypeConverter<V, int[]> converter, @NonNull TypeEvaluator<V> evaluator, V ... values) {
        return new MultiIntValuesHolder(propertyName, converter, evaluator, values);
    }

    @SafeVarargs
    @NonNull
    public static <T> PropertyValuesHolder ofMultiInt(@NonNull String propertyName, @Nullable TypeConverter<T, int[]> converter, @NonNull TypeEvaluator<T> evaluator, Keyframe ... values) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(values);
        return new MultiIntValuesHolder(propertyName, converter, evaluator, keyframeSet);
    }

    @NonNull
    public static PropertyValuesHolder ofFloat(@NonNull String propertyName, float ... values) {
        return new FloatPropertyValuesHolder(propertyName, values);
    }

    @NonNull
    public static PropertyValuesHolder ofFloat(@NonNull Property<?, Float> property, float ... values) {
        return new FloatPropertyValuesHolder(property, values);
    }

    @NonNull
    public static PropertyValuesHolder ofMultiFloat(@NonNull String propertyName, @SuppressLint(value={"ArrayReturn"}) @NonNull float[][] values) {
        if (values.length < 2) {
            throw new IllegalArgumentException("At least 2 values must be supplied");
        }
        int numParameters = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("values must not be null");
            }
            int length = values[i].length;
            if (i == 0) {
                numParameters = length;
                continue;
            }
            if (length == numParameters) continue;
            throw new IllegalArgumentException("Values must all have the same length");
        }
        FloatArrayEvaluator evaluator = new FloatArrayEvaluator(new float[numParameters]);
        return new MultiFloatValuesHolder(propertyName, null, (TypeEvaluator)evaluator, (Object[])values);
    }

    @NonNull
    public static PropertyValuesHolder ofMultiFloat(@NonNull String propertyName, @NonNull Path path) {
        PathKeyframes keyframes = KeyframeSet.ofPath(path);
        PointFToFloatArray converter = new PointFToFloatArray();
        return new MultiFloatValuesHolder(propertyName, (TypeConverter)converter, null, keyframes);
    }

    @SafeVarargs
    @NonNull
    public static <V> PropertyValuesHolder ofMultiFloat(@NonNull String propertyName, @NonNull TypeConverter<V, float[]> converter, @NonNull TypeEvaluator<V> evaluator, V ... values) {
        return new MultiFloatValuesHolder(propertyName, converter, evaluator, values);
    }

    @SafeVarargs
    @NonNull
    public static <T> PropertyValuesHolder ofMultiFloat(@NonNull String propertyName, @Nullable TypeConverter<T, float[]> converter, @NonNull TypeEvaluator<T> evaluator, Keyframe ... values) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(values);
        return new MultiFloatValuesHolder(propertyName, converter, evaluator, keyframeSet);
    }

    @NonNull
    public static PropertyValuesHolder ofObject(@NonNull String propertyName, @NonNull TypeEvaluator evaluator, Object ... values) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(propertyName);
        pvh.setObjectValues(values);
        pvh.setEvaluator(evaluator);
        return pvh;
    }

    @NonNull
    public static PropertyValuesHolder ofObject(@NonNull String propertyName, @Nullable TypeConverter<PointF, ?> converter, @NonNull Path path) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(propertyName);
        pvh.mKeyframes = KeyframeSet.ofPath(path);
        pvh.mValueType = PointF.class;
        pvh.setConverter(converter);
        return pvh;
    }

    @SafeVarargs
    @NonNull
    public static <V> PropertyValuesHolder ofObject(@NonNull Property property, @NonNull TypeEvaluator<V> evaluator, V ... values) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(property);
        pvh.setObjectValues(values);
        pvh.setEvaluator(evaluator);
        return pvh;
    }

    @SafeVarargs
    @NonNull
    public static <T, V> PropertyValuesHolder ofObject(@NonNull Property<?, V> property, @NonNull TypeConverter<T, V> converter, @NonNull TypeEvaluator<T> evaluator, T ... values) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(property);
        pvh.setConverter(converter);
        pvh.setObjectValues(values);
        pvh.setEvaluator(evaluator);
        return pvh;
    }

    @NonNull
    public static <V> PropertyValuesHolder ofObject(@NonNull Property<?, V> property, @Nullable TypeConverter<PointF, V> converter, @NonNull Path path) {
        PropertyValuesHolder pvh = new PropertyValuesHolder(property);
        pvh.mKeyframes = KeyframeSet.ofPath(path);
        pvh.mValueType = PointF.class;
        pvh.setConverter(converter);
        return pvh;
    }

    @SafeVarargs
    @NonNull
    public static PropertyValuesHolder ofKeyframe(@NonNull String propertyName, Keyframe ... values) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(values);
        return PropertyValuesHolder.ofKeyframes(propertyName, keyframeSet);
    }

    @SafeVarargs
    @NonNull
    public static PropertyValuesHolder ofKeyframe(@NonNull Property property, Keyframe ... values) {
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(values);
        return PropertyValuesHolder.ofKeyframes(property, keyframeSet);
    }

    static PropertyValuesHolder ofKeyframes(String propertyName, Keyframes keyframes) {
        if (keyframes instanceof Keyframes.IntKeyframes) {
            return new IntPropertyValuesHolder(propertyName, (Keyframes.IntKeyframes)keyframes);
        }
        if (keyframes instanceof Keyframes.FloatKeyframes) {
            return new FloatPropertyValuesHolder(propertyName, (Keyframes.FloatKeyframes)keyframes);
        }
        PropertyValuesHolder pvh = new PropertyValuesHolder(propertyName);
        pvh.mKeyframes = keyframes;
        pvh.mValueType = keyframes.getType();
        return pvh;
    }

    static PropertyValuesHolder ofKeyframes(Property property, Keyframes keyframes) {
        if (keyframes instanceof Keyframes.IntKeyframes) {
            return new IntPropertyValuesHolder(property, (Keyframes.IntKeyframes)keyframes);
        }
        if (keyframes instanceof Keyframes.FloatKeyframes) {
            return new FloatPropertyValuesHolder(property, (Keyframes.FloatKeyframes)keyframes);
        }
        PropertyValuesHolder pvh = new PropertyValuesHolder(property);
        pvh.mKeyframes = keyframes;
        pvh.mValueType = keyframes.getType();
        return pvh;
    }

    public void setIntValues(int ... values) {
        this.mValueType = Integer.TYPE;
        this.mKeyframes = KeyframeSet.ofInt(values);
    }

    public void setFloatValues(float ... values) {
        this.mValueType = Float.TYPE;
        this.mKeyframes = KeyframeSet.ofFloat(values);
    }

    public void setKeyframes(Keyframe ... values) {
        int numKeyframes = values.length;
        Keyframe[] keyframes = new Keyframe[Math.max(numKeyframes, 2)];
        this.mValueType = values[0].getType();
        for (int i = 0; i < numKeyframes; ++i) {
            keyframes[i] = values[i];
        }
        this.mKeyframes = new KeyframeSet(keyframes);
    }

    public void setObjectValues(Object ... values) {
        this.mValueType = values[0].getClass();
        this.mKeyframes = KeyframeSet.ofObject(values);
        if (this.mEvaluator != null) {
            this.mKeyframes.setEvaluator(this.mEvaluator);
        }
    }

    public void setConverter(@Nullable TypeConverter converter) {
        this.mConverter = converter;
    }

    private Method getPropertyFunction(Class<?> targetClass, String prefix, Class<?> valueType) {
        Method returnVal = null;
        String methodName = PropertyValuesHolder.getMethodName(prefix, this.mPropertyName);
        Class[] args = null;
        if (valueType == null) {
            try {
                returnVal = targetClass.getMethod(methodName, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        } else {
            args = new Class[1];
            Class<Object>[] typeVariants = valueType.equals(Float.class) ? FLOAT_VARIANTS : (valueType.equals(Integer.class) ? INTEGER_VARIANTS : (valueType.equals(Double.class) ? DOUBLE_VARIANTS : new Class[]{valueType}));
            Class<?>[] classArray = typeVariants;
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?> typeVariant;
                args[0] = typeVariant = classArray[i];
                try {
                    returnVal = targetClass.getMethod(methodName, args);
                    if (this.mConverter == null) {
                        this.mValueType = typeVariant;
                    }
                    return returnVal;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        returnVal = targetClass.getDeclaredMethod(methodName, args);
                        returnVal.setAccessible(true);
                        if (this.mConverter == null) {
                            this.mValueType = typeVariant;
                        }
                        return returnVal;
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        continue;
                    }
                }
            }
        }
        if (returnVal == null) {
            Log.w((String)"PropertyValuesHolder", (String)("Method " + PropertyValuesHolder.getMethodName(prefix, this.mPropertyName) + "() with type " + valueType + " not found on target class " + targetClass));
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method setupSetterOrGetter(Class<?> targetClass, HashMap<Class<?>, HashMap<String, Method>> propertyMapMap, String prefix, Class<?> valueType) {
        Method setterOrGetter = null;
        HashMap<Class<?>, HashMap<String, Method>> hashMap = propertyMapMap;
        synchronized (hashMap) {
            HashMap<String, Method> propertyMap = propertyMapMap.get(targetClass);
            boolean wasInMap = false;
            if (propertyMap != null && (wasInMap = propertyMap.containsKey(this.mPropertyName))) {
                setterOrGetter = propertyMap.get(this.mPropertyName);
            }
            if (!wasInMap) {
                setterOrGetter = this.getPropertyFunction(targetClass, prefix, valueType);
                if (propertyMap == null) {
                    propertyMap = new HashMap();
                    propertyMapMap.put(targetClass, propertyMap);
                }
                propertyMap.put(this.mPropertyName, setterOrGetter);
            }
        }
        return setterOrGetter;
    }

    void setupSetter(Class<?> targetClass) {
        Class<Object> propertyType = this.mConverter == null ? this.mValueType : this.mConverter.getTargetType();
        this.mSetter = this.setupSetterOrGetter(targetClass, sSetterPropertyMap, "set", propertyType);
    }

    private void setupGetter(Class<?> targetClass) {
        this.mGetter = this.setupSetterOrGetter(targetClass, sGetterPropertyMap, "get", null);
    }

    void setupSetterAndGetter(Object target) {
        if (this.mProperty != null) {
            try {
                Object testValue = null;
                List keyframes = this.mKeyframes.getKeyframes();
                int keyframeCount = keyframes == null ? 0 : keyframes.size();
                for (int i = 0; i < keyframeCount; ++i) {
                    Keyframe<Object> kf = keyframes.get(i);
                    if (kf.hasValue() && !kf.valueWasSetOnStart()) continue;
                    if (testValue == null) {
                        testValue = this.convertBack(this.mProperty.get(target));
                    }
                    kf.setValue(testValue);
                    kf.setValueWasSetOnStart(true);
                }
                return;
            }
            catch (ClassCastException e) {
                Log.w((String)"PropertyValuesHolder", (String)("No such property (" + this.mProperty.getName() + ") on target object " + target + ". Trying reflection instead"));
                this.mProperty = null;
            }
        }
        if (this.mProperty == null) {
            List keyframes;
            Class<?> targetClass = target.getClass();
            if (this.mSetter == null) {
                this.setupSetter(targetClass);
            }
            int keyframeCount = (keyframes = this.mKeyframes.getKeyframes()) == null ? 0 : keyframes.size();
            for (int i = 0; i < keyframeCount; ++i) {
                Keyframe<Object> kf = keyframes.get(i);
                if (kf.hasValue() && !kf.valueWasSetOnStart()) continue;
                if (this.mGetter == null) {
                    this.setupGetter(targetClass);
                    if (this.mGetter == null) {
                        return;
                    }
                }
                try {
                    Object value = this.convertBack(this.mGetter.invoke(target, new Object[0]));
                    kf.setValue(value);
                    kf.setValueWasSetOnStart(true);
                    continue;
                }
                catch (InvocationTargetException e) {
                    Log.e((String)"PropertyValuesHolder", (String)e.toString());
                    continue;
                }
                catch (IllegalAccessException e) {
                    Log.e((String)"PropertyValuesHolder", (String)e.toString());
                }
            }
        }
    }

    private Object convertBack(Object value) {
        if (this.mConverter != null) {
            if (!(this.mConverter instanceof BidirectionalTypeConverter)) {
                throw new IllegalArgumentException("Converter " + this.mConverter.getClass().getName() + " must be a BidirectionalTypeConverter");
            }
            value = ((BidirectionalTypeConverter)this.mConverter).convertBack(value);
        }
        return value;
    }

    private void setupValue(Object target, Keyframe kf) {
        if (this.mProperty != null) {
            Object value = this.convertBack(this.mProperty.get(target));
            kf.setValue(value);
        } else {
            try {
                if (this.mGetter == null) {
                    Class<?> targetClass = target.getClass();
                    this.setupGetter(targetClass);
                    if (this.mGetter == null) {
                        return;
                    }
                }
                Object value = this.convertBack(this.mGetter.invoke(target, new Object[0]));
                kf.setValue(value);
            }
            catch (InvocationTargetException e) {
                Log.e((String)"PropertyValuesHolder", (String)e.toString());
            }
            catch (IllegalAccessException e) {
                Log.e((String)"PropertyValuesHolder", (String)e.toString());
            }
        }
    }

    void setupStartValue(Object target) {
        List keyframes = this.mKeyframes.getKeyframes();
        if (!keyframes.isEmpty()) {
            this.setupValue(target, keyframes.get(0));
        }
    }

    void setupEndValue(Object target) {
        List keyframes = this.mKeyframes.getKeyframes();
        if (!keyframes.isEmpty()) {
            this.setupValue(target, keyframes.get(keyframes.size() - 1));
        }
    }

    @SuppressLint(value={"NoClone"})
    @NonNull
    public PropertyValuesHolder clone() {
        try {
            PropertyValuesHolder newPVH = (PropertyValuesHolder)super.clone();
            newPVH.mPropertyName = this.mPropertyName;
            newPVH.mProperty = this.mProperty;
            newPVH.mKeyframes = this.mKeyframes.clone();
            newPVH.mEvaluator = this.mEvaluator;
            return newPVH;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    void setAnimatedValue(Object target) {
        if (this.mProperty != null) {
            this.mProperty.set(target, this.getAnimatedValue());
        }
        if (this.mSetter != null) {
            try {
                this.mTmpValueArray[0] = this.getAnimatedValue();
                this.mSetter.invoke(target, this.mTmpValueArray);
            }
            catch (InvocationTargetException e) {
                Log.e((String)"PropertyValuesHolder", (String)e.toString());
            }
            catch (IllegalAccessException e) {
                Log.e((String)"PropertyValuesHolder", (String)e.toString());
            }
        }
    }

    void init() {
        if (this.mEvaluator == null) {
            TypeEvaluator<Integer> typeEvaluator = this.mValueType == Integer.class ? IntEvaluator.getInstance() : (this.mEvaluator = this.mValueType == Float.class ? FloatEvaluator.getInstance() : null);
        }
        if (this.mEvaluator != null) {
            this.mKeyframes.setEvaluator(this.mEvaluator);
        }
    }

    public void setEvaluator(@NonNull TypeEvaluator evaluator) {
        this.mEvaluator = evaluator;
        this.mKeyframes.setEvaluator(evaluator);
    }

    void calculateValue(float fraction) {
        Object value = this.mKeyframes.getValue(fraction);
        this.mAnimatedValue = this.mConverter == null ? value : this.mConverter.convert(value);
    }

    public void setPropertyName(@NonNull String propertyName) {
        this.mPropertyName = propertyName;
    }

    public void setProperty(@NonNull Property property) {
        this.mProperty = property;
    }

    @NonNull
    public String getPropertyName() {
        return this.mPropertyName;
    }

    Object getAnimatedValue() {
        return this.mAnimatedValue;
    }

    Class<?> getValueType() {
        return this.mValueType;
    }

    @NonNull
    public String toString() {
        return this.mPropertyName + ": " + this.mKeyframes.toString();
    }

    static String getMethodName(String prefix, String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            return prefix;
        }
        char firstLetter = Character.toUpperCase(propertyName.charAt(0));
        String theRest = propertyName.substring(1);
        return prefix + firstLetter + theRest;
    }

    static class IntPropertyValuesHolder
    extends PropertyValuesHolder {
        private IntProperty mIntProperty;
        Keyframes.IntKeyframes mIntKeyframes;
        int mIntAnimatedValue;

        IntPropertyValuesHolder(String propertyName, Keyframes.IntKeyframes keyframes) {
            super(propertyName);
            this.mValueType = Integer.TYPE;
            this.mKeyframes = keyframes;
            this.mIntKeyframes = keyframes;
        }

        IntPropertyValuesHolder(Property property, Keyframes.IntKeyframes keyframes) {
            super(property);
            this.mValueType = Integer.TYPE;
            this.mKeyframes = keyframes;
            this.mIntKeyframes = keyframes;
            if (property instanceof IntProperty) {
                this.mIntProperty = (IntProperty)this.mProperty;
            }
        }

        IntPropertyValuesHolder(String propertyName, int ... values) {
            super(propertyName);
            this.setIntValues(values);
        }

        IntPropertyValuesHolder(Property property, int ... values) {
            super(property);
            this.setIntValues(values);
            if (property instanceof IntProperty) {
                this.mIntProperty = (IntProperty)this.mProperty;
            }
        }

        @Override
        public void setProperty(@NonNull Property property) {
            if (property instanceof IntProperty) {
                this.mIntProperty = (IntProperty)property;
            } else {
                super.setProperty(property);
            }
        }

        @Override
        public void setIntValues(int ... values) {
            super.setIntValues(values);
            this.mIntKeyframes = (Keyframes.IntKeyframes)this.mKeyframes;
        }

        @Override
        void calculateValue(float fraction) {
            this.mIntAnimatedValue = this.mIntKeyframes.getIntValue(fraction);
        }

        @Override
        Object getAnimatedValue() {
            return this.mIntAnimatedValue;
        }

        @Override
        @NonNull
        public IntPropertyValuesHolder clone() {
            IntPropertyValuesHolder newPVH = (IntPropertyValuesHolder)super.clone();
            newPVH.mIntKeyframes = (Keyframes.IntKeyframes)newPVH.mKeyframes;
            return newPVH;
        }

        @Override
        void setAnimatedValue(Object target) {
            if (this.mIntProperty != null) {
                this.mIntProperty.setValue(target, this.mIntAnimatedValue);
                return;
            }
            if (this.mProperty != null) {
                this.mProperty.set(target, (Object)this.mIntAnimatedValue);
                return;
            }
            try {
                this.mTmpValueArray[0] = this.mIntAnimatedValue;
                this.mSetter.invoke(target, this.mTmpValueArray);
            }
            catch (InvocationTargetException e) {
                Log.e((String)"PropertyValuesHolder", (String)e.toString());
            }
            catch (IllegalAccessException e) {
                Log.e((String)"PropertyValuesHolder", (String)e.toString());
            }
        }
    }

    static class MultiIntValuesHolder
    extends PropertyValuesHolder {
        MultiIntValuesHolder(String propertyName, TypeConverter converter, TypeEvaluator evaluator, Object ... values) {
            super(propertyName);
            this.setConverter(converter);
            this.setObjectValues(values);
            this.setEvaluator(evaluator);
        }

        MultiIntValuesHolder(String propertyName, TypeConverter converter, TypeEvaluator evaluator, Keyframes keyframes) {
            super(propertyName);
            this.setConverter(converter);
            this.mKeyframes = keyframes;
            this.setEvaluator(evaluator);
        }

        @Override
        void setAnimatedValue(Object target) {
            int[] values = (int[])this.getAnimatedValue();
            Object[] boxedValues = new Integer[values.length];
            for (int i = 0; i < boxedValues.length; ++i) {
                boxedValues[i] = values[i];
            }
            if (this.mSetter != null) {
                try {
                    this.mSetter.invoke(target, boxedValues);
                }
                catch (InvocationTargetException e) {
                    Log.e((String)"PropertyValuesHolder", (String)e.toString());
                }
                catch (IllegalAccessException e) {
                    Log.e((String)"PropertyValuesHolder", (String)e.toString());
                }
            }
        }

        @Override
        void setupSetterAndGetter(Object target) {
            this.setupSetter(target.getClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void setupSetter(Class<?> targetClass) {
            HashMap hashMap = sSetterPropertyMap;
            synchronized (hashMap) {
                HashMap<String, Method> propertyMap = (HashMap<String, Method>)sSetterPropertyMap.get(targetClass);
                boolean wasInMap = false;
                if (propertyMap != null && (wasInMap = propertyMap.containsKey(this.mPropertyName))) {
                    this.mSetter = (Method)propertyMap.get(this.mPropertyName);
                }
                if (!wasInMap) {
                    int i;
                    String methodName = MultiIntValuesHolder.getMethodName("set", this.mPropertyName);
                    this.calculateValue(0.0f);
                    int[] values = (int[])this.getAnimatedValue();
                    int numParams = values.length;
                    Class[] parameterTypes = new Class[values.length];
                    for (i = 0; i < numParams; ++i) {
                        parameterTypes[i] = Integer.TYPE;
                    }
                    try {
                        this.mSetter = targetClass.getMethod(methodName, parameterTypes);
                        if (this.mSetter == null) {
                            for (i = 0; i < numParams; ++i) {
                                parameterTypes[i] = Integer.class;
                            }
                            this.mSetter = targetClass.getMethod(methodName, parameterTypes);
                        }
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    if (propertyMap == null) {
                        propertyMap = new HashMap<String, Method>();
                        sSetterPropertyMap.put(targetClass, propertyMap);
                    }
                    propertyMap.put(this.mPropertyName, this.mSetter);
                }
            }
        }
    }

    private static class PointFToIntArray
    extends TypeConverter<PointF, int[]> {
        private int[] mCoordinates = new int[2];

        PointFToIntArray() {
            super(PointF.class, int[].class);
        }

        @Override
        @NonNull
        public int[] convert(@NonNull PointF value) {
            this.mCoordinates[0] = Math.round(value.x);
            this.mCoordinates[1] = Math.round(value.y);
            return this.mCoordinates;
        }
    }

    static class FloatPropertyValuesHolder
    extends PropertyValuesHolder {
        private FloatProperty mFloatProperty;
        Keyframes.FloatKeyframes mFloatKeyframes;
        float mFloatAnimatedValue;

        FloatPropertyValuesHolder(String propertyName, Keyframes.FloatKeyframes keyframes) {
            super(propertyName);
            this.mValueType = Float.TYPE;
            this.mKeyframes = keyframes;
            this.mFloatKeyframes = keyframes;
        }

        FloatPropertyValuesHolder(Property property, Keyframes.FloatKeyframes keyframes) {
            super(property);
            this.mValueType = Float.TYPE;
            this.mKeyframes = keyframes;
            this.mFloatKeyframes = keyframes;
            if (property instanceof FloatProperty) {
                this.mFloatProperty = (FloatProperty)this.mProperty;
            }
        }

        FloatPropertyValuesHolder(String propertyName, float ... values) {
            super(propertyName);
            this.setFloatValues(values);
        }

        FloatPropertyValuesHolder(Property property, float ... values) {
            super(property);
            this.setFloatValues(values);
            if (property instanceof FloatProperty) {
                this.mFloatProperty = (FloatProperty)this.mProperty;
            }
        }

        @Override
        public void setProperty(@NonNull Property property) {
            if (property instanceof FloatProperty) {
                this.mFloatProperty = (FloatProperty)property;
            } else {
                super.setProperty(property);
            }
        }

        @Override
        public void setFloatValues(float ... values) {
            super.setFloatValues(values);
            this.mFloatKeyframes = (Keyframes.FloatKeyframes)this.mKeyframes;
        }

        @Override
        void calculateValue(float fraction) {
            this.mFloatAnimatedValue = this.mFloatKeyframes.getFloatValue(fraction);
        }

        @Override
        Object getAnimatedValue() {
            return Float.valueOf(this.mFloatAnimatedValue);
        }

        @Override
        @NonNull
        public FloatPropertyValuesHolder clone() {
            FloatPropertyValuesHolder newPVH = (FloatPropertyValuesHolder)super.clone();
            newPVH.mFloatKeyframes = (Keyframes.FloatKeyframes)newPVH.mKeyframes;
            return newPVH;
        }

        @Override
        void setAnimatedValue(Object target) {
            if (this.mFloatProperty != null) {
                this.mFloatProperty.setValue(target, this.mFloatAnimatedValue);
                return;
            }
            if (this.mProperty != null) {
                this.mProperty.set(target, (Object)Float.valueOf(this.mFloatAnimatedValue));
                return;
            }
            if (this.mSetter != null) {
                try {
                    this.mTmpValueArray[0] = Float.valueOf(this.mFloatAnimatedValue);
                    this.mSetter.invoke(target, this.mTmpValueArray);
                }
                catch (InvocationTargetException e) {
                    Log.e((String)"PropertyValuesHolder", (String)e.toString());
                }
                catch (IllegalAccessException e) {
                    Log.e((String)"PropertyValuesHolder", (String)e.toString());
                }
            }
        }
    }

    static class MultiFloatValuesHolder
    extends PropertyValuesHolder {
        MultiFloatValuesHolder(String propertyName, TypeConverter converter, TypeEvaluator evaluator, Object ... values) {
            super(propertyName);
            this.setConverter(converter);
            this.setObjectValues(values);
            this.setEvaluator(evaluator);
        }

        MultiFloatValuesHolder(String propertyName, TypeConverter converter, TypeEvaluator evaluator, Keyframes keyframes) {
            super(propertyName);
            this.setConverter(converter);
            this.mKeyframes = keyframes;
            this.setEvaluator(evaluator);
        }

        @Override
        void setAnimatedValue(Object target) {
            float[] values = (float[])this.getAnimatedValue();
            Object[] boxedValues = new Float[values.length];
            for (int i = 0; i < boxedValues.length; ++i) {
                boxedValues[i] = Float.valueOf(values[i]);
            }
            if (this.mSetter != null) {
                try {
                    this.mSetter.invoke(target, boxedValues);
                }
                catch (InvocationTargetException e) {
                    Log.e((String)"PropertyValuesHolder", (String)e.toString());
                }
                catch (IllegalAccessException e) {
                    Log.e((String)"PropertyValuesHolder", (String)e.toString());
                }
            }
        }

        @Override
        void setupSetterAndGetter(Object target) {
            this.setupSetter(target.getClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void setupSetter(Class<?> targetClass) {
            HashMap hashMap = sSetterPropertyMap;
            synchronized (hashMap) {
                HashMap<String, Method> propertyMap = (HashMap<String, Method>)sSetterPropertyMap.get(targetClass);
                boolean wasInMap = false;
                if (propertyMap != null && (wasInMap = propertyMap.containsKey(this.mPropertyName))) {
                    this.mSetter = (Method)propertyMap.get(this.mPropertyName);
                }
                if (!wasInMap) {
                    int i;
                    String methodName = MultiFloatValuesHolder.getMethodName("set", this.mPropertyName);
                    this.calculateValue(0.0f);
                    float[] values = (float[])this.getAnimatedValue();
                    int numParams = values.length;
                    Class[] parameterTypes = new Class[values.length];
                    for (i = 0; i < numParams; ++i) {
                        parameterTypes[i] = Float.TYPE;
                    }
                    try {
                        this.mSetter = targetClass.getMethod(methodName, parameterTypes);
                        if (this.mSetter == null) {
                            for (i = 0; i < numParams; ++i) {
                                parameterTypes[i] = Float.class;
                            }
                            this.mSetter = targetClass.getMethod(methodName, parameterTypes);
                        }
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    if (propertyMap == null) {
                        propertyMap = new HashMap<String, Method>();
                        sSetterPropertyMap.put(targetClass, propertyMap);
                    }
                    propertyMap.put(this.mPropertyName, this.mSetter);
                }
            }
        }
    }

    private static class PointFToFloatArray
    extends TypeConverter<PointF, float[]> {
        private float[] mCoordinates = new float[2];

        PointFToFloatArray() {
            super(PointF.class, float[].class);
        }

        @Override
        @NonNull
        public float[] convert(@NonNull PointF value) {
            this.mCoordinates[0] = value.x;
            this.mCoordinates[1] = value.y;
            return this.mCoordinates;
        }
    }
}

