/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.location.altitude.impl.proto;

import androidx.core.location.altitude.impl.proto.AllocatedBuffer;
import androidx.core.location.altitude.impl.proto.CheckReturnValue;
import java.nio.ByteBuffer;

@CheckReturnValue
abstract class BufferAllocator {
    private static final BufferAllocator UNPOOLED = new BufferAllocator(){

        @Override
        public AllocatedBuffer allocateHeapBuffer(int capacity) {
            return AllocatedBuffer.wrap(new byte[capacity]);
        }

        @Override
        public AllocatedBuffer allocateDirectBuffer(int capacity) {
            return AllocatedBuffer.wrap(ByteBuffer.allocateDirect(capacity));
        }
    };

    BufferAllocator() {
    }

    public static BufferAllocator unpooled() {
        return UNPOOLED;
    }

    public abstract AllocatedBuffer allocateHeapBuffer(int var1);

    public abstract AllocatedBuffer allocateDirectBuffer(int var1);
}

