/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.widget;

import android.appwidget.AppWidgetManager;
import android.os.Bundle;
import android.util.Log;
import android.util.SizeF;
import android.widget.RemoteViews;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.core.util.SizeFCompat;
import androidx.core.widget.AppWidgetManagerApi16Impl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nH\u0007J*\u0010\f\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nH\u0007J\f\u0010\u000f\u001a\u00020\u000b*\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Landroidx/core/widget/AppWidgetManagerApi31Impl;", "", "()V", "createExactSizeAppWidget", "Landroid/widget/RemoteViews;", "appWidgetManager", "Landroid/appwidget/AppWidgetManager;", "appWidgetId", "", "factory", "Lkotlin/Function1;", "Landroidx/core/util/SizeFCompat;", "createResponsiveSizeAppWidget", "dpSizes", "", "toSizeFCompat", "Landroid/util/SizeF;", "core-remoteviews_release"})
@RequiresApi(value=31)
final class AppWidgetManagerApi31Impl {
    @NotNull
    public static final AppWidgetManagerApi31Impl INSTANCE = new AppWidgetManagerApi31Impl();

    private AppWidgetManagerApi31Impl() {
    }

    /*
     * WARNING - void declaration
     */
    @DoNotInline
    @NotNull
    public final RemoteViews createExactSizeAppWidget(@NotNull AppWidgetManager appWidgetManager, int appWidgetId, @NotNull Function1<? super SizeFCompat, ? extends RemoteViews> factory) {
        Intrinsics.checkNotNullParameter((Object)appWidgetManager, (String)"appWidgetManager");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        Bundle options = appWidgetManager.getAppWidgetOptions(appWidgetId);
        ArrayList sizes = options.getParcelableArrayList("appWidgetSizes");
        Collection collection = sizes;
        if (collection == null || collection.isEmpty()) {
            Log.w((String)"AppWidgetManagerCompat", (String)"App widget SizeF sizes not found in the options bundle, falling back to the min/max sizes");
            return AppWidgetManagerApi16Impl.INSTANCE.createExactSizeAppWidget(appWidgetManager, appWidgetId, factory);
        }
        Iterable $this$associateWith$iv = sizes;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            SizeF sizeF = (SizeF)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            RemoteViews remoteViews = (RemoteViews)factory.invoke((Object)INSTANCE.toSizeFCompat((SizeF)it));
            map.put(t, remoteViews);
        }
        Map map = result$iv;
        return new RemoteViews(map);
    }

    /*
     * WARNING - void declaration
     */
    @DoNotInline
    @NotNull
    public final RemoteViews createResponsiveSizeAppWidget(@NotNull Collection<SizeFCompat> dpSizes, @NotNull Function1<? super SizeFCompat, ? extends RemoteViews> factory) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(dpSizes, (String)"dpSizes");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        Iterable $this$associate$iv = dpSizes;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            SizeFCompat it = (SizeFCompat)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.toSizeF(), (Object)factory.invoke((Object)it));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map map = destination$iv$iv;
        return new RemoteViews(map);
    }

    private final SizeFCompat toSizeFCompat(SizeF $this$toSizeFCompat) {
        SizeFCompat sizeFCompat = SizeFCompat.toSizeFCompat((SizeF)$this$toSizeFCompat);
        Intrinsics.checkNotNullExpressionValue((Object)sizeFCompat, (String)"toSizeFCompat(this)");
        return sizeFCompat;
    }
}

