/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.widget;

import android.appwidget.AppWidgetManager;
import android.os.Bundle;
import android.util.Log;
import android.widget.RemoteViews;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.core.util.SizeFCompat;
import androidx.core.widget.AppWidgetManagerCompat;
import androidx.core.widget.LandscapePortraitSizes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\tH\u0002J,\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\tH\u0007J:\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\tH\u0007J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0014"}, d2={"Landroidx/core/widget/AppWidgetManagerApi16Impl;", "", "()V", "createAppWidget", "Landroid/widget/RemoteViews;", "landscapeSize", "Landroidx/core/util/SizeFCompat;", "portraitSize", "factory", "Lkotlin/Function1;", "createExactSizeAppWidget", "appWidgetManager", "Landroid/appwidget/AppWidgetManager;", "appWidgetId", "", "createResponsiveSizeAppWidget", "sizes", "", "getSizesFromOptionsBundle", "Landroidx/core/widget/LandscapePortraitSizes;", "core-remoteviews_release"})
@RequiresApi(value=16)
@SourceDebugExtension(value={"SMAP\nAppWidgetManagerCompat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppWidgetManagerCompat.kt\nandroidx/core/widget/AppWidgetManagerApi16Impl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,336:1\n2333#2,14:337\n766#2:351\n857#2,2:352\n1963#2,14:354\n766#2:368\n857#2,2:369\n1963#2,14:371\n*S KotlinDebug\n*F\n+ 1 AppWidgetManagerCompat.kt\nandroidx/core/widget/AppWidgetManagerApi16Impl\n*L\n259#1:337,14\n271#1:351\n271#1:352,2\n271#1:354,14\n273#1:368\n273#1:369,2\n273#1:371,14\n*E\n"})
final class AppWidgetManagerApi16Impl {
    @NotNull
    public static final AppWidgetManagerApi16Impl INSTANCE = new AppWidgetManagerApi16Impl();

    private AppWidgetManagerApi16Impl() {
    }

    @DoNotInline
    @NotNull
    public final RemoteViews createExactSizeAppWidget(@NotNull AppWidgetManager appWidgetManager, int appWidgetId, @NotNull Function1<? super SizeFCompat, ? extends RemoteViews> factory) {
        Intrinsics.checkNotNullParameter((Object)appWidgetManager, (String)"appWidgetManager");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        LandscapePortraitSizes landscapePortraitSizes = this.getSizesFromOptionsBundle(appWidgetManager, appWidgetId);
        if (landscapePortraitSizes == null) {
            AppWidgetManagerApi16Impl $this$createExactSizeAppWidget_u24lambda_u240 = this;
            boolean bl = false;
            Log.w((String)"AppWidgetManagerCompat", (String)"App widget sizes not found in the options bundle, falling back to the provider size");
            return AppWidgetManagerCompat.createAppWidgetFromProviderInfo(appWidgetManager, appWidgetId, factory);
        }
        LandscapePortraitSizes landscapePortraitSizes2 = landscapePortraitSizes;
        SizeFCompat landscapeSize = landscapePortraitSizes2.component1();
        SizeFCompat portraitSize = landscapePortraitSizes2.component2();
        return this.createAppWidget(landscapeSize, portraitSize, factory);
    }

    /*
     * WARNING - void declaration
     */
    @DoNotInline
    @NotNull
    public final RemoteViews createResponsiveSizeAppWidget(@NotNull AppWidgetManager appWidgetManager, int appWidgetId, @NotNull Collection<SizeFCompat> sizes, @NotNull Function1<? super SizeFCompat, ? extends RemoteViews> factory) {
        SizeFCompat sizeFCompat;
        Object v5;
        void $this$filterTo$iv$iv;
        SizeFCompat sizeFCompat2;
        Object maxElem$iv;
        Object v3;
        void $this$filterTo$iv$iv2;
        Object v0;
        Intrinsics.checkNotNullParameter((Object)appWidgetManager, (String)"appWidgetManager");
        Intrinsics.checkNotNullParameter(sizes, (String)"sizes");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        Iterable $this$minByOrNull$iv = sizes;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                SizeFCompat it = (SizeFCompat)minElem$iv;
                boolean bl = false;
                float minValue$iv = AppWidgetManagerCompat.getArea(it);
                do {
                    Object e$iv = iterator$iv.next();
                    SizeFCompat it2 = (SizeFCompat)e$iv;
                    $i$a$-minByOrNull-AppWidgetManagerApi16Impl$createResponsiveSizeAppWidget$minSize$1 = false;
                    float v$iv = AppWidgetManagerCompat.getArea(it2);
                    if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        SizeFCompat sizeFCompat3 = v0;
        if (sizeFCompat3 == null) {
            throw new IllegalStateException("Sizes cannot be empty".toString());
        }
        SizeFCompat minSize = sizeFCompat3;
        LandscapePortraitSizes landscapePortraitSizes = this.getSizesFromOptionsBundle(appWidgetManager, appWidgetId);
        if (landscapePortraitSizes == null) {
            AppWidgetManagerApi16Impl $this$createResponsiveSizeAppWidget_u24lambda_u242 = this;
            boolean bl = false;
            Log.w((String)"AppWidgetManagerCompat", (String)("App widget sizes not found in the options bundle, falling back to the smallest supported size (" + minSize + ')'));
            landscapePortraitSizes = new LandscapePortraitSizes(minSize, minSize);
        }
        LandscapePortraitSizes landscapePortraitSizes2 = landscapePortraitSizes;
        SizeFCompat landscapeSize = landscapePortraitSizes2.component1();
        SizeFCompat portraitSize = landscapePortraitSizes2.component2();
        Iterable $this$filter$iv = sizes;
        boolean $i$f$filter = false;
        Iterable v$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            SizeFCompat it = (SizeFCompat)element$iv$iv;
            boolean bl = false;
            if (!AppWidgetManagerCompat.approxDominates(landscapeSize, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv2 = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv2.hasNext()) {
            v3 = null;
        } else {
            maxElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v3 = maxElem$iv;
            } else {
                SizeFCompat it = (SizeFCompat)maxElem$iv;
                boolean bl = false;
                float maxValue$iv = AppWidgetManagerCompat.getArea(it);
                do {
                    Object e$iv = iterator$iv2.next();
                    SizeFCompat it3 = (SizeFCompat)e$iv;
                    $i$a$-maxByOrNull-AppWidgetManagerApi16Impl$createResponsiveSizeAppWidget$effectiveLandscapeSize$2 = false;
                    float v$iv2 = AppWidgetManagerCompat.getArea(it3);
                    if (Float.compare(maxValue$iv, v$iv2) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv2;
                } while (iterator$iv2.hasNext());
                v3 = maxElem$iv;
            }
        }
        if ((sizeFCompat2 = (SizeFCompat)v3) == null) {
            sizeFCompat2 = minSize;
        }
        SizeFCompat effectiveLandscapeSize = sizeFCompat2;
        Iterable $this$filter$iv2 = sizes;
        boolean $i$f$filter2 = false;
        maxElem$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SizeFCompat it = (SizeFCompat)element$iv$iv;
            boolean bl = false;
            if (!AppWidgetManagerCompat.approxDominates(portraitSize, it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$maxByOrNull$iv2 = (List)destination$iv$iv2;
        boolean $i$f$maxByOrNull2 = false;
        Iterator iterator$iv3 = $this$maxByOrNull$iv2.iterator();
        if (!iterator$iv3.hasNext()) {
            v5 = null;
        } else {
            Object maxElem$iv2 = iterator$iv3.next();
            if (!iterator$iv3.hasNext()) {
                v5 = maxElem$iv2;
            } else {
                SizeFCompat it = (SizeFCompat)maxElem$iv2;
                boolean bl = false;
                float maxValue$iv = AppWidgetManagerCompat.getArea(it);
                do {
                    Object e$iv = iterator$iv3.next();
                    SizeFCompat it4 = (SizeFCompat)e$iv;
                    $i$a$-maxByOrNull-AppWidgetManagerApi16Impl$createResponsiveSizeAppWidget$effectivePortraitSize$2 = false;
                    float v$iv3 = AppWidgetManagerCompat.getArea(it4);
                    if (Float.compare(maxValue$iv, v$iv3) >= 0) continue;
                    maxElem$iv2 = e$iv;
                    maxValue$iv = v$iv3;
                } while (iterator$iv3.hasNext());
                v5 = maxElem$iv2;
            }
        }
        if ((sizeFCompat = (SizeFCompat)v5) == null) {
            sizeFCompat = minSize;
        }
        SizeFCompat effectivePortraitSize = sizeFCompat;
        return this.createAppWidget(effectiveLandscapeSize, effectivePortraitSize, factory);
    }

    private final RemoteViews createAppWidget(SizeFCompat landscapeSize, SizeFCompat portraitSize, Function1<? super SizeFCompat, ? extends RemoteViews> factory) {
        return Intrinsics.areEqual((Object)landscapeSize, (Object)portraitSize) ? (RemoteViews)factory.invoke((Object)landscapeSize) : new RemoteViews((RemoteViews)factory.invoke((Object)landscapeSize), (RemoteViews)factory.invoke((Object)portraitSize));
    }

    private final LandscapePortraitSizes getSizesFromOptionsBundle(AppWidgetManager appWidgetManager, int appWidgetId) {
        Bundle options = appWidgetManager.getAppWidgetOptions(appWidgetId);
        int portWidthDp = options.getInt("appWidgetMinWidth", -1);
        int portHeightDp = options.getInt("appWidgetMaxHeight", -1);
        if (portWidthDp < 0 || portHeightDp < 0) {
            return null;
        }
        int landWidthDp = options.getInt("appWidgetMaxWidth", -1);
        int landHeightDp = options.getInt("appWidgetMinHeight", -1);
        if (landWidthDp < 0 || landHeightDp < 0) {
            return null;
        }
        return new LandscapePortraitSizes(new SizeFCompat((float)landWidthDp, (float)landHeightDp), new SizeFCompat((float)portWidthDp, (float)portHeightDp));
    }
}

