/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.widget;

import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProviderInfo;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.widget.RemoteViews;
import androidx.core.util.SizeFCompat;
import androidx.core.widget.AppWidgetManagerApi31Impl;
import androidx.core.widget.LandscapePortraitSizes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\fH\u0002\u001a,\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\fH\u0000\u001a*\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\f\u001a,\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\fH\u0000\u001a8\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\f\u001a:\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\fH\u0000\u001a\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0015\u0010\u001b\u001a\u00020\u001c*\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0080\u0004\u001a\u0014\u0010\u001e\u001a\u00020\u0004*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0014\u0010\u001f\u001a\u00020 *\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a&\u0010!\u001a\u00020 *\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\f\u001a4\u0010!\u001a\u00020 *\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\""}, d2={"LogTag", "", "area", "", "Landroidx/core/util/SizeFCompat;", "getArea", "(Landroidx/core/util/SizeFCompat;)F", "createAppWidget", "Landroid/widget/RemoteViews;", "landscapeSize", "portraitSize", "factory", "Lkotlin/Function1;", "createAppWidgetFromProviderInfo", "appWidgetManager", "Landroid/appwidget/AppWidgetManager;", "appWidgetId", "", "createExactSizeAppWidget", "createExactSizeAppWidgetInner", "createResponsiveSizeAppWidget", "dpSizes", "", "createResponsiveSizeAppWidgetInner", "sizes", "getSizesFromOptionsBundle", "Landroidx/core/widget/LandscapePortraitSizes;", "approxDominates", "", "other", "getSizeFromProviderInfo", "requireValidAppWidgetId", "", "updateAppWidget", "core-remoteviews_release"})
@JvmName(name="AppWidgetManagerCompat")
@SourceDebugExtension(value={"SMAP\nAppWidgetManagerCompat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppWidgetManagerCompat.kt\nandroidx/core/widget/AppWidgetManagerCompat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,312:1\n1#2:313\n2333#3,14:314\n766#3:328\n857#3,2:329\n1963#3,14:331\n766#3:345\n857#3,2:346\n1963#3,14:348\n*S KotlinDebug\n*F\n+ 1 AppWidgetManagerCompat.kt\nandroidx/core/widget/AppWidgetManagerCompat\n*L\n236#1:314,14\n248#1:328\n248#1:329,2\n248#1:331,14\n250#1:345\n250#1:346,2\n250#1:348,14\n*E\n"})
public final class AppWidgetManagerCompat {
    @NotNull
    private static final String LogTag = "AppWidgetManagerCompat";

    public static final boolean approxDominates(@NotNull SizeFCompat $this$approxDominates, @NotNull SizeFCompat other) {
        Intrinsics.checkNotNullParameter((Object)$this$approxDominates, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (float)Math.ceil($this$approxDominates.getWidth()) + 1.0f >= other.getWidth() && (float)Math.ceil($this$approxDominates.getHeight()) + 1.0f >= other.getHeight();
    }

    public static final float getArea(@NotNull SizeFCompat $this$area) {
        Intrinsics.checkNotNullParameter((Object)$this$area, (String)"<this>");
        return $this$area.getWidth() * $this$area.getHeight();
    }

    public static final void updateAppWidget(@NotNull AppWidgetManager $this$updateAppWidget, int appWidgetId, @NotNull Function1<? super SizeFCompat, ? extends RemoteViews> factory) {
        Intrinsics.checkNotNullParameter((Object)$this$updateAppWidget, (String)"<this>");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        $this$updateAppWidget.updateAppWidget(appWidgetId, AppWidgetManagerCompat.createExactSizeAppWidget($this$updateAppWidget, appWidgetId, factory));
    }

    @NotNull
    public static final RemoteViews createExactSizeAppWidget(@NotNull AppWidgetManager appWidgetManager, int appWidgetId, @NotNull Function1<? super SizeFCompat, ? extends RemoteViews> factory) {
        Intrinsics.checkNotNullParameter((Object)appWidgetManager, (String)"appWidgetManager");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        AppWidgetManagerCompat.requireValidAppWidgetId(appWidgetManager, appWidgetId);
        return Build.VERSION.SDK_INT >= 31 ? AppWidgetManagerApi31Impl.INSTANCE.createExactSizeAppWidget(appWidgetManager, appWidgetId, factory) : AppWidgetManagerCompat.createExactSizeAppWidgetInner(appWidgetManager, appWidgetId, factory);
    }

    public static final void updateAppWidget(@NotNull AppWidgetManager $this$updateAppWidget, int appWidgetId, @NotNull Collection<SizeFCompat> dpSizes, @NotNull Function1<? super SizeFCompat, ? extends RemoteViews> factory) {
        Intrinsics.checkNotNullParameter((Object)$this$updateAppWidget, (String)"<this>");
        Intrinsics.checkNotNullParameter(dpSizes, (String)"dpSizes");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        $this$updateAppWidget.updateAppWidget(appWidgetId, AppWidgetManagerCompat.createResponsiveSizeAppWidget($this$updateAppWidget, appWidgetId, dpSizes, factory));
    }

    @NotNull
    public static final RemoteViews createResponsiveSizeAppWidget(@NotNull AppWidgetManager appWidgetManager, int appWidgetId, @NotNull Collection<SizeFCompat> dpSizes, @NotNull Function1<? super SizeFCompat, ? extends RemoteViews> factory) {
        Intrinsics.checkNotNullParameter((Object)appWidgetManager, (String)"appWidgetManager");
        Intrinsics.checkNotNullParameter(dpSizes, (String)"dpSizes");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        AppWidgetManagerCompat.requireValidAppWidgetId(appWidgetManager, appWidgetId);
        if (!(!dpSizes.isEmpty())) {
            boolean $i$a$-require-AppWidgetManagerCompat$createResponsiveSizeAppWidget$32 = false;
            String $i$a$-require-AppWidgetManagerCompat$createResponsiveSizeAppWidget$32 = "Sizes cannot be empty";
            throw new IllegalArgumentException($i$a$-require-AppWidgetManagerCompat$createResponsiveSizeAppWidget$32.toString());
        }
        if (!(dpSizes.size() <= 16)) {
            boolean bl = false;
            String string = "At most 16 sizes may be provided";
            throw new IllegalArgumentException(string.toString());
        }
        return Build.VERSION.SDK_INT >= 31 ? AppWidgetManagerApi31Impl.INSTANCE.createResponsiveSizeAppWidget(dpSizes, factory) : AppWidgetManagerCompat.createResponsiveSizeAppWidgetInner(appWidgetManager, appWidgetId, dpSizes, factory);
    }

    private static final void requireValidAppWidgetId(AppWidgetManager $this$requireValidAppWidgetId, int appWidgetId) {
        if ($this$requireValidAppWidgetId.getAppWidgetInfo(appWidgetId) == null) {
            boolean bl = false;
            String string = "Invalid app widget id: " + appWidgetId;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public static final RemoteViews createExactSizeAppWidgetInner(@NotNull AppWidgetManager appWidgetManager, int appWidgetId, @NotNull Function1<? super SizeFCompat, ? extends RemoteViews> factory) {
        Intrinsics.checkNotNullParameter((Object)appWidgetManager, (String)"appWidgetManager");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        LandscapePortraitSizes landscapePortraitSizes = AppWidgetManagerCompat.getSizesFromOptionsBundle(appWidgetManager, appWidgetId);
        if (landscapePortraitSizes == null) {
            boolean bl = false;
            Log.w((String)LogTag, (String)"App widget sizes not found in the options bundle, falling back to the provider size");
            return AppWidgetManagerCompat.createAppWidgetFromProviderInfo(appWidgetManager, appWidgetId, factory);
        }
        LandscapePortraitSizes landscapePortraitSizes2 = landscapePortraitSizes;
        SizeFCompat landscapeSize = landscapePortraitSizes2.component1();
        SizeFCompat portraitSize = landscapePortraitSizes2.component2();
        return AppWidgetManagerCompat.createAppWidget(landscapeSize, portraitSize, factory);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RemoteViews createResponsiveSizeAppWidgetInner(@NotNull AppWidgetManager appWidgetManager, int appWidgetId, @NotNull Collection<SizeFCompat> sizes, @NotNull Function1<? super SizeFCompat, ? extends RemoteViews> factory) {
        SizeFCompat sizeFCompat;
        Object v5;
        void $this$filterTo$iv$iv;
        SizeFCompat sizeFCompat2;
        Object maxElem$iv;
        Object v3;
        void $this$filterTo$iv$iv2;
        Object v0;
        Intrinsics.checkNotNullParameter((Object)appWidgetManager, (String)"appWidgetManager");
        Intrinsics.checkNotNullParameter(sizes, (String)"sizes");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        Iterable $this$minByOrNull$iv = sizes;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                SizeFCompat it = (SizeFCompat)minElem$iv;
                boolean bl = false;
                float minValue$iv = AppWidgetManagerCompat.getArea(it);
                do {
                    Object e$iv = iterator$iv.next();
                    SizeFCompat it2 = (SizeFCompat)e$iv;
                    $i$a$-minByOrNull-AppWidgetManagerCompat$createResponsiveSizeAppWidgetInner$minSize$1 = false;
                    float v$iv = AppWidgetManagerCompat.getArea(it2);
                    if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        SizeFCompat sizeFCompat3 = v0;
        if (sizeFCompat3 == null) {
            throw new IllegalStateException("Sizes cannot be empty".toString());
        }
        SizeFCompat minSize = sizeFCompat3;
        LandscapePortraitSizes landscapePortraitSizes = AppWidgetManagerCompat.getSizesFromOptionsBundle(appWidgetManager, appWidgetId);
        if (landscapePortraitSizes == null) {
            boolean bl = false;
            Log.w((String)LogTag, (String)("App widget sizes not found in the options bundle, falling back to the smallest supported size (" + minSize + ')'));
            landscapePortraitSizes = new LandscapePortraitSizes(minSize, minSize);
        }
        LandscapePortraitSizes landscapePortraitSizes2 = landscapePortraitSizes;
        SizeFCompat landscapeSize = landscapePortraitSizes2.component1();
        SizeFCompat portraitSize = landscapePortraitSizes2.component2();
        Iterable $this$filter$iv = sizes;
        boolean $i$f$filter = false;
        Iterable v$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            SizeFCompat it = (SizeFCompat)element$iv$iv;
            boolean bl = false;
            if (!AppWidgetManagerCompat.approxDominates(landscapeSize, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv2 = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv2.hasNext()) {
            v3 = null;
        } else {
            maxElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v3 = maxElem$iv;
            } else {
                SizeFCompat it = (SizeFCompat)maxElem$iv;
                boolean bl = false;
                float maxValue$iv = AppWidgetManagerCompat.getArea(it);
                do {
                    Object e$iv = iterator$iv2.next();
                    SizeFCompat it3 = (SizeFCompat)e$iv;
                    $i$a$-maxByOrNull-AppWidgetManagerCompat$createResponsiveSizeAppWidgetInner$effectiveLandscapeSize$2 = false;
                    float v$iv2 = AppWidgetManagerCompat.getArea(it3);
                    if (Float.compare(maxValue$iv, v$iv2) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv2;
                } while (iterator$iv2.hasNext());
                v3 = maxElem$iv;
            }
        }
        if ((sizeFCompat2 = (SizeFCompat)v3) == null) {
            sizeFCompat2 = minSize;
        }
        SizeFCompat effectiveLandscapeSize = sizeFCompat2;
        Iterable $this$filter$iv2 = sizes;
        boolean $i$f$filter2 = false;
        maxElem$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SizeFCompat it = (SizeFCompat)element$iv$iv;
            boolean bl = false;
            if (!AppWidgetManagerCompat.approxDominates(portraitSize, it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$maxByOrNull$iv2 = (List)destination$iv$iv2;
        boolean $i$f$maxByOrNull2 = false;
        Iterator iterator$iv3 = $this$maxByOrNull$iv2.iterator();
        if (!iterator$iv3.hasNext()) {
            v5 = null;
        } else {
            Object maxElem$iv2 = iterator$iv3.next();
            if (!iterator$iv3.hasNext()) {
                v5 = maxElem$iv2;
            } else {
                SizeFCompat it = (SizeFCompat)maxElem$iv2;
                boolean bl = false;
                float maxValue$iv = AppWidgetManagerCompat.getArea(it);
                do {
                    Object e$iv = iterator$iv3.next();
                    SizeFCompat it4 = (SizeFCompat)e$iv;
                    $i$a$-maxByOrNull-AppWidgetManagerCompat$createResponsiveSizeAppWidgetInner$effectivePortraitSize$2 = false;
                    float v$iv3 = AppWidgetManagerCompat.getArea(it4);
                    if (Float.compare(maxValue$iv, v$iv3) >= 0) continue;
                    maxElem$iv2 = e$iv;
                    maxValue$iv = v$iv3;
                } while (iterator$iv3.hasNext());
                v5 = maxElem$iv2;
            }
        }
        if ((sizeFCompat = (SizeFCompat)v5) == null) {
            sizeFCompat = minSize;
        }
        SizeFCompat effectivePortraitSize = sizeFCompat;
        return AppWidgetManagerCompat.createAppWidget(effectiveLandscapeSize, effectivePortraitSize, factory);
    }

    private static final RemoteViews createAppWidget(SizeFCompat landscapeSize, SizeFCompat portraitSize, Function1<? super SizeFCompat, ? extends RemoteViews> factory) {
        return Intrinsics.areEqual((Object)landscapeSize, (Object)portraitSize) ? (RemoteViews)factory.invoke((Object)landscapeSize) : new RemoteViews((RemoteViews)factory.invoke((Object)landscapeSize), (RemoteViews)factory.invoke((Object)portraitSize));
    }

    private static final LandscapePortraitSizes getSizesFromOptionsBundle(AppWidgetManager appWidgetManager, int appWidgetId) {
        Bundle options = appWidgetManager.getAppWidgetOptions(appWidgetId);
        int portWidthDp = options.getInt("appWidgetMinWidth", -1);
        int portHeightDp = options.getInt("appWidgetMaxHeight", -1);
        if (portWidthDp < 0 || portHeightDp < 0) {
            return null;
        }
        int landWidthDp = options.getInt("appWidgetMaxWidth", -1);
        int landHeightDp = options.getInt("appWidgetMinHeight", -1);
        if (landWidthDp < 0 || landHeightDp < 0) {
            return null;
        }
        return new LandscapePortraitSizes(new SizeFCompat((float)landWidthDp, (float)landHeightDp), new SizeFCompat((float)portWidthDp, (float)portHeightDp));
    }

    @NotNull
    public static final RemoteViews createAppWidgetFromProviderInfo(@NotNull AppWidgetManager appWidgetManager, int appWidgetId, @NotNull Function1<? super SizeFCompat, ? extends RemoteViews> factory) {
        Intrinsics.checkNotNullParameter((Object)appWidgetManager, (String)"appWidgetManager");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        return (RemoteViews)factory.invoke((Object)AppWidgetManagerCompat.getSizeFromProviderInfo(appWidgetManager, appWidgetId));
    }

    @NotNull
    public static final SizeFCompat getSizeFromProviderInfo(@NotNull AppWidgetManager $this$getSizeFromProviderInfo, int appWidgetId) {
        Intrinsics.checkNotNullParameter((Object)$this$getSizeFromProviderInfo, (String)"<this>");
        AppWidgetProviderInfo providerInfo = $this$getSizeFromProviderInfo.getAppWidgetInfo(appWidgetId);
        float width = AppWidgetManagerCompat.getSizeFromProviderInfo$pxToDp(providerInfo.minWidth);
        float height = AppWidgetManagerCompat.getSizeFromProviderInfo$pxToDp(providerInfo.minHeight);
        return new SizeFCompat(width, height);
    }

    private static final float getSizeFromProviderInfo$pxToDp(int value) {
        return (float)value / Resources.getSystem().getDisplayMetrics().density;
    }
}

