/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.widget;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Parcel;
import android.util.Base64;
import android.util.Log;
import android.widget.RemoteViews;
import android.widget.RemoteViewsService;
import androidx.annotation.RestrictTo;
import androidx.core.content.pm.PackageInfoCompat;
import androidx.core.remoteviews.R;
import androidx.core.widget.RemoteViewsCompat;
import androidx.core.widget.RemoteViewsCompatService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00072\u00020\u0001:\u0003\u0007\b\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Landroidx/core/widget/RemoteViewsCompatService;", "Landroid/widget/RemoteViewsService;", "()V", "onGetViewFactory", "Landroid/widget/RemoteViewsService$RemoteViewsFactory;", "intent", "Landroid/content/Intent;", "Companion", "RemoteViewsCompatServiceData", "RemoteViewsCompatServiceViewFactory", "core-remoteviews_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nRemoteViewsCompatService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteViewsCompatService.kt\nandroidx/core/widget/RemoteViewsCompatService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,319:1\n1#2:320\n*E\n"})
public final class RemoteViewsCompatService
extends RemoteViewsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "RemoteViewsCompatServic";
    @NotNull
    private static final String EXTRA_VIEW_ID = "androidx.core.widget.extra.view_id";

    @NotNull
    public RemoteViewsService.RemoteViewsFactory onGetViewFactory(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        int appWidgetId = intent.getIntExtra("appWidgetId", -1);
        if (!(appWidgetId != -1)) {
            boolean bl = false;
            String string = "No app widget id was present in the intent";
            throw new IllegalStateException(string.toString());
        }
        int viewId = intent.getIntExtra(EXTRA_VIEW_ID, -1);
        if (!(viewId != -1)) {
            boolean bl = false;
            String string = "No view id was present in the intent";
            throw new IllegalStateException(string.toString());
        }
        return new RemoteViewsCompatServiceViewFactory((Context)this, appWidgetId, viewId);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/core/widget/RemoteViewsCompatService$Companion;", "", "()V", "EXTRA_VIEW_ID", "", "TAG", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "appWidgetId", "", "viewId", "saveItems", "", "items", "Landroidx/core/widget/RemoteViewsCompat$RemoteCollectionItems;", "core-remoteviews_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Intent createIntent(@NotNull Context context, int appWidgetId, int viewId) {
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent2 = new Intent(context, RemoteViewsCompatService.class).putExtra("appWidgetId", appWidgetId).putExtra(RemoteViewsCompatService.EXTRA_VIEW_ID, viewId);
            Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"Intent(context, RemoteVi\u2026ra(EXTRA_VIEW_ID, viewId)");
            Intent intent3 = intent = intent2;
            boolean bl = false;
            intent3.setData(Uri.parse((String)intent3.toUri(1)));
            return intent;
        }

        public final void saveItems(@NotNull Context context, int appWidgetId, int viewId, @NotNull RemoteViewsCompat.RemoteCollectionItems items) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)items, (String)"items");
            RemoteViewsCompatServiceData.Companion.create(context, items).save(context, appWidgetId, viewId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\nR\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/core/widget/RemoteViewsCompatService$RemoteViewsCompatServiceData;", "", "itemsBytes", "", "buildVersion", "", "appVersion", "", "([BLjava/lang/String;J)V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "mAppVersion", "mBuildVersion", "mItemsBytes", "save", "", "context", "Landroid/content/Context;", "appWidgetId", "", "viewId", "writeToParcel", "dest", "Companion", "core-remoteviews_release"})
    private static final class RemoteViewsCompatServiceData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final byte[] mItemsBytes;
        @NotNull
        private final String mBuildVersion;
        private final long mAppVersion;
        @NotNull
        private static final String PREFS_FILENAME = "androidx.core.widget.prefs.RemoteViewsCompat";

        private RemoteViewsCompatServiceData(byte[] itemsBytes, String buildVersion, long appVersion) {
            this.mItemsBytes = itemsBytes;
            this.mBuildVersion = buildVersion;
            this.mAppVersion = appVersion;
        }

        public RemoteViewsCompatServiceData(@NotNull Parcel parcel) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            int length = parcel.readInt();
            this.mItemsBytes = new byte[length];
            parcel.readByteArray(this.mItemsBytes);
            String string = parcel.readString();
            Intrinsics.checkNotNull((Object)string);
            this.mBuildVersion = string;
            this.mAppVersion = parcel.readLong();
        }

        public final void writeToParcel(@NotNull Parcel dest) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeInt(this.mItemsBytes.length);
            dest.writeByteArray(this.mItemsBytes);
            dest.writeString(this.mBuildVersion);
            dest.writeLong(this.mAppVersion);
        }

        public final void save(@NotNull Context context, int appWidgetId, int viewId) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Companion.getPrefs$core_remoteviews_release(context).edit().putString(Companion.getKey$core_remoteviews_release(appWidgetId, viewId), Companion.serializeToHexString$core_remoteviews_release((Function2<? super Parcel, ? super Integer, Unit>)((Function2)new Function2<Parcel, Integer, Unit>(this){
                final /* synthetic */ RemoteViewsCompatServiceData this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull Parcel parcel, int n) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    this.this$0.writeToParcel(parcel);
                }
            }))).apply();
        }

        public /* synthetic */ RemoteViewsCompatServiceData(byte[] itemsBytes, String buildVersion, long appVersion, DefaultConstructorMarker $constructor_marker) {
            this(itemsBytes, buildVersion, appVersion);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ1\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002H\f0\u0010H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J1\u0010\u0014\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\u0015\u001a\u00020\u00042\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002H\f0\u0010H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u001fJ\u0019\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0004\b\"\u0010#J'\u0010$\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b%J'\u0010&\u001a\u00020\u000e2\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020)0(H\u0000\u00a2\u0006\u0002\b*J'\u0010+\u001a\u00020\u00042\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020)0(H\u0000\u00a2\u0006\u0002\b,R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Landroidx/core/widget/RemoteViewsCompatService$RemoteViewsCompatServiceData$Companion;", "", "()V", "PREFS_FILENAME", "", "create", "Landroidx/core/widget/RemoteViewsCompatService$RemoteViewsCompatServiceData;", "context", "Landroid/content/Context;", "items", "Landroidx/core/widget/RemoteViewsCompat$RemoteCollectionItems;", "deserializeFromBytes", "P", "bytes", "", "creator", "Lkotlin/Function1;", "Landroid/os/Parcel;", "deserializeFromBytes$core_remoteviews_release", "([BLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "deserializeFromHexString", "hexString", "deserializeFromHexString$core_remoteviews_release", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getKey", "appWidgetId", "", "viewId", "getKey$core_remoteviews_release", "getPrefs", "Landroid/content/SharedPreferences;", "getPrefs$core_remoteviews_release", "getVersionCode", "", "getVersionCode$core_remoteviews_release", "(Landroid/content/Context;)Ljava/lang/Long;", "load", "load$core_remoteviews_release", "serializeToBytes", "parcelable", "Lkotlin/Function2;", "", "serializeToBytes$core_remoteviews_release", "serializeToHexString", "serializeToHexString$core_remoteviews_release", "core-remoteviews_release"})
        @SourceDebugExtension(value={"SMAP\nRemoteViewsCompatService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteViewsCompatService.kt\nandroidx/core/widget/RemoteViewsCompatService$RemoteViewsCompatServiceData$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,319:1\n1#2:320\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String getKey$core_remoteviews_release(int appWidgetId, int viewId) {
                return "" + appWidgetId + ':' + viewId;
            }

            @NotNull
            public final SharedPreferences getPrefs$core_remoteviews_release(@NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                SharedPreferences sharedPreferences = context.getSharedPreferences(RemoteViewsCompatServiceData.PREFS_FILENAME, 0);
                Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026S_FILENAME, MODE_PRIVATE)");
                return sharedPreferences;
            }

            @NotNull
            public final RemoteViewsCompatServiceData create(@NotNull Context context, @NotNull RemoteViewsCompat.RemoteCollectionItems items) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)items, (String)"items");
                Long versionCode = this.getVersionCode$core_remoteviews_release(context);
                if (!(versionCode != null)) {
                    boolean bl = false;
                    String string = "Couldn't obtain version code for app";
                    throw new IllegalStateException(string.toString());
                }
                byte[] byArray = this.serializeToBytes$core_remoteviews_release((Function2<? super Parcel, ? super Integer, Unit>)((Function2)new Function2<Parcel, Integer, Unit>((Object)items){

                    public final void invoke(@NotNull Parcel p0, int p1) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((RemoteViewsCompat.RemoteCollectionItems)this.receiver).writeToParcel$core_remoteviews_release(p0, p1);
                    }
                }));
                String string = Build.VERSION.INCREMENTAL;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"INCREMENTAL");
                return new RemoteViewsCompatServiceData(byArray, string, versionCode, null);
            }

            @Nullable
            public final RemoteViewsCompat.RemoteCollectionItems load$core_remoteviews_release(@NotNull Context context, int appWidgetId, int viewId) {
                RemoteViewsCompat.RemoteCollectionItems remoteCollectionItems;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                SharedPreferences prefs = this.getPrefs$core_remoteviews_release(context);
                String hexString = prefs.getString(this.getKey$core_remoteviews_release(appWidgetId, viewId), null);
                if (hexString == null) {
                    Log.w((String)RemoteViewsCompatService.TAG, (String)("No collection items were stored for widget " + appWidgetId));
                    return null;
                }
                RemoteViewsCompatServiceData data2 = (RemoteViewsCompatServiceData)this.deserializeFromHexString$core_remoteviews_release(hexString, load.data.1.INSTANCE);
                if (!Intrinsics.areEqual((Object)Build.VERSION.INCREMENTAL, (Object)data2.mBuildVersion)) {
                    Log.w((String)RemoteViewsCompatService.TAG, (String)("Android version code has changed, not using stored collection items for widget " + appWidgetId));
                    return null;
                }
                Long versionCode = this.getVersionCode$core_remoteviews_release(context);
                if (versionCode == null) {
                    Log.w((String)RemoteViewsCompatService.TAG, (String)("Couldn't get version code, not using stored collection items for widget " + appWidgetId));
                    return null;
                }
                long l = data2.mAppVersion;
                if (versionCode != l) {
                    Log.w((String)RemoteViewsCompatService.TAG, (String)("App version code has changed, not using stored collection items for widget " + appWidgetId));
                    return null;
                }
                try {
                    remoteCollectionItems = (RemoteViewsCompat.RemoteCollectionItems)this.deserializeFromBytes$core_remoteviews_release(data2.mItemsBytes, load.1.INSTANCE);
                }
                catch (Throwable t) {
                    Log.e((String)RemoteViewsCompatService.TAG, (String)("Unable to deserialize stored collection items for widget " + appWidgetId), (Throwable)t);
                    remoteCollectionItems = null;
                }
                return remoteCollectionItems;
            }

            @Nullable
            public final Long getVersionCode$core_remoteviews_release(@NotNull Context context) {
                PackageInfo packageInfo;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                PackageManager packageManager = context.getPackageManager();
                try {
                    packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.e((String)RemoteViewsCompatService.TAG, (String)("Couldn't retrieve version code for " + context.getPackageManager()), (Throwable)e);
                    return null;
                }
                PackageInfo packageInfo2 = packageInfo;
                return PackageInfoCompat.getLongVersionCode((PackageInfo)packageInfo2);
            }

            @NotNull
            public final String serializeToHexString$core_remoteviews_release(@NotNull Function2<? super Parcel, ? super Integer, Unit> parcelable) {
                Intrinsics.checkNotNullParameter(parcelable, (String)"parcelable");
                String string = Base64.encodeToString((byte[])this.serializeToBytes$core_remoteviews_release(parcelable), (int)0);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(serialize\u2026celable), Base64.DEFAULT)");
                return string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final byte[] serializeToBytes$core_remoteviews_release(@NotNull Function2<? super Parcel, ? super Integer, Unit> parcelable) {
                byte[] byArray;
                Intrinsics.checkNotNullParameter(parcelable, (String)"parcelable");
                Parcel parcel = Parcel.obtain();
                Intrinsics.checkNotNullExpressionValue((Object)parcel, (String)"obtain()");
                Parcel parcel2 = parcel;
                try {
                    parcel2.setDataPosition(0);
                    parcelable.invoke((Object)parcel2, (Object)0);
                    byte[] byArray2 = parcel2.marshall();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n                    pa\u2026shall()\n                }");
                    byArray = byArray2;
                }
                finally {
                    parcel2.recycle();
                }
                return byArray;
            }

            public final <P> P deserializeFromHexString$core_remoteviews_release(@NotNull String hexString, @NotNull Function1<? super Parcel, ? extends P> creator) {
                Intrinsics.checkNotNullParameter((Object)hexString, (String)"hexString");
                Intrinsics.checkNotNullParameter(creator, (String)"creator");
                byte[] byArray = Base64.decode((String)hexString, (int)0);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(hexString, Base64.DEFAULT)");
                return this.deserializeFromBytes$core_remoteviews_release(byArray, creator);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final <P> P deserializeFromBytes$core_remoteviews_release(@NotNull byte[] bytes, @NotNull Function1<? super Parcel, ? extends P> creator) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                Intrinsics.checkNotNullParameter(creator, (String)"creator");
                Parcel parcel = Parcel.obtain();
                Intrinsics.checkNotNullExpressionValue((Object)parcel, (String)"obtain()");
                Parcel parcel2 = parcel;
                try {
                    parcel2.unmarshall(bytes, 0, bytes.length);
                    parcel2.setDataPosition(0);
                    object = creator.invoke((Object)parcel2);
                }
                finally {
                    parcel2.recycle();
                }
                return (P)object;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/core/widget/RemoteViewsCompatService$RemoteViewsCompatServiceViewFactory;", "Landroid/widget/RemoteViewsService$RemoteViewsFactory;", "mContext", "Landroid/content/Context;", "mAppWidgetId", "", "mViewId", "(Landroid/content/Context;II)V", "mItems", "Landroidx/core/widget/RemoteViewsCompat$RemoteCollectionItems;", "getCount", "getItemId", "", "position", "getLoadingView", "", "getViewAt", "Landroid/widget/RemoteViews;", "getViewTypeCount", "hasStableIds", "", "loadData", "", "onCreate", "onDataSetChanged", "onDestroy", "Companion", "core-remoteviews_release"})
    @SourceDebugExtension(value={"SMAP\nRemoteViewsCompatService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteViewsCompatService.kt\nandroidx/core/widget/RemoteViewsCompatService$RemoteViewsCompatServiceViewFactory\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,319:1\n26#2:320\n*S KotlinDebug\n*F\n+ 1 RemoteViewsCompatService.kt\nandroidx/core/widget/RemoteViewsCompatService$RemoteViewsCompatServiceViewFactory\n*L\n95#1:320\n*E\n"})
    private static final class RemoteViewsCompatServiceViewFactory
    implements RemoteViewsService.RemoteViewsFactory {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Context mContext;
        private final int mAppWidgetId;
        private final int mViewId;
        @NotNull
        private RemoteViewsCompat.RemoteCollectionItems mItems;
        @NotNull
        private static final RemoteViewsCompat.RemoteCollectionItems EMPTY;

        public RemoteViewsCompatServiceViewFactory(@NotNull Context mContext, int mAppWidgetId, int mViewId) {
            Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
            this.mContext = mContext;
            this.mAppWidgetId = mAppWidgetId;
            this.mViewId = mViewId;
            this.mItems = EMPTY;
        }

        public void onCreate() {
            this.loadData();
        }

        public void onDataSetChanged() {
            this.loadData();
        }

        private final void loadData() {
            RemoteViewsCompat.RemoteCollectionItems remoteCollectionItems = RemoteViewsCompatServiceData.Companion.load$core_remoteviews_release(this.mContext, this.mAppWidgetId, this.mViewId);
            if (remoteCollectionItems == null) {
                remoteCollectionItems = EMPTY;
            }
            this.mItems = remoteCollectionItems;
        }

        public void onDestroy() {
        }

        public int getCount() {
            return this.mItems.getItemCount();
        }

        @NotNull
        public RemoteViews getViewAt(int position) {
            RemoteViews remoteViews;
            try {
                remoteViews = this.mItems.getItemView(position);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                remoteViews = new RemoteViews(this.mContext.getPackageName(), R.layout.invalid_list_item);
            }
            return remoteViews;
        }

        @Nullable
        public Void getLoadingView() {
            return null;
        }

        public int getViewTypeCount() {
            return this.mItems.getViewTypeCount();
        }

        public long getItemId(int position) {
            long l;
            try {
                l = this.mItems.getItemId(position);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                l = -1L;
            }
            return l;
        }

        public boolean hasStableIds() {
            return this.mItems.hasStableIds();
        }

        static {
            boolean $i$f$emptyArray = false;
            EMPTY = new RemoteViewsCompat.RemoteCollectionItems(new long[0], new RemoteViews[0], false, 1);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/core/widget/RemoteViewsCompatService$RemoteViewsCompatServiceViewFactory$Companion;", "", "()V", "EMPTY", "Landroidx/core/widget/RemoteViewsCompat$RemoteCollectionItems;", "core-remoteviews_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

