/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.testing.util;

import androidx.annotation.GuardedBy;
import androidx.core.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\f\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/core/testing/util/TestConsumer;", "T", "Landroidx/core/util/Consumer;", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "values", "", "accept", "", "t", "(Ljava/lang/Object;)V", "assertValues", "", "core-testing_release"})
public final class TestConsumer<T>
implements Consumer<T> {
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();
    @GuardedBy(value="lock")
    @NotNull
    private final List<T> values = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(T t) {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.values.add(t);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void assertValues(@NotNull List<? extends T> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (!Intrinsics.areEqual(this.values, values)) {
                throw new AssertionError((Object)("Expected " + values + " but received " + this.values));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }
}

