/*
 * Decompiled with CFR 0.152.
 */
package androidx.credentials.e2ee;

import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.google.crypto.tink.subtle.Ed25519Sign;
import com.google.crypto.tink.subtle.Hkdf;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0006H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Landroidx/credentials/e2ee/IdentityKey;", "", "public", "", "private", "type", "", "([B[BI)V", "getPrivate", "()[B", "getPublic", "getType", "()I", "equals", "", "other", "hashCode", "Companion", "IdentityKeyType", "credentials-e2ee_release"})
public final class IdentityKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] public;
    @NotNull
    private final byte[] private;
    private final int type;
    public static final int IDENTITY_KEY_TYPE_RESERVED = 0;
    public static final int IDENTITY_KEY_TYPE_ED25519 = 6;

    private IdentityKey(byte[] byArray, byte[] byArray2, int type) {
        this.public = byArray;
        this.private = byArray2;
        this.type = type;
    }

    @NotNull
    public final byte[] getPublic() {
        return this.public;
    }

    @NotNull
    public final byte[] getPrivate() {
        return this.private;
    }

    public final int getType() {
        return this.type;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof IdentityKey)) {
            return false;
        }
        return this.type == ((IdentityKey)other).type && Arrays.equals(this.private, ((IdentityKey)other).private) && Arrays.equals(this.public, ((IdentityKey)other).public);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.public);
        result = 31 * result + Arrays.hashCode(this.private);
        result = 31 * result + this.type;
        return result;
    }

    @JvmStatic
    @WorkerThread
    @NotNull
    public static final IdentityKey createFromPrf(@NotNull byte[] prf, @Nullable byte[] salt, int keyType) {
        return Companion.createFromPrf(prf, salt, keyType);
    }

    public /* synthetic */ IdentityKey(byte[] byArray, byte[] byArray2, int type, DefaultConstructorMarker $constructor_marker) {
        this(byArray, byArray2, type);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Landroidx/credentials/e2ee/IdentityKey$Companion;", "", "()V", "IDENTITY_KEY_TYPE_ED25519", "", "IDENTITY_KEY_TYPE_RESERVED", "createFromPrf", "Landroidx/credentials/e2ee/IdentityKey;", "prf", "", "salt", "keyType", "credentials-e2ee_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @WorkerThread
        @NotNull
        public final IdentityKey createFromPrf(@NotNull byte[] prf, @Nullable byte[] salt, int keyType) {
            Intrinsics.checkNotNullParameter((Object)prf, (String)"prf");
            if (keyType != 6) {
                throw new IllegalArgumentException("Only Ed25519 is supported at this stage.");
            }
            byte[] byArray = salt;
            if (salt == null) {
                byArray = new byte[32];
            }
            byte[] byArray2 = Hkdf.computeHkdf((String)"HmacSHA256", (byte[])prf, (byte[])byArray, (byte[])new byte[0], (int)32);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"computeHkdf(\n           \u2026size= */ 32\n            )");
            byte[] hkdf = byArray2;
            Ed25519Sign.KeyPair keyPair = Ed25519Sign.KeyPair.newKeyPairFromSeed((byte[])hkdf);
            Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"newKeyPairFromSeed(hkdf)");
            Ed25519Sign.KeyPair keyPair2 = keyPair;
            byte[] byArray3 = keyPair2.getPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"keyPair.publicKey");
            byte[] byArray4 = keyPair2.getPrivateKey();
            Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"keyPair.privateKey");
            return new IdentityKey(byArray3, byArray4, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @kotlin.annotation.Retention(value=AnnotationRetention.SOURCE)
    @Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/credentials/e2ee/IdentityKey$IdentityKeyType;", "", "credentials-e2ee_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface IdentityKeyType {
    }
}

