/*
 * Decompiled with CFR 0.152.
 */
package androidx.credentials.playservices.controllers;

import android.app.Activity;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ResultReceiver;
import androidx.credentials.exceptions.CreateCredentialException;
import androidx.credentials.exceptions.CreateCredentialInterruptedException;
import androidx.credentials.exceptions.CreateCredentialUnknownException;
import androidx.credentials.exceptions.GetCredentialException;
import androidx.credentials.exceptions.GetCredentialInterruptedException;
import androidx.credentials.exceptions.GetCredentialUnknownException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0004J!\u0010\r\u001a\u0004\u0018\u00010\b\"\n\b\u0000\u0010\u000e*\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/credentials/playservices/controllers/CredentialProviderBaseController;", "", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "generateHiddenActivityIntent", "", "resultReceiver", "Landroid/os/ResultReceiver;", "hiddenIntent", "Landroid/content/Intent;", "typeTag", "", "toIpcFriendlyResultReceiver", "T", "(Landroid/os/ResultReceiver;)Landroid/os/ResultReceiver;", "Companion", "credentials-play-services-auth_release"})
public class CredentialProviderBaseController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Activity activity;
    @NotNull
    private static final Set<Integer> retryables;
    private static final int CONTROLLER_REQUEST_CODE;
    @NotNull
    public static final String TYPE_TAG = "TYPE";
    @NotNull
    public static final String BEGIN_SIGN_IN_TAG = "BEGIN_SIGN_IN";
    @NotNull
    public static final String CREATE_PASSWORD_TAG = "CREATE_PASSWORD";
    @NotNull
    public static final String CREATE_PUBLIC_KEY_CREDENTIAL_TAG = "CREATE_PUBLIC_KEY_CREDENTIAL";
    @NotNull
    public static final String REQUEST_TAG = "REQUEST_TYPE";
    @NotNull
    public static final String RESULT_DATA_TAG = "RESULT_DATA";
    @NotNull
    public static final String FAILURE_RESPONSE_TAG = "FAILURE_RESPONSE";
    @NotNull
    public static final String EXCEPTION_TYPE_TAG = "EXCEPTION_TYPE";
    @NotNull
    public static final String EXCEPTION_MESSAGE_TAG = "EXCEPTION_MESSAGE";
    @NotNull
    public static final String ACTIVITY_REQUEST_CODE_TAG = "ACTIVITY_REQUEST_CODE";
    @NotNull
    public static final String RESULT_RECEIVER_TAG = "RESULT_RECEIVER";

    public CredentialProviderBaseController(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.activity = activity;
    }

    @Nullable
    public final <T extends ResultReceiver> ResultReceiver toIpcFriendlyResultReceiver(T resultReceiver2) {
        Parcel parcel = Parcel.obtain();
        Intrinsics.checkNotNullExpressionValue((Object)parcel, (String)"obtain()");
        Parcel parcel2 = parcel;
        T t = resultReceiver2;
        Intrinsics.checkNotNull(t);
        t.writeToParcel(parcel2, 0);
        parcel2.setDataPosition(0);
        ResultReceiver ipcFriendly = (ResultReceiver)ResultReceiver.CREATOR.createFromParcel(parcel2);
        parcel2.recycle();
        return ipcFriendly;
    }

    protected final void generateHiddenActivityIntent(@NotNull ResultReceiver resultReceiver2, @NotNull Intent hiddenIntent, @NotNull String typeTag) {
        Intrinsics.checkNotNullParameter((Object)resultReceiver2, (String)"resultReceiver");
        Intrinsics.checkNotNullParameter((Object)hiddenIntent, (String)"hiddenIntent");
        Intrinsics.checkNotNullParameter((Object)typeTag, (String)"typeTag");
        hiddenIntent.putExtra(TYPE_TAG, typeTag);
        hiddenIntent.putExtra(ACTIVITY_REQUEST_CODE_TAG, CONTROLLER_REQUEST_CODE);
        hiddenIntent.putExtra(RESULT_RECEIVER_TAG, (Parcelable)this.toIpcFriendlyResultReceiver(resultReceiver2));
        hiddenIntent.setFlags(65536);
    }

    protected static final int getCONTROLLER_REQUEST_CODE() {
        return Companion.getCONTROLLER_REQUEST_CODE();
    }

    static {
        Object[] objectArray = new Integer[]{8, 7, 20};
        retryables = SetsKt.setOf((Object[])objectArray);
        CONTROLLER_REQUEST_CODE = 1;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\u001cJ!\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00078\u0004X\u0085D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Landroidx/credentials/playservices/controllers/CredentialProviderBaseController$Companion;", "", "()V", "ACTIVITY_REQUEST_CODE_TAG", "", "BEGIN_SIGN_IN_TAG", "CONTROLLER_REQUEST_CODE", "", "getCONTROLLER_REQUEST_CODE$annotations", "getCONTROLLER_REQUEST_CODE", "()I", "CREATE_PASSWORD_TAG", "CREATE_PUBLIC_KEY_CREDENTIAL_TAG", "EXCEPTION_MESSAGE_TAG", "EXCEPTION_TYPE_TAG", "FAILURE_RESPONSE_TAG", "REQUEST_TAG", "RESULT_DATA_TAG", "RESULT_RECEIVER_TAG", "TYPE_TAG", "retryables", "", "getRetryables", "()Ljava/util/Set;", "createCredentialExceptionTypeToException", "Landroidx/credentials/exceptions/CreateCredentialException;", "typeName", "msg", "createCredentialExceptionTypeToException$credentials_play_services_auth_release", "getCredentialExceptionTypeToException", "Landroidx/credentials/exceptions/GetCredentialException;", "getCredentialExceptionTypeToException$credentials_play_services_auth_release", "credentials-play-services-auth_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Integer> getRetryables() {
            return retryables;
        }

        protected final int getCONTROLLER_REQUEST_CODE() {
            return CONTROLLER_REQUEST_CODE;
        }

        @JvmStatic
        protected static /* synthetic */ void getCONTROLLER_REQUEST_CODE$annotations() {
        }

        @NotNull
        public final GetCredentialException getCredentialExceptionTypeToException$credentials_play_services_auth_release(@Nullable String typeName, @Nullable String msg) {
            return Intrinsics.areEqual((Object)typeName, (Object)GetCredentialUnknownException.class.getName()) ? (GetCredentialException)new GetCredentialInterruptedException((CharSequence)msg) : (GetCredentialException)new GetCredentialUnknownException((CharSequence)msg);
        }

        @NotNull
        public final CreateCredentialException createCredentialExceptionTypeToException$credentials_play_services_auth_release(@Nullable String typeName, @Nullable String msg) {
            return Intrinsics.areEqual((Object)typeName, (Object)GetCredentialInterruptedException.class.getName()) ? (CreateCredentialException)new CreateCredentialInterruptedException((CharSequence)msg) : (CreateCredentialException)new CreateCredentialUnknownException((CharSequence)msg);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

