/*
 * Decompiled with CFR 0.152.
 */
package androidx.credentials.playservices;

import android.app.Activity;
import android.content.Context;
import android.os.CancellationSignal;
import android.util.Log;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.credentials.ClearCredentialStateRequest;
import androidx.credentials.CreateCredentialRequest;
import androidx.credentials.CreateCredentialResponse;
import androidx.credentials.CreatePasswordRequest;
import androidx.credentials.CreatePublicKeyCredentialRequest;
import androidx.credentials.CredentialManagerCallback;
import androidx.credentials.CredentialProvider;
import androidx.credentials.GetCredentialRequest;
import androidx.credentials.GetCredentialResponse;
import androidx.credentials.exceptions.ClearCredentialException;
import androidx.credentials.exceptions.ClearCredentialUnknownException;
import androidx.credentials.exceptions.CreateCredentialException;
import androidx.credentials.exceptions.GetCredentialException;
import androidx.credentials.playservices.CredentialProviderPlayServicesImpl;
import androidx.credentials.playservices.controllers.BeginSignIn.CredentialProviderBeginSignInController;
import androidx.credentials.playservices.controllers.CreatePassword.CredentialProviderCreatePasswordController;
import androidx.credentials.playservices.controllers.CreatePublicKeyCredential.CredentialProviderCreatePublicKeyCredentialController;
import com.google.android.gms.auth.api.identity.Identity;
import com.google.android.gms.common.GoogleApiAvailability;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J8\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0016J>\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0\u001bH\u0016J>\u0010$\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020%2\u0006\u0010 \u001a\u00020!2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0006@GX\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006)"}, d2={"Landroidx/credentials/playservices/CredentialProviderPlayServicesImpl;", "Landroidx/credentials/CredentialProvider;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "<set-?>", "Lcom/google/android/gms/common/GoogleApiAvailability;", "googleApiAvailability", "getGoogleApiAvailability$annotations", "()V", "getGoogleApiAvailability", "()Lcom/google/android/gms/common/GoogleApiAvailability;", "setGoogleApiAvailability", "(Lcom/google/android/gms/common/GoogleApiAvailability;)V", "isAvailableOnDevice", "", "isGooglePlayServicesAvailable", "", "onClearCredential", "", "request", "Landroidx/credentials/ClearCredentialStateRequest;", "cancellationSignal", "Landroid/os/CancellationSignal;", "executor", "Ljava/util/concurrent/Executor;", "callback", "Landroidx/credentials/CredentialManagerCallback;", "Ljava/lang/Void;", "Landroidx/credentials/exceptions/ClearCredentialException;", "onCreateCredential", "Landroidx/credentials/CreateCredentialRequest;", "activity", "Landroid/app/Activity;", "Landroidx/credentials/CreateCredentialResponse;", "Landroidx/credentials/exceptions/CreateCredentialException;", "onGetCredential", "Landroidx/credentials/GetCredentialRequest;", "Landroidx/credentials/GetCredentialResponse;", "Landroidx/credentials/exceptions/GetCredentialException;", "Companion", "credentials-play-services-auth_release"})
public final class CredentialProviderPlayServicesImpl
implements CredentialProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private GoogleApiAvailability googleApiAvailability;
    private static final String TAG = CredentialProviderPlayServicesImpl.class.getName();

    public CredentialProviderPlayServicesImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)googleApiAvailability, (String)"getInstance()");
        this.googleApiAvailability = googleApiAvailability;
    }

    @NotNull
    public final GoogleApiAvailability getGoogleApiAvailability() {
        return this.googleApiAvailability;
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    public final void setGoogleApiAvailability(@NotNull GoogleApiAvailability googleApiAvailability) {
        Intrinsics.checkNotNullParameter((Object)googleApiAvailability, (String)"<set-?>");
        this.googleApiAvailability = googleApiAvailability;
    }

    @VisibleForTesting(otherwise=2)
    public static /* synthetic */ void getGoogleApiAvailability$annotations() {
    }

    public void onGetCredential(@NotNull GetCredentialRequest request, @NotNull Activity activity, @Nullable CancellationSignal cancellationSignal, @NotNull Executor executor, @NotNull CredentialManagerCallback<GetCredentialResponse, GetCredentialException> callback) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (Companion.cancellationReviewer$credentials_play_services_auth_release(cancellationSignal)) {
            return;
        }
        new CredentialProviderBeginSignInController(activity).invokePlayServices(request, callback, executor, cancellationSignal);
    }

    public void onCreateCredential(@NotNull CreateCredentialRequest request, @NotNull Activity activity, @Nullable CancellationSignal cancellationSignal, @NotNull Executor executor, @NotNull CredentialManagerCallback<CreateCredentialResponse, CreateCredentialException> callback) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (Companion.cancellationReviewer$credentials_play_services_auth_release(cancellationSignal)) {
            return;
        }
        CreateCredentialRequest createCredentialRequest = request;
        if (createCredentialRequest instanceof CreatePasswordRequest) {
            CredentialProviderCreatePasswordController.Companion.getInstance(activity).invokePlayServices((CreatePasswordRequest)request, callback, executor, cancellationSignal);
        } else if (createCredentialRequest instanceof CreatePublicKeyCredentialRequest) {
            CredentialProviderCreatePublicKeyCredentialController.Companion.getInstance(activity).invokePlayServices((CreatePublicKeyCredentialRequest)request, callback, executor, cancellationSignal);
        } else {
            throw new UnsupportedOperationException("Create Credential request is unsupported, not password or publickeycredential");
        }
    }

    public boolean isAvailableOnDevice() {
        int resultCode = this.isGooglePlayServicesAvailable(this.context);
        return resultCode == 0;
    }

    private final int isGooglePlayServicesAvailable(Context context) {
        return this.googleApiAvailability.isGooglePlayServicesAvailable(context);
    }

    public void onClearCredential(@NotNull ClearCredentialStateRequest request, @Nullable CancellationSignal cancellationSignal, @NotNull Executor executor, @NotNull CredentialManagerCallback<Void, ClearCredentialException> callback) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (Companion.cancellationReviewer$credentials_play_services_auth_release(cancellationSignal)) {
            return;
        }
        Identity.getSignInClient((Context)this.context).signOut().addOnSuccessListener(arg_0 -> CredentialProviderPlayServicesImpl.onClearCredential$lambda$0((Function1)new Function1<Void, Unit>(cancellationSignal, executor, callback){
            final /* synthetic */ CancellationSignal $cancellationSignal;
            final /* synthetic */ Executor $executor;
            final /* synthetic */ CredentialManagerCallback<Void, ClearCredentialException> $callback;
            {
                this.$cancellationSignal = $cancellationSignal;
                this.$executor = $executor;
                this.$callback = $callback;
                super(1);
            }

            public final void invoke(Void it) {
                boolean isCanceled = false;
                CancellationSignal cancellationSignal = this.$cancellationSignal;
                if (cancellationSignal != null) {
                    CancellationSignal cancellationSignal2 = cancellationSignal;
                    CancellationSignal cancellationSignal3 = this.$cancellationSignal;
                    CancellationSignal it2 = cancellationSignal2;
                    boolean bl = false;
                    isCanceled = cancellationSignal3.isCanceled();
                }
                if (!isCanceled) {
                    Log.i((String)CredentialProviderPlayServicesImpl.access$getTAG$cp(), (String)"During clear credential, signed out successfully!");
                    this.$executor.execute(() -> onClearCredential.1.invoke$lambda$1(this.$callback));
                }
            }

            private static final void invoke$lambda$1(CredentialManagerCallback $callback) {
                Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
                $callback.onResult(null);
            }
        }, arg_0)).addOnFailureListener(arg_0 -> CredentialProviderPlayServicesImpl.onClearCredential$lambda$4(this, cancellationSignal, executor, callback, arg_0));
    }

    private static final void onClearCredential$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void onClearCredential$lambda$4$lambda$3$lambda$2(CredentialManagerCallback $callback, Exception $e) {
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        $callback.onError((Object)new ClearCredentialUnknownException((CharSequence)$e.getMessage()));
    }

    private static final void onClearCredential$lambda$4(CredentialProviderPlayServicesImpl this$0, CancellationSignal $cancellationSignal, Executor $executor, CredentialManagerCallback $callback, Exception e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        CredentialProviderPlayServicesImpl $this$onClearCredential_u24lambda_u244_u24lambda_u243 = this$0;
        boolean bl = false;
        boolean isCanceled = false;
        CancellationSignal cancellationSignal = $cancellationSignal;
        if (cancellationSignal != null) {
            CancellationSignal it = cancellationSignal;
            boolean bl2 = false;
            isCanceled = $cancellationSignal.isCanceled();
        }
        if (!isCanceled) {
            Log.w((String)TAG, (String)("During clear credential sign out failed with " + e));
            $executor.execute(() -> CredentialProviderPlayServicesImpl.onClearCredential$lambda$4$lambda$3$lambda$2($callback, e));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b\nR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/credentials/playservices/CredentialProviderPlayServicesImpl$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "cancellationReviewer", "", "cancellationSignal", "Landroid/os/CancellationSignal;", "cancellationReviewer$credentials_play_services_auth_release", "credentials-play-services-auth_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean cancellationReviewer$credentials_play_services_auth_release(@Nullable CancellationSignal cancellationSignal) {
            if (cancellationSignal != null) {
                if (cancellationSignal.isCanceled()) {
                    Log.i((String)TAG, (String)"the flow has been canceled");
                    return true;
                }
            } else {
                Log.i((String)TAG, (String)"No cancellationSignal found");
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

