/*
 * Decompiled with CFR 0.152.
 */
package androidx.credentials.playservices.controllers.CreatePublicKeyCredential;

import android.util.Base64;
import android.util.Log;
import androidx.credentials.CreatePublicKeyCredentialRequest;
import androidx.credentials.GetPublicKeyCredentialOption;
import androidx.credentials.exceptions.CreateCredentialCancellationException;
import androidx.credentials.exceptions.CreateCredentialException;
import androidx.credentials.exceptions.domerrors.AbortError;
import androidx.credentials.exceptions.domerrors.ConstraintError;
import androidx.credentials.exceptions.domerrors.DataError;
import androidx.credentials.exceptions.domerrors.DomError;
import androidx.credentials.exceptions.domerrors.EncodingError;
import androidx.credentials.exceptions.domerrors.InvalidStateError;
import androidx.credentials.exceptions.domerrors.NetworkError;
import androidx.credentials.exceptions.domerrors.NotAllowedError;
import androidx.credentials.exceptions.domerrors.NotReadableError;
import androidx.credentials.exceptions.domerrors.NotSupportedError;
import androidx.credentials.exceptions.domerrors.SecurityError;
import androidx.credentials.exceptions.domerrors.TimeoutError;
import androidx.credentials.exceptions.domerrors.UnknownError;
import androidx.credentials.exceptions.publickeycredential.CreatePublicKeyCredentialDomException;
import com.google.android.gms.auth.api.identity.BeginSignInRequest;
import com.google.android.gms.auth.api.identity.SignInCredential;
import com.google.android.gms.fido.common.Transport;
import com.google.android.gms.fido.fido2.api.common.Attachment;
import com.google.android.gms.fido.fido2.api.common.AttestationConveyancePreference;
import com.google.android.gms.fido.fido2.api.common.AuthenticationExtensions;
import com.google.android.gms.fido.fido2.api.common.AuthenticationExtensionsClientOutputs;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorAssertionResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorAttestationResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorErrorResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorResponse;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorSelectionCriteria;
import com.google.android.gms.fido.fido2.api.common.COSEAlgorithmIdentifier;
import com.google.android.gms.fido.fido2.api.common.ErrorCode;
import com.google.android.gms.fido.fido2.api.common.FidoAppIdExtension;
import com.google.android.gms.fido.fido2.api.common.GoogleThirdPartyPaymentExtension;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredential;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialCreationOptions;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialDescriptor;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialParameters;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialRpEntity;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialUserEntity;
import com.google.android.gms.fido.fido2.api.common.ResidentKeyRequirement;
import com.google.android.gms.fido.fido2.api.common.UserVerificationMethodExtension;
import com.google.android.gms.fido.fido2.api.common.UvmEntries;
import com.google.android.gms.fido.fido2.api.common.UvmEntry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Landroidx/credentials/playservices/controllers/CreatePublicKeyCredential/PublicKeyCredentialControllerUtility;", "", "()V", "Companion", "credentials-play-services-auth_release"})
public final class PublicKeyCredentialControllerUtility {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int FLAGS = 11;
    private static final String TAG = PublicKeyCredentialControllerUtility.class.getName();
    @NotNull
    private static final LinkedHashMap<ErrorCode, DomError> orderedErrorCodeToExceptions;

    @JvmStatic
    @NotNull
    public static final PublicKeyCredentialCreationOptions convert(@NotNull CreatePublicKeyCredentialRequest request) {
        return Companion.convert(request);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ErrorCode.UNKNOWN_ERR, (Object)new UnknownError()), TuplesKt.to((Object)ErrorCode.ABORT_ERR, (Object)new AbortError()), TuplesKt.to((Object)ErrorCode.ATTESTATION_NOT_PRIVATE_ERR, (Object)new NotReadableError()), TuplesKt.to((Object)ErrorCode.CONSTRAINT_ERR, (Object)new ConstraintError()), TuplesKt.to((Object)ErrorCode.DATA_ERR, (Object)new DataError()), TuplesKt.to((Object)ErrorCode.ENCODING_ERR, (Object)new InvalidStateError()), TuplesKt.to((Object)ErrorCode.NETWORK_ERR, (Object)new NetworkError()), TuplesKt.to((Object)ErrorCode.NOT_ALLOWED_ERR, (Object)new NotAllowedError()), TuplesKt.to((Object)ErrorCode.NOT_SUPPORTED_ERR, (Object)new NotSupportedError()), TuplesKt.to((Object)ErrorCode.SECURITY_ERR, (Object)new SecurityError()), TuplesKt.to((Object)ErrorCode.TIMEOUT_ERR, (Object)new TimeoutError())};
        orderedErrorCodeToExceptions = MapsKt.linkedMapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020#J\u001d\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060%2\u0006\u0010&\u001a\u00020'H\u0002\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001d\u0010*\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b-J\u001d\u0010.\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b/J\u001d\u00100\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b1J\u001d\u00102\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b3J\u001d\u00104\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b5J\u001d\u00106\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b7J\u0010\u00108\u001a\u0004\u0018\u0001092\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010:\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020;J\u000e\u0010<\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006="}, d2={"Landroidx/credentials/playservices/controllers/CreatePublicKeyCredential/PublicKeyCredentialControllerUtility$Companion;", "", "()V", "FLAGS", "", "TAG", "", "kotlin.jvm.PlatformType", "orderedErrorCodeToExceptions", "Ljava/util/LinkedHashMap;", "Lcom/google/android/gms/fido/fido2/api/common/ErrorCode;", "Landroidx/credentials/exceptions/domerrors/DomError;", "Lkotlin/collections/LinkedHashMap;", "getOrderedErrorCodeToExceptions$credentials_play_services_auth_release", "()Ljava/util/LinkedHashMap;", "addOptionalAuthenticatorAttachmentAndExtensions", "", "cred", "Lcom/google/android/gms/fido/fido2/api/common/PublicKeyCredential;", "json", "Lorg/json/JSONObject;", "b64Decode", "", "str", "b64Encode", "data", "checkAlgSupported", "", "alg", "convert", "Lcom/google/android/gms/fido/fido2/api/common/PublicKeyCredentialCreationOptions;", "request", "Landroidx/credentials/CreatePublicKeyCredentialRequest;", "convertToPlayAuthPasskeyRequest", "Lcom/google/android/gms/auth/api/identity/BeginSignInRequest$PasskeysRequestOptions;", "Landroidx/credentials/GetPublicKeyCredentialOption;", "convertToProperNamingScheme", "", "authenticatorResponse", "Lcom/google/android/gms/fido/fido2/api/common/AuthenticatorAttestationResponse;", "(Lcom/google/android/gms/fido/fido2/api/common/AuthenticatorAttestationResponse;)[Ljava/lang/String;", "getChallenge", "parseOptionalAuthenticatorSelection", "builder", "Lcom/google/android/gms/fido/fido2/api/common/PublicKeyCredentialCreationOptions$Builder;", "parseOptionalAuthenticatorSelection$credentials_play_services_auth_release", "parseOptionalExtensions", "parseOptionalExtensions$credentials_play_services_auth_release", "parseOptionalTimeout", "parseOptionalTimeout$credentials_play_services_auth_release", "parseOptionalWithRequiredDefaultsAttestationAndExcludeCredentials", "parseOptionalWithRequiredDefaultsAttestationAndExcludeCredentials$credentials_play_services_auth_release", "parseRequiredChallengeAndUser", "parseRequiredChallengeAndUser$credentials_play_services_auth_release", "parseRequiredRpAndParams", "parseRequiredRpAndParams$credentials_play_services_auth_release", "publicKeyCredentialResponseContainsError", "Landroidx/credentials/exceptions/CreateCredentialException;", "toAssertPasskeyResponse", "Lcom/google/android/gms/auth/api/identity/SignInCredential;", "toCreatePasskeyResponseJson", "credentials-play-services-auth_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PublicKeyCredentialCreationOptions convert(@NotNull CreatePublicKeyCredentialRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            String requestJson = request.getRequestJson();
            JSONObject json = new JSONObject(requestJson);
            PublicKeyCredentialCreationOptions.Builder builder = new PublicKeyCredentialCreationOptions.Builder();
            this.parseRequiredChallengeAndUser$credentials_play_services_auth_release(json, builder);
            this.parseRequiredRpAndParams$credentials_play_services_auth_release(json, builder);
            this.parseOptionalWithRequiredDefaultsAttestationAndExcludeCredentials$credentials_play_services_auth_release(json, builder);
            this.parseOptionalTimeout$credentials_play_services_auth_release(json, builder);
            this.parseOptionalAuthenticatorSelection$credentials_play_services_auth_release(json, builder);
            this.parseOptionalExtensions$credentials_play_services_auth_release(json, builder);
            PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)publicKeyCredentialCreationOptions, (String)"builder.build()");
            return publicKeyCredentialCreationOptions;
        }

        @NotNull
        public final String toCreatePasskeyResponseJson(@NotNull PublicKeyCredential cred) {
            Intrinsics.checkNotNullParameter((Object)cred, (String)"cred");
            JSONObject json = new JSONObject();
            AuthenticatorResponse authenticatorResponse = cred.getResponse();
            Intrinsics.checkNotNullExpressionValue((Object)authenticatorResponse, (String)"cred.response");
            AuthenticatorResponse authenticatorResponse2 = authenticatorResponse;
            if (authenticatorResponse2 instanceof AuthenticatorAttestationResponse) {
                JSONObject responseJson = new JSONObject();
                byte[] byArray = ((AuthenticatorAttestationResponse)authenticatorResponse2).getClientDataJSON();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"authenticatorResponse.clientDataJSON");
                responseJson.put("clientDataJSON", (Object)this.b64Encode(byArray));
                byte[] byArray2 = ((AuthenticatorAttestationResponse)authenticatorResponse2).getAttestationObject();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"authenticatorResponse.attestationObject");
                responseJson.put("attestationObject", (Object)this.b64Encode(byArray2));
                String[] transportArray = this.convertToProperNamingScheme((AuthenticatorAttestationResponse)authenticatorResponse2);
                JSONArray transports = new JSONArray((Object)transportArray);
                responseJson.put("transports", (Object)transports);
                json.put("response", (Object)responseJson);
            } else {
                Log.e((String)TAG, (String)("Authenticator response expected registration response but got: " + authenticatorResponse2.getClass().getName()));
            }
            this.addOptionalAuthenticatorAttachmentAndExtensions(cred, json);
            json.put("id", (Object)cred.getId());
            byte[] byArray = cred.getRawId();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cred.rawId");
            json.put("rawId", (Object)this.b64Encode(byArray));
            json.put("type", (Object)cred.getType());
            String string = json.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.toString()");
            return string;
        }

        private final String[] convertToProperNamingScheme(AuthenticatorAttestationResponse authenticatorResponse) {
            String[] stringArray = authenticatorResponse.getTransports();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"authenticatorResponse.transports");
            String[] transportArray = stringArray;
            int ix = 0;
            int n = transportArray.length;
            for (int i = 0; i < n; ++i) {
                String transport = transportArray[i];
                if (Intrinsics.areEqual((Object)transport, (Object)"cable")) {
                    transportArray[ix] = "hybrid";
                }
                ++ix;
            }
            return transportArray;
        }

        private final void addOptionalAuthenticatorAttachmentAndExtensions(PublicKeyCredential cred, JSONObject json) {
            String authenticatorAttachment = cred.getAuthenticatorAttachment();
            AuthenticationExtensionsClientOutputs clientExtensionResults = cred.getClientExtensionResults();
            if (authenticatorAttachment != null) {
                json.put("authenticatorAttachment", (Object)authenticatorAttachment);
            }
            if (clientExtensionResults != null) {
                try {
                    UvmEntries uvmEntries = clientExtensionResults.getUvmEntries();
                    Intrinsics.checkNotNullExpressionValue((Object)uvmEntries, (String)"clientExtensionResults.uvmEntries");
                    UvmEntries uvmEntries2 = uvmEntries;
                    List uvmEntriesList = uvmEntries2.getUvmEntryList();
                    if (uvmEntriesList != null) {
                        JSONArray uvmEntriesJSON = new JSONArray();
                        for (UvmEntry entry : uvmEntriesList) {
                            JSONObject uvmEntryJSON = new JSONObject();
                            uvmEntryJSON.put("userVerificationMethod", entry.getUserVerificationMethod());
                            uvmEntryJSON.put("keyProtectionType", (Object)entry.getKeyProtectionType());
                            uvmEntryJSON.put("matcherProtectionType", (Object)entry.getMatcherProtectionType());
                            uvmEntriesJSON.put((Object)uvmEntryJSON);
                        }
                        json.put("uvm", (Object)uvmEntriesJSON);
                    }
                }
                catch (Throwable t) {
                    Log.e((String)TAG, (String)("ClientExtensionResults faced possible implementation inconsistency in uvmEntries - " + t));
                }
            }
        }

        @NotNull
        public final String toAssertPasskeyResponse(@NotNull SignInCredential cred) {
            PublicKeyCredential publicKeyCred;
            Intrinsics.checkNotNullParameter((Object)cred, (String)"cred");
            JSONObject json = new JSONObject();
            PublicKeyCredential publicKeyCredential = publicKeyCred = cred.getPublicKeyCredential();
            Object object = publicKeyCredential != null ? publicKeyCredential.getResponse() : null;
            Intrinsics.checkNotNull((Object)object);
            AuthenticatorResponse authenticatorResponse = object;
            if (authenticatorResponse instanceof AuthenticatorAssertionResponse) {
                JSONObject responseJson = new JSONObject();
                byte[] byArray = ((AuthenticatorAssertionResponse)authenticatorResponse).getClientDataJSON();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"authenticatorResponse.clientDataJSON");
                responseJson.put("clientDataJSON", (Object)this.b64Encode(byArray));
                byte[] byArray2 = ((AuthenticatorAssertionResponse)authenticatorResponse).getAuthenticatorData();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"authenticatorResponse.authenticatorData");
                responseJson.put("authenticatorData", (Object)this.b64Encode(byArray2));
                byte[] byArray3 = ((AuthenticatorAssertionResponse)authenticatorResponse).getSignature();
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"authenticatorResponse.signature");
                responseJson.put("signature", (Object)this.b64Encode(byArray3));
                byte[] byArray4 = ((AuthenticatorAssertionResponse)authenticatorResponse).getUserHandle();
                if (byArray4 != null) {
                    byte[] it = byArray4;
                    boolean bl = false;
                    byte[] byArray5 = ((AuthenticatorAssertionResponse)authenticatorResponse).getUserHandle();
                    Intrinsics.checkNotNull((Object)byArray5);
                    responseJson.put("userHandle", (Object)Companion.b64Encode(byArray5));
                }
                json.put("response", (Object)responseJson);
            } else {
                Log.e((String)TAG, (String)("AuthenticatorResponse expected assertion response but got: " + authenticatorResponse.getClass().getName()));
            }
            json.put("id", (Object)publicKeyCred.getId());
            byte[] byArray = publicKeyCred.getRawId();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"publicKeyCred.rawId");
            json.put("rawId", (Object)this.b64Encode(byArray));
            json.put("type", (Object)publicKeyCred.getType());
            String string = json.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.toString()");
            return string;
        }

        @NotNull
        public final BeginSignInRequest.PasskeysRequestOptions convertToPlayAuthPasskeyRequest(@NotNull GetPublicKeyCredentialOption request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            JSONObject json = new JSONObject(request.getRequestJson());
            String rpId = json.optString("rpId", "");
            Intrinsics.checkNotNullExpressionValue((Object)rpId, (String)"rpId");
            if (((CharSequence)rpId).length() == 0) {
                throw new JSONException("GetPublicKeyCredentialOption - rpId not specified in the request or is unexpectedly empty");
            }
            byte[] challenge = this.getChallenge(json);
            BeginSignInRequest.PasskeysRequestOptions passkeysRequestOptions = new BeginSignInRequest.PasskeysRequestOptions.Builder().setSupported(true).setRpId(rpId).setChallenge(challenge).build();
            Intrinsics.checkNotNullExpressionValue((Object)passkeysRequestOptions, (String)"Builder()\n              \u2026\n                .build()");
            return passkeysRequestOptions;
        }

        private final byte[] getChallenge(JSONObject json) {
            String challengeB64 = json.optString("challenge", "");
            Intrinsics.checkNotNullExpressionValue((Object)challengeB64, (String)"challengeB64");
            if (((CharSequence)challengeB64).length() == 0) {
                throw new JSONException("Challenge not found in request or is unexpectedly empty");
            }
            return this.b64Decode(challengeB64);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final CreateCredentialException publicKeyCredentialResponseContainsError(@NotNull PublicKeyCredential cred) {
            Intrinsics.checkNotNullParameter((Object)cred, (String)"cred");
            AuthenticatorResponse authenticatorResponse = cred.getResponse();
            Intrinsics.checkNotNullExpressionValue((Object)authenticatorResponse, (String)"cred.response");
            AuthenticatorResponse authenticatorResponse2 = authenticatorResponse;
            if (!(authenticatorResponse2 instanceof AuthenticatorErrorResponse)) return null;
            ErrorCode errorCode = ((AuthenticatorErrorResponse)authenticatorResponse2).getErrorCode();
            Intrinsics.checkNotNullExpressionValue((Object)errorCode, (String)"authenticatorResponse.errorCode");
            ErrorCode code = errorCode;
            DomError exceptionError = this.getOrderedErrorCodeToExceptions$credentials_play_services_auth_release().get(code);
            String msg = ((AuthenticatorErrorResponse)authenticatorResponse2).getErrorMessage();
            CreateCredentialException exception = null;
            if (exceptionError == null) {
                return (CreateCredentialException)new CreatePublicKeyCredentialDomException((DomError)new UnknownError(), (CharSequence)("unknown fido gms exception - " + msg));
            }
            if (code != ErrorCode.CONSTRAINT_ERR) return (CreateCredentialException)new CreatePublicKeyCredentialDomException(exceptionError, (CharSequence)msg);
            String string = msg;
            if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Unable to get sync account", (boolean)false, (int)2, null) : false)) return (CreateCredentialException)new CreatePublicKeyCredentialDomException(exceptionError, (CharSequence)msg);
            return (CreateCredentialException)new CreateCredentialCancellationException((CharSequence)"Passkey registration was cancelled by the user.");
        }

        public final void parseOptionalExtensions$credentials_play_services_auth_release(@NotNull JSONObject json, @NotNull PublicKeyCredentialCreationOptions.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            if (json.has("extensions")) {
                boolean uvmStatus;
                boolean thirdPartyPaymentExtension;
                JSONObject extensions = json.getJSONObject("extensions");
                AuthenticationExtensions.Builder extensionBuilder = new AuthenticationExtensions.Builder();
                String appIdExtension = extensions.optString("appid", "");
                Intrinsics.checkNotNullExpressionValue((Object)appIdExtension, (String)"appIdExtension");
                if (((CharSequence)appIdExtension).length() > 0) {
                    extensionBuilder.setFido2Extension(new FidoAppIdExtension(appIdExtension));
                }
                if (thirdPartyPaymentExtension = extensions.optBoolean("thirdPartyPayment", false)) {
                    extensionBuilder.setGoogleThirdPartyPaymentExtension(new GoogleThirdPartyPaymentExtension(true));
                }
                if (uvmStatus = extensions.optBoolean("uvm", false)) {
                    extensionBuilder.setUserVerificationMethodExtension(new UserVerificationMethodExtension(true));
                }
                builder.setAuthenticationExtensions(extensionBuilder.build());
            }
        }

        public final void parseOptionalAuthenticatorSelection$credentials_play_services_auth_release(@NotNull JSONObject json, @NotNull PublicKeyCredentialCreationOptions.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            if (json.has("authenticatorSelection")) {
                JSONObject authenticatorSelection = json.getJSONObject("authenticatorSelection");
                AuthenticatorSelectionCriteria.Builder authSelectionBuilder = new AuthenticatorSelectionCriteria.Builder();
                boolean requireResidentKey = authenticatorSelection.optBoolean("requireResidentKey", false);
                String residentKey = authenticatorSelection.optString("residentKey", "");
                ResidentKeyRequirement residentKeyRequirement = null;
                Intrinsics.checkNotNullExpressionValue((Object)residentKey, (String)"residentKey");
                if (((CharSequence)residentKey).length() > 0) {
                    residentKeyRequirement = ResidentKeyRequirement.fromString((String)residentKey);
                }
                authSelectionBuilder.setRequireResidentKey(Boolean.valueOf(requireResidentKey)).setResidentKeyRequirement(residentKeyRequirement);
                String authenticatorAttachmentString = authenticatorSelection.optString("authenticatorAttachment", "");
                Intrinsics.checkNotNullExpressionValue((Object)authenticatorAttachmentString, (String)"authenticatorAttachmentString");
                if (((CharSequence)authenticatorAttachmentString).length() > 0) {
                    authSelectionBuilder.setAttachment(Attachment.fromString((String)authenticatorAttachmentString));
                }
                builder.setAuthenticatorSelection(authSelectionBuilder.build());
            }
        }

        public final void parseOptionalTimeout$credentials_play_services_auth_release(@NotNull JSONObject json, @NotNull PublicKeyCredentialCreationOptions.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            if (json.has("timeout")) {
                double timeout = (double)json.getLong("timeout") / (double)1000;
                builder.setTimeoutSeconds(Double.valueOf(timeout));
            }
        }

        public final void parseOptionalWithRequiredDefaultsAttestationAndExcludeCredentials$credentials_play_services_auth_release(@NotNull JSONObject json, @NotNull PublicKeyCredentialCreationOptions.Builder builder) {
            String attestationString;
            List excludeCredentialsList;
            block9: {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                excludeCredentialsList = new ArrayList();
                if (!json.has("excludeCredentials")) break block9;
                JSONArray pubKeyDescriptorJSONs = json.getJSONArray("excludeCredentials");
                int n = pubKeyDescriptorJSONs.length();
                for (int i = 0; i < n; ++i) {
                    String descriptorType;
                    byte[] descriptorId;
                    JSONObject descriptorJSON;
                    block11: {
                        block10: {
                            descriptorJSON = pubKeyDescriptorJSONs.getJSONObject(i);
                            String string = descriptorJSON.getString("id");
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptorJSON.getString(\"id\")");
                            descriptorId = this.b64Decode(string);
                            descriptorType = descriptorJSON.getString("type");
                            if (descriptorId.length == 0) break block10;
                            Intrinsics.checkNotNullExpressionValue((Object)descriptorType, (String)"descriptorType");
                            if (!(((CharSequence)descriptorType).length() == 0)) break block11;
                        }
                        throw new JSONException("PublicKeyCredentialDescriptor id or type value not found or unexpectedly empty");
                    }
                    List transports = null;
                    if (descriptorJSON.has("transports")) {
                        transports = new ArrayList();
                        JSONArray descriptorTransports = descriptorJSON.getJSONArray("transports");
                        int n2 = descriptorTransports.length();
                        for (int j = 0; j < n2; ++j) {
                            try {
                                ArrayList arrayList = (ArrayList)transports;
                                Transport transport = Transport.fromString((String)descriptorTransports.getString(j));
                                Intrinsics.checkNotNullExpressionValue((Object)transport, (String)"fromString(\n            \u2026rTransports.getString(j))");
                                arrayList.add(transport);
                                continue;
                            }
                            catch (Transport.UnsupportedTransportException e) {
                                throw new CreatePublicKeyCredentialDomException((DomError)new EncodingError(), (CharSequence)e.getMessage());
                            }
                        }
                    }
                    excludeCredentialsList.add(new PublicKeyCredentialDescriptor(descriptorType, descriptorId, transports));
                }
            }
            builder.setExcludeList(excludeCredentialsList);
            String string = attestationString = json.optString("attestation", "none");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attestationString");
            if (((CharSequence)string).length() == 0) {
                attestationString = "none";
            }
            builder.setAttestationConveyancePreference(AttestationConveyancePreference.fromString((String)attestationString));
        }

        public final void parseRequiredRpAndParams$credentials_play_services_auth_release(@NotNull JSONObject json, @NotNull PublicKeyCredentialCreationOptions.Builder builder) {
            String rpIcon;
            String rpName;
            String rpId;
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                    Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                    JSONObject rp = json.getJSONObject("rp");
                    rpId = rp.getString("id");
                    rpName = rp.optString("name", "");
                    String string = rpIcon = rp.optString("icon", "");
                    Intrinsics.checkNotNull((Object)string);
                    if (((CharSequence)string).length() == 0) {
                        rpIcon = null;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)rpName, (String)"rpName");
                    if (((CharSequence)rpName).length() == 0) break block6;
                    Intrinsics.checkNotNullExpressionValue((Object)rpId, (String)"rpId");
                    if (!(((CharSequence)rpId).length() == 0)) break block7;
                }
                throw new JSONException("PublicKeyCredentialCreationOptions rp ID or rp name are missing or unexpectedly empty");
            }
            builder.setRp(new PublicKeyCredentialRpEntity(rpId, rpName, rpIcon));
            JSONArray pubKeyCredParams = json.getJSONArray("pubKeyCredParams");
            List paramsList = new ArrayList();
            int n = pubKeyCredParams.length();
            for (int i = 0; i < n; ++i) {
                JSONObject param = pubKeyCredParams.getJSONObject(i);
                int paramAlg = (int)param.getLong("alg");
                String typeParam = param.optString("type", "");
                Intrinsics.checkNotNullExpressionValue((Object)typeParam, (String)"typeParam");
                if (((CharSequence)typeParam).length() == 0) {
                    throw new JSONException("PublicKeyCredentialCreationOptions PublicKeyCredentialParameter type missing or unexpectedly empty");
                }
                if (!this.checkAlgSupported(paramAlg)) continue;
                paramsList.add(new PublicKeyCredentialParameters(typeParam, paramAlg));
            }
            builder.setParameters(paramsList);
        }

        public final void parseRequiredChallengeAndUser$credentials_play_services_auth_release(@NotNull JSONObject json, @NotNull PublicKeyCredentialCreationOptions.Builder builder) {
            String userIcon;
            String displayName;
            String userName;
            byte[] userId;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                    Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                    byte[] challenge = this.getChallenge(json);
                    builder.setChallenge(challenge);
                    JSONObject user = json.getJSONObject("user");
                    String string = user.getString("id");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"user.getString(\"id\")");
                    userId = this.b64Decode(string);
                    userName = user.getString("name");
                    displayName = user.getString("displayName");
                    userIcon = user.optString("icon", "");
                    Intrinsics.checkNotNullExpressionValue((Object)displayName, (String)"displayName");
                    if (((CharSequence)displayName).length() == 0 || userId.length == 0) break block2;
                    Intrinsics.checkNotNullExpressionValue((Object)userName, (String)"userName");
                    if (!(((CharSequence)userName).length() == 0)) break block3;
                }
                throw new JSONException("PublicKeyCredentialCreationOptions UserEntity missing one or more of displayName, userId or userName, or they are unexpectedly empty");
            }
            builder.setUser(new PublicKeyCredentialUserEntity(userId, userName, userIcon, displayName));
        }

        @NotNull
        public final byte[] b64Decode(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            byte[] byArray = Base64.decode((String)str, (int)11);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(str, FLAGS)");
            return byArray;
        }

        @NotNull
        public final String b64Encode(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String string = Base64.encodeToString((byte[])data, (int)11);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(data, FLAGS)");
            return string;
        }

        public final boolean checkAlgSupported(int alg) {
            try {
                COSEAlgorithmIdentifier.fromCoseValue((int)alg);
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        @NotNull
        public final LinkedHashMap<ErrorCode, DomError> getOrderedErrorCodeToExceptions$credentials_play_services_auth_release() {
            return orderedErrorCodeToExceptions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

